/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.IOException;
import org.refcodes.component.Closable;
import org.refcodes.io.AbstractBytesReceiver;
import org.refcodes.io.BytesDestination;

public class BytesReceiverDecorator
extends AbstractBytesReceiver {
    private final BytesDestination _byteProvider;

    public BytesReceiverDecorator(BytesDestination aByteProvider) {
        this._byteProvider = aByteProvider;
        try {
            this.open();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public byte receiveByte() throws IOException {
        if (!this.isOpened()) {
            throw new IOException("Cannot read as this receiver is in connection status <" + String.valueOf((Object)this.getConnectionStatus()) + ">.");
        }
        return this._byteProvider.receiveByte();
    }

    @Override
    public synchronized int available() throws IOException {
        if (!this.isOpened()) {
            throw new IOException("Cannot read as this receiver is in connection status <" + String.valueOf((Object)this.getConnectionStatus()) + ">.");
        }
        throw new UnsupportedOperationException("The underlying type <" + BytesDestination.class.getName() + "> does not support means to determine avaialbility!");
    }

    @Override
    public byte[] receiveAllBytes() throws IOException {
        if (!this.isOpened()) {
            throw new IOException("Cannot read as this receiver is in connection status <" + String.valueOf((Object)this.getConnectionStatus()) + ">.");
        }
        return this._byteProvider.receiveAllBytes();
    }

    @Override
    public byte[] receiveBytes(int aLength) throws IOException {
        if (!this.isOpened()) {
            throw new IOException("Cannot read as this receiver is in connection status <" + String.valueOf((Object)this.getConnectionStatus()) + ">.");
        }
        return this._byteProvider.receiveBytes(aLength);
    }

    @Override
    public void close() throws IOException {
        if (this._byteProvider instanceof Closable) {
            ((Closable)((Object)this._byteProvider)).close();
        }
        super.close();
    }
}

