/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.refcodes.data.IoRetryCount;
import org.refcodes.data.IoSleepLoopTime;
import org.refcodes.data.IoTimeout;
import org.refcodes.data.SleepLoopTime;
import org.refcodes.io.ByteReceiver;
import org.refcodes.io.BytesDestination;
import org.refcodes.io.Skippable;
import org.refcodes.io.TimeoutInputStream;
import org.refcodes.io.TimeoutInputStreamAccessor;

public interface BytesReceiver
extends BytesDestination,
ByteReceiver,
TimeoutInputStreamAccessor,
Skippable {
    @Override
    default public long skip(long aLength) throws IOException {
        int count = 0;
        int i = 0;
        while ((long)i < aLength && (long)this.available() >= aLength - (long)i) {
            this.receiveByte();
            ++count;
            ++i;
        }
        return count;
    }

    @Override
    default public InputStream getInputStream() {
        return new ReceiverInputStream(this);
    }

    @Override
    default public TimeoutInputStream getInputStream(long aTimeoutMillis) {
        return new TimeoutInputStream((InputStream)new ReceiverInputStream(this), aTimeoutMillis);
    }

    @Override
    default public byte[] receiveAllBytes() throws IOException {
        ArrayList<Byte> theData = new ArrayList<Byte>();
        while (this.hasAvailable()) {
            theData.add(this.receiveByte());
        }
        byte[] theBytes = new byte[theData.size()];
        for (int i = 0; i < theBytes.length; ++i) {
            theBytes[i] = (Byte)theData.get(i);
        }
        return theBytes;
    }

    @Override
    default public byte[] receiveBytes(int aLength) throws IOException {
        int i;
        byte[] theBlock = new byte[aLength];
        for (i = 0; this.hasAvailable() && i < aLength; ++i) {
            theBlock[i] = this.receiveByte();
        }
        if (i == 0) {
            while (!this.hasAvailable()) {
                try {
                    Thread.sleep(SleepLoopTime.NORM.getTimeMillis());
                }
                catch (InterruptedException interruptedException) {}
            }
            while (this.hasAvailable() && i < aLength) {
                theBlock[i] = this.receiveByte();
                ++i;
            }
        }
        if (i == aLength) {
            return theBlock;
        }
        return Arrays.copyOfRange(theBlock, 0, i);
    }

    default public byte receiveByteWithin(long aTimeoutMillis) throws IOException {
        byte[] theBuffer = new byte[1];
        this.receiveBytesWithin(aTimeoutMillis, theBuffer, 0, 1);
        return theBuffer[0];
    }

    default public byte[] receiveBytesWithin(long aTimeoutMillis, int aLength) throws IOException {
        byte[] theBuffer = new byte[aLength];
        this.receiveBytesWithin(aTimeoutMillis, theBuffer, 0, aLength);
        return theBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void receiveBytesWithin(long aTimeoutMillis, byte[] aBuffer, int aOffset, int aLength) throws IOException {
        if (this.isClosed()) {
            throw new IOException("The receiver connection is already closed!");
        }
        long thePollTimeInMs = IoTimeout.toTimeoutSleepLoopTimeInMs(aTimeoutMillis);
        int theOffset = 0;
        if (aTimeoutMillis != -1L) {
            long theStartTimeMs = System.currentTimeMillis();
            while (this.isOpened() && theOffset < aLength && (aTimeoutMillis == -1L || System.currentTimeMillis() - theStartTimeMs < aTimeoutMillis)) {
                int eAvaialble;
                int eRemainder = aLength - theOffset;
                if (eRemainder > 0 && (eAvaialble = this.available()) > 0) {
                    if (eAvaialble > eRemainder) {
                        eAvaialble = eRemainder;
                    }
                    this.receiveBytes(aBuffer, theOffset, eAvaialble);
                    theOffset += eAvaialble;
                }
                if (theOffset == aLength) {
                    return;
                }
                BytesReceiver bytesReceiver = this;
                synchronized (bytesReceiver) {
                    try {
                        this.wait(thePollTimeInMs);
                    }
                    catch (InterruptedException e) {
                        throw new IOException("Interrupted while trying to read <" + aLength + "> number of bytes after <" + (System.currentTimeMillis() - theStartTimeMs) + "> milliseconds (with a given timeout of <" + aTimeoutMillis + "> milliseconds)!", e);
                    }
                }
            }
            if (this.isClosed()) {
                throw new IOException("Connection was closed after <" + (System.currentTimeMillis() - theStartTimeMs) + "> milliseconds (with a given timeout of <" + aTimeoutMillis + "> milliseconds) while trying to read <" + aLength + "> number of bytes!");
            }
        }
        if (theOffset < aLength) {
            throw new IOException("Operation timed out after <" + aTimeoutMillis + "> milliseconds while trying to read <" + aLength + "> number of bytes.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForBytesAvailableWithin(long aTimeoutMillis, int aNumberOfBytes) throws IOException {
        if (this.isClosed()) {
            throw new IOException("The receiver connection is already closed!");
        }
        long thePollTimeInMs = IoTimeout.toTimeoutSleepLoopTimeInMs(aTimeoutMillis);
        if (aTimeoutMillis != -1L) {
            long theStartTimeMs = System.currentTimeMillis();
            while (this.isOpened() && this.available() < aNumberOfBytes && System.currentTimeMillis() - theStartTimeMs < aTimeoutMillis) {
                BytesReceiver bytesReceiver = this;
                synchronized (bytesReceiver) {
                    try {
                        this.wait(thePollTimeInMs);
                    }
                    catch (InterruptedException e) {
                        throw new IOException("Interrupted while trying to read <" + aNumberOfBytes + "> number of bytes after <" + (System.currentTimeMillis() - theStartTimeMs) + "> milliseconds (with a given timeout of <" + aTimeoutMillis + "> milliseconds)!", e);
                    }
                }
            }
            if (this.isClosed()) {
                throw new IOException("Connection was closed after <" + (System.currentTimeMillis() - theStartTimeMs) + "> milliseconds (with a given timeout of <" + aTimeoutMillis + "> milliseconds) while trying to read <" + aNumberOfBytes + "> number of bytes!");
            }
        } else {
            while (this.isOpened() && this.available() < aNumberOfBytes) {
                BytesReceiver bytesReceiver = this;
                synchronized (bytesReceiver) {
                    try {
                        this.wait(thePollTimeInMs);
                    }
                    catch (InterruptedException e) {
                        throw new IOException("Interrupted while trying to read <" + aNumberOfBytes + "> number of bytes (in blocking mode)!", e);
                    }
                }
            }
            if (this.isClosed()) {
                throw new IOException("Connection was closed while trying to read <" + aNumberOfBytes + "> number of bytes (ib blocking mode).");
            }
        }
        if (this.available() < aNumberOfBytes) {
            throw new IOException("Operation timed out after <" + aTimeoutMillis + "> milliseconds while trying to read <" + aNumberOfBytes + "> number of bytes.");
        }
    }

    public static class ReceiverInputStream
    extends InputStream {
        private final BytesReceiver _receiver;
        private boolean _isClosed = false;

        public ReceiverInputStream(BytesReceiver aBytesReceiver) {
            this._receiver = aBytesReceiver;
        }

        @Override
        public int available() throws IOException {
            if (this._isClosed) {
                throw new IOException("The stream has already been closed!");
            }
            return this._receiver.available();
        }

        @Override
        public int read() throws IOException {
            if (this._receiver.isClosed() || this._isClosed) {
                return -1;
            }
            return this._receiver.receiveByte();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this._isClosed) {
                throw new IOException("The stream has already been closed!");
            }
            Integer theRetries = IoRetryCount.NORM.getValue();
            for (int i = 0; i < theRetries && this.available() < len; ++i) {
                ReceiverInputStream receiverInputStream = this;
                synchronized (receiverInputStream) {
                    try {
                        this.wait(IoSleepLoopTime.NORM.getTimeMillis());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
            int theAvailable = this.available();
            len = theAvailable <= len ? theAvailable : len;
            this._receiver.receiveBytes(b, off, len);
            return len;
        }

        @Override
        public void close() throws IOException {
            this._isClosed = true;
            super.close();
        }
    }
}

