/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.refcodes.cli.ArgumentEscapeCodeAccessor;
import org.refcodes.cli.CliMetrics;
import org.refcodes.cli.Condition;
import org.refcodes.cli.KeywordEscapeCodeAccessor;
import org.refcodes.cli.Operand;
import org.refcodes.cli.SyntaxMetrics;
import org.refcodes.cli.SyntaxMetricsAccessor;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.Term;
import org.refcodes.data.AnsiEscapeCode;
import org.refcodes.mixin.EscapeCodesStatusAccessor;
import org.refcodes.mixin.ResetEscapeCodeAccessor;
import org.refcodes.runtime.Terminal;

public class CliContext
implements CliMetrics {
    private boolean _isEscapeCodesEnabled = Terminal.isAnsiTerminalEnabled();
    private String _keywordEscapeCode = AnsiEscapeCode.toEscapeSequence(AnsiEscapeCode.DEFAULT_FOREGROUND_COLOR, AnsiEscapeCode.BOLD);
    private String _argumentEscapeCode = AnsiEscapeCode.toEscapeSequence(AnsiEscapeCode.DEFAULT_FOREGROUND_COLOR, AnsiEscapeCode.FAINT, AnsiEscapeCode.ITALIC);
    private String _resetEscapeCode = AnsiEscapeCode.toEscapeSequence(AnsiEscapeCode.RESET);
    private SyntaxMetrics _syntaxMetrics = SyntaxNotation.LOGICAL;

    public CliContext() {
    }

    public CliContext(boolean isEscapeCodesEnabled) {
        this._isEscapeCodesEnabled = isEscapeCodesEnabled;
    }

    public CliContext(CliMetrics aCliMetrics) {
        this._syntaxMetrics = aCliMetrics.getSyntaxMetrics();
        this._isEscapeCodesEnabled = aCliMetrics.isEscapeCodesEnabled();
        this._argumentEscapeCode = aCliMetrics.getArgumentEscapeCode();
        this._keywordEscapeCode = aCliMetrics.getKeywordEscapeCode();
        this._resetEscapeCode = aCliMetrics.getResetEscapeCode();
    }

    public CliContext(CliMetrics aCliMetrics, SyntaxMetrics aSyntaxMetrics) {
        this._syntaxMetrics = aSyntaxMetrics != null ? aSyntaxMetrics : aCliMetrics.getSyntaxMetrics();
        this._isEscapeCodesEnabled = aCliMetrics.isEscapeCodesEnabled();
        this._argumentEscapeCode = aCliMetrics.getArgumentEscapeCode();
        this._keywordEscapeCode = aCliMetrics.getKeywordEscapeCode();
        this._resetEscapeCode = aCliMetrics.getResetEscapeCode();
    }

    public CliContext(CliMetrics aCliMetrics, SyntaxMetrics aSyntaxMetrics, boolean isEscapeCodesEnabled) {
        this._syntaxMetrics = aSyntaxMetrics != null ? aSyntaxMetrics : aCliMetrics.getSyntaxMetrics();
        this._isEscapeCodesEnabled = isEscapeCodesEnabled;
        this._argumentEscapeCode = aCliMetrics.getArgumentEscapeCode();
        this._keywordEscapeCode = aCliMetrics.getKeywordEscapeCode();
        this._resetEscapeCode = aCliMetrics.getResetEscapeCode();
    }

    public CliContext(String aArgumentEscapeCode, String aKeywordEscapeCode, String aResetEscapeCode) {
        this._argumentEscapeCode = aArgumentEscapeCode;
        this._keywordEscapeCode = aKeywordEscapeCode;
        this._resetEscapeCode = aResetEscapeCode;
    }

    public CliContext(SyntaxMetrics aSyntaxMetrics) {
        this._syntaxMetrics = aSyntaxMetrics;
    }

    public CliContext(SyntaxMetrics aSyntaxMetrics, boolean isEscapeCodesEnabled) {
        this._syntaxMetrics = aSyntaxMetrics;
        this._isEscapeCodesEnabled = isEscapeCodesEnabled;
    }

    public CliContext(SyntaxMetrics aSyntaxMetrics, Character aShortOptionPrefix, String aLongOptionPrefix, boolean isEscapeCodesEnabled, String aArgumentEscapeCode, String aKeywordEscapeCode, String aResetEscapeCode) {
        this._syntaxMetrics = aSyntaxMetrics;
        this._isEscapeCodesEnabled = isEscapeCodesEnabled;
        this._argumentEscapeCode = aArgumentEscapeCode;
        this._keywordEscapeCode = aKeywordEscapeCode;
        this._resetEscapeCode = aResetEscapeCode;
    }

    public CliContext(SyntaxMetrics aSyntaxMetrics, String aArgumentEscapeCode, String aKeywordEscapeCode, String aResetEscapeCode) {
        this._syntaxMetrics = aSyntaxMetrics;
        this._argumentEscapeCode = aArgumentEscapeCode;
        this._keywordEscapeCode = aKeywordEscapeCode;
        this._resetEscapeCode = aResetEscapeCode;
    }

    private CliContext(Builder builder) {
        this._syntaxMetrics = builder.syntaxMetrics;
        this._argumentEscapeCode = builder.argumentEscapeCode;
        this._keywordEscapeCode = builder.keywordEscapeCode;
        this._resetEscapeCode = builder.resetEscapeCode;
        this._isEscapeCodesEnabled = builder.isEscapeCodesEnabled;
    }

    @Override
    public String getArgumentEscapeCode() {
        return this._argumentEscapeCode;
    }

    @Override
    public String getKeywordEscapeCode() {
        return this._keywordEscapeCode;
    }

    @Override
    public String getResetEscapeCode() {
        return this._resetEscapeCode;
    }

    @Override
    public SyntaxMetrics getSyntaxMetrics() {
        return this._syntaxMetrics;
    }

    @Override
    public boolean isEscapeCodesEnabled() {
        return this._isEscapeCodesEnabled;
    }

    public boolean isOption(String aArg) {
        if (aArg != null && aArg.length() != 0) {
            if (this._syntaxMetrics.getLongOptionPrefix() != null && aArg.startsWith(this._syntaxMetrics.getLongOptionPrefix())) {
                return true;
            }
            if (this._syntaxMetrics.getShortOptionPrefix() != null && this._syntaxMetrics.getShortOptionPrefix().equals(Character.valueOf(aArg.charAt(0)))) {
                return true;
            }
        }
        return false;
    }

    public String[] toKeywords(Term aTerm) {
        Operand theOperand;
        String[] theKeywords;
        HashSet<String> theOptions = new HashSet<String>();
        if (aTerm instanceof Condition) {
            Condition theCondition = (Condition)aTerm;
            for (Operand<?> eOperand : theCondition.toOperands()) {
                String[] eOptions = this.toKeywords(eOperand);
                if (eOptions == null || eOptions.length == 0) continue;
                theOptions.addAll(Arrays.asList(eOptions));
            }
        }
        if (aTerm instanceof Operand && (theKeywords = (theOperand = (Operand)aTerm).toKeywords(this)) != null && theKeywords.length != 0) {
            for (String eKeyword : theKeywords) {
                theOptions.add(eKeyword);
            }
        }
        return theOptions.toArray(new String[theOptions.size()]);
    }

    public String toArgumentEscapeCode() {
        return this._isEscapeCodesEnabled ? (this._argumentEscapeCode != null ? this._argumentEscapeCode : "") : "";
    }

    public String[] toExpandOptions(String[] aArgs) {
        ArrayList<Object> theArgs = new ArrayList<Object>();
        if (this.getSyntaxMetrics().getShortOptionPrefix() != null) {
            for (String eArg : aArgs) {
                if (eArg.length() > 2 && eArg.charAt(2) != '=' && (this.getSyntaxMetrics().getLongOptionPrefix() == null || this.getSyntaxMetrics().getLongOptionPrefix().isEmpty() || !eArg.startsWith(this.getSyntaxMetrics().getLongOptionPrefix())) && eArg.charAt(0) == this.getSyntaxMetrics().getShortOptionPrefix().charValue()) {
                    for (int i = 1; i < eArg.length(); ++i) {
                        theArgs.add(this.getSyntaxMetrics().getShortOptionPrefix().toString() + eArg.charAt(i));
                    }
                    continue;
                }
                theArgs.add(eArg);
            }
        }
        return theArgs.toArray(new String[theArgs.size()]);
    }

    public String toKeywordEscapeCode() {
        return this._isEscapeCodesEnabled ? (this._keywordEscapeCode != null ? this._keywordEscapeCode : "") : "";
    }

    public String toResetEscapeCode() {
        return this._isEscapeCodesEnabled ? (this._resetEscapeCode != null ? this._resetEscapeCode : "") : "";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements SyntaxMetricsAccessor.SyntaxMetricsBuilder<Builder>,
    ArgumentEscapeCodeAccessor.ArgumentEscapeCodeBuilder<Builder>,
    KeywordEscapeCodeAccessor.KeywordEscapeCodeBuilder<Builder>,
    ResetEscapeCodeAccessor.ResetEscapeCodeBuilder<Builder>,
    EscapeCodesStatusAccessor.EscapeCodeStatusBuilder<Builder> {
        private String argumentEscapeCode = AnsiEscapeCode.toEscapeSequence(AnsiEscapeCode.DEFAULT_FOREGROUND_COLOR, AnsiEscapeCode.FAINT, AnsiEscapeCode.ITALIC);
        private boolean isEscapeCodesEnabled = Terminal.isAnsiTerminalEnabled();
        private String keywordEscapeCode = AnsiEscapeCode.toEscapeSequence(AnsiEscapeCode.DEFAULT_FOREGROUND_COLOR, AnsiEscapeCode.BOLD);
        private String resetEscapeCode = AnsiEscapeCode.toEscapeSequence(AnsiEscapeCode.RESET);
        private SyntaxMetrics syntaxMetrics = SyntaxNotation.LOGICAL;

        private Builder() {
        }

        public CliContext build() {
            return new CliContext(this);
        }

        @Override
        public Builder withArgumentEscapeCode(String aArgumentEscapeCode) {
            this.argumentEscapeCode = aArgumentEscapeCode;
            return this;
        }

        @Override
        public Builder withEscapeCodesEnabled(boolean isEscapeCodesEnabled) {
            this.isEscapeCodesEnabled = isEscapeCodesEnabled;
            return this;
        }

        @Override
        public Builder withKeywordEscapeCode(String aKeywordEscapeCode) {
            this.keywordEscapeCode = aKeywordEscapeCode;
            return this;
        }

        @Override
        public Builder withResetEscapeCode(String aResetEscapeCode) {
            this.resetEscapeCode = aResetEscapeCode;
            return this;
        }

        @Override
        public Builder withSyntaxMetrics(SyntaxMetrics aSyntaxMetrics) {
            this.syntaxMetrics = aSyntaxMetrics;
            return this;
        }
    }
}

