/*
 * Decompiled with CFR 0.152.
 */
package club.funcodes.flatml;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.refcodes.archetype.CliHelper;
import org.refcodes.cli.ArrayOption;
import org.refcodes.cli.CasesCondition;
import org.refcodes.cli.CharOption;
import org.refcodes.cli.CliSugar;
import org.refcodes.cli.DebugFlag;
import org.refcodes.cli.EnumOption;
import org.refcodes.cli.Example;
import org.refcodes.cli.Flag;
import org.refcodes.cli.HelpFlag;
import org.refcodes.cli.IntOption;
import org.refcodes.cli.Operand;
import org.refcodes.cli.StringOption;
import org.refcodes.cli.SysInfoFlag;
import org.refcodes.cli.VerboseFlag;
import org.refcodes.data.AsciiColorPalette;
import org.refcodes.data.Delimiter;
import org.refcodes.exception.BugException;
import org.refcodes.io.TimeoutInputStream;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;
import org.refcodes.properties.DocumentMetrics;
import org.refcodes.properties.DocumentMetricsBuilder;
import org.refcodes.properties.ImmutableProperties;
import org.refcodes.properties.JsonProperties;
import org.refcodes.properties.MapProperties;
import org.refcodes.properties.PolyglotProperties;
import org.refcodes.properties.Properties;
import org.refcodes.properties.XmlProperties;
import org.refcodes.properties.YamlProperties;
import org.refcodes.runtime.ConfigLocator;
import org.refcodes.runtime.Execution;
import org.refcodes.struct.MapCanonicalTable;
import org.refcodes.textual.Font;
import org.refcodes.textual.FontFamily;
import org.refcodes.textual.FontStyle;
import org.refcodes.textual.VerboseTextBuilder;

public class Main {
    private static final RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private static final String NAME = "flatml";
    private static final String TITLE = "<flat-ML>";
    private static final String DESCRIPTION = "A shell filter flattening markup properties of XML, JSON, YAML, INI or PROPERTIES format to a key/value \"per line\" format for easy addressing elements in complex data sets (see [https://www.metacodes.pro/manpages/flatml_manpage])";
    private static final String LICENSE_NOTE = "You may choose between the LGPL v3.0 or later and the Apache License v2.0 when using this software";
    private static final String COPYRIGHT = "Copyright (c) by CLUB.FUNCODES (see [https://www.funcodes.club])";
    private static final char[] BANNER_PALETTE = AsciiColorPalette.MAX_LEVEL_GRAY.getPalette();
    private static final Font BANNER_FONT = new Font(FontFamily.DIALOG, FontStyle.BOLD);
    private static final String OUTPUTFILE_PROPERTY = "outputFile";
    private static final String INPUTFILE_PROPERTY = "inputFile";
    private static final String TIMEOUT_PROPERTY = "timeout";
    private static final String DELIMETER_PROPERTY = "delimiter";
    private static final String NO_ESCAPE_PROPERTY = "noEscape";
    private static final String FORMAT_PROPERTY = "format";
    private static final String PATTERN_PROPERTY = "pattern";
    private static final String KEY_PROPERTY = "key";
    private static final String SORT_PROPERTY = "sort";
    private static final String XML_REMOVE_ENVELOPE_PROPERTY = "xmlRemoveEnvelope";
    private static final String XML_ARRAY_INDEX_PROPERTY = "xmlArrayIndex";

    public static void main(String[] args) {
        CharOption theDelimiterArg = CliSugar.charOption(Character.valueOf('d'), DELIMETER_PROPERTY, DELIMETER_PROPERTY, "The delimiter to be used when separating the markup hierarchy into a flat path. If omitted, then the dot \"" + Delimiter.PACKAGE_HIERARCHY.getChar() + "\" is used.");
        StringOption theInputPathArg = CliSugar.stringOption(Character.valueOf('i'), "input-file", INPUTFILE_PROPERTY, "The input markup (XML, JSON, YAML) file(s) from which to read the values (can be used multiple times to merge multiple files). If omitted, then <STDIN> is used.");
        ArrayOption<String> theInputPathsArg = CliSugar.asArray(theInputPathArg);
        StringOption theOutputPathArg = CliSugar.stringOption(Character.valueOf('o'), "output-file", OUTPUTFILE_PROPERTY, "The (flat) output file to which to write the values, if omitted, then <STDOUT> is used.");
        StringOption theKeyArg = CliSugar.stringOption(Character.valueOf('k'), KEY_PROPERTY, KEY_PROPERTY, "The key (flattened path) of the value to retrieve.");
        StringOption thePatternArg = CliSugar.stringOption(Character.valueOf('p'), PATTERN_PROPERTY, PATTERN_PROPERTY, "The ant like pattern ('*' matching a single path element, '**' matching multiple path elements and '?' matching a single character) of the keys (flattened paths) which's lines to retrieve.");
        IntOption theTimeoutSecsArg = CliSugar.intOption(Character.valueOf('t'), TIMEOUT_PROPERTY, TIMEOUT_PROPERTY, "Specifies the timeout (seconds) to wait for input, a value of -1 disables the dedicated timeout.");
        EnumOption<OutputFormat> theOutputFormatArg = CliSugar.enumOption(Character.valueOf('f'), FORMAT_PROPERTY, OutputFormat.class, FORMAT_PROPERTY, "Specifies the output format instead of flattened properties: " + VerboseTextBuilder.asString((Object[])OutputFormat.values()));
        Flag theXmlRemoveEnvelopeFlag = CliSugar.flag(Character.valueOf('r'), "remove-envelope", XML_REMOVE_ENVELOPE_PROPERTY, "Removes an XML document's root element (envelope) when it just serves the purpose of an envelope.");
        Flag theXmlArrayIndexFlag = CliSugar.flag(Character.valueOf('a'), "array-index", XML_ARRAY_INDEX_PROPERTY, "Adds an index attribute to collection (array) elements when using a format \"" + theOutputFormatArg.toSpec() + "\" of notation \"" + OutputFormat.XML.name() + "\".");
        Flag thePreserveFlag = CliSugar.flag(Character.valueOf('n'), "no-escape", NO_ESCAPE_PROPERTY, "Preserves any carriage return <CR> and line feed <LF> characters (omits escaping them with '\\r' and '\\n' char sequences).");
        Flag theSortFlag = CliSugar.flag(Character.valueOf('s'), SORT_PROPERTY, SORT_PROPERTY, "Sorts the keys of the flattened markup.");
        VerboseFlag theVerboseFlag = CliSugar.verboseFlag();
        SysInfoFlag theSysInfoFlag = CliSugar.sysInfoFlag(false);
        HelpFlag theHelpFlag = CliSugar.helpFlag();
        DebugFlag theDebugFlag = CliSugar.debugFlag();
        CasesCondition theArgsSyntax = CliSugar.cases(CliSugar.optional(theInputPathsArg, theOutputPathArg, CliSugar.xor(CliSugar.and(theOutputFormatArg, CliSugar.optional(theXmlArrayIndexFlag)), CliSugar.any(theDelimiterArg, CliSugar.xor(theKeyArg, thePatternArg, theSortFlag), thePreserveFlag)), theTimeoutSecsArg, theXmlRemoveEnvelopeFlag, theVerboseFlag, theDebugFlag), CliSugar.xor(theHelpFlag, CliSugar.and(theSysInfoFlag, CliSugar.any(theVerboseFlag))));
        Example[] theExamples = CliSugar.examples(CliSugar.example("Flattens markup from <STDIN> to <STDOUT>", new Operand[0]), CliSugar.example("Flattens markup from <STDIN> to <STDOUT> with given delimiter", theDelimiterArg), CliSugar.example("Converts markup from <STDIN> to <STDOUT> using given output format", theOutputFormatArg), CliSugar.example("Converts markup from <STDIN> to <STDOUT> with given delimiter to output format", theDelimiterArg, theOutputFormatArg), CliSugar.example("Flattens markup from <STDIN> to output file", theOutputPathArg), CliSugar.example("Flattens markup from <STDIN> to output file with given delimiter", theOutputPathArg, theDelimiterArg), CliSugar.example("Flattens markup from <STDIN> to output file using a timeout", theOutputPathArg, theTimeoutSecsArg), CliSugar.example("Flattens markup from input file to <STDOUT>", theInputPathArg), CliSugar.example("Flattens markup from input file to <STDOUT> and alphabetically sorts the result", theInputPathArg, theSortFlag), CliSugar.example("Flattens markup from input file to <STDOUT> removing an XML root envelope", theInputPathArg, theXmlRemoveEnvelopeFlag), CliSugar.example("Flattens markup from input file to output file", theInputPathArg, theOutputPathArg), CliSugar.example("Flattens and merges markup from multiple(!) input files to <STDOUT>", theInputPathArg, theInputPathArg, theInputPathArg), CliSugar.example("Flattens and merges markup from multiple(!) input files to output file", theInputPathArg, theInputPathArg, theInputPathArg, theOutputPathArg), CliSugar.example("Prints the value for the given key (flattened path) to <STDOUT>", theInputPathArg, theKeyArg), CliSugar.example("Prints the key's (flattened paths) lines matching the given pattern to <STDOUT>", theInputPathArg, thePatternArg), CliSugar.example("To show the help text", theHelpFlag), CliSugar.example("To print the system info", theSysInfoFlag));
        CliHelper theCliHelper = ((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)CliHelper.builder().withArgs(args)).withArgsSyntax(theArgsSyntax)).withExamples(theExamples)).withResourceClass((Class)Main.class)).withName(NAME)).withTitle(TITLE)).withDescription(DESCRIPTION)).withLicense(LICENSE_NOTE)).withCopyright(COPYRIGHT)).withBannerFont(BANNER_FONT)).withBannerFontPalette(BANNER_PALETTE)).withLogger(LOGGER)).build();
        boolean isVerbose = theCliHelper.isVerbose();
        if (isVerbose) {
            LOGGER.info("Starting application <flatml> ...");
        }
        try {
            int theTimeoutMillis;
            OutputFormat theOutputFormat = (OutputFormat)((Object)theOutputFormatArg.getValue());
            DocumentMetrics theDocumentMetrics = DocumentMetricsBuilder.builder().withEnvelope(!theXmlRemoveEnvelopeFlag.isEnabled()).withArrayIndex(theXmlArrayIndexFlag.isEnabled()).build();
            boolean isEscape = !thePreserveFlag.isEnabled();
            boolean isSort = theSortFlag.isEnabled();
            String theKey = (String)theKeyArg.getValue();
            String thePattern = (String)thePatternArg.getValue();
            char theDelimiter = theDelimiterArg.getValueOr(Character.valueOf(Delimiter.PACKAGE_HIERARCHY.getChar())).charValue();
            String[] theInputPaths = (String[])theInputPathsArg.getValue();
            File theOutputFile = theOutputPathArg.hasValue() ? new File((String)theOutputPathArg.getValue()) : null;
            int theTimeoutSecs = theTimeoutSecsArg.getValueOr(-1);
            int n = theTimeoutMillis = theTimeoutSecs != -1 ? theTimeoutSecs * 1000 : -1;
            if (isVerbose) {
                LOGGER.printSeparator();
                LOGGER.info("Input file(s) = " + (theInputPaths != null ? VerboseTextBuilder.asString(theInputPaths) : "<STDIN>"));
                LOGGER.info("Output file = <" + String.valueOf(theOutputFile != null ? theOutputFile : "STDOUT") + ">");
                LOGGER.info("Output format = <" + (theOutputFormat == null ? "FLAT" : theOutputFormat.name()) + ">");
                LOGGER.info("Delimiter = <" + theDelimiter + ">");
                LOGGER.info("Key = <" + theKey + ">");
                LOGGER.info("Pattern = <" + thePattern + ">");
                LOGGER.info("Remove XML (root element) envelope = <" + (!theDocumentMetrics.hasEnvelope() ? "YES" : "NO") + ">");
                LOGGER.info("Add XML array index attribute = <" + (theDocumentMetrics.hasArrayIndex() ? "YES" : "NO") + ">");
                LOGGER.info("Sort keys = <" + (isSort ? "YES" : "NO") + ">");
                LOGGER.info("Escape <CR> and <LF> = <" + (isEscape ? "YES" : "NO") + ">");
                LOGGER.info("Timeout (seconds) = <" + String.valueOf(theTimeoutSecs == -1 ? "none" : Integer.valueOf(theTimeoutSecs)) + ">");
            }
            Properties theProperties = new MapProperties();
            if (theInputPaths == null) {
                theProperties = new PolyglotProperties(new BufferedInputStream(new TimeoutInputStream(Execution.toBootstrapStandardIn(), theTimeoutMillis)), theDocumentMetrics);
            } else {
                for (String eFile : theInputPaths) {
                    theProperties.insert(new PolyglotProperties(eFile, ConfigLocator.USER_WORKING_DIRECTORY, theDocumentMetrics));
                }
            }
            try (BufferedWriter theOutputWriter = new BufferedWriter(new OutputStreamWriter(theOutputFile != null ? new FileOutputStream(theOutputFile) : new BufferedOutputStream(Execution.toBootstrapStandardOut())));){
                if (theOutputFormat == null) {
                    Main.printFlattened(theOutputWriter, theProperties, theDelimiter, theKey, thePattern, isSort, isEscape, isVerbose && theOutputFile == null);
                } else {
                    switch (theOutputFormat.ordinal()) {
                        case 0: {
                            Main.printJson(theOutputWriter, theProperties, isVerbose && theOutputFile == null);
                            break;
                        }
                        case 1: {
                            Main.printXml(theOutputWriter, theProperties, theDocumentMetrics, isVerbose && theOutputFile == null);
                            break;
                        }
                        case 2: {
                            Main.printYaml(theOutputWriter, theProperties, isVerbose && theOutputFile == null);
                            break;
                        }
                        default: {
                            throw new BugException("Missing case statement for <" + String.valueOf((Object)theOutputFormat) + "> in implementation!");
                        }
                    }
                }
                theOutputWriter.flush();
            }
            if (isVerbose && theOutputFile != null) {
                LOGGER.printSeparator();
                LOGGER.info("Successful converted <" + theOutputFile.getName() + "> using delimiter <" + theDelimiter + ">!");
            }
        }
        catch (Throwable e) {
            theCliHelper.exitOnException(e);
        }
    }

    private static void printJson(BufferedWriter aOutputWriter, ImmutableProperties aPolyglotProperties, boolean isVerbose) throws IOException {
        JsonProperties theProperties = new JsonProperties(aPolyglotProperties);
        if (isVerbose) {
            LOGGER.printTail();
        }
        aOutputWriter.write(theProperties.toSerialized());
    }

    private static void printYaml(BufferedWriter aOutputWriter, ImmutableProperties aPolyglotProperties, boolean isVerbose) throws IOException {
        YamlProperties theProperties = new YamlProperties(aPolyglotProperties);
        if (isVerbose) {
            LOGGER.printTail();
        }
        aOutputWriter.write(theProperties.toSerialized());
    }

    private static void printXml(BufferedWriter aOutputWriter, ImmutableProperties aPolyglotProperties, DocumentMetrics theDocumentMetrics, boolean isVerbose) throws IOException {
        XmlProperties theProperties = new XmlProperties(aPolyglotProperties, theDocumentMetrics);
        if (isVerbose) {
            LOGGER.printTail();
        }
        aOutputWriter.write(theProperties.toSerialized());
    }

    private static void printFlattened(BufferedWriter aOutputWriter, ImmutableProperties aPolyglotProperties, char aDelimiter, String aKey, String aPattern, boolean isSort, boolean isEscape, boolean isVerbose) throws IOException {
        MapCanonicalTable theTable = new MapCanonicalTable((Object)aPolyglotProperties, aDelimiter);
        if (aKey != null) {
            String theValue;
            if (isVerbose) {
                LOGGER.printTail();
            }
            if ((theValue = (String)theTable.get((Object)aKey)) == null) {
                theValue = "null";
            }
            aOutputWriter.write((isEscape ? theValue.replace("\r", "\\r").replace("\n", "\\n") : theValue) + System.lineSeparator());
        } else {
            if (aPattern != null && !((String)aPattern).startsWith(Character.toString(aDelimiter))) {
                aPattern = aDelimiter + (String)aPattern;
            }
            boolean hasTail = false;
            for (String string : isSort ? theTable.sortedKeys() : (aPattern == null ? theTable.keySet() : theTable.queryPaths((String)aPattern))) {
                if (isVerbose && !hasTail) {
                    LOGGER.printTail();
                    hasTail = true;
                }
                aOutputWriter.write(string.substring(1) + "=" + (isEscape ? ((String)theTable.get((Object)string)).replace("\r", "\\r").replace("\n", "\\n") : (String)theTable.get((Object)string)) + System.lineSeparator());
            }
        }
    }

    static enum OutputFormat {
        JSON,
        XML,
        YAML;

    }
}

