/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.refcodes.data.AsciiColorPalette;
import org.refcodes.exception.Trap;
import org.refcodes.graphical.BoxBorderMode;
import org.refcodes.graphical.GraphicalUtility;
import org.refcodes.graphical.RgbPixel;
import org.refcodes.graphical.RgbPixmap;
import org.refcodes.graphical.RgbPixmapBuilderImpl;
import org.refcodes.graphical.RgbPixmapImageBuilder;
import org.refcodes.mixin.ColumnWidthAccessor;
import org.refcodes.runtime.Execution;
import org.refcodes.runtime.Terminal;
import org.refcodes.textual.AbstractText;
import org.refcodes.textual.AsciiArtMode;
import org.refcodes.textual.CaseStyleBuilder;
import org.refcodes.textual.Font;
import org.refcodes.textual.FontAccessor;
import org.refcodes.textual.FontFamily;
import org.refcodes.textual.FontFamilyAccessor;
import org.refcodes.textual.FontNameAccessor;
import org.refcodes.textual.FontSizeAccessor;
import org.refcodes.textual.FontStyle;
import org.refcodes.textual.FontStyleAccessor;
import org.refcodes.textual.HorizAlignTextBuilder;
import org.refcodes.textual.HorizAlignTextMode;
import org.refcodes.textual.PixmapRatioMode;
import org.refcodes.textual.TextBorderBuilder;
import org.refcodes.textual.TextBoxStyle;
import org.refcodes.textual.TextLineBuilder;

public class AsciiArtBuilder
extends AbstractText<AsciiArtBuilder>
implements FontAccessor.FontProperty,
FontAccessor.FontBuilder<AsciiArtBuilder>,
FontFamilyAccessor.FontFamilyProperty,
FontFamilyAccessor.FontFamilyBuilder<AsciiArtBuilder>,
FontStyleAccessor.FontStyleProperty,
FontStyleAccessor.FontStyleBuilder<AsciiArtBuilder>,
FontSizeAccessor.FontSizeProperty,
FontSizeAccessor.FontSizeBuilder<AsciiArtBuilder>,
FontNameAccessor.FontNameProperty,
FontNameAccessor.FontNameBuilder<AsciiArtBuilder>,
ColumnWidthAccessor.ColumnWidthBuilder<AsciiArtBuilder>,
ColumnWidthAccessor.ColumnWidthProperty {
    private static final Logger LOGGER = Logger.getLogger(AsciiArtBuilder.class.getName());
    private Font _font = new Font(FontFamily.SANS_SERIF, FontStyle.PLAIN, 16);
    private RgbPixmap _pixmap = null;
    private AsciiArtMode _asciiArtMode = AsciiArtMode.NORMAL;
    private PixmapRatioMode _pixmapRatioMode = PixmapRatioMode.NONE;
    private AsciiColorPalette _asciiColorPalette = AsciiColorPalette.HALFTONE_GRAY;
    private char[] _asciiColors = null;
    private int _columnWidth = -1;
    private TextBoxStyle _borderStyle = null;
    private int _borderPadding = 0;

    public int getBorderPadding() {
        return this._borderPadding;
    }

    public void setBorderPadding(int aBorderPadding) {
        this._borderPadding = aBorderPadding;
    }

    public AsciiArtBuilder withBorderPadding(int aBorderPadding) {
        this._borderPadding = aBorderPadding;
        return this;
    }

    public TextBoxStyle getBorderStyle() {
        return this._borderStyle;
    }

    public void setBorderStyle(TextBoxStyle aBorderStyle) {
        this._borderStyle = aBorderStyle;
    }

    public AsciiArtBuilder withBorderStyle(TextBoxStyle aBorderStyle) {
        this._borderStyle = aBorderStyle;
        return this;
    }

    public PixmapRatioMode getPixmapRatioMode() {
        return this._pixmapRatioMode;
    }

    public void setPixmapRatioMode(PixmapRatioMode aPixmapRatioMode) {
        this._pixmapRatioMode = aPixmapRatioMode;
    }

    public RgbPixmap getRgbPixmap() {
        return this._pixmap;
    }

    @Override
    public AsciiArtBuilder withColumnWidth(int aColumnWidth) {
        this.setColumnWidth(aColumnWidth);
        return this;
    }

    @Override
    public void setColumnWidth(int aColumnWidth) {
        this._columnWidth = aColumnWidth;
    }

    @Override
    public int getColumnWidth() {
        return this._columnWidth;
    }

    @Override
    public Font getFont() {
        return this._font;
    }

    @Override
    public void setFont(Font aFont) {
        this._font = aFont;
    }

    @Override
    public AsciiArtBuilder withFont(Font aFont) {
        this.setFont(aFont);
        return this;
    }

    public AsciiArtMode getAsciiArtMode() {
        return this._asciiArtMode;
    }

    public void setAsciiArtMode(AsciiArtMode aAsciiArtMode) {
        this._asciiArtMode = aAsciiArtMode;
    }

    public char[] getAsciiColors() {
        return this._asciiColors != null ? this._asciiColors : (char[])(this._asciiColorPalette != null ? this._asciiColorPalette.getPalette() : null);
    }

    public void setAsciiColors(char ... aAsciiColors) {
        this._asciiColors = aAsciiColors;
        this._asciiColorPalette = null;
    }

    public AsciiColorPalette getAsciiColorPalette() {
        return this._asciiColorPalette;
    }

    public void setAsciiColorPalette(AsciiColorPalette aAsciiColorPalette) {
        this._asciiColorPalette = aAsciiColorPalette;
        this._asciiColors = null;
    }

    @Override
    public FontFamily getFontFamily() {
        return this._font != null ? this._font.getFamily() : null;
    }

    @Override
    public void setFontFamily(FontFamily aFontName) {
        if (this._font == null) {
            this._font = new Font();
        }
        this._font.setFamily(aFontName);
        this.setFont(this._font);
    }

    @Override
    public AsciiArtBuilder withFontFamily(FontFamily aFontName) {
        this.setFontFamily(aFontName);
        return this;
    }

    @Override
    public FontStyle getFontStyle() {
        return this._font != null ? this._font.getStyle() : null;
    }

    @Override
    public void setFontStyle(FontStyle aFontStyle) {
        if (this._font == null) {
            this._font = new Font();
        }
        this._font.setStyle(aFontStyle);
        this.setFont(this._font);
    }

    @Override
    public AsciiArtBuilder withFontStyle(FontStyle aFontStyle) {
        this.setFontStyle(aFontStyle);
        return this;
    }

    @Override
    public int getFontSize() {
        return this._font != null ? Integer.valueOf(this._font.getSize()) : null;
    }

    @Override
    public void setFontSize(int aFontSize) {
        if (this._font == null) {
            this._font = new Font();
        }
        this._font.setSize(aFontSize);
        this.setFont(this._font);
    }

    @Override
    public AsciiArtBuilder withFontSize(int aFontSize) {
        this.setFontSize(aFontSize);
        return this;
    }

    @Override
    public String getFontName() {
        return this._font != null ? this._font.getName() : null;
    }

    @Override
    public void setFontName(String aFontName) {
        if (this._font == null) {
            this._font = new Font();
        }
        this._font.setName(aFontName);
        this.setFont(this._font);
    }

    @Override
    public AsciiArtBuilder withFontName(String aFontName) {
        this.setFontName(aFontName);
        return this;
    }

    public void setRgbPixmap(RgbPixmap aPixmap) {
        this._pixmap = aPixmap;
    }

    @Override
    public String[] toStrings() {
        if (this._pixmap != null) {
            return AsciiArtBuilder.asAsciiArt(this._pixmap, this.getColumnWidth(), this.getAsciiArtMode(), this.getPixmapRatioMode(), this.getAsciiColors(), this.getBorderPadding(), this.getBorderStyle());
        }
        if (this.getText() != null) {
            return AsciiArtBuilder.asAsciiArt(this._columnWidth, this._font, this._asciiArtMode, this.getAsciiColors(), this.getBorderPadding(), this.getBorderStyle(), this.getText());
        }
        throw new IllegalStateException("Cannot invoke the ASCII-Art generation as there is neither a text nor a pixmap being set.");
    }

    @Override
    public String[] toStrings(String ... aText) {
        return AsciiArtBuilder.asAsciiArt(this._columnWidth, this._font, this._asciiArtMode, this.getAsciiColors(), aText);
    }

    public String toString(RgbPixmap aPixmap) {
        Object theResult = "";
        String[] theStrings = this.toStrings(aPixmap);
        for (int i = 0; i < theStrings.length; ++i) {
            theResult = (String)theResult + theStrings[i];
            if (i >= theStrings.length - 1) continue;
            theResult = (String)theResult + Terminal.getLineBreak();
        }
        return theResult;
    }

    public String[] toStrings(RgbPixmap aPixmap) {
        return AsciiArtBuilder.asAsciiArt(aPixmap, this.getColumnWidth(), this.getAsciiArtMode(), this.getPixmapRatioMode(), this.getAsciiColors());
    }

    public AsciiArtBuilder withAsciiArtMode(AsciiArtMode aAsciiArtMode) {
        this.setAsciiArtMode(aAsciiArtMode);
        return this;
    }

    public AsciiArtBuilder withPixmapRatioMode(PixmapRatioMode aPixmapRatioMode) {
        this.setPixmapRatioMode(aPixmapRatioMode);
        return this;
    }

    public AsciiArtBuilder withAsciiColors(char ... aAsciiColors) {
        this.setAsciiColors(aAsciiColors);
        return this;
    }

    public void setAsciiColors(String aAsciiColors) {
        char[] theChars = new char[aAsciiColors.length()];
        aAsciiColors.getChars(0, aAsciiColors.length(), theChars, 0);
        this.setAsciiColors(theChars);
    }

    public AsciiArtBuilder withAsciiColors(String aAsciiColors) {
        this.setAsciiColors(aAsciiColors);
        return this;
    }

    public AsciiArtBuilder withAsciiColorPalette(AsciiColorPalette aAsciiColorPalette) {
        this.setAsciiColorPalette(aAsciiColorPalette);
        return this;
    }

    public AsciiArtBuilder withRgbPixmap(RgbPixmap aPixmap) {
        this.setRgbPixmap(aPixmap);
        return this;
    }

    public void setImageFile(File aImageFile) throws IOException {
        this.setRgbPixmap(new RgbPixmapImageBuilder().withImageFile(aImageFile).toPixmap());
    }

    public AsciiArtBuilder withImageFile(File aImageFile) throws IOException {
        this.setImageFile(aImageFile);
        return this;
    }

    public void setImageInputStream(InputStream aImageStream) throws IOException {
        this.setRgbPixmap(new RgbPixmapImageBuilder().withImageInputStream(aImageStream).toPixmap());
    }

    public AsciiArtBuilder withImageInputStream(InputStream aImageStream) throws IOException {
        this.setImageInputStream(aImageStream);
        return this;
    }

    public String toString(InputStream aImageStream) throws IOException {
        RgbPixmapImageBuilder theBuilder = new RgbPixmapImageBuilder().withWidth(this.getColumnWidth());
        return this.toString(theBuilder.toPixmap(aImageStream));
    }

    public String[] toStrings(InputStream aImageStream) throws IOException {
        RgbPixmapImageBuilder theBuilder = new RgbPixmapImageBuilder().withWidth(this.getColumnWidth());
        return this.toStrings(theBuilder.toPixmap(aImageStream));
    }

    public String toString(File aImageFile) throws IOException {
        RgbPixmapImageBuilder theBuilder = new RgbPixmapImageBuilder().withWidth(this.getColumnWidth());
        return this.toString(theBuilder.toPixmap(aImageFile));
    }

    public String[] toStrings(File aImageFile) throws IOException {
        RgbPixmapImageBuilder theBuilder = new RgbPixmapImageBuilder().withWidth(this.getColumnWidth());
        return this.toStrings(theBuilder.toPixmap(aImageFile));
    }

    public static String[] asAsciiArt(int aWidth, Font aFont, AsciiArtMode aAsciiArtMode, String[] aLines, char ... aPalette) {
        return AsciiArtBuilder.asAsciiArt(aWidth, aFont, aAsciiArtMode, aPalette, aLines);
    }

    public static String[] asAsciiArt(int aWidth, Font aFont, AsciiArtMode aAsciiArtMode, char[] aPalette, String ... aLines) {
        ArrayList<String> theText = new ArrayList<String>();
        for (int i = 0; i < aLines.length; ++i) {
            String eLine = aLines[i];
            Collections.addAll(theText, AsciiArtBuilder.asAsciiArt(eLine, aWidth, aFont, aAsciiArtMode, aPalette));
            if (i >= aLines.length - 1) continue;
            theText.add(new TextLineBuilder().withLineChar(' ').withColumnWidth(((String)theText.get(0)).length()).toString());
        }
        return theText.toArray(new String[theText.size()]);
    }

    public static String[] asAsciiArt(int aWidth, Font aFont, AsciiArtMode aAsciiArtMode, char[] aPalette, int aBorderPadding, TextBoxStyle aBorderStyle, String ... aLines) {
        int theCanvasWidth = aWidth - aBorderPadding * 2;
        if (aBorderStyle != null) {
            theCanvasWidth -= 2;
        }
        String[] theAsciiArt = AsciiArtBuilder.asAsciiArt(theCanvasWidth, aFont, aAsciiArtMode, aPalette, aLines);
        if (aBorderPadding != 0) {
            theAsciiArt = ((TextBorderBuilder)new TextBorderBuilder().withBoxBorderMode(BoxBorderMode.ALL).withText(theAsciiArt)).withBorderWidth(aBorderPadding).withBorderChar(' ').toStrings();
        }
        if (aBorderStyle != null) {
            theAsciiArt = ((TextBorderBuilder)new TextBorderBuilder().withText(theAsciiArt)).withBoxBorderMode(BoxBorderMode.ALL).withTextBoxStyle(aBorderStyle).toStrings();
        }
        return theAsciiArt;
    }

    public static String[] asAsciiArt(String aText, int aWidth, Font aFont, AsciiArtMode aAsciiArtMode, char ... aPalette) {
        try {
            switch (aAsciiArtMode) {
                case NORMAL: {
                    if (aWidth != -1) {
                        return AsciiArtBuilder.toAsciiArt(aText, aWidth, aFont, aPalette);
                    }
                    if (aWidth == -1 && aFont.getSize() == -1) {
                        return AsciiArtBuilder.toAsciiArt(aText, Terminal.toHeuristicWidth(), aFont, aPalette);
                    }
                    return AsciiArtBuilder.toAsciiArt(aText, aFont, aPalette);
                }
                case INVERSE: {
                    if (aWidth != -1) {
                        return AsciiArtBuilder.toInverseAsciiArt(aText, aWidth, aFont, aPalette);
                    }
                    if (aWidth == -1 && aFont.getSize() == -1) {
                        return AsciiArtBuilder.toInverseAsciiArt(aText, Terminal.toHeuristicWidth(), aFont, aPalette);
                    }
                    return AsciiArtBuilder.toInverseAsciiArt(aText, aFont, aPalette);
                }
            }
            throw new IllegalArgumentException("You must pass a valid ASCII-Art mode, though you actually passed <" + String.valueOf((Object)aAsciiArtMode) + ">!");
        }
        catch (Error | Exception e) {
            if (Execution.isUnderTest()) {
                LOGGER.log(Level.WARNING, Trap.asMessage(e), e);
            }
            return AsciiArtBuilder.asSimpleBanner(aText, aWidth, aAsciiArtMode, aPalette);
        }
    }

    public static String[] asSimpleBanner(String aText, int aWidth, AsciiArtMode aAsciiArtMode, char ... aPalette) {
        if (aText == null || aText.isEmpty()) {
            return new String[0];
        }
        if (aAsciiArtMode == AsciiArtMode.INVERSE) {
            char[] thePalette = new char[aPalette.length];
            System.arraycopy(aPalette, 0, thePalette, 0, aPalette.length);
            AsciiArtBuilder.reverseArray(thePalette);
            aPalette = thePalette;
        }
        boolean theInnerBorderWidth = true;
        int theTotalBorderChars = 2;
        aText = CaseStyleBuilder.asKebabCase(aText);
        TextBorderBuilder theBorderBuilder = new TextBorderBuilder();
        StringBuilder theString = new StringBuilder();
        char theFillChar = aPalette[0];
        if (theFillChar != ' ') {
            theString.append(' ');
        }
        for (int i = 0; i < aText.length(); ++i) {
            theString.append(aText.charAt(i));
            if (i >= aText.length() - 1) continue;
            theString.append(' ');
        }
        if (theFillChar != ' ') {
            theString.append(' ');
        }
        aText = theString.toString().toUpperCase();
        HorizAlignTextBuilder theHorizAlignTextBuilder = new HorizAlignTextBuilder();
        int theHorizWidth = aText.length() + 2 <= aWidth ? aWidth - 2 : aText.length();
        theHorizAlignTextBuilder.setColumnWidth(theHorizWidth);
        theHorizAlignTextBuilder.setFillChar(theFillChar);
        theHorizAlignTextBuilder.setText(new String[]{aText});
        theHorizAlignTextBuilder.setHorizAlignTextMode(HorizAlignTextMode.CENTER);
        aText = theHorizAlignTextBuilder.toString();
        theBorderBuilder.setText(new String[]{aText});
        theBorderBuilder.setBorderChar(theFillChar);
        theBorderBuilder.setBorderWidth(1);
        theBorderBuilder.setBoxBorderMode(BoxBorderMode.TOP_RIGHT_BOTTOM_LEFT);
        return theBorderBuilder.toStrings();
    }

    public static String[] asAsciiArt(File aImageFile, int aWidth, AsciiArtMode aAsciiArtMode, PixmapRatioMode aPixmapRatioMode, char ... aPalette) throws IOException {
        RgbPixmapImageBuilder thePixmap = new RgbPixmapImageBuilder().withWidth(aWidth);
        return AsciiArtBuilder.asAsciiArt(thePixmap.toPixmap(aImageFile), aWidth, aAsciiArtMode, aPixmapRatioMode, aPalette);
    }

    public static String[] asAsciiArt(InputStream aImageStream, int aWidth, AsciiArtMode aAsciiArtMode, PixmapRatioMode aPixmapRatioMode, char ... aPalette) throws IOException {
        RgbPixmapImageBuilder thePixmap = new RgbPixmapImageBuilder().withWidth(aWidth);
        return AsciiArtBuilder.asAsciiArt(thePixmap.toPixmap(aImageStream), aWidth, aAsciiArtMode, aPixmapRatioMode, aPalette);
    }

    public static String[] asAsciiArt(RgbPixmap aPixmap, int aWidth, AsciiArtMode aAsciiArtMode, PixmapRatioMode aPixmapRatioMode, char ... aPalette) {
        int theWidth;
        RgbPixmap thePixmap = aPixmap;
        int n = theWidth = aWidth == -1 ? aPixmap.getWidth() : aWidth;
        if (theWidth != aPixmap.getWidth() || aPixmapRatioMode != PixmapRatioMode.NONE) {
            BufferedImage theBufferedImage = new BufferedImage(aPixmap.getWidth(), aPixmap.getHeight(), 6);
            for (int x = 0; x < aPixmap.getWidth(); ++x) {
                for (int y = 0; y < aPixmap.getHeight(); ++y) {
                    theBufferedImage.setRGB(x, y, ((RgbPixel)aPixmap.getPixelAt(x, y)).toRgbValue());
                }
            }
            int theHeight = aPixmap.getHeight();
            if (aPixmapRatioMode != PixmapRatioMode.NONE) {
                theHeight = Math.round((float)theWidth / (float)aPixmap.getWidth() * (float)aPixmap.getHeight() * aPixmapRatioMode.getRatio());
            }
            Image theScaledImage = theBufferedImage.getScaledInstance(theWidth, theHeight, 4);
            theBufferedImage = new BufferedImage(theWidth, theHeight, 6);
            theBufferedImage.getGraphics().drawImage(theScaledImage, 0, 0, new Color(0, 0, 0), null);
            RgbPixmapBuilderImpl theScaledPixmap = new RgbPixmapBuilderImpl(theWidth, theHeight);
            for (int x = 0; x < theScaledPixmap.getWidth(); ++x) {
                for (int y = 0; y < theScaledPixmap.getHeight(); ++y) {
                    theScaledPixmap.setRgbAt(theBufferedImage.getRGB(x, y), x, y);
                }
            }
            thePixmap = theScaledPixmap;
        }
        switch (aAsciiArtMode) {
            case NORMAL: {
                return AsciiArtBuilder.toAsciiArt(thePixmap, aPalette);
            }
            case INVERSE: {
                return AsciiArtBuilder.toInverseAsciiArt(thePixmap, aPalette);
            }
        }
        throw new IllegalArgumentException("You must pass a valid ASCII-Art mode, though you actually passed <" + String.valueOf((Object)aAsciiArtMode) + ">!");
    }

    public static String[] asAsciiArt(RgbPixmap aPixmap, int aWidth, AsciiArtMode aAsciiArtMode, PixmapRatioMode aPixmapRatioMode, char[] aAsciiColors, int aBorderPadding, TextBoxStyle aBorderStyle) {
        int theCanvasWidth = aWidth - aBorderPadding * 2;
        if (aBorderStyle != null) {
            theCanvasWidth -= 2;
        }
        String[] theAsciiArt = AsciiArtBuilder.asAsciiArt(aPixmap, theCanvasWidth, aAsciiArtMode, aPixmapRatioMode, aAsciiColors);
        if (aBorderPadding != 0) {
            theAsciiArt = ((TextBorderBuilder)new TextBorderBuilder().withBoxBorderMode(BoxBorderMode.ALL).withText(theAsciiArt)).withBorderWidth(aBorderPadding).withBorderChar(' ').toStrings();
        }
        if (aBorderStyle != null) {
            theAsciiArt = ((TextBorderBuilder)new TextBorderBuilder().withText(theAsciiArt)).withBoxBorderMode(BoxBorderMode.ALL).withTextBoxStyle(aBorderStyle).toStrings();
        }
        return theAsciiArt;
    }

    protected static String[] toAsciiArt(RgbPixmap aPixmap, char[] aPalette) {
        String[] theAsciiArt = new String[aPixmap.getHeight()];
        for (int y = 0; y < aPixmap.getHeight(); ++y) {
            theAsciiArt[y] = "";
            for (int x = 0; x < aPixmap.getWidth(); ++x) {
                int n = y;
                theAsciiArt[n] = theAsciiArt[n] + AsciiArtBuilder.toAscii(((RgbPixel)aPixmap.getPixelAt(x, y)).toRgbValue(), aPalette);
            }
        }
        return theAsciiArt;
    }

    protected static String[] toInverseAsciiArt(RgbPixmap aPixmap, char[] aPalette) {
        char[] thePalette = new char[aPalette.length];
        System.arraycopy(aPalette, 0, thePalette, 0, aPalette.length);
        AsciiArtBuilder.reverseArray(thePalette);
        return AsciiArtBuilder.toAsciiArt(aPixmap, thePalette);
    }

    protected static String[] toAsciiArt(String aText, int aWidth, String aFontName, int aFontStyle, char[] aPalette) {
        try {
            String[] theLines = AsciiArtBuilder.toAsciiArt(aText, new Font(GraphicalUtility.getAwtFont(aText, aWidth, aFontName, aFontStyle)), aPalette);
            for (int i = 0; i < theLines.length; ++i) {
                if (theLines[i].length() == aWidth) continue;
                theLines[i] = ((HorizAlignTextBuilder)new HorizAlignTextBuilder().withHorizAlignTextMode(HorizAlignTextMode.CENTER).withText(new String[]{theLines[i]})).withColumnWidth(aWidth).withFillChar(aPalette[0]).toString();
            }
            return theLines;
        }
        catch (Error | Exception e) {
            if (Execution.isUnderTest()) {
                LOGGER.log(Level.WARNING, Trap.asMessage(e), e);
            }
            return AsciiArtBuilder.asSimpleBanner(aText, aWidth, AsciiArtMode.NORMAL, aPalette);
        }
    }

    protected static String[] toAsciiArt(String aText, int aWidth, Font aFont, char[] aPalette) {
        String theFontName = aFont.getName();
        int theFontSyle = aFont.getStyle().getCode();
        String[] theLines = AsciiArtBuilder.toAsciiArt(aText, aWidth, theFontName, theFontSyle, aPalette);
        for (int i = 0; i < theLines.length; ++i) {
            if (theLines[i].length() == aWidth) continue;
            theLines[i] = ((HorizAlignTextBuilder)new HorizAlignTextBuilder().withHorizAlignTextMode(HorizAlignTextMode.CENTER).withText(new String[]{theLines[i]})).withColumnWidth(aWidth).withFillChar(aPalette[0]).toString();
        }
        return theLines;
    }

    protected static String[] toInverseAsciiArt(String aText, int aWidth, String aFontName, int aFontStyle, char[] aPalette) {
        char[] thePalette = new char[aPalette.length];
        System.arraycopy(aPalette, 0, thePalette, 0, aPalette.length);
        AsciiArtBuilder.reverseArray(thePalette);
        return AsciiArtBuilder.toAsciiArt(aText, aWidth, aFontName, aFontStyle, thePalette);
    }

    protected static String[] toInverseAsciiArt(String aText, int aWidth, Font aFont, char[] aPalette) {
        char[] thePalette = new char[aPalette.length];
        System.arraycopy(aPalette, 0, thePalette, 0, aPalette.length);
        AsciiArtBuilder.reverseArray(thePalette);
        return AsciiArtBuilder.toAsciiArt(aText, aWidth, aFont, thePalette);
    }

    protected static String[] toAsciiArt(String aText, int aWidth, String aFontName, int aFontStyle) {
        return AsciiArtBuilder.toAsciiArt(aText, aWidth, aFontName, aFontStyle, AsciiColorPalette.MAX_LEVEL_GRAY.getPalette());
    }

    protected static String[] toInverseAsciiArt(String aText, int aWidth, String aFontName, int aFontStyle) {
        char[] thePalette = new char[AsciiColorPalette.MAX_LEVEL_GRAY.getPalette().length];
        System.arraycopy(AsciiColorPalette.MAX_LEVEL_GRAY.getPalette(), 0, thePalette, 0, AsciiColorPalette.MAX_LEVEL_GRAY.getPalette().length);
        AsciiArtBuilder.reverseArray(thePalette);
        return AsciiArtBuilder.toAsciiArt(aText, aWidth, aFontName, aFontStyle, thePalette);
    }

    protected static String[] toAsciiArt(String aText, Font aFont) {
        return AsciiArtBuilder.toAsciiArt(aText, aFont, AsciiColorPalette.MAX_LEVEL_GRAY.getPalette());
    }

    protected static String[] toInverseAsciiArt(String aText, Font aFont) {
        char[] thePalette = new char[AsciiColorPalette.MAX_LEVEL_GRAY.getPalette().length];
        System.arraycopy(AsciiColorPalette.MAX_LEVEL_GRAY.getPalette(), 0, thePalette, 0, AsciiColorPalette.MAX_LEVEL_GRAY.getPalette().length);
        AsciiArtBuilder.reverseArray(thePalette);
        return AsciiArtBuilder.toAsciiArt(aText, aFont, thePalette);
    }

    protected static String[] toAsciiArt(String aText, Font aFont, char[] aPalette) {
        int theImageType = 10;
        BufferedImage theImage = new BufferedImage(1, 1, 10);
        Graphics theGraphics = theImage.getGraphics();
        theGraphics.setFont(aFont.toAwtFont());
        FontMetrics theFontMetrics = theGraphics.getFontMetrics();
        int theWidth = theFontMetrics.stringWidth(aText);
        int theHeight = theFontMetrics.getAscent() + theFontMetrics.getHeight() + theFontMetrics.getDescent();
        theImage = new BufferedImage(theWidth, theHeight, 10);
        theGraphics = theImage.getGraphics();
        theGraphics.setFont(aFont.toAwtFont());
        Graphics2D theGraphics2d = (Graphics2D)theGraphics;
        theGraphics2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        theGraphics2d.drawString(aText, 0, theHeight - theFontMetrics.getDescent());
        ArrayList<String> theLines = new ArrayList<String>();
        int theTrimBegin = theWidth;
        int theTrimEnd = 0;
        block0: for (int y = 0; y < theHeight; ++y) {
            int i;
            StringBuilder theBuffer = new StringBuilder();
            for (int x = 0; x < theWidth; ++x) {
                char eAsciiChar = AsciiArtBuilder.toAscii(theImage.getRGB(x, y), aPalette);
                theBuffer.append(eAsciiChar);
            }
            String eLine = theBuffer.toString();
            if (eLine.trim().isEmpty() || AsciiArtBuilder.isObsolete(eLine)) continue;
            theLines.add(eLine);
            for (i = 0; i < eLine.length(); ++i) {
                if (eLine.charAt(i) == ' ' || i >= theTrimBegin) continue;
                theTrimBegin = i;
                break;
            }
            for (i = eLine.length() - 1; i >= 0; --i) {
                if (eLine.charAt(i) == ' ' || i <= theTrimEnd) continue;
                theTrimEnd = i;
                continue block0;
            }
        }
        if (theTrimBegin == 0 && theTrimEnd == theWidth - 1) {
            return theLines.toArray(new String[theLines.size()]);
        }
        String[] theResult = new String[theLines.size()];
        for (int i = 0; i < theLines.size(); ++i) {
            theResult[i] = ((String)theLines.get(i)).substring(theTrimBegin, theTrimEnd + 1);
        }
        return theResult;
    }

    protected static String[] toInverseAsciiArt(String aText, Font aFont, char[] aPalette) {
        char[] thePalette = new char[aPalette.length];
        System.arraycopy(aPalette, 0, thePalette, 0, aPalette.length);
        AsciiArtBuilder.reverseArray(thePalette);
        return AsciiArtBuilder.toAsciiArt(aText, aFont, thePalette);
    }

    protected static char toAscii(int aRgbValue, char[] aPalette) {
        float theFactor = 256.0f / (float)aPalette.length;
        float theIndex = (float)GraphicalUtility.toGray(aRgbValue) / theFactor;
        int eGrayIndex = (int)theIndex;
        char theAsciiChar = aPalette[eGrayIndex];
        return theAsciiChar;
    }

    protected static char toAscii(int aRgbValue) {
        return AsciiArtBuilder.toAscii(aRgbValue, AsciiColorPalette.MAX_LEVEL_GRAY.getPalette());
    }

    private static boolean isObsolete(String aLine) {
        if (aLine == null || aLine.isEmpty()) {
            return true;
        }
        char theChar = aLine.charAt(0);
        for (int i = 1; i < aLine.length(); ++i) {
            if (aLine.charAt(i) == theChar) continue;
            return false;
        }
        return true;
    }

    private static void reverseArray(char[] aArray) {
        for (int i = 0; i < aArray.length / 2; ++i) {
            char eChar = aArray[i];
            aArray[i] = aArray[aArray.length - i - 1];
            aArray[aArray.length - i - 1] = eChar;
        }
    }
}

