/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.struct.ext.factory;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.refcodes.data.Encoding;
import org.refcodes.exception.MarshalException;
import org.refcodes.exception.UnmarshalException;
import org.refcodes.struct.CanonicalTable;
import org.refcodes.struct.ImmutableCanonicalTable;
import org.refcodes.struct.ImmutablePathTable;
import org.refcodes.struct.MapCanonicalTable;
import org.refcodes.struct.ext.factory.AbstractCanonicalTableFactory;
import org.refcodes.struct.ext.factory.DocumentOptions;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XmlCanonicalTableFactory
extends AbstractCanonicalTableFactory {
    protected static final String ROOT_SELECTOR = "root";
    public static final String COMMENT_OPEN = "<!--";
    public static final String COMMENT_CLOSE = "-->";
    private static final String XML_TEXT_VALUE = "#text";

    @Override
    public CanonicalTable fromMarshaled(InputStream aMarshaled, DocumentOptions aOptions) throws UnmarshalException {
        try {
            char theDelimiter = aOptions != null ? aOptions.getDelimiterOr(ImmutablePathTable.DELIMITER) : ImmutablePathTable.DELIMITER;
            MapCanonicalTable theCanonicalMap = new MapCanonicalTable(theDelimiter);
            DocumentBuilderFactory theFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder theBuilder = theFactory.newDocumentBuilder();
            Document theDocument = theBuilder.parse(new InputSource(aMarshaled));
            theDocument.normalize();
            NodeList theElements = theDocument.getChildNodes();
            this.visitElements(theCanonicalMap, theElements, theCanonicalMap.getRootPath(), theDelimiter);
            this.postProcess(theCanonicalMap);
            return theCanonicalMap;
        }
        catch (Exception e) {
            throw new UnmarshalException("Unable to unmarshal the external representation from stream <" + String.valueOf(aMarshaled) + ">!", e);
        }
    }

    @Override
    public String toMarshaled(ImmutableCanonicalTable aUnmarshaled, DocumentOptions aOptions) throws MarshalException {
        String theComment;
        Object theHeader;
        String theRootElement;
        String string = theRootElement = aOptions != null ? aOptions.getRootElement() : null;
        if (theRootElement == null || theRootElement.isEmpty()) {
            theRootElement = ROOT_SELECTOR;
        }
        if (aUnmarshaled.dirs().size() > 1 || aUnmarshaled.dirs().size() == 0 && aUnmarshaled.leaves().size() != 1 || aUnmarshaled.dirs().size() == 1 && aUnmarshaled.leaves().size() != 0) {
            aUnmarshaled = aUnmarshaled.retrieveTo(theRootElement);
        }
        if (aOptions != null && aOptions.getHeader() == null) {
            theHeader = "";
        } else {
            Object object = theHeader = aOptions != null ? aOptions.getHeader() : null;
        }
        if (theHeader == null) {
            boolean isStandAnlone;
            String theVersion;
            String theEncoding;
            String string2 = theEncoding = aOptions != null ? aOptions.getEncoding() : null;
            if (theEncoding == null || theEncoding.isEmpty()) {
                theEncoding = Encoding.UTF_8.getCode();
            }
            String string3 = theVersion = aOptions != null ? aOptions.getVersion() : null;
            if (theVersion == null || theVersion.isEmpty()) {
                theVersion = "1.0";
            }
            boolean bl = isStandAnlone = aOptions != null ? aOptions.isStandAloneOr(true) : true;
            if (theVersion == null || theVersion.isEmpty()) {
                theVersion = "1.0";
            }
            theHeader = "<?xml version=\"" + theVersion + "\" encoding=\"" + theEncoding + "\" standalone=\"" + (isStandAnlone ? "yes" : "no") + "\"?>";
        }
        if (((String)theHeader).length() != 0) {
            theHeader = (String)theHeader + System.lineSeparator();
        }
        String theXml = XmlCanonicalTableFactory.toXml(aUnmarshaled, aOptions != null ? aOptions.hasArrayIndexOr(false) : false);
        String string4 = theComment = aOptions != null ? aOptions.getComment() : null;
        if (theComment != null && theComment.length() > 0) {
            String[] theLines;
            for (String eLine : theLines = theComment.split("\\r?\\n")) {
                theHeader = (String)theHeader + "<!-- " + eLine + " -->" + System.lineSeparator();
            }
        }
        return (String)theHeader + theXml;
    }

    @Override
    public InputStream fromUnmarshaled(ImmutableCanonicalTable aUnmarshaled, DocumentOptions aOptions) throws MarshalException {
        String theMarshaled = this.toMarshaled(aUnmarshaled, aOptions);
        ByteArrayInputStream theMarshalledStream = new ByteArrayInputStream(theMarshaled.getBytes());
        return theMarshalledStream;
    }

    protected static String toXml(ImmutableCanonicalTable aImmutableCanonicalTable, boolean hasArrayIndexAttribute) {
        return XmlCanonicalTableFactory.toXml(aImmutableCanonicalTable, aImmutableCanonicalTable.getRootPath(), "", hasArrayIndexAttribute);
    }

    @Override
    protected void postProcess(CanonicalTable aProperties) {
        String theSuffix = aProperties.getDelimiter() + XML_TEXT_VALUE;
        for (String eKey : new ArrayList(aProperties.keySet())) {
            String eValue;
            String eToPath;
            if (!eKey.endsWith(theSuffix) || aProperties.isLeaf(eToPath = eKey.substring(0, eKey.length() - theSuffix.length())) || (eValue = (String)aProperties.remove((Object)eKey)) == null) continue;
            aProperties.put(eToPath, eValue);
        }
        super.postProcess(aProperties);
    }

    private static String toXml(ImmutableCanonicalTable aImmutableCanonicalTable, String aPath, String aIndent, boolean hasArrayIndexAttribute) {
        StringBuilder theBuffer = new StringBuilder();
        for (String eChild : aImmutableCanonicalTable.children(aPath)) {
            String theArray;
            String ePath = aImmutableCanonicalTable.toPath(aPath, eChild);
            if (aImmutableCanonicalTable.isArray(ePath)) {
                theArray = XmlCanonicalTableFactory.toArrayIndex(aImmutableCanonicalTable, aPath, eChild, aIndent, hasArrayIndexAttribute);
                theBuffer.append(theArray);
                continue;
            }
            if (aImmutableCanonicalTable.isIndexDir(ePath)) {
                theArray = XmlCanonicalTableFactory.toDirIndex(aImmutableCanonicalTable, aPath, eChild, aIndent, hasArrayIndexAttribute);
                theBuffer.append(theArray);
                continue;
            }
            if (eChild.startsWith("" + aImmutableCanonicalTable.getAnnotator())) continue;
            String theAttributes = XmlCanonicalTableFactory.toAttributes(aImmutableCanonicalTable, ePath);
            String eElement = XmlCanonicalTableFactory.toElement(aImmutableCanonicalTable, aPath, eChild, aIndent, theAttributes, hasArrayIndexAttribute);
            theBuffer.append(eElement);
        }
        return theBuffer.toString();
    }

    private static String toElement(ImmutableCanonicalTable aImmutableCanonicalTable, String aPath, String aChild, String aIndent, String aAttribs, boolean hasArrayIndexAttribute) {
        String theContent;
        StringBuilder theBuffer = new StringBuilder();
        String thePath = aImmutableCanonicalTable.toPath(aPath, aChild);
        theBuffer.append(aIndent);
        theBuffer.append("<" + aChild + aAttribs);
        String theValue = "";
        if (aImmutableCanonicalTable.containsKey((Object)thePath)) {
            theValue = (String)aImmutableCanonicalTable.get((Object)thePath);
        }
        if (((theContent = XmlCanonicalTableFactory.toXml(aImmutableCanonicalTable, thePath, aIndent + "\t", hasArrayIndexAttribute)) == null || theContent.isEmpty()) && (theValue == null || theValue.isEmpty())) {
            theBuffer.append("/>");
        } else {
            theBuffer.append(">");
            theBuffer.append(theValue);
            if (theContent.length() != 0) {
                theBuffer.append(System.lineSeparator());
                theBuffer.append(theContent);
                theBuffer.append(aIndent);
            }
            theBuffer.append("</" + aChild + ">");
            theBuffer.append(System.lineSeparator());
        }
        return theBuffer.toString();
    }

    private static String toAttributes(ImmutableCanonicalTable aImmutableCanonicalTable, String aPath) {
        StringBuilder theBuffer = new StringBuilder();
        Set<String> theAttribPaths = aImmutableCanonicalTable.queryPaths(aPath, ImmutablePathTable.ANNOTATOR + "*");
        for (String ePath : theAttribPaths) {
            String eValue = (String)aImmutableCanonicalTable.get((Object)ePath);
            String eLeaf = aImmutableCanonicalTable.toLeaf(ePath).substring(1);
            if (theBuffer.length() != 0) {
                theBuffer.append(" ");
            }
            theBuffer.append(eLeaf);
            theBuffer.append('=');
            theBuffer.append('\"');
            theBuffer.append(eValue);
            theBuffer.append('\"');
        }
        if (theBuffer.length() != 0) {
            theBuffer.insert(0, ' ');
        }
        return theBuffer.toString();
    }

    private static String toArrayIndex(ImmutableCanonicalTable aImmutableCanonicalTable, String aPath, String aChild, String aIndent, boolean hasArrayIndexAttribute) {
        StringBuilder theBuffer = new StringBuilder();
        String thePath = aImmutableCanonicalTable.toPath(aPath, aChild);
        int[] indexes = aImmutableCanonicalTable.getArrayIndexes(thePath);
        String theAttribs = XmlCanonicalTableFactory.toAttributes(aImmutableCanonicalTable, thePath);
        for (int i : indexes) {
            String eIndex = XmlCanonicalTableFactory.toArrayIndex(aImmutableCanonicalTable, thePath, i, aChild, theAttribs, aIndent, hasArrayIndexAttribute);
            theBuffer.append(eIndex);
        }
        return theBuffer.toString();
    }

    private static String toArrayIndex(ImmutableCanonicalTable aImmutableCanonicalTable, String aPath, int aIndex, String aElement, String aAttribs, String aIndent, boolean hasArrayIndexAttribute) {
        String theValue;
        String theAttribs = XmlCanonicalTableFactory.toAttributes(aImmutableCanonicalTable, aImmutableCanonicalTable.toPath(aPath, aIndex));
        aAttribs = (String)aAttribs + theAttribs;
        StringBuilder theBuffer = new StringBuilder();
        theBuffer.append(aIndent);
        theBuffer.append("<");
        theBuffer.append(aElement);
        theBuffer.append((String)aAttribs);
        if (hasArrayIndexAttribute) {
            theBuffer.append(" index=\"");
            theBuffer.append(aIndex);
            theBuffer.append("\"");
        }
        if ((theValue = (String)aImmutableCanonicalTable.get(aPath, aIndex)) == null || theValue.isEmpty()) {
            theBuffer.append("/>");
        } else {
            theBuffer.append('>');
            theBuffer.append(theValue);
            theBuffer.append("</");
            theBuffer.append(aElement);
            theBuffer.append('>');
        }
        theBuffer.append(System.lineSeparator());
        return theBuffer.toString();
    }

    private static String toDirIndex(ImmutableCanonicalTable aImmutableCanonicalTable, String aPath, String aChild, String aIndent, boolean hasArrayIndexAttribute) {
        StringBuilder theBuffer = new StringBuilder();
        String thePath = aImmutableCanonicalTable.toPath(aPath, aChild);
        int[] indexes = aImmutableCanonicalTable.getDirIndexes(thePath);
        String theAttribs = XmlCanonicalTableFactory.toAttributes(aImmutableCanonicalTable, thePath);
        for (int i : indexes) {
            CanonicalTable eCanonicalMap = aImmutableCanonicalTable.getDirAt(thePath, i);
            String eIndex = XmlCanonicalTableFactory.toDirIndex(eCanonicalMap, thePath, i, aChild, theAttribs, aIndent, hasArrayIndexAttribute);
            theBuffer.append(eIndex);
        }
        return theBuffer.toString();
    }

    private static String toDirIndex(ImmutableCanonicalTable aImmutableCanonicalTable, String aPath, int aIndex, String aElement, String aAttribs, String aIndent, boolean hasArrayIndexAttribute) {
        String theValue;
        StringBuilder theBuffer = new StringBuilder();
        String theAttribs = XmlCanonicalTableFactory.toAttributes(aImmutableCanonicalTable, aImmutableCanonicalTable.getRootPath());
        theBuffer.append(aIndent);
        theBuffer.append("<");
        theBuffer.append(aElement);
        theBuffer.append(aAttribs);
        theBuffer.append(theAttribs);
        if (hasArrayIndexAttribute) {
            theBuffer.append(" index=\"");
            theBuffer.append(aIndex);
            theBuffer.append("\"");
        }
        if ((theValue = XmlCanonicalTableFactory.toXml(aImmutableCanonicalTable, "", aIndent + "\t", hasArrayIndexAttribute)) == null || theValue.isEmpty()) {
            theBuffer.append("/>");
        } else {
            theBuffer.append('>');
            theBuffer.append(System.lineSeparator());
            theBuffer.append(theValue);
            theBuffer.append(System.lineSeparator());
            theBuffer.append(aIndent);
            theBuffer.append("</");
            theBuffer.append(aElement);
            theBuffer.append('>');
        }
        theBuffer.append(System.lineSeparator());
        return theBuffer.toString();
    }

    private void visitElements(CanonicalTable aCanonicalTable, NodeList aElements, String aPath, char aDelimiter) {
        for (int i = 0; i < aElements.getLength(); ++i) {
            this.visitElement(aCanonicalTable, aElements.item(i), aPath, aDelimiter);
        }
    }

    private void visitElement(CanonicalTable aCanonicalTable, Node aElement, String aPath, char aDelimiter) {
        aPath = aCanonicalTable.toPath(aPath, aElement.getNodeName());
        int next = this.toAttributeIndex(aElement.getAttributes());
        if (next != -1) {
            aPath = aCanonicalTable.toPath(aPath, next);
        }
        aPath = this.toIndexed(aCanonicalTable, aPath);
        NodeList eChildren = aElement.getChildNodes();
        if (aElement.getNodeType() == 3 || aElement.getNodeType() == 4) {
            String eValue = aElement.getTextContent();
            if (eValue != null && eValue.trim().isEmpty()) {
                eValue = null;
            }
            if (eValue != null) {
                aCanonicalTable.add(aPath, eValue);
            }
        }
        this.visitAttributes(aCanonicalTable, aElement.getAttributes(), aPath);
        this.visitElements(aCanonicalTable, eChildren, aPath, aDelimiter);
    }

    private void visitAttributes(CanonicalTable aCanonicalTable, NamedNodeMap aAttribs, String aPath) {
        if (aAttribs != null) {
            for (int i = 0; i < aAttribs.getLength(); ++i) {
                Node eAttribute = aAttribs.item(i);
                this.visitAttribute(aCanonicalTable, aPath, eAttribute);
            }
        }
    }

    private void visitAttribute(CanonicalTable aCanonicalTable, String aPath, Node eAttribute) {
        if (!"index".equals(eAttribute.getNodeName())) {
            aPath = aCanonicalTable.toPath(aPath, ImmutablePathTable.ANNOTATOR + eAttribute.getNodeName());
            aCanonicalTable.add(aPath, eAttribute.getNodeValue());
        }
    }

    private int toAttributeIndex(NamedNodeMap aAttribs) {
        int index = -1;
        if (aAttribs != null) {
            try {
                for (int i = 0; i < aAttribs.getLength(); ++i) {
                    Node eAttribute = aAttribs.item(i);
                    if (!"index".equals(eAttribute.getNodeName())) continue;
                    return Integer.parseInt(eAttribute.getNodeValue());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    private String toIndexed(CanonicalTable aCanonicalTable, String aPath) {
        if (aCanonicalTable.isIndexDir(aPath)) {
            aPath = aCanonicalTable.toPath(aPath, aCanonicalTable.nextDirIndex(aPath));
        } else if (aCanonicalTable.isDir(aPath)) {
            CanonicalTable theSubDirs = aCanonicalTable.removeFrom(aPath);
            aCanonicalTable.insertTo(aCanonicalTable.toPath(aPath, "0"), theSubDirs);
            aPath = aCanonicalTable.toPath(aPath, "1");
        }
        return aPath;
    }
}

