/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.struct;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.refcodes.data.BooleanLiterals;
import org.refcodes.data.Delimiter;
import org.refcodes.struct.CanonicalTable;
import org.refcodes.struct.ImmutableInterOperableTable;
import org.refcodes.struct.ImmutablePathTable;
import org.refcodes.struct.MapCanonicalTable;
import org.refcodes.struct.Property;
import org.refcodes.struct.Relation;

public interface ImmutableCanonicalTable
extends ImmutableInterOperableTable<String> {
    default public String[] asArray(Object aKey) {
        return this.asArray(aKey instanceof String ? (String)aKey : (aKey != null ? aKey.toString() : (String)null));
    }

    default public String[] asArray(Object aKey, char aDelimiter) {
        return this.asArray(aKey instanceof String ? (String)aKey : (aKey != null ? aKey.toString() : (String)null));
    }

    default public String[] asArray(String aKey) {
        return this.asArray(aKey, Delimiter.LIST.getChar());
    }

    default public String[] asArray(String aKey, char aDelimiter) {
        String[] theArray = null;
        String theValue = (String)this.get((Object)aKey);
        if (theValue != null && theValue.length() != 0) {
            theArray = theValue.split(Pattern.quote("" + aDelimiter));
        }
        return theArray;
    }

    default public boolean[] asBooleanArray(Object aKey) {
        return this.asBooleanArray(aKey instanceof String ? (String)aKey : (aKey != null ? aKey.toString() : (String)null));
    }

    default public boolean[] asBooleanArray(Object aKey, char aDelimiter) {
        return this.asBooleanArray(aKey instanceof String ? (String)aKey : (aKey != null ? aKey.toString() : (String)null));
    }

    default public boolean[] asBooleanArray(String aKey) {
        return this.asBooleanArray(aKey, Delimiter.LIST.getChar());
    }

    default public boolean[] asBooleanArray(String aKey, char aDelimiter) {
        boolean[] theBooleanArray = null;
        Object[] theArray = this.asArray(aKey, aDelimiter);
        if (theArray != null) {
            theBooleanArray = new boolean[theArray.length];
            block0: for (int i = 0; i < theArray.length; ++i) {
                for (String eTrue : BooleanLiterals.TRUE.getNames()) {
                    if (!eTrue.equalsIgnoreCase(theArray[i].trim())) continue;
                    theBooleanArray[i] = true;
                    continue block0;
                }
                for (String eFalse : BooleanLiterals.FALSE.getNames()) {
                    if (!eFalse.equalsIgnoreCase(((String)theArray[i]).trim())) continue;
                    theBooleanArray[i] = false;
                    continue block0;
                }
                throw new NumberFormatException("Unable to parse boolean from key <" + aKey + "> using delimiter '" + aDelimiter + "' at position <" + i + "> of the array <" + Arrays.toString(theArray) + ">!");
            }
        }
        return theBooleanArray;
    }

    default public byte[] asByteArray(Object aKey) {
        return this.asByteArray(aKey instanceof String ? (String)aKey : (aKey != null ? aKey.toString() : (String)null));
    }

    default public byte[] asByteArray(Object aKey, char aDelimiter) {
        return this.asByteArray(aKey instanceof String ? (String)aKey : (aKey != null ? aKey.toString() : (String)null));
    }

    default public byte[] asByteArray(String aKey) {
        return this.asByteArray(aKey, Delimiter.LIST.getChar());
    }

    default public byte[] asByteArray(String aKey, char aDelimiter) {
        byte[] theToArray = null;
        String[] theArray = this.asArray(aKey, aDelimiter);
        if (theArray != null) {
            theToArray = new byte[theArray.length];
            for (int i = 0; i < theArray.length; ++i) {
                String eValue = theArray[i].trim();
                if (eValue.endsWith(".0")) {
                    eValue = eValue.substring(0, eValue.length() - 2);
                }
                theToArray[i] = Byte.valueOf(eValue);
            }
        }
        return theToArray;
    }

    default public char[] asCharArray(Object aKey) {
        return this.asCharArray(aKey instanceof String ? (String)aKey : (aKey != null ? aKey.toString() : (String)null));
    }

    default public char[] asCharArray(Object aKey, char aDelimiter) {
        return this.asCharArray(aKey instanceof String ? (String)aKey : (aKey != null ? aKey.toString() : (String)null));
    }

    default public char[] asCharArray(String aKey) {
        return this.asCharArray(aKey, Delimiter.LIST.getChar());
    }

    default public char[] asCharArray(String aKey, char aDelimiter) {
        char[] theToArray = null;
        Object[] theArray = this.asArray(aKey, aDelimiter);
        if (theArray != null) {
            theToArray = new char[theArray.length];
            for (int i = 0; i < theArray.length; ++i) {
                String eValue = theArray[i].trim();
                if (eValue.isEmpty()) {
                    eValue = theArray[i];
                }
                if (eValue.length() != 1) {
                    throw new NumberFormatException("Unable to convert from key <" + aKey + "> using delimiter '" + aDelimiter + "' at position <" + i + "> of the array <" + Arrays.toString(theArray) + ">!");
                }
                theToArray[i] = eValue.charAt(0);
            }
        }
        return theToArray;
    }

    default public double[] asDoubleArray(Object aKey) {
        return this.asDoubleArray(aKey instanceof String ? (String)aKey : (aKey != null ? aKey.toString() : (String)null));
    }

    default public double[] asDoubleArray(Object aKey, char aDelimiter) {
        return this.asDoubleArray(aKey instanceof String ? (String)aKey : (aKey != null ? aKey.toString() : (String)null));
    }

    default public double[] asDoubleArray(String aKey) {
        return this.asDoubleArray(aKey, Delimiter.LIST.getChar());
    }

    default public double[] asDoubleArray(String aKey, char aDelimiter) {
        double[] theToArray = null;
        String[] theArray = this.asArray(aKey, aDelimiter);
        if (theArray != null) {
            theToArray = new double[theArray.length];
            for (int i = 0; i < theArray.length; ++i) {
                theToArray[i] = Double.valueOf(theArray[i].trim());
            }
        }
        return theToArray;
    }

    default public float[] asFloatArray(Object aKey) {
        return this.asFloatArray(aKey instanceof String ? (String)aKey : (aKey != null ? aKey.toString() : (String)null));
    }

    default public float[] asFloatArray(Object aKey, char aDelimiter) {
        return this.asFloatArray(aKey instanceof String ? (String)aKey : (aKey != null ? aKey.toString() : (String)null));
    }

    default public float[] asFloatArray(String aKey) {
        return this.asFloatArray(aKey, Delimiter.LIST.getChar());
    }

    default public float[] asFloatArray(String aKey, char aDelimiter) {
        float[] theToArray = null;
        String[] theArray = this.asArray(aKey, aDelimiter);
        if (theArray != null) {
            theToArray = new float[theArray.length];
            for (int i = 0; i < theArray.length; ++i) {
                theToArray[i] = Float.valueOf(theArray[i].trim()).floatValue();
            }
        }
        return theToArray;
    }

    default public int[] asIntArray(Object aKey) {
        return this.asIntArray(aKey instanceof String ? (String)aKey : (aKey != null ? aKey.toString() : (String)null));
    }

    default public int[] asIntArray(Object aKey, char aDelimiter) {
        return this.asIntArray(aKey instanceof String ? (String)aKey : (aKey != null ? aKey.toString() : (String)null));
    }

    default public int[] asIntArray(String aKey) {
        return this.asIntArray(aKey, Delimiter.LIST.getChar());
    }

    default public int[] asIntArray(String aKey, char aDelimiter) {
        int[] theToArray = null;
        String[] theArray = this.asArray(aKey, aDelimiter);
        if (theArray != null) {
            theToArray = new int[theArray.length];
            for (int i = 0; i < theArray.length; ++i) {
                String eValue = theArray[i].trim();
                if (eValue.endsWith(".0")) {
                    eValue = eValue.substring(0, eValue.length() - 2);
                }
                theToArray[i] = Integer.valueOf(eValue);
            }
        }
        return theToArray;
    }

    default public long[] asLongArray(Object aKey) {
        return this.asLongArray(aKey instanceof String ? (String)aKey : (aKey != null ? aKey.toString() : (String)null));
    }

    default public long[] asLongArray(Object aKey, char aDelimiter) {
        return this.asLongArray(aKey instanceof String ? (String)aKey : (aKey != null ? aKey.toString() : (String)null));
    }

    default public long[] asLongArray(String aKey) {
        return this.asLongArray(aKey, Delimiter.LIST.getChar());
    }

    default public long[] asLongArray(String aKey, char aDelimiter) {
        long[] theToArray = null;
        String[] theArray = this.asArray(aKey, aDelimiter);
        if (theArray != null) {
            theToArray = new long[theArray.length];
            for (int i = 0; i < theArray.length; ++i) {
                String eValue = theArray[i].trim();
                if (eValue.endsWith(".0")) {
                    eValue = eValue.substring(0, eValue.length() - 2);
                }
                theToArray[i] = Long.valueOf(eValue);
            }
        }
        return theToArray;
    }

    default public short[] asShortArray(Object aKey) {
        return this.asShortArray(aKey instanceof String ? (String)aKey : (aKey != null ? aKey.toString() : (String)null));
    }

    default public short[] asShortArray(Object aKey, char aDelimiter) {
        return this.asShortArray(aKey instanceof String ? (String)aKey : (aKey != null ? aKey.toString() : (String)null));
    }

    default public short[] asShortArray(String aKey) {
        return this.asShortArray(aKey, Delimiter.LIST.getChar());
    }

    default public short[] asShortArray(String aKey, char aDelimiter) {
        short[] theToArray = null;
        String[] theArray = this.asArray(aKey, aDelimiter);
        if (theArray != null) {
            theToArray = new short[theArray.length];
            for (int i = 0; i < theArray.length; ++i) {
                String eValue = theArray[i].trim();
                if (eValue.endsWith(".0")) {
                    eValue = eValue.substring(0, eValue.length() - 2);
                }
                theToArray[i] = Short.valueOf(eValue);
            }
        }
        return theToArray;
    }

    @Override
    default public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    default public CanonicalTable getDirAt(String[] aPathElements, int aIndex) {
        return this.getDirAt(this.toPath(aPathElements), aIndex);
    }

    default public CanonicalTable getDirAt(int aIndex) {
        return this.getDirAt(this.getRootPath(), aIndex);
    }

    default public CanonicalTable getDirAt(String aPath, int aIndex) {
        return this.retrieveFrom(this.toPath(aPath, Integer.toString(aIndex)));
    }

    default public CanonicalTable getDirAt(Collection<?> aPathElements, int aIndex) {
        return this.getDirAt(this.toPath(aPathElements), aIndex);
    }

    default public CanonicalTable getDirAt(Object aPath, int aIndex) {
        return this.getDirAt(this.toPath(aPath), aIndex);
    }

    default public CanonicalTable getDirAt(Object[] aPathElements, int aIndex) {
        return this.getDirAt(this.toPath(aPathElements), aIndex);
    }

    default public CanonicalTable query(Collection<?> aQueryElements) {
        return this.query(this.toPath(aQueryElements));
    }

    default public CanonicalTable query(Object ... aQueryElements) {
        return this.query(this.toPath(aQueryElements));
    }

    default public CanonicalTable query(Pattern aRegExp) {
        return new MapCanonicalTable(ImmutableInterOperableTable.super.query(aRegExp));
    }

    default public CanonicalTable query(String aPathQuery) {
        return new MapCanonicalTable(ImmutableInterOperableTable.super.query(aPathQuery));
    }

    default public CanonicalTable query(String ... aQueryElements) {
        return this.query(this.toPath(aQueryElements));
    }

    default public CanonicalTable queryBetween(Collection<?> aFromPath, Collection<?> aPathQuery, Collection<?> aToPath) {
        return this.queryBetween(this.toPath(aFromPath), this.toPath(aPathQuery), this.toPath(aToPath));
    }

    default public CanonicalTable queryBetween(Object aFromPath, Object aPathQuery, Object aToPath) {
        return this.queryBetween(this.toPath(aFromPath), this.toPath(aPathQuery), this.toPath(aToPath));
    }

    default public CanonicalTable queryBetween(Object[] aFromPath, Object[] aPathQuery, Object[] aToPath) {
        return this.queryBetween(this.toPath(aFromPath), this.toPath(aPathQuery), this.toPath(aToPath));
    }

    default public CanonicalTable queryBetween(String aFromPath, Pattern aRegExp, String aToPath) {
        return new MapCanonicalTable(ImmutableInterOperableTable.super.queryBetween(aFromPath, aRegExp, aToPath));
    }

    default public CanonicalTable queryBetween(String aFromPath, String aPathQuery, String aToPath) {
        return new MapCanonicalTable(ImmutableInterOperableTable.super.queryBetween(aFromPath, aPathQuery, aToPath));
    }

    default public CanonicalTable queryBetween(String[] aFromPath, String[] aPathQuery, String[] aToPath) {
        return this.queryBetween(this.toPath(aFromPath), this.toPath(aPathQuery), this.toPath(aToPath));
    }

    default public CanonicalTable queryFrom(Collection<?> aPathQuery, Collection<?> aFromPath) {
        return this.queryFrom(this.toPath(aPathQuery), this.toPath(aFromPath));
    }

    default public CanonicalTable queryFrom(Object aPathQuery, Object aFromPath) {
        return this.queryFrom(this.toPath(aPathQuery), this.toPath(aFromPath));
    }

    default public CanonicalTable queryFrom(Object[] aPathQuery, Object[] aFromPath) {
        return this.queryFrom(this.toPath(aPathQuery), this.toPath(aFromPath));
    }

    default public CanonicalTable queryFrom(Pattern aRegExp, String aFromPath) {
        return new MapCanonicalTable(ImmutableInterOperableTable.super.queryFrom(aRegExp, aFromPath));
    }

    default public CanonicalTable queryFrom(String aPathQuery, String aFromPath) {
        return new MapCanonicalTable(ImmutableInterOperableTable.super.queryFrom(aPathQuery, aFromPath));
    }

    default public CanonicalTable queryFrom(String[] aPathQuery, String[] aFromPath) {
        return this.queryFrom(this.toPath(aPathQuery), this.toPath(aFromPath));
    }

    default public CanonicalTable queryTo(Collection<?> aPathQuery, String aToPath) {
        return this.queryTo(this.toPath(aPathQuery), this.toPath((Object)aToPath));
    }

    default public CanonicalTable queryTo(Object aPathQuery, String aToPath) {
        return this.queryTo(this.toPath(aPathQuery), this.toPath((Object)aToPath));
    }

    default public CanonicalTable queryTo(Object[] aPathQuery, String aToPath) {
        return this.queryTo(this.toPath(aPathQuery), this.toPath((Object)aToPath));
    }

    default public CanonicalTable queryTo(Pattern aRegExp, String aToPath) {
        return new MapCanonicalTable(ImmutableInterOperableTable.super.queryTo(aRegExp, aToPath));
    }

    default public CanonicalTable queryTo(String aPathQuery, String aToPath) {
        return new MapCanonicalTable(ImmutableInterOperableTable.super.queryTo(aPathQuery, aToPath));
    }

    default public CanonicalTable queryTo(String[] aPathQuery, String aToPath) {
        return this.queryTo(this.toPath(aPathQuery), this.toPath((Object)aToPath));
    }

    default public CanonicalTable retrieveBetween(Collection<?> aFromPath, Collection<?> aToPath) {
        return this.retrieveBetween(this.toPath(aFromPath), this.toPath(aToPath));
    }

    default public CanonicalTable retrieveBetween(Object aFromPath, Object aToPath) {
        return this.retrieveBetween(this.toPath(aFromPath), this.toPath(aToPath));
    }

    default public CanonicalTable retrieveBetween(Object[] aFromPath, Object[] aToPath) {
        return this.retrieveBetween(this.toPath(aFromPath), this.toPath(aToPath));
    }

    default public CanonicalTable retrieveBetween(String aFromPath, String aToPath) {
        CanonicalTable thePathMap = this.retrieveFrom(aFromPath);
        return thePathMap.retrieveTo(aToPath);
    }

    default public CanonicalTable retrieveBetween(String[] aFromPath, String[] aToPath) {
        return this.retrieveBetween(this.toPath(aFromPath), this.toPath(aToPath));
    }

    default public CanonicalTable retrieveFrom(Collection<?> aPathElements) {
        return this.retrieveFrom(this.toPath(aPathElements));
    }

    default public CanonicalTable retrieveFrom(Object aParentPath) {
        return this.retrieveFrom(this.toPath(aParentPath));
    }

    default public CanonicalTable retrieveFrom(Object ... aPathElements) {
        return this.retrieveFrom(this.toPath(aPathElements));
    }

    public CanonicalTable retrieveFrom(String var1);

    default public CanonicalTable retrieveFrom(String ... aPathElements) {
        return this.retrieveFrom(this.toPath(aPathElements));
    }

    default public CanonicalTable retrieveTo(Collection<?> aToPathElements) {
        return this.retrieveTo(this.toPath(aToPathElements));
    }

    default public CanonicalTable retrieveTo(Object aToPath) {
        return this.retrieveTo(this.toPath(aToPath));
    }

    default public CanonicalTable retrieveTo(Object ... aToPathElements) {
        return this.retrieveTo(this.toPath(aToPathElements));
    }

    public CanonicalTable retrieveTo(String var1);

    default public CanonicalTable retrieveTo(String ... aToPathElements) {
        return this.retrieveTo(this.toPath(aToPathElements));
    }

    default public CanonicalTable getDir(Collection<?> aPathElements) {
        return this.getDir(this.toPath(aPathElements));
    }

    default public CanonicalTable getDir(Object aPath) {
        return this.getDir(this.toPath(aPath));
    }

    default public CanonicalTable getDir(Object ... aPathElements) {
        return this.getDir(this.toPath(aPathElements));
    }

    default public CanonicalTable getDir(String aPath) {
        return this.retrieveFrom(aPath);
    }

    default public CanonicalTable getDir(String ... aPathElements) {
        return this.getDir(this.toPath(aPathElements));
    }

    default public CanonicalTable[] getDirs(Collection<?> aPathElements) {
        return this.getDirs(this.toPath(aPathElements));
    }

    default public CanonicalTable[] getDirs(Object aPath) {
        return this.getDirs(this.toPath(aPath));
    }

    default public CanonicalTable[] getDirs(Object ... aPathElements) {
        return this.getDirs(this.toPath(aPathElements));
    }

    default public CanonicalTable[] getDirs(String aPath) {
        CanonicalTable[] theDirs;
        if (this.isIndexDir(aPath)) {
            int[] theIndexes = this.getDirIndexes(aPath);
            theDirs = new CanonicalTable[theIndexes[theIndexes.length - 1] + 1];
            for (int i : theIndexes) {
                theDirs[theIndexes[i]] = this.getDirAt(aPath, theIndexes[i]);
            }
        } else {
            theDirs = new CanonicalTable[]{this.getDir(aPath)};
        }
        return theDirs;
    }

    default public CanonicalTable[] getDirs(String ... aPathElements) {
        return this.getDirs(this.toPath(aPathElements));
    }

    @Override
    default public Map<String, String> toMap() {
        HashMap<String, String> theProperties = new HashMap<String, String>();
        for (String eKey : this.keySet()) {
            theProperties.put(eKey, (String)this.get((Object)eKey));
        }
        return theProperties;
    }

    default public Properties toProperties() {
        Properties theProperties = new Properties();
        for (String eKey : this.keySet()) {
            theProperties.put(this.toPropertyPath(eKey), this.get((Object)eKey));
        }
        return theProperties;
    }

    public static interface MutableCanonicalTable
    extends ImmutableCanonicalTable,
    ImmutableInterOperableTable.MutableInterOperableTable<String>,
    Map<String, String> {
        @Override
        default public boolean containsValue(Object value) {
            return this.values().contains(value);
        }

        default public void insert(ImmutableCanonicalTable aFrom) {
            this.insert((Object)aFrom);
        }

        default public void insertBetween(String aToPath, ImmutableCanonicalTable aFrom, String aFromPath) {
            this.insertBetween(aToPath, (Object)aFrom, aFromPath);
        }

        default public void insertFrom(ImmutableCanonicalTable aFrom, String aFromPath) {
            this.insertFrom((Object)aFrom, aFromPath);
        }

        default public void insertTo(String aToPath, ImmutableCanonicalTable aFrom) {
            this.insertTo(aToPath, (Object)aFrom);
        }

        @Override
        default public String put(Object aKey, String aValue) {
            return this.put(aKey instanceof String ? (String)aKey : (aKey != null ? aKey.toString() : (String)null), aValue);
        }

        @Override
        default public String put(Object[] aPathElements, String aValue) {
            return this.put(this.toPath(aPathElements), aValue);
        }

        default public String put(Property aProperty) {
            return this.put((String)aProperty.getKey(), (String)aProperty.getValue());
        }

        @Override
        default public String put(Relation<String, String> aRelation) {
            return this.put((String)aRelation.getKey(), (String)aRelation.getValue());
        }

        @Override
        default public String put(String[] aPathElements, String aValue) {
            return this.put(this.toPath(aPathElements), aValue);
        }

        default public void putAll(ImmutableCanonicalTable aProperties) {
            for (Object eKey : aProperties.keySet()) {
                this.put((String)eKey, (String)this.get(eKey));
            }
        }

        default public void putAll(Properties aProperties) {
            for (Object eKey : aProperties.keySet()) {
                this.put((String)eKey, (String)this.get(eKey));
            }
        }

        @Override
        default public void putAll(Map<? extends String, ? extends String> aProperties) {
            for (String string : aProperties.keySet()) {
                this.put(string, (String)this.get((Object)string));
            }
        }

        default public CanonicalTable putDirAt(Collection<?> aPathElements, int aIndex, Object aDir) {
            return this.putDirAt(this.toPath(aPathElements), aIndex, aDir);
        }

        default public CanonicalTable putDirAt(Collection<?> aPathElements, int aIndex, ImmutablePathTable<String> aDir) {
            return this.putDirAt(this.toPath(aPathElements), aIndex, (ImmutablePathTable)aDir);
        }

        default public CanonicalTable putDirAt(int aIndex, Object aDir) {
            return this.putDirAt(this.getRootPath(), aIndex, aDir);
        }

        default public CanonicalTable putDirAt(int aIndex, ImmutablePathTable<String> aDir) {
            return this.putDirAt(this.getRootPath(), aIndex, (ImmutablePathTable)aDir);
        }

        default public CanonicalTable putDirAt(Object aPath, int aIndex, Object aDir) {
            return this.putDirAt(this.toPath(aPath), aIndex, aDir);
        }

        default public CanonicalTable putDirAt(Object aPath, int aIndex, ImmutablePathTable<String> aDir) {
            return this.putDirAt(this.toPath(aPath), aIndex, (ImmutablePathTable)aDir);
        }

        default public CanonicalTable putDirAt(Object[] aPathElements, int aIndex, Object aDir) {
            return this.putDirAt(this.toPath(aPathElements), aIndex, aDir);
        }

        default public CanonicalTable putDirAt(Object[] aPathElements, int aIndex, ImmutablePathTable<String> aDir) {
            return this.putDirAt(this.toPath(aPathElements), aIndex, (ImmutablePathTable)aDir);
        }

        default public CanonicalTable putDirAt(String aPath, int aIndex, Object aDir) {
            CanonicalTable theReplaced = this.removeDirAt(aPath, aIndex);
            this.insertTo(this.toPath(aPath, aIndex), aDir);
            return theReplaced;
        }

        default public CanonicalTable putDirAt(String aPath, int aIndex, ImmutablePathTable<String> aDir) {
            CanonicalTable theReplaced = this.removeDirAt(aPath, aIndex);
            this.insertTo(this.toPath(aPath, aIndex), aDir);
            return theReplaced;
        }

        default public CanonicalTable putDirAt(String[] aPathElements, int aIndex, Object aDir) {
            return this.putDirAt(this.toPath(aPathElements), aIndex, aDir);
        }

        default public CanonicalTable putDirAt(String[] aPathElements, int aIndex, ImmutablePathTable<String> aDir) {
            return this.putDirAt(this.toPath(aPathElements), aIndex, (ImmutablePathTable)aDir);
        }

        default public CanonicalTable removeAll(Collection<?> aPathQueryElements) {
            return new MapCanonicalTable(ImmutableInterOperableTable.MutableInterOperableTable.super.removeAll(aPathQueryElements));
        }

        default public CanonicalTable removeAll(Object ... aPathQueryElements) {
            return new MapCanonicalTable(ImmutableInterOperableTable.MutableInterOperableTable.super.removeAll(aPathQueryElements));
        }

        default public CanonicalTable removeAll(Object aPathQuery) {
            return new MapCanonicalTable(ImmutableInterOperableTable.MutableInterOperableTable.super.removeAll(aPathQuery));
        }

        default public CanonicalTable removeAll(Pattern aRegExp) {
            return new MapCanonicalTable(ImmutableInterOperableTable.MutableInterOperableTable.super.removeAll(aRegExp));
        }

        default public CanonicalTable removeAll(String ... aPathQueryElements) {
            return new MapCanonicalTable(ImmutableInterOperableTable.MutableInterOperableTable.super.removeAll(aPathQueryElements));
        }

        default public CanonicalTable removeAll(String aPathQuery) {
            return new MapCanonicalTable(ImmutableInterOperableTable.MutableInterOperableTable.super.removeAll(aPathQuery));
        }

        default public CanonicalTable removeDirAt(int aIndex) {
            return new MapCanonicalTable(ImmutableInterOperableTable.MutableInterOperableTable.super.removeDirAt(aIndex));
        }

        default public CanonicalTable removeDirAt(Object aPath, int aIndex) {
            return new MapCanonicalTable(ImmutableInterOperableTable.MutableInterOperableTable.super.removeDirAt(aPath, aIndex));
        }

        default public CanonicalTable removeDirAt(Object[] aPathElements, int aIndex) {
            return new MapCanonicalTable(ImmutableInterOperableTable.MutableInterOperableTable.super.removeDirAt(aPathElements, aIndex));
        }

        default public CanonicalTable removeDirAt(String aPath, int aIndex) {
            return new MapCanonicalTable(ImmutableInterOperableTable.MutableInterOperableTable.super.removeDirAt(aPath, aIndex));
        }

        default public CanonicalTable removeDirAt(String[] aPathElements, int aIndex) {
            return new MapCanonicalTable(ImmutableInterOperableTable.MutableInterOperableTable.super.removeDirAt(aPathElements, aIndex));
        }

        default public CanonicalTable removeFrom(Collection<?> aPathElements) {
            return new MapCanonicalTable(ImmutableInterOperableTable.MutableInterOperableTable.super.removeFrom(aPathElements));
        }

        default public CanonicalTable removeFrom(Object ... aPathElements) {
            return new MapCanonicalTable(ImmutableInterOperableTable.MutableInterOperableTable.super.removeFrom(aPathElements));
        }

        default public CanonicalTable removeFrom(Object aPath) {
            return new MapCanonicalTable(ImmutableInterOperableTable.MutableInterOperableTable.super.removeFrom(aPath));
        }

        default public CanonicalTable removeFrom(String aPath) {
            return new MapCanonicalTable(ImmutableInterOperableTable.MutableInterOperableTable.super.removeFrom(aPath));
        }

        default public CanonicalTable removeFrom(String ... aPathElements) {
            return new MapCanonicalTable(ImmutableInterOperableTable.MutableInterOperableTable.super.removeFrom(aPathElements));
        }

        default public CanonicalTable removePaths(Collection<?> aPaths) {
            return new MapCanonicalTable(ImmutableInterOperableTable.MutableInterOperableTable.super.removePaths(aPaths));
        }

        default public CanonicalTable removePaths(String ... aPaths) {
            return new MapCanonicalTable(ImmutableInterOperableTable.MutableInterOperableTable.super.removePaths(aPaths));
        }
    }
}

