/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.logger;

import org.refcodes.controlflow.InvocationStrategy;
import org.refcodes.criteria.BadCriteriaException;
import org.refcodes.criteria.Criteria;
import org.refcodes.exception.BugException;
import org.refcodes.logger.AbstractLoggerDispatcher;
import org.refcodes.logger.LoggerUtility;
import org.refcodes.logger.QueryLogger;
import org.refcodes.tabular.Header;
import org.refcodes.tabular.Records;

abstract class AbstractQueryLoggerDispatcher<L extends QueryLogger<T>, T>
extends AbstractLoggerDispatcher<L, T>
implements QueryLogger<T> {
    @SafeVarargs
    public AbstractQueryLoggerDispatcher(L ... aLoggers) {
        super(aLoggers);
    }

    @Override
    public Records<T> findLogs() {
        try {
            return this.findLogs(null, null, -1);
        }
        catch (BadCriteriaException e) {
            throw new BugException("We must not get this exception <" + e.getClass().getName() + "> as no criteria has been provided: ", e);
        }
    }

    @Override
    public Records<T> findLogs(int aLimit) {
        try {
            return this.findLogs(null, null, aLimit);
        }
        catch (BadCriteriaException e) {
            throw new BugException("We must not get this exception <" + e.getClass().getName() + "> as no criteria has been provided: ", e);
        }
    }

    @Override
    public Records<T> findLogs(Criteria aCriteria) {
        try {
            return this.findLogs(aCriteria, null, -1);
        }
        catch (BadCriteriaException e) {
            throw new BugException("We must not get this exception <" + e.getClass().getName() + "> as no criteria has been provided: ", e);
        }
    }

    @Override
    public Records<T> findLogs(Header<T> aHeader, int aLimit) {
        try {
            return this.findLogs(null, aHeader, aLimit);
        }
        catch (BadCriteriaException e) {
            throw new BugException("We must not get this exception <" + e.getClass().getName() + "> as no criteria has been provided: ", e);
        }
    }

    @Override
    public Records<T> findLogs(Criteria aCriteria, int aLimit) throws BadCriteriaException {
        return this.findLogs(aCriteria, null, aLimit);
    }

    @Override
    public Records<T> findLogs(Criteria aCriteria, Header<T> aHeader) throws BadCriteriaException {
        return this.findLogs(aCriteria, aHeader, -1);
    }

    @Override
    public Records<T> findLogs(Criteria aCriteria, Header<T> aHeader, int aLimit) throws BadCriteriaException {
        return LoggerUtility.findLogs(aCriteria, aHeader, aLimit, this.getLoggers(), InvocationStrategy.ROUND_ROBIN);
    }
}

