/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.IOException;
import java.io.OutputStream;
import org.refcodes.io.ByteTransmitter;
import org.refcodes.io.BytesSource;
import org.refcodes.mixin.OutputStreamAccessor;

public interface BytesTransmitter
extends BytesSource,
ByteTransmitter,
OutputStreamAccessor {
    @Override
    default public void transmitBytes(byte[] aBytes, int aOffset, int aLength) throws IOException {
        for (int i = 0; i < aLength; ++i) {
            this.transmitByte(aBytes[aOffset + i]);
        }
    }

    @Override
    default public OutputStream getOutputStream() {
        return new TransmitterOutputStream(this);
    }

    public static class TransmitterOutputStream
    extends OutputStream {
        private final BytesTransmitter _transmitter;
        private boolean _isClosed = false;

        public TransmitterOutputStream(BytesTransmitter aBytesTransmitter) {
            this._transmitter = aBytesTransmitter;
        }

        @Override
        public void write(int aByte) throws IOException {
            if (this._isClosed) {
                throw new IOException("The stream has already been closed!");
            }
            this._transmitter.transmitByte((byte)aByte);
        }

        @Override
        public void write(byte[] aBytes, int aOffset, int aLength) throws IOException {
            if (this._isClosed) {
                throw new IOException("The stream has already been closed!");
            }
            this._transmitter.transmitBytes(aBytes, aOffset, aLength);
        }

        @Override
        public void close() throws IOException {
            this._isClosed = true;
            super.close();
        }
    }
}

