/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.refcodes.data.IoTimeout;
import org.refcodes.exception.TimeoutIOException;
import org.refcodes.io.TimeoutInputStream;

public class AvailableInputStream
extends TimeoutInputStream {
    private Object _monitor;

    public AvailableInputStream(InputStream aInputStream, long aTimeoutMillis) {
        this(aInputStream, aTimeoutMillis, (Object)null);
    }

    public AvailableInputStream(InputStream aInputStream, Long aTimeoutMillis) {
        this(aInputStream, (long)aTimeoutMillis, (Object)null);
    }

    public AvailableInputStream(InputStream aInputStream, Object aMonitor) {
        this(aInputStream, -1L, aMonitor);
    }

    public AvailableInputStream(InputStream aInputStream) {
        this(aInputStream, -1L, (Object)null);
    }

    public AvailableInputStream(InputStream aInputStream, long aTimeoutMillis, Object aMonitor) {
        super(aInputStream, aTimeoutMillis);
        this._monitor = aMonitor != null ? aMonitor : this;
    }

    @Override
    public int read(long aTimeoutMillis) throws IOException {
        if (this._isClosed) {
            return -1;
        }
        try {
            this.waitForBytesAvailable(1, aTimeoutMillis);
            return this._inputStream.read();
        }
        catch (EOFException e) {
            return -1;
        }
        catch (IOException e) {
            if (this._isClosed) {
                return -1;
            }
            throw e;
        }
    }

    @Override
    public int read(byte[] b, int off, int len, long aTimeoutMillis) throws IOException {
        try {
            this.waitForBytesAvailable(len, aTimeoutMillis);
            return this._inputStream.read(b, off, len);
        }
        catch (EOFException e) {
            return -1;
        }
    }

    @Override
    public int read(byte[] b, long aTimeoutMillis) throws IOException {
        if (b != null && b.length != 0) {
            int len = b.length;
            try {
                this.waitForBytesAvailable(len, aTimeoutMillis);
                return this._inputStream.read(b);
            }
            catch (EOFException e) {
                return -1;
            }
        }
        return 0;
    }

    @Override
    public int readNBytes(byte[] b, int off, int len, long aTimeoutMillis) throws IOException {
        if (b != null && b.length != 0) {
            try {
                this.waitForBytesAvailable(len, aTimeoutMillis);
                return this._inputStream.readNBytes(b, off, len);
            }
            catch (EOFException e) {
                return -1;
            }
        }
        return 0;
    }

    @Override
    public byte[] readNBytes(int len, long aTimeoutMillis) throws IOException {
        if (len > 0) {
            this.waitForBytesAvailable(len, aTimeoutMillis);
            return this._inputStream.readNBytes(len);
        }
        return new byte[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForBytesAvailable(int aNumberOfBytes, long aTimeoutMillis) throws IOException {
        if (this._isClosed) {
            throw new IOException("The stream has already been closed!");
        }
        if (this.available() != -1 && this._inputStream.markSupported()) {
            this._inputStream.mark(1);
            int theValue = 0;
            try {
                theValue = this._inputStream.read();
                if (theValue != -1) {
                    return;
                }
            }
            catch (Exception exception) {
            }
            finally {
                this._inputStream.reset();
            }
            if (theValue == -1) {
                throw new EOFException("Reached end of file (stream), no more data available!");
            }
        }
        if (aTimeoutMillis != -1L) {
            long theStartTimeMs = System.currentTimeMillis();
            while (!this._isClosed && this.available() < aNumberOfBytes && System.currentTimeMillis() - theStartTimeMs < aTimeoutMillis) {
                Object object = this._monitor;
                synchronized (object) {
                    try {
                        this._monitor.wait(IoTimeout.toTimeoutSleepLoopTimeInMs(aTimeoutMillis));
                    }
                    catch (InterruptedException e) {
                        throw new IOException("Interrupted while trying to read <" + aNumberOfBytes + "> number of bytes after <" + (System.currentTimeMillis() - theStartTimeMs) + "> milliseconds (with a given timeout of <" + aTimeoutMillis + "> milliseconds)!", e);
                    }
                }
            }
            if (this._isClosed) {
                throw new IOException("Connection was closed after <" + (System.currentTimeMillis() - theStartTimeMs) + "> milliseconds (with a given timeout of <" + aTimeoutMillis + "> milliseconds) while trying to read <" + aNumberOfBytes + "> number of bytes.");
            }
            if (this.available() < aNumberOfBytes) {
                throw new TimeoutIOException(aTimeoutMillis, "Operation timed out after <" + aTimeoutMillis + "> milliseconds while trying to read <" + aNumberOfBytes + "> number of bytes.");
            }
        }
    }
}

