/*
 * Decompiled with CFR 0.152.
 */
package club.funcodes.dadum;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import net.objecthunter.exp4j.ExpressionBuilder;
import org.refcodes.archetype.CliHelper;
import org.refcodes.cli.CasesCondition;
import org.refcodes.cli.CliSugar;
import org.refcodes.cli.EnumOption;
import org.refcodes.cli.Example;
import org.refcodes.cli.Flag;
import org.refcodes.cli.HelpFlag;
import org.refcodes.cli.StringOption;
import org.refcodes.cli.SysInfoFlag;
import org.refcodes.cli.VerboseFlag;
import org.refcodes.data.AsciiColorPalette;
import org.refcodes.data.MemoryUnit;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;
import org.refcodes.numerical.NumericalUtility;
import org.refcodes.properties.ext.application.ApplicationProperties;
import org.refcodes.runtime.Execution;
import org.refcodes.textual.Font;
import org.refcodes.textual.FontFamily;
import org.refcodes.textual.FontStyle;
import org.refcodes.textual.RandomTextMode;
import org.refcodes.textual.VerboseTextBuilder;

public class Main {
    private static final RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private static final String NAME = "dadum";
    private static final String TITLE = "n.." + "dadum".toUpperCase() + "..\u221e";
    private static final String DEFAULT_CONFIG = "dadum.ini";
    private static final String LICENSE_NOTE = "You may choose between the LGPL v3.0 or later and the Apache License v2.0 when using this software";
    private static final String COPYRIGHT = "Copyright (c) by CLUB.FUNCODES | See [https://www.metacodes.pro/manpages/dadum_manpage]";
    private static final char[] BANNER_PALETTE = AsciiColorPalette.MAX_LEVEL_GRAY.getPalette();
    private static final Font BANNER_FONT = new Font(FontFamily.SANS_SERIF, FontStyle.PLAIN);
    private static final String DESCRIPTION = "Tool for dumping mass data (\"[da]ta-[dum]per\") by pattern to files or streams (see [https://www.metacodes.pro/manpages/dadum_manpage]).";
    private static final String BYTES_PROPERTY = "bytes";
    private static final String TEXT_PROPERTY = "text";
    private static final String OUTPUTFILE_PROPERTY = "outputFile";
    private static final String RND_BYTES_PROPERTY = "rndBytes";
    private static final String RND_TEXT_PROPERTY = "rndText";
    private static final String RND_TEXT_MODE_PROPERTY = "rndTextMode";
    private static final String SIZE_UNIT_PROPERTY = "sizeUnit";
    private static final String SIZE_PROPERTY = "size";

    public static void main(String[] args) {
        EnumOption<RandomTextMode> theRndTextModeArg = CliSugar.enumOption("rnd-text-mode", RandomTextMode.class, RND_TEXT_MODE_PROPERTY, "The random text mode for generating random text output: " + VerboseTextBuilder.asString(RandomTextMode.values()));
        EnumOption<MemoryUnit> theSizeUnitArg = CliSugar.enumOption("unit", MemoryUnit.class, SIZE_UNIT_PROPERTY, "The memory unit to use when calculating the size: " + VerboseTextBuilder.asString((Object[])MemoryUnit.values()));
        Flag theRndTextFlag = CliSugar.flag("rnd-text", RND_TEXT_PROPERTY, "Use random text for generating text output.");
        Flag theRndBytesFlag = CliSugar.flag("rnd-bytes", RND_BYTES_PROPERTY, "Use random bytes for generating binary output.");
        StringOption theOutputFileArg = CliSugar.stringOption(Character.valueOf('o'), "output-file", OUTPUTFILE_PROPERTY, "The output file which to process to.");
        StringOption theTextArg = CliSugar.stringOption(Character.valueOf('t'), TEXT_PROPERTY, TEXT_PROPERTY, "The text message which to process.");
        StringOption theBytesArg = CliSugar.stringOption(Character.valueOf('b'), BYTES_PROPERTY, BYTES_PROPERTY, "The message in bytes (e.g. \"127, 128, 0x10, 0xFF\") which to process.");
        StringOption theSizeArg = CliSugar.stringOption(Character.valueOf('s'), SIZE_PROPERTY, SIZE_PROPERTY, "The size of the data to be dumped (can be an expression such as \"640 * 480\", a value of '\u221e' or `-1` will bomb your storage).");
        VerboseFlag theVerboseFlag = CliSugar.verboseFlag();
        SysInfoFlag theSysInfoFlag = CliSugar.sysInfoFlag(false);
        HelpFlag theHelpFlag = CliSugar.helpFlag();
        CasesCondition theArgsSyntax = CliSugar.cases(CliSugar.and(theSizeArg, CliSugar.any(CliSugar.xor(theRndBytesFlag, CliSugar.and(theRndTextFlag, CliSugar.any(theRndTextModeArg)), theBytesArg, theTextArg)), CliSugar.any(CliSugar.and(theOutputFileArg, CliSugar.any(theVerboseFlag)), theSizeUnitArg)), CliSugar.xor(theHelpFlag, CliSugar.and(theSysInfoFlag, CliSugar.any(theVerboseFlag))));
        Example[] theExamples = CliSugar.examples(CliSugar.example("Dump random binary data to a file", theSizeArg, theRndBytesFlag, theOutputFileArg, theVerboseFlag), CliSugar.example("Dump random text data to a file", theSizeArg, theRndTextFlag, theOutputFileArg, theVerboseFlag), CliSugar.example("Dump random text data using specified charset to a file", theSizeArg, theRndTextFlag, theRndTextModeArg, theOutputFileArg, theVerboseFlag), CliSugar.example("Dump binary data using specified bytes (repeatedly) to a file", theSizeArg, theBytesArg, theOutputFileArg, theVerboseFlag), CliSugar.example("Dump text data using specified text (repeatedly) to a file", theSizeArg, theTextArg, theOutputFileArg, theVerboseFlag), CliSugar.example("Dump random binary data to STDOUT", theSizeArg, theRndBytesFlag, theVerboseFlag), CliSugar.example("Dump random text data to STDOUT", theSizeArg, theRndTextFlag, theVerboseFlag), CliSugar.example("Dump random text data using specified charset to STDOUT", theSizeArg, theRndTextFlag, theRndTextModeArg, theVerboseFlag), CliSugar.example("Dump binary data using specified bytes (repeatedly) to STDOUT", theSizeArg, theBytesArg, theVerboseFlag), CliSugar.example("Dump text data using specified text (repeatedly) to STDOUT", theSizeArg, theTextArg, theVerboseFlag), CliSugar.example("To show the help text", theHelpFlag), CliSugar.example("To print the system info", theSysInfoFlag));
        CliHelper theCliHelper = ((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)CliHelper.builder().withArgs(args)).withArgsSyntax(theArgsSyntax)).withExamples(theExamples)).withFilePath(DEFAULT_CONFIG)).withResourceClass((Class)Main.class)).withName(NAME)).withTitle(TITLE)).withDescription(DESCRIPTION)).withLicense(LICENSE_NOTE)).withCopyright(COPYRIGHT)).withBannerFont(BANNER_FONT)).withBannerFontPalette(BANNER_PALETTE)).withLogger(LOGGER)).build();
        ApplicationProperties theArgsProperties = theCliHelper.getApplicationProperties();
        boolean isVerbose = theVerboseFlag.isEnabled();
        try {
            RandomTextMode theRndTextMode;
            String theText = (String)theArgsProperties.get((Object)theTextArg);
            String theBytesString = (String)theArgsProperties.get((Object)theBytesArg);
            String theOutputFileName = (String)theArgsProperties.get((Object)theOutputFileArg);
            boolean isRndBytes = theArgsProperties.getBoolean((Object)theRndBytesFlag);
            boolean isRndText = theArgsProperties.getBoolean((Object)theRndTextFlag);
            MemoryUnit theSizeUnit = theArgsProperties.getEnumOr(MemoryUnit.class, theSizeUnitArg, MemoryUnit.BYTE);
            byte[] theBytes = theBytesString != null ? NumericalUtility.toBytes(theBytesString) : null;
            String theSizeText = (String)theArgsProperties.get((Object)theSizeArg);
            if ("\u221e".equals(theSizeText)) {
                theSizeText = "-1";
            }
            long theSize = (long)new ExpressionBuilder(theSizeText).build().evaluate();
            long theBytesSize = theSizeUnit.toBytes(theSize).longValue();
            MemoryUnit theSuitableSizeUnit = MemoryUnit.toSuitableUnit(theBytesSize);
            RandomTextMode randomTextMode = theRndTextMode = isRndText ? RandomTextMode.ALPHANUMERIC : theArgsProperties.getEnum(RandomTextMode.class, (Object)theRndTextModeArg);
            if (isVerbose) {
                if (theText != null && theText.length() != 0) {
                    LOGGER.info("Text = " + theText);
                }
                if (theBytes != null && theBytes.length != 0) {
                    LOGGER.info("Bytes = { " + NumericalUtility.toHexString(", ", theBytes) + " }");
                }
                if (theRndTextMode != null) {
                    LOGGER.info("Encoding = " + String.valueOf(theRndTextMode));
                }
                LOGGER.info("Size = " + theSize + " " + theSizeUnit.getUnit() + (String)(theSizeUnit != theSuitableSizeUnit ? " (" + String.valueOf(theSuitableSizeUnit.fromBytes(theBytesSize)) + " " + theSuitableSizeUnit.getUnit() + ")" : "") + (String)(theSizeUnit != MemoryUnit.BYTE && theSuitableSizeUnit != MemoryUnit.BYTE ? " [" + theBytesSize + " " + MemoryUnit.BYTE.getUnit() + "]" : ""));
            }
            OutputStream theOutputStream = Execution.toBootstrapStandardOut();
            if (theOutputFileName != null && theOutputFileName.length() != 0) {
                File theOutputFile = new File(theOutputFileName);
                if (isVerbose) {
                    LOGGER.info("Output file = \"" + theOutputFileName + "\" (<" + theOutputFile.getAbsolutePath() + ">)");
                }
                theOutputStream = new FileOutputStream(theOutputFile);
            }
            try (BufferedOutputStream theBufferedOutputStream = new BufferedOutputStream(theOutputStream);){
                if (theText != null && theText.length() != 0) {
                    theBytes = theText.getBytes();
                }
                long theCount = 0L;
                SecureRandom theRnd = new SecureRandom();
                while (theCount < theBytesSize || theBytesSize == -1L) {
                    int eRnd;
                    if (theRndTextMode != null) {
                        eRnd = theRnd.nextInt(theRndTextMode.getCharSet().length);
                        ((OutputStream)theBufferedOutputStream).write(theRndTextMode.getCharSet()[eRnd]);
                        ++theCount;
                        continue;
                    }
                    if (isRndBytes) {
                        eRnd = theRnd.nextInt(256);
                        ((OutputStream)theBufferedOutputStream).write(eRnd);
                        ++theCount;
                        continue;
                    }
                    if (theBytes != null && theBytes.length != 0) {
                        if (theCount + (long)theBytes.length <= theBytesSize || theBytesSize == -1L) {
                            ((OutputStream)theBufferedOutputStream).write(theBytes);
                            theCount += (long)theBytes.length;
                            continue;
                        }
                        for (int i = 0; i < theBytes.length && theCount < theBytesSize; ++theCount, ++i) {
                            ((OutputStream)theBufferedOutputStream).write(theBytes[i]);
                        }
                        continue;
                    }
                    eRnd = theRnd.nextInt(RandomTextMode.ALPHANUMERIC.getCharSet().length);
                    ((OutputStream)theBufferedOutputStream).write(RandomTextMode.ALPHANUMERIC.getCharSet()[eRnd]);
                    ++theCount;
                }
            }
        }
        catch (Throwable e) {
            theCliHelper.exitOnException(e);
        }
    }
}

