/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.tabular;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.refcodes.data.Delimiter;
import org.refcodes.tabular.Column;
import org.refcodes.tabular.ColumnFactory;
import org.refcodes.tabular.ColumnMismatchException;
import org.refcodes.tabular.Header;
import org.refcodes.tabular.HeaderMismatchException;
import org.refcodes.tabular.Record;
import org.refcodes.tabular.RecordWriter;
import org.refcodes.tabular.TabularUtility;
import org.refcodes.textual.CsvBuilder;
import org.refcodes.textual.CsvEscapeMode;
import org.refcodes.textual.CsvMixin;
import org.refcodes.textual.VerboseTextBuilder;

public class CsvRecordWriter<T>
implements CsvMixin,
RecordWriter<T> {
    protected Header<T> _header;
    private ColumnFactory<T> _columnFactory;
    protected PrintStream _outputStream;
    protected CsvBuilder _csvBuilder;
    private String[] _commentPrefixes = null;

    public CsvRecordWriter(Header<T> aHeader, File aCsvFile) throws FileNotFoundException {
        this(aHeader, null, new PrintStream(aCsvFile), Delimiter.CSV.getChar());
    }

    public CsvRecordWriter(Header<T> aHeader, File aCsvFile, char aCsvDelimiter) throws FileNotFoundException {
        this(aHeader, null, new PrintStream(aCsvFile), aCsvDelimiter);
    }

    public CsvRecordWriter(File aCsvFile) throws FileNotFoundException {
        this(null, null, new PrintStream(aCsvFile), Delimiter.CSV.getChar());
    }

    public CsvRecordWriter(File aCsvFile, char aCsvDelimiter) throws FileNotFoundException {
        this(null, null, new PrintStream(aCsvFile), aCsvDelimiter);
    }

    public CsvRecordWriter(Header<T> aHeader, OutputStream aCsvOutputStream) {
        this(aHeader, null, new PrintStream(aCsvOutputStream, true), Delimiter.CSV.getChar());
    }

    public CsvRecordWriter(Header<T> aHeader, OutputStream aCsvOutputStream, char aCsvDelimiter) {
        this(aHeader, null, new PrintStream(aCsvOutputStream, true), aCsvDelimiter);
    }

    public CsvRecordWriter(OutputStream aCsvOutputStream) {
        this(null, null, new PrintStream(aCsvOutputStream, true), Delimiter.CSV.getChar());
    }

    public CsvRecordWriter(ColumnFactory<T> aColumnFactory, File aCsvFile) throws FileNotFoundException {
        this(null, aColumnFactory, new PrintStream(aCsvFile), Delimiter.CSV.getChar());
    }

    public CsvRecordWriter(ColumnFactory<T> aColumnFactory, File aCsvFile, char aCsvDelimiter) throws FileNotFoundException {
        this(null, aColumnFactory, new PrintStream(aCsvFile), aCsvDelimiter);
    }

    public CsvRecordWriter(ColumnFactory<T> aColumnFactory, OutputStream aCsvOutputStream) {
        this(null, aColumnFactory, new PrintStream(aCsvOutputStream, true), Delimiter.CSV.getChar());
    }

    public CsvRecordWriter(ColumnFactory<T> aColumnFactory, OutputStream aCsvOutputStream, char aCsvDelimiter) {
        this(null, aColumnFactory, new PrintStream(aCsvOutputStream, true), aCsvDelimiter);
    }

    public CsvRecordWriter(Header<T> aHeader, File aCsvFile, Charset aEncoding) throws IOException {
        this(aHeader, null, new PrintStream(aCsvFile, aEncoding.name()), Delimiter.CSV.getChar());
    }

    public CsvRecordWriter(Header<T> aHeader, File aCsvFile, Charset aEncoding, char aCsvDelimiter) throws IOException {
        this(aHeader, null, new PrintStream(aCsvFile, aEncoding.name()), aCsvDelimiter);
    }

    public CsvRecordWriter(File aCsvFile, Charset aEncoding) throws IOException {
        this(null, null, new PrintStream(aCsvFile, aEncoding.name()), Delimiter.CSV.getChar());
    }

    public CsvRecordWriter(File aCsvFile, Charset aEncoding, char aCsvDelimiter) throws IOException {
        this(null, null, new PrintStream(aCsvFile, aEncoding.name()), aCsvDelimiter);
    }

    public CsvRecordWriter(Header<T> aHeader, OutputStream aCsvOutputStream, Charset aEncoding) throws UnsupportedEncodingException {
        this(aHeader, null, new PrintStream(aCsvOutputStream, true, aEncoding.name()), Delimiter.CSV.getChar());
    }

    public CsvRecordWriter(Header<T> aHeader, OutputStream aCsvOutputStream, Charset aEncoding, char aCsvDelimiter) throws UnsupportedEncodingException {
        this(aHeader, null, new PrintStream(aCsvOutputStream, true, aEncoding.name()), aCsvDelimiter);
    }

    public CsvRecordWriter(OutputStream aCsvOutputStream, Charset aEncoding) throws UnsupportedEncodingException {
        this(null, null, new PrintStream(aCsvOutputStream, true, aEncoding.name()), Delimiter.CSV.getChar());
    }

    public CsvRecordWriter(ColumnFactory<T> aColumnFactory, File aCsvFile, Charset aEncoding) throws IOException {
        this(null, aColumnFactory, new PrintStream(aCsvFile, aEncoding.name()), Delimiter.CSV.getChar());
    }

    public CsvRecordWriter(ColumnFactory<T> aColumnFactory, File aCsvFile, Charset aEncoding, char aCsvDelimiter) throws IOException {
        this(null, aColumnFactory, new PrintStream(aCsvFile, aEncoding.name()), aCsvDelimiter);
    }

    public CsvRecordWriter(ColumnFactory<T> aColumnFactory, OutputStream aCsvOutputStream, Charset aEncoding) throws UnsupportedEncodingException {
        this(null, aColumnFactory, new PrintStream(aCsvOutputStream, true, aEncoding.name()), Delimiter.CSV.getChar());
    }

    public CsvRecordWriter(ColumnFactory<T> aColumnFactory, OutputStream aCsvOutputStream, Charset aEncoding, char aCsvDelimiter) throws UnsupportedEncodingException {
        this(null, aColumnFactory, new PrintStream(aCsvOutputStream, true, aEncoding.name()), aCsvDelimiter);
    }

    public CsvRecordWriter(PrintStream aPrintStream) {
        this(null, null, aPrintStream, Delimiter.CSV.getChar());
    }

    public CsvRecordWriter(ColumnFactory<T> aColumnFactory, PrintStream aPrintStream) {
        this(null, aColumnFactory, aPrintStream, Delimiter.CSV.getChar());
    }

    public CsvRecordWriter(Header<T> aHeader, PrintStream aPrintStream, char aCsvDelimiter) {
        this(aHeader, null, aPrintStream, aCsvDelimiter);
    }

    public CsvRecordWriter(Header<T> aHeader, PrintStream aPrintStream) {
        this(aHeader, null, aPrintStream, Delimiter.CSV.getChar());
    }

    public CsvRecordWriter(ColumnFactory<T> aColumnFactory, PrintStream aPrintStream, char aCsvDelimiter) {
        this(null, aColumnFactory, aPrintStream, aCsvDelimiter);
    }

    protected CsvRecordWriter(Header<T> aHeader, ColumnFactory<T> aColumnFactory, PrintStream aPrintStream, char aCsvDelimiter) {
        this._csvBuilder = new CsvBuilder().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withDelimiter(aCsvDelimiter);
        this._header = aHeader;
        this._outputStream = aPrintStream != null ? aPrintStream : System.out;
        this._columnFactory = aColumnFactory;
    }

    @Override
    public void setCommentPrefixes(String ... aCommentPrefixes) {
        this._commentPrefixes = aCommentPrefixes;
    }

    @Override
    public String[] getCommentPrefixes() {
        return this._commentPrefixes;
    }

    @Override
    public void clearCommentPrefixes() {
        this._commentPrefixes = null;
    }

    @Override
    public CsvRecordWriter<T> withCommentPrefixes(String ... aCommentPrefixes) {
        this.setCommentPrefixes(aCommentPrefixes);
        return this;
    }

    @Override
    public void close() throws IOException {
        this._outputStream.close();
    }

    @Override
    public CsvEscapeMode getCsvEscapeMode() {
        return this._csvBuilder.getCsvEscapeMode();
    }

    @Override
    public boolean isTrim() {
        return this._csvBuilder.isTrim();
    }

    @Override
    public char getDelimiter() {
        return this._csvBuilder.getDelimiter();
    }

    @Override
    public void setTrim(boolean isTrim) {
        this._csvBuilder.setTrim(isTrim);
    }

    @Override
    public void setDelimiter(char aCsvDelimiter) {
        this._csvBuilder.setDelimiter(aCsvDelimiter);
    }

    @Override
    public CsvRecordWriter<T> withTrim(boolean isTrimRecords) {
        this._csvBuilder.setTrim(isTrimRecords);
        return this;
    }

    @Override
    public CsvRecordWriter<T> withCsvEscapeMode(CsvEscapeMode aCsvEscapeMode) {
        this._csvBuilder.setCsvEscapeMode(aCsvEscapeMode);
        return this;
    }

    @Override
    public CsvRecordWriter<T> withDelimiter(char aCsvDelimiter) {
        this._csvBuilder.setDelimiter(aCsvDelimiter);
        return this;
    }

    @Override
    public void setCsvEscapeMode(CsvEscapeMode aCsvEscapeMode) {
        this._csvBuilder.setCsvEscapeMode(aCsvEscapeMode);
    }

    @Override
    public void parseHeader(String ... aHeader) {
        this._header = TabularUtility.toHeader(aHeader, this._columnFactory);
    }

    @Override
    public void writeHeader(String ... aHeader) {
        String theHeader = this._csvBuilder.toRecord(aHeader);
        this._header = TabularUtility.toHeader(aHeader, this._columnFactory);
        this._outputStream.println(theHeader);
    }

    @Override
    public void writeHeader(Header<T> aHeader) {
        this._header = aHeader;
        this._columnFactory = null;
        String theHeader = this._csvBuilder.toRecord(aHeader.toKeys());
        this._outputStream.println(theHeader);
    }

    @Override
    public void writeHeader() {
        String theHeader = this._csvBuilder.toRecord(this._header.toKeys());
        this._outputStream.println(theHeader);
    }

    @Override
    public void writeNext(T ... aRecord) {
        if (this._header != null) {
            if (this._header.size() != aRecord.length) {
                throw new IllegalArgumentException("Expecting the record to be of (header's) size <" + this._header.size() + ">, though it is of length <" + String.valueOf(aRecord != null ? Integer.valueOf(aRecord.length) : "null") + ">. The header provided = " + new VerboseTextBuilder().toString(this._header.keySet()) + ", the record provided = " + new VerboseTextBuilder().toString(aRecord) + ".");
            }
            ArrayList<String> theRecord = new ArrayList<String>();
            for (int i = 0; i < this._header.size(); ++i) {
                String eValue = ((Column)this._header.get(i)).toStorageString_(aRecord[i]);
                theRecord.add(eValue);
            }
            this._outputStream.println(this._csvBuilder.toRecord(new Object[]{theRecord}));
        } else {
            this._outputStream.println(this._csvBuilder.toRecord(aRecord));
        }
    }

    @Override
    public void writeNext(Record<T> aRecord) throws ColumnMismatchException, HeaderMismatchException {
        ArrayList<String> theStorageStrings;
        if (this._header != null) {
            theStorageStrings = new ArrayList<String>();
            for (int i = 0; i < this._header.size(); ++i) {
                Column eColumn = (Column)this._header.get(i);
                Object theValue = aRecord.get(eColumn.getKey());
                theStorageStrings.add(eColumn.toStorageString_(theValue));
            }
        } else {
            throw new IllegalStateException("In order to use this method you must have configured / initialized a Header instance.");
        }
        this._outputStream.println(this._csvBuilder.toRecord(new Object[]{theStorageStrings}));
    }

    public void writeComment(String aComment) {
        this._outputStream.println(this.toComment(aComment));
    }

    public void writeHeaderComment(String ... aHeader) {
        String theHeader = this._csvBuilder.toRecord(aHeader);
        this._header = TabularUtility.toHeader(aHeader, this._columnFactory);
        this._outputStream.println(this.toComment(theHeader));
    }

    public void writeHeaderComment(Header<T> aHeader) {
        this._header = aHeader;
        this._columnFactory = null;
        String theHeader = this._csvBuilder.toRecord(aHeader.toKeys());
        this._outputStream.println(this.toComment(theHeader));
    }

    public void writeHeaderComment() {
        String theHeader = this._csvBuilder.toRecord(this._header.toKeys());
        this._outputStream.println(this.toComment(theHeader));
    }

    @Override
    public Header<T> getHeader() {
        return this._header;
    }
}

