/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.struct.ext.factory;

import org.refcodes.mixin.ArrayIndexAccessor;
import org.refcodes.mixin.CommentAccessor;
import org.refcodes.mixin.DelimiterAccessor;
import org.refcodes.mixin.DelimitersAccessor;
import org.refcodes.mixin.EncodingAccessor;
import org.refcodes.mixin.EnvelopeAccessor;
import org.refcodes.mixin.VersionAccessor;
import org.refcodes.runtime.OptionDescriptor;
import org.refcodes.runtime.Options;
import org.refcodes.runtime.SystemProperty;

public class DocumentOptions
extends Options
implements DelimiterAccessor,
DelimitersAccessor,
EnvelopeAccessor,
ArrayIndexAccessor,
CommentAccessor,
EncodingAccessor<String>,
VersionAccessor<String> {
    private static final long serialVersionUID = 1L;

    protected DocumentOptions(Builder aBuilder) {
        super(aBuilder, Configuration.class);
    }

    @Override
    public boolean hasArrayIndex() {
        if (SystemProperty.DOCUMENT_ARRAY_INDEX.hasValue()) {
            return SystemProperty.DOCUMENT_ARRAY_INDEX.isEnabled();
        }
        return this.getOr(Configuration.DOCUMENT_ARRAY_INDEX, Boolean.class, Boolean.valueOf(false));
    }

    public boolean hasArrayIndexOr(boolean hasArrayIndexDefault) {
        if (SystemProperty.DOCUMENT_ARRAY_INDEX.hasValue()) {
            return SystemProperty.DOCUMENT_ARRAY_INDEX.isEnabled();
        }
        return this.getOr(Configuration.DOCUMENT_ARRAY_INDEX, Boolean.class, Boolean.valueOf(hasArrayIndexDefault));
    }

    public String getBaseUrl() {
        return this.get(Configuration.DOCUMENT_BASE_URL, String.class);
    }

    public String getBaseUrlOr(String aDefaultUrl) {
        return this.getOr(Configuration.DOCUMENT_BASE_URL, String.class, aDefaultUrl);
    }

    @Override
    public boolean hasEnvelope() {
        if (SystemProperty.DOCUMENT_ENVELOPE.hasValue()) {
            return SystemProperty.DOCUMENT_ENVELOPE.isEnabled();
        }
        return this.getOr(Configuration.DOCUMENT_ENVELOPE, Boolean.class, Boolean.valueOf(false));
    }

    public boolean isStandAlone() {
        return this.getOr(Configuration.DOCUMENT_STAND_ALONE, Boolean.class, Boolean.valueOf(false));
    }

    public boolean isStandAloneOr(boolean isStandAloneDefault) {
        return this.getOr(Configuration.DOCUMENT_STAND_ALONE, Boolean.class, Boolean.valueOf(isStandAloneDefault));
    }

    @Override
    public char getDelimiter() {
        return this.get(Configuration.DOCUMENT_PATH_DELIMITER, Character.class).charValue();
    }

    public char getDelimiterOr(char aDelimiterDefault) {
        return this.getOr(Configuration.DOCUMENT_PATH_DELIMITER, Character.class, Character.valueOf(aDelimiterDefault)).charValue();
    }

    @Override
    public char[] getDelimiters() {
        return this.get(Configuration.DOCUMENT_PATH_DELIMITERS, char[].class);
    }

    public char[] getDelimitersOr(char[] aDelimitersDefault) {
        return this.getOr(Configuration.DOCUMENT_PATH_DELIMITERS, char[].class, aDelimitersDefault);
    }

    @Override
    public String getComment() {
        return this.get(Configuration.DOCUMENT_COMMENT, String.class);
    }

    @Override
    public String getEncoding() {
        return this.get(Configuration.DOCUMENT_ENCODING, String.class);
    }

    public String getEncodingOr(String aEncodingDefault) {
        return this.getOr(Configuration.DOCUMENT_ENCODING, String.class, aEncodingDefault);
    }

    public String getRootElement() {
        return this.get(Configuration.DOCUMENT_ROOT_ELEMENT, String.class);
    }

    public String getHeader() {
        return this.get(Configuration.DOCUMENT_HEADER, String.class);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String getVersion() {
        return this.get(Configuration.DOCUMENT_VERSION, String.class);
    }

    public static enum Configuration implements OptionDescriptor
    {
        DOCUMENT_ARRAY_INDEX{

            @Override
            public String getDescription() {
                return "When set to true, then marshaling (XML) documents will preserve array index information by using an index attribute for array elements in the produced XML.";
            }

            public Class<?> getType() {
                return Boolean.class;
            }
        }
        ,
        DOCUMENT_BASE_URL{

            @Override
            public String getDescription() {
                return "The URL where HTML was retrieved from, to resolve relative links against.";
            }

            public Class<?> getType() {
                return String.class;
            }
        }
        ,
        DOCUMENT_COMMENT{

            @Override
            public String getDescription() {
                return "The comment to be included in the marshaled document.";
            }

            public Class<?> getType() {
                return String.class;
            }
        }
        ,
        DOCUMENT_PATH_DELIMITER{

            @Override
            public String getDescription() {
                return "Specifies the path delimiter for serializing certain data structures.";
            }

            public Class<?> getType() {
                return Character.class;
            }
        }
        ,
        DOCUMENT_PATH_DELIMITERS{

            @Override
            public String getDescription() {
                return "Specifies the valid path delimiters for deserializing certain data structures.";
            }

            public Class<?> getType() {
                return String.class;
            }
        }
        ,
        DOCUMENT_ENCODING{

            @Override
            public String getDescription() {
                return "Specifies a charset code such as ASCII orUTF_8.";
            }

            public Class<?> getType() {
                return String.class;
            }
        }
        ,
        DOCUMENT_ENVELOPE{

            @Override
            public String getDescription() {
                return "When set to true, then unmarshaling (XML) documents willpreserve the preserve the root element (envelope) even when merely acting as envelope: As an (XML) document requires a root element, the root element often is provided as of syntactic reasons and not as of semantic reasons.";
            }

            public Class<?> getType() {
                return Boolean.class;
            }
        }
        ,
        DOCUMENT_HEADER{

            @Override
            public String getDescription() {
                return "E.g. used in an XML file's head's declaration such as '<?xml ecnoding=\"UTF-8\" version=\"1.0\" standalone=\"yes\"?>'.";
            }

            public Class<?> getType() {
                return String.class;
            }
        }
        ,
        DOCUMENT_ROOT_ELEMENT{

            @Override
            public String getDescription() {
                return "";
            }

            public Class<?> getType() {
                return Boolean.class;
            }
        }
        ,
        DOCUMENT_STAND_ALONE{

            @Override
            public String getDescription() {
                return "E.g. used in an XML file's head's declaration such as '<?xml ecnoding=\"UTF-8\" version=\"1.0\" standalone=\"yes\"?>' to determine whether this is a stand alone document.";
            }

            public Class<?> getType() {
                return Boolean.class;
            }
        }
        ,
        DOCUMENT_VERSION{

            @Override
            public String getDescription() {
                return "dentifies a version, such as an XML version (depends on the notation to which to marshal).";
            }

            public Class<?> getType() {
                return String.class;
            }
        };

    }

    public static class Builder
    extends Options.Builder
    implements DelimiterAccessor.DelimiterBuilder<Builder>,
    DelimitersAccessor.DelimitersBuilder<Builder>,
    EnvelopeAccessor.EnvelopeBuilder<Builder>,
    ArrayIndexAccessor.ArrayIndexBuilder<Builder>,
    CommentAccessor.CommentBuilder<Builder>,
    EncodingAccessor.EncodingBuilder<String, Builder>,
    VersionAccessor.VersionBuilder<String, Builder> {
        @Override
        public Builder withProperty(String aKey, Object aValue) {
            super.withProperty(aKey, aValue);
            return this;
        }

        @Override
        public Builder withProperty(Enum aKey, Object aValue) {
            super.withProperty(aKey, aValue);
            return this;
        }

        @Override
        public Builder withArrayIndex(boolean hasArrayIndex) {
            this.withProperty(Configuration.DOCUMENT_ARRAY_INDEX, (Object)hasArrayIndex);
            return this;
        }

        public Builder withBaseUrl(String aBaseUrl) {
            this.withProperty(Configuration.DOCUMENT_BASE_URL, (Object)aBaseUrl);
            return this;
        }

        public Builder withHeader(String aHeading) {
            this.withProperty(Configuration.DOCUMENT_HEADER, (Object)aHeading);
            return this;
        }

        public Builder withRootElement(String aRootElement) {
            this.withProperty(Configuration.DOCUMENT_ROOT_ELEMENT, (Object)aRootElement);
            return this;
        }

        public Builder withStandAlone(boolean isStandAlone) {
            this.withProperty(Configuration.DOCUMENT_STAND_ALONE, (Object)isStandAlone);
            return this;
        }

        @Override
        public Builder withComment(String aComment) {
            this.withProperty(Configuration.DOCUMENT_COMMENT, (Object)aComment);
            return this;
        }

        @Override
        public Builder withDelimiter(char aDelimiter) {
            this.withProperty(Configuration.DOCUMENT_PATH_DELIMITER, (Object)Character.valueOf(aDelimiter));
            return this;
        }

        @Override
        public Builder withDelimiters(char ... aDelimiters) {
            this.withProperty(Configuration.DOCUMENT_PATH_DELIMITERS, (Object)aDelimiters);
            return this;
        }

        @Override
        public Builder withEnvelope(boolean hasEnvelope) {
            this.withProperty(Configuration.DOCUMENT_ENVELOPE, (Object)hasEnvelope);
            return this;
        }

        @Override
        public Builder withEncoding(String aEncoding) {
            this.withProperty(Configuration.DOCUMENT_ENCODING, (Object)aEncoding);
            return this;
        }

        @Override
        public Builder withVersion(String aVersion) {
            this.withProperty(Configuration.DOCUMENT_VERSION, (Object)aVersion);
            return this;
        }

        @Override
        public DocumentOptions build() {
            return new DocumentOptions(this);
        }
    }
}

