/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.schema;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.refcodes.mixin.Bytes;
import org.refcodes.numerical.NumericalUtility;
import org.refcodes.schema.Schema;
import org.refcodes.schema.SchemaVisitor;

public class PlantUmlVisitor
implements SchemaVisitor<String> {
    private static final char FOR = '@';
    private static final String SEPARATOR = "___";
    private static final String HAS = "has";
    private static final String INDENT = "  ";
    private static final String NULL = "NULL";
    private static final String STARTUML = "@startuml";
    private static final String ENDUML = "@enduml";
    private static final String OBJECT = "object";
    private static final String REFERENCES = "-->";

    @Override
    public String visit(Schema aSchema) {
        StringBuilder theBuffer = new StringBuilder();
        theBuffer.append(STARTUML).append(System.lineSeparator());
        this.visitNested(aSchema, theBuffer, new HashSet<String>());
        theBuffer.append(ENDUML);
        return theBuffer.toString();
    }

    private void visitNested(Schema aSchema, StringBuilder aBuffer, Set<String> aVisited) {
        if (aSchema != null) {
            if (aVisited.contains(this.toObjectName(aSchema))) {
                return;
            }
            aVisited.add(this.toObjectName(aSchema));
            String theStereotype = aSchema.getStereotype() != null && aSchema.getStereotype().length() > 0 ? " <<" + aSchema.getStereotype() + ">>" : "";
            aBuffer.append(System.lineSeparator());
            aBuffer.append(OBJECT).append(" ").append('\"').append(this.toObjectName(aSchema)).append('\"').append(theStereotype).append(" {").append(System.lineSeparator());
            ArrayList theKeys = new ArrayList(aSchema.keySet());
            Collections.sort(theKeys);
            boolean hasSeparator = false;
            for (String eKey : theKeys) {
                Object eObj;
                if (!hasSeparator && eKey.length() > 0 && Character.isLowerCase(eKey.charAt(0))) {
                    hasSeparator = true;
                    aBuffer.append(INDENT).append(SEPARATOR).append(System.lineSeparator());
                }
                if ((eObj = aSchema.get(eKey)) == null) continue;
                String eValue = this.toString(eObj).replace(System.lineSeparator(), "\\n");
                aBuffer.append(INDENT).append(eKey).append(" = ").append(eValue).append(System.lineSeparator());
            }
            aBuffer.append("}").append(System.lineSeparator());
            if (aSchema.getChildren() != null && aSchema.getChildren().length != 0) {
                for (Schema eChild : aSchema.getChildren()) {
                    this.visitNested(eChild, aBuffer, aVisited);
                }
                aBuffer.append(System.lineSeparator());
            }
            if (aSchema.getChildren() != null) {
                for (Schema eSchema : aSchema.getChildren()) {
                    String eAssociation = "<" + String.valueOf(eSchema.get("ASSOCIATION") != null ? eSchema.get("ASSOCIATION") : HAS) + ">";
                    aBuffer.append('\"').append(this.toObjectName(aSchema)).append('\"').append(" ").append(REFERENCES).append(" ").append('\"').append(this.toObjectName(eSchema)).append('\"').append(" : ").append(eAssociation).append(System.lineSeparator());
                }
            }
        }
    }

    private String toString(Object aObj) {
        if (aObj != null && aObj.getClass().isArray()) {
            StringBuilder theBuffer = new StringBuilder("[");
            int theLength = Array.getLength(aObj);
            for (int i = 0; i < theLength; ++i) {
                Object eObj = Array.get(aObj, i);
                theBuffer.append(this.toString(eObj));
                if (i >= theLength - 1) continue;
                theBuffer.append(", ");
            }
            theBuffer.append("]");
            return theBuffer.toString();
        }
        if (aObj instanceof String || aObj != null && aObj.getClass().isEnum()) {
            return "\"" + String.valueOf(aObj) + "\"";
        }
        if (aObj instanceof Character) {
            return "'" + String.valueOf(aObj) + "'";
        }
        if (aObj instanceof Byte) {
            return NumericalUtility.toHexString((byte)((Byte)aObj));
        }
        if (aObj instanceof Class) {
            return ((Class)aObj).getName();
        }
        if (aObj instanceof Exception) {
            return "\"" + String.valueOf(aObj) + "\"";
        }
        if (aObj instanceof Bytes) {
            Bytes bytes = (Bytes)aObj;
            return this.toString(bytes.toBytes());
        }
        return aObj != null ? aObj.toString() : NULL;
    }

    private String toObjectName(Schema aSchema) {
        if (aSchema.getIdentifier() != null) {
            return aSchema.getIdentifier();
        }
        StringBuilder theBuilder = new StringBuilder();
        if (aSchema.getType() != null) {
            theBuilder.append(aSchema.getType().getName());
        } else {
            theBuilder.append(aSchema.getAlias());
        }
        if (aSchema.get("HASH") != null) {
            theBuilder.append('@').append(aSchema.getHash());
        }
        return theBuilder.toString();
    }
}

