/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.numerical;

import org.refcodes.numerical.CrcAlgorithm;
import org.refcodes.numerical.CrcSize;
import org.refcodes.numerical.Endianess;
import org.refcodes.numerical.NumericalUtility;

public class CrcAlgorithmImpl
implements CrcAlgorithm {
    final int _crcBitWidth;
    private final long _initCrc;
    private final String _name;
    private final long _polynomial;
    private final boolean _refIn;
    private final boolean _refOut;
    private final long _xorOut;
    private final long[] _table = new long[256];
    private long _mask = -1L;
    private CrcSize _crcWidth = null;

    public CrcAlgorithmImpl(String aName, int aCrcBitWidth, long aPolynomial, long aInitCrc, boolean aRefIn, boolean aRefOut, long aXorOut) {
        this._name = aName;
        this._initCrc = aInitCrc;
        this._polynomial = aPolynomial;
        this._refIn = aRefIn;
        this._refOut = aRefOut;
        this._xorOut = aXorOut;
        this._crcBitWidth = aCrcBitWidth;
        if (this._crcBitWidth < 64) {
            this._mask = (1L << this._crcBitWidth) - 1L;
        }
        for (int i = 0; i < this._table.length; ++i) {
            long eTmp = i;
            if (this._refIn) {
                eTmp = NumericalUtility.toReversedLong(eTmp, this._crcBitWidth);
            } else if (this._crcBitWidth > 8) {
                eTmp <<= this._crcBitWidth - 8;
            }
            long eLastBit = 1L << this._crcBitWidth - 1;
            for (int j = 0; j < 8; ++j) {
                if ((eTmp & eLastBit) != 0L) {
                    eTmp = eTmp << 1 ^ this._polynomial;
                    continue;
                }
                eTmp <<= 1;
            }
            if (this._refOut) {
                eTmp = NumericalUtility.toReversedLong(eTmp, this._crcBitWidth);
            }
            this._table[i] = eTmp & this._mask;
        }
    }

    @Override
    public long toCrcChecksum(byte aData) {
        return this.toCrcChecksum(new byte[]{aData}, 0, 1);
    }

    @Override
    public long toCrcChecksum(long aCrc, byte aData) {
        return this.toCrcChecksum(aCrc, new byte[]{aData}, 0, 1);
    }

    @Override
    public long toCrcChecksum(byte[] aData) {
        return this.toCrcChecksum(aData, 0, aData.length);
    }

    @Override
    public long toCrcChecksum(long aCrc, byte[] aData) {
        return this.toCrcChecksum(aCrc, aData, 0, aData.length);
    }

    @Override
    public long toCrcChecksum(byte[] aData, int aOffset, int aLength) {
        long theInitCrc = this._refOut ? NumericalUtility.toReversedLong(this._initCrc, this._crcBitWidth) : this._initCrc;
        long theChecksum = this.toCrcChecksum(theInitCrc, aData, aOffset, aLength);
        return (theChecksum ^ this._xorOut) & this._mask;
    }

    @Override
    public long toCrcChecksum(long aCrc, byte[] aData, int aOffset, int aLength) {
        long theCrc = aCrc;
        if (this._refOut) {
            for (int i = aOffset; i < aOffset + aLength; ++i) {
                theCrc = this._table[(int)((theCrc ^ (long)aData[i]) & 0xFFL)] ^ theCrc >>> 8;
                theCrc &= this._mask;
            }
        } else {
            int toRight = this._crcBitWidth - 8;
            toRight = toRight < 0 ? 0 : toRight;
            for (int i = aOffset; i < aOffset + aLength; ++i) {
                theCrc = this._table[(int)((theCrc >> toRight ^ (long)aData[i]) & 0xFFL)] ^ theCrc << 8;
                theCrc &= this._mask;
            }
        }
        return theCrc;
    }

    @Override
    public byte[] toCrcBytes(byte aData, Endianess aEndianess) {
        return this.toCrcBytes(new byte[]{aData}, 0, 1, aEndianess);
    }

    @Override
    public byte[] toCrcBytes(long aCrc, byte aData, Endianess aEndianess) {
        return this.toCrcBytes(aCrc, new byte[]{aData}, 0, 1, aEndianess);
    }

    @Override
    public byte[] toCrcBytes(byte[] aData, Endianess aEndianess) {
        return this.toCrcBytes(aData, 0, aData.length, aEndianess);
    }

    @Override
    public byte[] toCrcBytes(long aCrc, byte[] aData, Endianess aEndianess) {
        return this.toCrcBytes(aCrc, aData, 0, aData.length, aEndianess);
    }

    @Override
    public byte[] toCrcBytes(byte[] aData, int aOffset, int aLength, Endianess aEndianess) {
        long theCrc = this.toCrcChecksum(aData, aOffset, aLength);
        return aEndianess.toUnsignedBytes(theCrc, this._crcBitWidth / 8);
    }

    @Override
    public byte[] toCrcBytes(long aCrc, byte[] aData, int aOffset, int aLength, Endianess aEndianess) {
        long theCrc = this.toCrcChecksum(aCrc, aData, aOffset, aLength);
        return aEndianess.toUnsignedBytes(theCrc, this._crcBitWidth / 8);
    }

    @Override
    public int getCrcWidth() {
        return this._crcBitWidth / 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CrcSize getCrcSize() {
        if (this._crcWidth == null) {
            CrcAlgorithmImpl crcAlgorithmImpl = this;
            synchronized (crcAlgorithmImpl) {
                if (this._crcWidth == null) {
                    this._crcWidth = CrcSize.toCrcCategory(this._crcBitWidth / 8);
                }
            }
        }
        return this._crcWidth;
    }

    @Override
    public String getName() {
        return this._name;
    }
}

