/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.IOException;
import org.refcodes.data.IoTimeout;
import org.refcodes.exception.TimeoutIOException;

public interface Skippable {
    default public void skipAvailable() throws IOException {
        int theAvailable = this.available();
        if (theAvailable > 0) {
            this.skip(theAvailable);
        }
    }

    default public void skipAvailableWithin(long aSkipTimeSpanInMs) throws IOException {
        this.skipAvailableWithin(aSkipTimeSpanInMs, -1L);
    }

    default public void skipAvailableWithin(long aSkipTimeSpanInMs, long aTimeoutMillis) throws IOException {
        while (this.available() > 0) {
            this.skip(this.available());
            if (this.available() != 0) continue;
            try {
                Thread.sleep(aSkipTimeSpanInMs);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    default public void skipAvailableWithin(int aSkipLoops, int aSkipLoopTimeoutInMs) throws IOException {
        int i = 0;
        while (this.available() != 0) {
            try {
                Thread.sleep(aSkipLoopTimeoutInMs);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.skipAvailable();
            if (i++ < aSkipLoops) continue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void skipAvailableTill(long aSkipTimeSpanInMs) throws IOException {
        long theStartTime = System.currentTimeMillis();
        long theSleepLoopTime = IoTimeout.toTimeoutSleepLoopTimeInMs(aSkipTimeSpanInMs);
        while (System.currentTimeMillis() - theStartTime < aSkipTimeSpanInMs) {
            this.skipAvailable();
            Skippable skippable = this;
            synchronized (skippable) {
                try {
                    this.wait(theSleepLoopTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    default public void skipAvailableTillSilenceFor(long aSilenceTimeSpanInMs) throws IOException {
        this.skipAvailableTillSilenceFor(aSilenceTimeSpanInMs, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void skipAvailableTillSilenceFor(long aSilenceTimeSpanInMs, long aTimeoutMillis) throws IOException {
        long theStartTime = System.currentTimeMillis();
        long theSleepLoopTime = IoTimeout.toTimeoutSleepLoopTimeInMs(aSilenceTimeSpanInMs);
        while (true) {
            if (this.available() > 0) {
                if (aTimeoutMillis != -1L && System.currentTimeMillis() - theStartTime >= aTimeoutMillis) {
                    throw new TimeoutIOException(aTimeoutMillis, "Unable to sense a silence time span of <" + aSilenceTimeSpanInMs + "> milliseconds within a timeout of <" + aTimeoutMillis + "> milliseconds!");
                }
                this.skipAvailable();
                Skippable skippable = this;
                synchronized (skippable) {
                    try {
                        this.wait(theSleepLoopTime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (this.hasSenseSilenceFor(aSilenceTimeSpanInMs, theSleepLoopTime)) break;
        }
    }

    default public void skipAvailableExcept(int aLength) throws IOException {
        if (this.available() > aLength) {
            this.skip(this.available() - aLength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasSenseSilenceFor(long aSilenceTimeSpanInMs, long aSleepLoopTime) throws IOException {
        long theStartTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - theStartTime < aSilenceTimeSpanInMs) {
            if (this.available() > 0) {
                return false;
            }
            Skippable skippable = this;
            synchronized (skippable) {
                try {
                    this.wait(aSleepLoopTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return true;
    }

    public long skip(long var1) throws IOException;

    public int available() throws IOException;
}

