/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.internal;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PathPattern {
    private static final char REGEX_ESCAPE_CHAR = '\\';
    private static final char OPEN_CURLY = '{';
    private static final char DOLLAR = '$';
    private static final char[] ESCAPE_INSIDE_CHARACTER_CLASS = new char[]{'^', '-', ']', '\\'};
    private static final char[] ESCAPE_OUTSIDE_CHARACTER_CLASS = new char[]{'.', '^', '$', '*', '+', '?', '(', ')', '[', '{', '\\', '|'};
    private static final int WILDCARD_NAME_PREFIX_LENGTH = 2;
    private static final int WILDCARD_NAME_SUFFIX_LENGTH = 2;
    private static final int SIMPLE_NAME_PREFIX_LENGTH = 2;
    private static final int SIMPLE_NAME_SUFFIX_LENGTH = 1;
    private static final String WILDCARD_NAME_PATTERN = "(?<=\\$\\{).*?(?=\\}\\=)";
    private static final String SIMPLE_NAME_PATTERN = "(?<=\\$\\{).*?(?=\\})";
    private static final String WILDCARD_DOUBOLE_ASTERISK = "(.*)";
    private static final String REGEX_SAFE_DOT = "\\.";
    private final Pattern _pattern;
    private final String[] _wildcardNames;

    public PathPattern(String aPath, char aDelimiter) {
        Object eTail;
        String eHead;
        Object WILDCARD_QUESTION_MARK;
        int i;
        if (aDelimiter == '?' || aDelimiter == '*' || aDelimiter == '|') {
            throw new IllegalArgumentException("Your delimiter '" + aDelimiter + "' must not be one of the following chars: '?', '*', '|'.");
        }
        aPath = PathPattern.toEscapedReservedChars(aPath);
        Object theDelimiter = PathPattern.toEscapedInsiceCharacterClass(aDelimiter);
        if (aDelimiter == '\\') {
            theDelimiter = (String)theDelimiter + (String)theDelimiter;
        }
        String theWildcardAsterisk = "([^" + (String)theDelimiter + "]*)";
        String REGEX_DELIMITER = PathPattern.toEscapedOutsiceCharacterClass(aDelimiter);
        Object REGEX_SAFE_DELIMITER = REGEX_DELIMITER;
        if (aDelimiter == '\\') {
            REGEX_SAFE_DELIMITER = (String)REGEX_SAFE_DELIMITER + (String)REGEX_SAFE_DELIMITER;
        }
        Object theRegex = aPath;
        theRegex = aPath.replaceAll(REGEX_DELIMITER, (String)REGEX_SAFE_DELIMITER);
        theRegex = ((String)theRegex).replaceAll(REGEX_SAFE_DOT, REGEX_SAFE_DOT);
        theRegex = ((String)theRegex).replaceAll("(?<!\\*)\\*(?!\\*)", theWildcardAsterisk);
        theRegex = ((String)theRegex).replaceAll("\\*\\*", WILDCARD_DOUBOLE_ASTERISK);
        int theMaxQuestionMarks = 0;
        for (i = 0; i < aPath.length(); ++i) {
            if (aPath.charAt(i) != '?') continue;
            ++theMaxQuestionMarks;
        }
        for (i = theMaxQuestionMarks; i > 0; --i) {
            WILDCARD_QUESTION_MARK = "(";
            Object QUESTION_MARK = "";
            for (int j = 0; j < i; ++j) {
                WILDCARD_QUESTION_MARK = (String)WILDCARD_QUESTION_MARK + "\\\\w";
                QUESTION_MARK = (String)QUESTION_MARK + "\\?";
            }
            WILDCARD_QUESTION_MARK = (String)WILDCARD_QUESTION_MARK + ")";
            theRegex = ((String)theRegex).replaceAll((String)QUESTION_MARK, (String)WILDCARD_QUESTION_MARK);
        }
        WILDCARD_QUESTION_MARK = "(\\\\w";
        String theQuestionMark = ((String)WILDCARD_QUESTION_MARK).replaceAll("(\\\\)\\\\", "$1");
        String theAsterisk = theWildcardAsterisk.replaceAll("\\\\", "");
        if (aDelimiter == '\\') {
            theAsterisk = theWildcardAsterisk.replaceAll("\\\\\\\\", "\\\\");
        }
        String theDoubleAsterisk = WILDCARD_DOUBOLE_ASTERISK.replaceAll("(\\\\)\\\\", "$1");
        ArrayList<String> theWildcardNames = new ArrayList<String>();
        Pattern theJokerPattern = Pattern.compile(WILDCARD_NAME_PATTERN);
        Matcher eJokerMatcher = theJokerPattern.matcher((CharSequence)theRegex);
        while (eJokerMatcher.find()) {
            String eTruncated = ((String)theRegex).substring(eJokerMatcher.end() + 2);
            if (!(eTruncated.startsWith(theAsterisk) || eTruncated.startsWith(theDoubleAsterisk) || eTruncated.startsWith(theQuestionMark))) {
                throw new IllegalArgumentException("Your wildcard name (such as \"" + ((String)theRegex).substring(eJokerMatcher.start(), eJokerMatcher.start()) + "\") in pattern <" + aPath + "> must prefix a wildcard such as \"" + theAsterisk + "\" or \"" + theDoubleAsterisk + "\" or \"" + theQuestionMark + "!");
            }
            String eName = ((String)theRegex).substring(eJokerMatcher.start(), eJokerMatcher.end());
            theWildcardNames.add(eName);
            eHead = ((String)theRegex).substring(0, eJokerMatcher.start() - 2);
            eTail = ((String)theRegex).substring(eJokerMatcher.end() + 2);
            eTail = ((String)eTail).substring(0, 1) + "?<" + eName + ">" + ((String)eTail).substring(1);
            theRegex = eHead + (String)eTail;
            eJokerMatcher = theJokerPattern.matcher((CharSequence)theRegex);
        }
        theJokerPattern = Pattern.compile(SIMPLE_NAME_PATTERN);
        eJokerMatcher = theJokerPattern.matcher((CharSequence)theRegex);
        while (eJokerMatcher.find()) {
            String eName = ((String)theRegex).substring(eJokerMatcher.start(), eJokerMatcher.end());
            theWildcardNames.add(eName);
            eHead = ((String)theRegex).substring(0, eJokerMatcher.start() - 2);
            eTail = theWildcardAsterisk + ((String)theRegex).substring(eJokerMatcher.end() + 1);
            eTail = ((String)eTail).substring(0, 1) + "?<" + eName + ">" + ((String)eTail).substring(1);
            theRegex = eHead + (String)eTail;
            eJokerMatcher = theJokerPattern.matcher((CharSequence)theRegex);
        }
        this._pattern = Pattern.compile((String)theRegex);
        this._wildcardNames = theWildcardNames.size() != 0 ? theWildcardNames.toArray(new String[theWildcardNames.size()]) : null;
    }

    public Pattern getPattern() {
        return this._pattern;
    }

    public String[] getWildcardNames() {
        return this._wildcardNames;
    }

    private static String toEscapedReservedChars(String aPathPattern) {
        aPathPattern = PathPattern.toEscapeDollar(aPathPattern);
        aPathPattern = PathPattern.toEscapeOpenCurly(aPathPattern);
        return aPathPattern;
    }

    private static String toEscapeDollar(String aPathPattern) {
        int index = ((String)aPathPattern).indexOf(36);
        while (index != -1 && (((String)aPathPattern).length() == 1 || index == ((String)aPathPattern).length() - 1 || index < ((String)aPathPattern).length() - 1 && ((String)aPathPattern).charAt(index + 1) != '{')) {
            if (index == 0) {
                aPathPattern = PathPattern.toEscapedOutsiceCharacterClass('$') + ((String)aPathPattern).substring(index + 1);
                ++index;
            } else {
                aPathPattern = ((String)aPathPattern).substring(0, index) + PathPattern.toEscapedOutsiceCharacterClass('$') + ((String)aPathPattern).substring(index + 1);
                ++index;
            }
            String tmp = ((String)aPathPattern).substring(index + 1);
            int tmpIndex = index;
            index = tmp.indexOf(36);
            if (index == -1) continue;
            index += tmpIndex + 1;
        }
        return aPathPattern;
    }

    private static String toEscapeOpenCurly(String aPathPattern) {
        int index = ((String)aPathPattern).indexOf(123);
        while (index != -1 && index == 0 || index > 0 && ((String)aPathPattern).charAt(index - 1) != '$') {
            if (index == 0) {
                aPathPattern = PathPattern.toEscapedOutsiceCharacterClass('{') + ((String)aPathPattern).substring(1);
                ++index;
            } else {
                aPathPattern = ((String)aPathPattern).substring(0, index) + PathPattern.toEscapedOutsiceCharacterClass('{') + ((String)aPathPattern).substring(index + 1);
                ++index;
            }
            String tmp = ((String)aPathPattern).substring(index + 1);
            int tmpIndex = index;
            index = tmp.indexOf(123);
            if (index == -1) continue;
            index += tmpIndex + 1;
        }
        return aPathPattern;
    }

    private static String toEscapedInsiceCharacterClass(char aChar) {
        for (char aESCAPE_INSIDE_CHARACTER_CLASS : ESCAPE_INSIDE_CHARACTER_CLASS) {
            if (aESCAPE_INSIDE_CHARACTER_CLASS != aChar) continue;
            return "\\" + aChar;
        }
        return "" + aChar;
    }

    private static String toEscapedOutsiceCharacterClass(char aChar) {
        for (char aESCAPE_OUTSIDE_CHARACTER_CLASS : ESCAPE_OUTSIDE_CHARACTER_CLASS) {
            if (aESCAPE_OUTSIDE_CHARACTER_CLASS != aChar) continue;
            return "\\" + aChar;
        }
        return "" + aChar;
    }
}

