/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.data;

public enum AsciiColorPalette {
    MIN_LEVEL_GRAY(new char[]{' ', '.', '-', '*', '#'}),
    NORM_LEVEL_GRAY(new char[]{' ', '.', ':', '-', '=', '+', '*', '#', '%', '@'}),
    MAX_LEVEL_GRAY(new char[]{' ', '.', '\'', '`', '^', '\"', ',', ':', ';', 'I', 'l', '!', 'i', '>', '<', '~', '+', '_', '-', '?', ']', '[', '}', '{', '1', ')', '(', '|', '\\', '/', 't', 'f', 'j', 'r', 'x', 'n', 'u', 'v', 'c', 'z', 'X', 'Y', 'U', 'J', 'C', 'L', 'Q', '0', 'O', 'Z', 'm', 'w', 'q', 'p', 'd', 'b', 'k', 'h', 'a', 'o', '*', '#', 'M', 'W', '&', '8', '%', 'B', '@', '$'}),
    HALFTONE_GRAY(new char[]{' ', '\u2591', '\u2592', '\u2593', '\u2588'}),
    MONOCHROME(new char[]{' ', '\u2588'});

    private char[] _palette;

    private AsciiColorPalette(char[] aPalette) {
        this._palette = aPalette;
    }

    public char[] getPalette() {
        return this._palette;
    }

    public char[] toInverse() {
        char[] theResult = new char[this._palette.length];
        for (int i = 0; i < this._palette.length; ++i) {
            theResult[i] = this._palette[this._palette.length - 1 - i];
        }
        return theResult;
    }

    public static AsciiColorPalette fromPaletteName(String aPaletteName) {
        for (AsciiColorPalette eValue : AsciiColorPalette.values()) {
            if (!eValue.name().equalsIgnoreCase(aPaletteName)) continue;
            return eValue;
        }
        return null;
    }
}

