/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.archetype;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import org.refcodes.archetype.AbstractCliBuilder;
import org.refcodes.archetype.CliSupport;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.Condition;
import org.refcodes.cli.DebugFlag;
import org.refcodes.cli.Example;
import org.refcodes.cli.Flag;
import org.refcodes.cli.HelpFlag;
import org.refcodes.cli.InitFlag;
import org.refcodes.cli.Option;
import org.refcodes.cli.QuietFlag;
import org.refcodes.cli.SyntaxMetrics;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.Term;
import org.refcodes.cli.VerboseFlag;
import org.refcodes.data.ExitCode;
import org.refcodes.exception.Trap;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;
import org.refcodes.properties.DocumentMetricsBuilder;
import org.refcodes.properties.ext.application.ApplicationProperties;
import org.refcodes.properties.ext.application.CliApplicationProperties;
import org.refcodes.runtime.ConfigLocator;
import org.refcodes.runtime.Execution;
import org.refcodes.runtime.Host;
import org.refcodes.textual.Font;
import org.refcodes.textual.TextBoxGrid;

public class CliHelper
implements CliSupport {
    protected static final String DEFAULT_EMPTY_ARGS_MESSAGE = "Please provide command line arguments specifying your intend!";
    protected static final String DEFAULT_PASSWORD_PROMPT = "Please enter password and hit [ENTER] > ";
    protected ApplicationProperties _properties;
    private String _name;
    private String _passwordPrompt;
    private String _emptyArgsMessage;
    private HelpFlag _helpFlag;
    private boolean _isDebug;
    private boolean _isVerbose;
    private Consumer<Integer> _shutDownHook;
    private RuntimeLogger _logger;
    private URL _url;
    private InputStream _inputStream;
    private File _file;
    private String _filePath;
    private ConfigLocator _configLocator;
    private Class<?> _resourceClass;

    CliHelper(String[] aArgs, Character aShortOptionPrefix, String aLongOptionPrefix, Term aArgsSyntax, SyntaxMetrics aSyntaxMetrics, String aTitle, String aName, String aDescription, String aCopyright, String aLicense, Collection<Example> aExamples, URL aUrl, InputStream aInputStream, File aFile, String aFilePath, ConfigLocator aConfigLocator, Class<?> aResourceClass, char[] aDelimiters, boolean isVerboseFallback, String aPasswordPrompt, String aEmptyArgsMessage, Font aBannerFont, char[] aBannerFontPalette, Character aSeparatorLnChar, TextBoxGrid aTextBoxGrid, String aLineBreak, Integer aConsoleWidth, Integer aMaxConsoleWidth, Boolean isEscCodesEnabled, String aBannerEscCode, String aBannerBorderEscCode, String aArgumentEscCode, String aCommandEscCode, String aOptionEscCode, String aDescriptionEscCode, String aLineSeparatorEscCode, String aResetEscCode, Consumer<Integer> aShutdownHook, PrintStream aStandardOut, PrintStream aErrorOut, ArgsParseMessageMode aArgsParseMessageMode, RuntimeLogger aLogger) {
        block45: {
            this._passwordPrompt = null;
            this._emptyArgsMessage = null;
            this._helpFlag = null;
            this._isVerbose = false;
            this._shutDownHook = null;
            aTitle = aTitle != null && ((String)aTitle).length() != 0 ? aTitle : "<" + aName.toUpperCase() + ">";
            this._logger = aLogger != null ? aLogger : RuntimeLoggerFactorySingleton.createRuntimeLogger();
            this._shutDownHook = aShutdownHook;
            this._name = aName;
            this._emptyArgsMessage = aEmptyArgsMessage != null ? aEmptyArgsMessage : DEFAULT_EMPTY_ARGS_MESSAGE;
            this._passwordPrompt = aPasswordPrompt != null ? aPasswordPrompt : DEFAULT_PASSWORD_PROMPT;
            this._url = aUrl;
            this._inputStream = aInputStream;
            this._file = aFile;
            this._filePath = aFilePath;
            this._configLocator = aConfigLocator;
            this._resourceClass = this.toResourceLocator(aResourceClass);
            this._properties = new CliApplicationProperties(aArgsSyntax, DocumentMetricsBuilder.builder().withDelimiters(aDelimiters).build());
            this._properties.setSyntaxMetrics(aSyntaxMetrics != null ? aSyntaxMetrics : SyntaxNotation.GNU_POSIX);
            this._properties.setName(aName);
            this._properties.setTitle((String)aTitle);
            this._properties.setCopyright(aCopyright);
            this._properties.setLicense(aLicense);
            this._properties.setBannerFont(aBannerFont);
            this._properties.setBannerFontPalette(aBannerFontPalette);
            this._properties.setDescription(aDescription);
            this._properties.setExamples(aExamples);
            if (aConsoleWidth != null && aConsoleWidth != -1) {
                this._properties.setConsoleWidth(aConsoleWidth);
            }
            if (aMaxConsoleWidth != null && aMaxConsoleWidth != -1) {
                this._properties.setMaxConsoleWidth(aMaxConsoleWidth);
            }
            if (aTextBoxGrid != null) {
                this._properties.setTextBoxGrid(aTextBoxGrid);
            }
            if (aLineBreak != null) {
                this._properties.setLineBreak(aLineBreak);
            }
            if (isEscCodesEnabled != null) {
                this._properties.setEscapeCodesEnabled(isEscCodesEnabled);
            }
            if (aBannerEscCode != null) {
                this._properties.setBannerEscapeCode(aBannerEscCode);
            }
            if (aBannerBorderEscCode != null) {
                this._properties.setBannerBorderEscapeCode(aBannerBorderEscCode);
            }
            if (aArgumentEscCode != null) {
                this._properties.setArgumentEscapeCode(aArgumentEscCode);
            }
            if (aCommandEscCode != null) {
                this._properties.setCommandEscapeCode(aCommandEscCode);
            }
            if (aOptionEscCode != null) {
                this._properties.setKeywordEscapeCode(aOptionEscCode);
            }
            if (aDescriptionEscCode != null) {
                this._properties.setDescriptionEscapeCode(aDescriptionEscCode);
            }
            if (aResetEscCode != null) {
                this._properties.setResetEscapeCode(aResetEscCode);
            }
            if (aShortOptionPrefix != null) {
                this._properties.setShortOptionPrefix(aShortOptionPrefix);
            }
            if (aLongOptionPrefix != null) {
                this._properties.setLongOptionPrefix(aLongOptionPrefix);
            }
            if (aLineSeparatorEscCode != null) {
                this._properties.setLineSeparatorEscapeCode(aLineSeparatorEscCode);
            }
            if (aSeparatorLnChar != null) {
                this._properties.setSeparatorLnChar(aSeparatorLnChar.charValue());
            }
            if (aStandardOut != null) {
                this._properties.setStandardOut(aStandardOut);
            }
            if (aErrorOut != null) {
                this._properties.setErrorOut(aErrorOut);
            }
            try {
                this._properties.evalArgs(aArgs);
            }
            catch (ArgsSyntaxException e) {
                this.printHelp();
                if (aArgs == null || aArgs.length == 0) {
                    this._properties.errorLn(this._emptyArgsMessage != null && this._emptyArgsMessage.length() != 0 ? this._emptyArgsMessage : DEFAULT_EMPTY_ARGS_MESSAGE);
                } else {
                    String theMessage = switch (aArgsParseMessageMode.ordinal()) {
                        case 0 -> e.getMessage();
                        case 2 -> e.toMessage();
                        case 1 -> {
                            Throwable var46_45 = e.getCause();
                            if (var46_45 instanceof ArgsSyntaxException) {
                                ArgsSyntaxException exc = (ArgsSyntaxException)var46_45;
                                yield exc.toHeuristicMessage();
                            }
                            yield e.toHeuristicMessage();
                        }
                        default -> e.getMessage();
                    };
                    this._properties.errorLn(theMessage);
                }
                this.exit(ExitCode.MISUSE);
            }
            if (this._properties.getBoolean("help").booleanValue()) {
                this.printHelp();
                this.exit(ExitCode.SUCCESS);
            }
            VerboseFlag theVerboseFlag = null;
            QuietFlag theQuietFlag = null;
            Flag theDebugFlag = null;
            Flag theInitFlag = null;
            if (aArgsSyntax instanceof Condition) {
                Condition theCondition = (Condition)aArgsSyntax;
                theVerboseFlag = theCondition.toOperand(VerboseFlag.class);
                theQuietFlag = theCondition.toOperand(QuietFlag.class);
                theDebugFlag = theCondition.toOperand(DebugFlag.class);
                theInitFlag = theCondition.toOperand(InitFlag.class);
                this._helpFlag = theCondition.toOperand(HelpFlag.class);
            }
            this._isVerbose = this.isVerbose(theVerboseFlag, theQuietFlag, isVerboseFallback);
            boolean bl = this._isDebug = theDebugFlag != null ? theDebugFlag.isEnabled() : false;
            if (this._isVerbose) {
                this.printBanner();
            }
            try {
                block46: {
                    if (theInitFlag != null && theInitFlag.isEnabled()) {
                        this.createConfigFile();
                        this.exit(ExitCode.SUCCESS);
                        break block45;
                    }
                    try {
                        this.loadConfigFile();
                    }
                    catch (Exception e) {
                        if (this._filePath == null || this._filePath.length() == 0) break block46;
                        throw e;
                    }
                }
                this._isVerbose = this.isVerbose(theVerboseFlag, theQuietFlag, isVerboseFallback);
                try {
                    this._isDebug = this._properties.getBoolean(theDebugFlag != null ? theDebugFlag.getAlias() : "debug");
                }
                catch (Exception e) {}
            }
            catch (Exception e) {
                if (this._isDebug) {
                    if (this._isVerbose) {
                        this._logger.error(Trap.asMessage(e), e);
                    } else {
                        this._properties.errorLn(Trap.asMessage(e));
                        e.printStackTrace();
                    }
                } else if (this._isVerbose) {
                    this._logger.error(Trap.asMessage(e));
                } else {
                    this._properties.errorLn(Trap.asMessage(e));
                }
                this.exit(e.hashCode() % 255);
            }
        }
        if (this._properties.getBoolean("sysinfo").booleanValue()) {
            this.printSysInfo();
            this.exit(ExitCode.SUCCESS);
        }
    }

    private CliHelper(AbstractCliBuilder<?, ?> aBuilder) {
        this(aBuilder.args, aBuilder.shortOptionPrefix, aBuilder.longOptionPrefix, aBuilder.argsSyntax, aBuilder.syntaxMetrics, aBuilder.title, aBuilder.name, aBuilder.description, aBuilder.copyright, aBuilder.license, aBuilder.examples, aBuilder.url, aBuilder.inputStream, aBuilder.file, aBuilder.filePath, aBuilder.configLocator, aBuilder.resourceClass, aBuilder.delimiters, aBuilder.verboseFallback, aBuilder.passwordPrompt, aBuilder.emptyArgsMessage, aBuilder.bannerFont, aBuilder.bannerFontPalette, aBuilder.separatorLnChar, aBuilder.textBoxGrid, aBuilder.lineBreak, aBuilder.consoleWidth, aBuilder.maxConsoleWidth, aBuilder.escCodesEnabled, aBuilder.bannerEscCode, aBuilder.bannerBorderEscCode, aBuilder.argumentEscCode, aBuilder.commandEscCode, aBuilder.optionEscCode, aBuilder.descriptionEscCode, aBuilder.lineSeparatorEscCode, aBuilder.resetEscCode, aBuilder.shutDownHook, aBuilder.standardOut, aBuilder.errorOut, aBuilder.argsParseMessageMode, aBuilder.logger);
    }

    @Override
    public void createResourceFile(String aResourcePath, File aDestinationFile) throws IOException {
        File theFile;
        String theResourceName = this.toResourceName(aResourcePath);
        File file = theFile = aDestinationFile != null ? aDestinationFile : new File(theResourceName);
        if (this._isVerbose) {
            this._logger.info("Creating file at <" + theFile.getAbsolutePath() + "> ...");
        }
        try (FileOutputStream theOutputStream = new FileOutputStream(theFile);
             InputStream theInputStream = this._resourceClass != null ? this._resourceClass.getResourceAsStream("/" + aResourcePath) : CliHelper.class.getResourceAsStream("/" + aResourcePath);){
            theInputStream.transferTo(theOutputStream);
            theOutputStream.flush();
        }
    }

    @Override
    public void createResourceFile(String aResourcePath, String aDestinationPath) throws IOException {
        String theResourceName = this.toResourceName(aResourcePath);
        String theDestinationPath = aDestinationPath != null && aDestinationPath.length() != 0 ? aDestinationPath : theResourceName;
        File theFile = new File(theDestinationPath);
        if (this._isVerbose) {
            this._logger.info("Creating file at <" + theFile.getAbsolutePath() + "> ...");
        }
        try (FileOutputStream theOutputStream = new FileOutputStream(theFile);
             InputStream theInputStream = this._resourceClass != null ? this._resourceClass.getResourceAsStream("/" + aResourcePath) : CliHelper.class.getResourceAsStream("/" + aResourcePath);){
            theInputStream.transferTo(theOutputStream);
            theOutputStream.flush();
        }
    }

    @Override
    public void exit(ExitCode aExitCode) {
        this.exit(aExitCode.getStatusCode());
    }

    @Override
    public void exit(int aStatusCode) {
        if (this._shutDownHook != null) {
            this._shutDownHook.accept(aStatusCode);
        } else {
            System.exit(aStatusCode);
        }
    }

    @Override
    public void exitOnException(Throwable e) {
        this.printException(e);
        this.exit(e.hashCode() % 255);
    }

    @Override
    public ApplicationProperties getApplicationProperties() {
        return this._properties;
    }

    @Override
    public boolean isDebug() {
        return this._isDebug;
    }

    @Override
    public boolean isVerbose() {
        return this._isVerbose;
    }

    @Override
    public void printException(String aMessage) {
        this.printException(aMessage, null);
    }

    @Override
    public void printException(Throwable e) {
        this.printException(null, e);
    }

    @Override
    public void printException(String aMessage, Throwable e) {
        String theMessage;
        String string = theMessage = aMessage != null ? aMessage : e.getClass().getSimpleName() + ": " + Trap.asMessage(e);
        if (!this._isVerbose) {
            this._logger.printTail();
        }
        if (this._isDebug) {
            if (this._isVerbose) {
                if (e != null) {
                    this._logger.error(theMessage, e);
                } else {
                    this._logger.error(theMessage);
                }
            } else {
                System.out.println(theMessage);
                if (e != null) {
                    e.printStackTrace();
                }
            }
        } else if (this._isVerbose) {
            this._logger.error(theMessage);
        } else {
            System.out.println(theMessage);
        }
        if (this._helpFlag != null) {
            if (this._isVerbose) {
                this._logger.info("Call '" + this._name + " " + (this._properties != null ? this._properties.getLongOptionPrefix() : SyntaxNotation.DEFAULT.getLongOptionPrefix()) + this._helpFlag.getLongOption() + "' for help!");
            } else {
                System.out.println("Call '" + this._name + " " + (this._properties != null ? this._properties.getLongOptionPrefix() : SyntaxNotation.DEFAULT.getLongOptionPrefix()) + this._helpFlag.getLongOption() + "' for help!");
            }
        }
    }

    @Override
    public void printSysInfo() {
        if (this._isVerbose) {
            this._logger.printSeparator();
            for (String eKey : this._properties.sortedKeys()) {
                this._logger.info(eKey + " = " + (String)this._properties.get((Object)eKey));
            }
            this._logger.printSeparator();
            Map<String, String> theSysinfo = Host.toSystemInfo();
            ArrayList<String> theKeys = new ArrayList<String>(theSysinfo.keySet());
            Collections.sort(theKeys);
            for (String eKey : theKeys) {
                this._logger.info(eKey + " = " + theSysinfo.get(eKey));
            }
            this._logger.printSeparator();
        } else {
            System.out.println(Host.toPrettySystemInfo());
        }
    }

    @Override
    public char[] readPassword() {
        return this.readPassword(this._passwordPrompt);
    }

    @Override
    public char[] readPassword(String aPrompt) {
        if (this._isVerbose) {
            this._logger.printTail();
        }
        System.console().printf(aPrompt, new Object[0]);
        char[] theReadPassword = System.console().readPassword();
        if (theReadPassword == null || theReadPassword.length == 0) {
            this.exit(ExitCode.CONTROL_C);
        }
        return theReadPassword;
    }

    @Override
    public String[] toOptions(Option<?> aOption) {
        return this._properties.toOptions(aOption);
    }

    protected void printBanner() {
        this._properties.printBanner();
    }

    protected void printHelp() {
        this._properties.printHelp();
    }

    private void createConfigFile() throws IOException {
        String theConfigPath = this._properties.getOr("config", this._filePath);
        theConfigPath = theConfigPath != null && theConfigPath.length() != 0 ? theConfigPath : this._filePath;
        File theFile = new File(theConfigPath);
        if (this._isVerbose) {
            this._logger.info("Initializing file at <" + theFile.getAbsolutePath() + "> ...");
        }
        try (FileOutputStream theOutputStream = new FileOutputStream(theFile);
             InputStream theInputStream = this._resourceClass != null ? this._resourceClass.getResourceAsStream("/" + this._filePath) : CliHelper.class.getResourceAsStream("/" + this._filePath);){
            theInputStream.transferTo(theOutputStream);
            theOutputStream.flush();
        }
    }

    private boolean isVerbose(VerboseFlag aVerboseFlag, QuietFlag aQuietFlag, boolean isVerboseFallback) {
        if (aVerboseFlag == null && aQuietFlag == null && !this._properties.containsKey((Object)"quiet") && !this._properties.containsKey((Object)"verbose")) {
            return isVerboseFallback;
        }
        if (aVerboseFlag != null && aVerboseFlag.hasValue()) {
            return aVerboseFlag.isEnabled();
        }
        if (aQuietFlag != null && aQuietFlag.hasValue()) {
            return !aQuietFlag.isEnabled();
        }
        boolean isQuiet = this._properties.containsKey((Object)"quiet") && this._properties.getBoolean("quiet") == false;
        boolean isVerbose = this._properties.containsKey((Object)"verbose") && this._properties.getBoolean("verbose") != false;
        return aQuietFlag != null && !isQuiet || aVerboseFlag != null && isVerbose;
    }

    private void loadConfigFile() throws ParseException, IOException {
        block15: {
            if (this._url != null) {
                this._properties.withURL(this._url);
                if (this._isVerbose) {
                    this._logger.info("Loaded config from <" + this._url.toString() + "> ...");
                    this._logger.printSeparator();
                }
            } else if (this._inputStream != null) {
                this._properties.withInputStream(this._inputStream);
                if (this._isVerbose) {
                    this._logger.info("Loaded config _inputStream <" + this._inputStream.toString() + "> ...");
                    this._logger.printSeparator();
                }
            } else if (this._file != null) {
                this._properties.withFile(this._file);
                if (this._isVerbose) {
                    this._logger.info("Loaded config from <" + this._file.toString() + "> ...");
                    this._logger.printSeparator();
                }
            } else {
                String aConfigPath = this._properties.getOr("config", this._filePath);
                if (aConfigPath != null && aConfigPath.length() != 0) {
                    this._properties.withResourceFilePath(this._resourceClass, aConfigPath, this._configLocator);
                    if (this._isVerbose) {
                        this._logger.info("Loaded config from <" + aConfigPath + "> ...");
                        this._logger.printSeparator();
                    }
                } else if (this._filePath != null && this._filePath.length() != 0) {
                    try {
                        this._properties.withResourceFilePath(this._resourceClass, this._filePath);
                    }
                    catch (IOException ignore) {
                        if (!this._isVerbose) break block15;
                        this._logger.warn("Config file with name <" + this._filePath + "> not found (skipping) as of: " + Trap.asMessage(ignore));
                    }
                }
            }
        }
    }

    private Class<?> toResourceLocator(Class<?> aResourceLocator) {
        if (aResourceLocator == null && (aResourceLocator = Execution.getMainClass()) == null && (aResourceLocator = Execution.getCallerType(AbstractCliBuilder.class)) == null && (aResourceLocator = Execution.getCallerType(this.getClass())) == null) {
            aResourceLocator = this.getClass();
        }
        return aResourceLocator;
    }

    private String toResourceName(String aResourcePath) {
        String theResourceName = aResourcePath;
        int index = theResourceName.indexOf(File.pathSeparator);
        while (index != -1 && index != theResourceName.length() - 1) {
            theResourceName = theResourceName.substring(index + 1);
            index = theResourceName.indexOf(File.pathSeparator);
        }
        return theResourceName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum ArgsParseMessageMode {
        SIMPLE,
        HEURISTIC,
        VERBOSE;

    }

    public static class Builder
    extends AbstractCliBuilder<Builder, CliHelper> {
        @Override
        public CliHelper build() {
            return new CliHelper(this);
        }
    }
}

