/*
 * Decompiled with CFR 0.152.
 */
package club.funcodes.crackzip;

import club.funcodes.crackzip.CrackZip;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.model.FileHeader;
import org.refcodes.archetype.CliHelper;
import org.refcodes.cli.ArrayOption;
import org.refcodes.cli.CasesCondition;
import org.refcodes.cli.CleanFlag;
import org.refcodes.cli.CliSugar;
import org.refcodes.cli.DebugFlag;
import org.refcodes.cli.EnumOption;
import org.refcodes.cli.Example;
import org.refcodes.cli.Flag;
import org.refcodes.cli.HelpFlag;
import org.refcodes.cli.IntOption;
import org.refcodes.cli.StringOption;
import org.refcodes.cli.SysInfoFlag;
import org.refcodes.cli.VerboseFlag;
import org.refcodes.component.LifecycleException;
import org.refcodes.data.AnsiEscapeCode;
import org.refcodes.data.AsciiColorPalette;
import org.refcodes.data.CharSet;
import org.refcodes.data.ExitCode;
import org.refcodes.exception.Trap;
import org.refcodes.generator.AlphabetCounterComposite;
import org.refcodes.generator.AlphabetCounterMetrics;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;
import org.refcodes.properties.ResourceProperties;
import org.refcodes.properties.TomlProperties;
import org.refcodes.properties.ext.application.ApplicationProperties;
import org.refcodes.runtime.Terminal;
import org.refcodes.struct.CanonicalTable;
import org.refcodes.textual.Font;
import org.refcodes.textual.FontFamily;
import org.refcodes.textual.FontStyle;
import org.refcodes.textual.VerboseTextBuilder;
import sun.misc.Signal;

public class Main {
    private static final RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private static final String NAME = "crackzip";
    private static final String DEFAULT_CONFIG = "crackzip.ini";
    private static final String TITLE = "\u2026CRACKX7IP\u2026";
    private static final String LICENSE_NOTE = "You may choose between the LGPL v3.0 or later and the Apache License v2.0 when using this software";
    private static final String COPYRIGHT = "Copyright (c) by CLUB.FUNCODES | See [https://www.metacodes.pro/manpages/crackzip_manpage]";
    private static final char[] BANNER_PALETTE = AsciiColorPalette.MAX_LEVEL_GRAY.getPalette();
    private static final Font BANNER_FONT = new Font(FontFamily.DIALOG, FontStyle.BOLD);
    private static final String DESCRIPTION = "Recovery tool for cracking password protected ZIP (*.zip) files (see [https://www.metacodes.pro/manpages/crackzip_manpage]).";
    private static final String ZIPFILE_PROPERTY = "zipFile";
    private static final String WORDLIST_PROPERTY = "wordFile";
    private static final String OUTPUTDIR_PROPERTY = "outputDir";
    private static final String INFO_PROPERTY = "info";
    private static final String BRUTEFORCE_PROPERTY = "bruteForce";
    private static final String INIT_PROPERTY = "init";
    private static final String CHARSET_PROPERTY = "charSet";
    private static final String ALPHABET_PROPERTY = "alphabet";
    private static final String MINLENGTH_PROPERTY = "minLength";
    private static final String MAXLENGTH_PROPERTY = "maxLength";
    private static final String RESUMEFROM_PROPERTY = "resumeFrom";
    private static final String THREADS_PROPERTY = "threads";
    private static final String PRIORITY_PROPERTY = "priority";
    private static final String PASSWORD_PROPERTY = "password";
    private static final String NOCACHE_PROPERTY = "noCache";
    private static final String UPDATE_PROPERTY = "updateTimeMillis";
    private static final String TIMEELAPSED_PROPERTY = "timeElapsedSecs";
    private static final String PASSWORDCOUNT_PROPERTY = "passwordCount";
    private static final String EXPRESSION_PROPERTY = "expression";
    private static final String YES_REGEX_PROPERTY = "yesRegex";
    private static final String NO_REGEX_PROPERTY = "noRegex";
    private static final int DEFAULT_MINLENGTH = 1;
    private static final int DEFAULT_MAXLENGTH = -1;
    private static final CharSet DEFAULT_CHARSET = CharSet.ASCII;
    private static final int DEFAULT_UPDATE_TIME_MS = 2500;
    private static final String ESC_BOLD = Terminal.isAnsiTerminalEnabled() ? AnsiEscapeCode.toEscapeSequence(AnsiEscapeCode.BOLD) : "";
    private static final String ESC_ATTENTION = Terminal.isAnsiTerminalEnabled() ? AnsiEscapeCode.toEscapeSequence(AnsiEscapeCode.FG_BRIGHT_YELLOW, AnsiEscapeCode.BG_BLUE) : "";
    private static final String ESC_RESET = Terminal.isAnsiTerminalEnabled() ? AnsiEscapeCode.toEscapeSequence(AnsiEscapeCode.RESET) : "";

    public static void main(String[] args) {
        block41: {
            EnumOption<CharSet> theCharSetArg = CliSugar.enumOption("char-set", CharSet.class, CHARSET_PROPERTY, "The character set to use when probing passwords: " + VerboseTextBuilder.asString(CharSet.values()));
            StringOption theAlphabetArg = CliSugar.stringOption(Character.valueOf('a'), ALPHABET_PROPERTY, ALPHABET_PROPERTY, "The alphabet to when probing passwords.");
            StringOption theWordListFileArg = CliSugar.stringOption(Character.valueOf('w'), "word-list", WORDLIST_PROPERTY, "The word list file (one word per line) which contains the passwords to probe.");
            StringOption theInputFileArg = CliSugar.stringOption(Character.valueOf('i'), "input-file", ZIPFILE_PROPERTY, "The input ZIP (*.zip) file which to examine.");
            StringOption theOutputDirArg = CliSugar.stringOption(Character.valueOf('o'), "output-dir", OUTPUTDIR_PROPERTY, "The output directory where to write the results to.");
            StringOption theResumeArg = CliSugar.stringOption(Character.valueOf('r'), "resume-from", RESUMEFROM_PROPERTY, "Resume the operation from the given password.");
            StringOption theExpressionArg = CliSugar.stringOption(Character.valueOf('e'), EXPRESSION_PROPERTY, EXPRESSION_PROPERTY, "The expression(s) in combination defining the password each as of \"[minLength-maxLength]:{char(s),char(s),...,char(s)}:'startValue'\". e.g. \"[3-12]:{A-Z,0-9,ASCII_SPECIAL,U+03B1,U+03B2,U+03B3,a,b,c}:'a10!Y'\" (probed password's min length is 3, max length is 12, valid characters include all upper case letters from 'A' to 'Z', all digits from '0' to '9', the ASCII_SPECIAL char(s), the letters 'alpha', 'beta', 'gamma' as of the given UTF codepoints as well as the letters 'a', 'b', 'c' and the section's start value \"a10!Y\"). Predefined char sets as of: " + VerboseTextBuilder.asString(CharSet.values()));
            StringOption theYesExpArg = CliSugar.stringOption(Character.valueOf('y'), "yes-regex", YES_REGEX_PROPERTY, "A regular expression which must match a password to be included(!) for probing, e.g. \"\\b.*?(.)\\1.*?\\b\" to include only those password with at least two same characters directly next to each other.");
            StringOption theNoExpArg = CliSugar.stringOption(Character.valueOf('n'), "no-regex", NO_REGEX_PROPERTY, "A regular expression which must match a password to be skipped(!) for probing, e.g. \"\\b.*?(.)\\1.*?\\b\" to skip those password with at least two same characters directly next to each other.");
            ArrayOption<String> theExpressionArgs = CliSugar.asArray(theExpressionArg);
            Flag theInfoFlag = CliSugar.flag(INFO_PROPERTY, INFO_PROPERTY, "Show detailed information about the ZIP (*.zip) input  file.");
            Flag theBruteForceFlag = CliSugar.flag(Character.valueOf('b'), "brute-force", BRUTEFORCE_PROPERTY, "Start brute force password recovery.");
            DebugFlag theDebugFlag = CliSugar.debugFlag(false);
            Flag theInitFlag = CliSugar.flag(INIT_PROPERTY, INIT_PROPERTY, "Initialize a new project.");
            VerboseFlag theVerboseFlag = CliSugar.verboseFlag();
            SysInfoFlag theSysInfoFlag = CliSugar.sysInfoFlag(false);
            HelpFlag theHelpFlag = CliSugar.helpFlag();
            CleanFlag theCleanFlag = CliSugar.cleanFlag(false);
            Flag theNoCacheFlag = CliSugar.flag("no-cache", NOCACHE_PROPERTY, "Experimental, do not(!) load ZIP (*.zip) input file into memory (no speedup) before processing.");
            IntOption theMinLengthArg = CliSugar.intOption("min-length", MINLENGTH_PROPERTY, "Min password length to probe (defaults to <1>).");
            IntOption theMaxLengthArg = CliSugar.intOption("max-length", MAXLENGTH_PROPERTY, "Max password length to probe, a value of -1 denotes an infinite max length (defaults to <-1>).");
            IntOption theThreadsArg = CliSugar.intOption(Character.valueOf('t'), THREADS_PROPERTY, THREADS_PROPERTY, "Number of threads to use (defaults to <" + Runtime.getRuntime().availableProcessors() + "> on this machine).");
            IntOption thePriorityArg = CliSugar.intOption(Character.valueOf('p'), PRIORITY_PROPERTY, PRIORITY_PROPERTY, "Thread priority (min = <1>, max = <10>) to use (defaults to <5>).");
            IntOption theUpdateTimeArg = CliSugar.intOption(Character.valueOf('u'), "update-time", UPDATE_PROPERTY, "Update time in ms of update current execution status into project file and, upon verbose mode, on the screen (defaults to <2500>).");
            CasesCondition theArgsSyntax = CliSugar.cases(CliSugar.and(theBruteForceFlag, theInputFileArg, CliSugar.any(theOutputDirArg, CliSugar.xor(theWordListFileArg, theExpressionArgs, CliSugar.any(theMinLengthArg, theMaxLengthArg, CliSugar.xor(theCharSetArg, theAlphabetArg), theResumeArg)), theYesExpArg, theNoExpArg, theThreadsArg, thePriorityArg, theUpdateTimeArg, theNoCacheFlag, theVerboseFlag, theDebugFlag)), CliSugar.and(theInitFlag, theInputFileArg, CliSugar.any(theVerboseFlag, theDebugFlag)), CliSugar.and(theCleanFlag, theInputFileArg, CliSugar.any(theVerboseFlag, theDebugFlag)), CliSugar.and(theInfoFlag, theInputFileArg, CliSugar.any(theVerboseFlag, theDebugFlag)), CliSugar.xor(theHelpFlag, CliSugar.and(theSysInfoFlag, CliSugar.any(theVerboseFlag))));
            Example[] theExamples = CliSugar.examples(CliSugar.example("Crack archive password using a char set", theBruteForceFlag, theInputFileArg, theCharSetArg, theVerboseFlag), CliSugar.example("Crack archive password using a custom alphabet", theBruteForceFlag, theInputFileArg, theAlphabetArg, theVerboseFlag), CliSugar.example("Crack archive password using a word list", theBruteForceFlag, theInputFileArg, theWordListFileArg, theVerboseFlag), CliSugar.example("Crack archive starting at password using a char set", theBruteForceFlag, theInputFileArg, theCharSetArg, theResumeArg, theVerboseFlag), CliSugar.example("Crack archive starting at password using a custom alphabet", theBruteForceFlag, theInputFileArg, theAlphabetArg, theResumeArg, theVerboseFlag), CliSugar.example("Crack archive starting at password using a a word list", theBruteForceFlag, theInputFileArg, theWordListFileArg, theResumeArg, theVerboseFlag), CliSugar.example("Crack archive with passwords [min..max] using a char set", theBruteForceFlag, theInputFileArg, theCharSetArg, theMinLengthArg, theMaxLengthArg, theVerboseFlag), CliSugar.example("Crack archive with passwords [min..max] using a custom alphabet", theBruteForceFlag, theInputFileArg, theAlphabetArg, theMinLengthArg, theMaxLengthArg, theVerboseFlag), CliSugar.example("Crack archive with number of threads and thread priorities", theBruteForceFlag, theInputFileArg, theThreadsArg, thePriorityArg, theVerboseFlag), CliSugar.example("Crack archive with three expressions for complex passwords to probe", theBruteForceFlag, theInputFileArg, theExpressionArg, theExpressionArg, theExpressionArg), CliSugar.example("Crack archive and extract cracked content to output folder", theBruteForceFlag, theInputFileArg, theOutputDirArg, theVerboseFlag), CliSugar.example("Update frequency (ms) of current execution status into project file", theBruteForceFlag, theInputFileArg, theUpdateTimeArg, theVerboseFlag), CliSugar.example("Clean archive's project configuration", theCleanFlag, theInputFileArg, theVerboseFlag), CliSugar.example("Show ZIP file information", theInfoFlag, theInputFileArg, theVerboseFlag), CliSugar.example("To show the help text", theHelpFlag), CliSugar.example("To print the system info", theSysInfoFlag));
            CliHelper theCliHelper = ((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)CliHelper.builder().withArgs(args)).withArgsSyntax(theArgsSyntax)).withExamples(theExamples)).withResourceClass((Class)Main.class)).withName(NAME)).withTitle(TITLE)).withDescription(DESCRIPTION)).withLicense(LICENSE_NOTE)).withCopyright(COPYRIGHT)).withBannerFont(BANNER_FONT)).withBannerFontPalette(BANNER_PALETTE)).withLogger(LOGGER)).build();
            ApplicationProperties theArgsProperties = theCliHelper.getApplicationProperties();
            boolean isVerbose = theCliHelper.isVerbose();
            boolean isDebug = theArgsProperties.getBoolean((Object)theDebugFlag);
            try {
                String theZipFilePath = (String)theInputFileArg.getValue();
                String theProjectFilePath = theZipFilePath + ".ini";
                if (!theProjectFilePath.endsWith(".ini")) {
                    theProjectFilePath = theProjectFilePath + ".ini";
                }
                if (theInfoFlag.isEnabled()) {
                    Main.info(theZipFilePath, isVerbose);
                    break block41;
                }
                if (theBruteForceFlag.isEnabled()) {
                    int thePriority;
                    AlphabetCounterMetrics[] theAlphabetCounterMetrics;
                    Pattern theNoPattern;
                    File theProjectFile;
                    File theZipFile = Main.toZipFile(theZipFilePath, isVerbose);
                    if (isVerbose) {
                        LOGGER.printSeparator();
                    }
                    if ((theProjectFile = Main.toProjectFile(theProjectFilePath, isVerbose)).isDirectory()) {
                        throw new IOException("Project file \"" + theProjectFilePath + "\" (<" + theProjectFile.getAbsolutePath() + ">) points to a directory!");
                    }
                    if (!theProjectFile.exists()) {
                        theCliHelper.createResourceFile(DEFAULT_CONFIG, theProjectFile);
                    }
                    TomlProperties theProjectProperties = new TomlProperties(theProjectFile);
                    theProjectProperties.putAll(theArgsProperties.getArgsParserProperties());
                    if (theAlphabetArg.hasValue() || theCharSetArg.hasValue()) {
                        theProjectProperties.remove((Object)ALPHABET_PROPERTY);
                        theProjectProperties.remove((Object)CHARSET_PROPERTY);
                    }
                    if (isVerbose) {
                        LOGGER.printSeparator();
                    }
                    String theOutputDirPath = (String)theProjectProperties.get((Object)OUTPUTDIR_PROPERTY);
                    File theOutputDir = null;
                    if (theOutputDirPath != null && theOutputDirPath.length() != 0) {
                        theOutputDir = new File(theOutputDirPath);
                        if (isVerbose) {
                            LOGGER.info("Output dir = \"" + theOutputDirPath + "\" (<" + theOutputDir.getAbsolutePath() + ">)");
                        }
                        if (!theOutputDir.isDirectory() && !theOutputDir.mkdir()) {
                            throw new IOException("Cannot create output dir \"" + theOutputDirPath + "\" (<" + theOutputDir.getAbsolutePath() + ">)!");
                        }
                    }
                    String theYesRegex = (String)theProjectProperties.get((Object)YES_REGEX_PROPERTY);
                    String theNoRegex = (String)theProjectProperties.get((Object)NO_REGEX_PROPERTY);
                    Pattern theYesPattern = theYesRegex != null && theYesRegex.length() != 0 ? Pattern.compile(theYesRegex) : null;
                    Pattern pattern = theNoPattern = theNoRegex != null && theNoRegex.length() != 0 ? Pattern.compile(theNoRegex) : null;
                    if (isVerbose) {
                        if (theYesPattern != null) {
                            LOGGER.info("Yes regex = \"" + theYesRegex + "\" (<" + theYesPattern.pattern() + ">)");
                        }
                        if (theNoPattern != null) {
                            LOGGER.info("No regex = \"" + theNoRegex + "\" (<" + theNoPattern.pattern() + ">)");
                        }
                    }
                    boolean hasAlphabetArg = theMinLengthArg.hasValue() || theMaxLengthArg.hasValue() || theAlphabetArg.hasValue() || theCharSetArg.hasValue() || theResumeArg.hasValue();
                    boolean hasExpressionArg = theExpressionArgs.hasValue();
                    boolean hasWordListFileArg = theWordListFileArg.hasValue();
                    if (hasAlphabetArg) {
                        Main.cleanProjectExpression(theProjectProperties, isVerbose);
                        int theMinLength = theProjectProperties.getIntOr(MINLENGTH_PROPERTY, (Integer)1);
                        int theMaxLength = theProjectProperties.getIntOr(MAXLENGTH_PROPERTY, (Integer)-1);
                        String theResume = (String)theProjectProperties.get((Object)RESUMEFROM_PROPERTY);
                        String theAlphabet = (String)theProjectProperties.get((Object)ALPHABET_PROPERTY);
                        CharSet theCharSet = theProjectProperties.getEnum(CharSet.class, CHARSET_PROPERTY);
                        theAlphabetCounterMetrics = new AlphabetCounterMetrics[]{Main.toAlphabetCounterMetrics(theResume, theMinLength, theMaxLength, theAlphabet, theCharSet)};
                        Main.resetProjectProperties(theProjectProperties);
                    } else if (hasWordListFileArg) {
                        Main.cleanProjectExpression(theProjectProperties, isVerbose);
                        String theResume = (String)theProjectProperties.get((Object)RESUMEFROM_PROPERTY);
                        String theWordListFilePath = (String)theWordListFileArg.getValue();
                        File theWordListFile = new File(theWordListFilePath);
                        if (isVerbose) {
                            LOGGER.printSeparator();
                            LOGGER.info("Word list = " + theWordListFile.getAbsolutePath());
                        }
                        theAlphabetCounterMetrics = new AlphabetCounterMetrics[]{new AlphabetCounterMetrics(theResume, theWordListFile)};
                        Main.resetProjectProperties(theProjectProperties);
                    } else if (hasExpressionArg) {
                        String[] theExpressions;
                        Main.resetProjectProperties(theProjectProperties);
                        if (theExpressionArgs.hasValue()) {
                            theProjectProperties.putArray(EXPRESSION_PROPERTY, (String[])theExpressionArgs.getValue());
                        }
                        if ((theExpressions = (String[])theProjectProperties.getArray(EXPRESSION_PROPERTY)) == null || theExpressions.length == 0) {
                            throw new IllegalArgumentException("You provided empty expression(s) " + (theExpressions == null ? "<null>" : "<{}>") + " for argument (property) <expression> though at least one expression is required!");
                        }
                        theAlphabetCounterMetrics = new AlphabetCounterMetrics[theExpressions.length];
                        for (int i = 0; i < theExpressions.length; ++i) {
                            theAlphabetCounterMetrics[i] = new AlphabetCounterMetrics(theExpressions[i]);
                        }
                    } else {
                        String[] theExpressions = (String[])theProjectProperties.getArray(RESUMEFROM_PROPERTY);
                        if (theExpressions == null || theExpressions.length == 0) {
                            theExpressions = (String[])theProjectProperties.getArray(EXPRESSION_PROPERTY);
                        }
                        if (theExpressions == null || theExpressions.length == 0) {
                            throw new IllegalArgumentException("You provided empty expression(s) " + (theExpressions == null ? "<null>" : "<{}>") + " for argument (property) <expression> though at least one expression is required!");
                        }
                        theAlphabetCounterMetrics = new AlphabetCounterMetrics[theExpressions.length];
                        for (int i = 0; i < theExpressions.length; ++i) {
                            theAlphabetCounterMetrics[i] = new AlphabetCounterMetrics(theExpressions[i]);
                        }
                    }
                    if (isVerbose) {
                        LOGGER.printSeparator();
                        LOGGER.info("Number of expressions being processed = " + theAlphabetCounterMetrics.length);
                        for (AlphabetCounterMetrics eMetrics : theAlphabetCounterMetrics) {
                            LOGGER.printSeparator();
                            LOGGER.info("Expression = " + eMetrics.toAlphabetExpression());
                            LOGGER.info("Min length = " + eMetrics.getMinLength());
                            LOGGER.info("Max length = " + String.valueOf(eMetrics.getMaxLength() == -1 ? "\u221e" : Integer.valueOf(eMetrics.getMaxLength())));
                            if (eMetrics.getAlphabet() != null) {
                                LOGGER.info("Alphabet = " + VerboseTextBuilder.asString(eMetrics.getAlphabet()));
                            }
                            if (eMetrics.getStartValue() != null) {
                                LOGGER.info("Start value = " + eMetrics.getStartValue());
                            }
                            if (eMetrics.getWords() == null) continue;
                            LOGGER.info("Words = " + VerboseTextBuilder.asString(eMetrics.getWords()));
                        }
                    }
                    AlphabetCounterComposite theAlphabetCounter = new AlphabetCounterComposite(theAlphabetCounterMetrics);
                    int theThreads = theProjectProperties.getIntOr(THREADS_PROPERTY, (Integer)(Runtime.getRuntime().availableProcessors() / 2 + 1));
                    if (isVerbose) {
                        LOGGER.printSeparator();
                        LOGGER.info("Number of threads to use: " + theThreads);
                    }
                    if ((thePriority = theProjectProperties.getIntOr(PRIORITY_PROPERTY, (Integer)5).intValue()) < 1 || thePriority > 10) {
                        throw new IllegalArgumentException("The thread priority <" + thePriority + "> must be between <1> and <10>!");
                    }
                    if (isVerbose) {
                        LOGGER.info("Thread priority used: " + thePriority);
                    }
                    boolean isNoCache = theProjectProperties.getBoolean(NOCACHE_PROPERTY);
                    if (isVerbose) {
                        LOGGER.info("Process in-memory: " + (isNoCache ? "No" : "Yes"));
                    }
                    int theUpdateTime = theProjectProperties.getIntOr(UPDATE_PROPERTY, (Integer)2500);
                    if (isVerbose) {
                        LOGGER.info("Update time (ms): " + theUpdateTime);
                    }
                    theProjectProperties.flush();
                    Main.crackZipFile(theZipFile, theOutputDir, theAlphabetCounter, theYesPattern, theNoPattern, theThreads, thePriority, isNoCache, theUpdateTime, theProjectProperties, isVerbose, isDebug);
                    break block41;
                }
                if (theInitFlag.isEnabled()) {
                    File theProjectFile = Main.toProjectFile(theProjectFilePath, isVerbose);
                    theCliHelper.createResourceFile(DEFAULT_CONFIG, theProjectFile);
                } else if (theCleanFlag.isEnabled()) {
                    Main.init(theProjectFilePath, isVerbose);
                }
            }
            catch (Throwable e) {
                theCliHelper.exitOnException(e);
            }
        }
    }

    private static void cleanProjectExpression(ResourceProperties aProjectProperties, boolean isVerbose) {
        CanonicalTable theRemoved = aProjectProperties.removeAll(EXPRESSION_PROPERTY, "**");
        if (theRemoved != null && theRemoved.size() != 0 && isVerbose) {
            LOGGER.printSeparator();
            for (String eKey : theRemoved.sortedKeys()) {
                LOGGER.info("Discarding expression: \"" + (String)theRemoved.get((Object)eKey) + "\" (overwritten by command line args)...");
            }
        }
    }

    private static void resetProjectProperties(ResourceProperties aProjectProperties) {
        aProjectProperties.remove((Object)MINLENGTH_PROPERTY);
        aProjectProperties.remove((Object)MAXLENGTH_PROPERTY);
        aProjectProperties.remove((Object)RESUMEFROM_PROPERTY);
        aProjectProperties.remove((Object)ALPHABET_PROPERTY);
        aProjectProperties.remove((Object)CHARSET_PROPERTY);
        aProjectProperties.remove((Object)PASSWORDCOUNT_PROPERTY);
        aProjectProperties.remove((Object)TIMEELAPSED_PROPERTY);
        aProjectProperties.remove((Object)EXPRESSION_PROPERTY);
        aProjectProperties.removeAll(EXPRESSION_PROPERTY, "**");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void crackZipFile(File aInFile, File aOutputDir, AlphabetCounterComposite aAlphabetCounterComposite, Pattern aYesPattern, Pattern aNoPattern, int aThreads, int aPriority, boolean isNoCache, long aUpdateResumeLoopTimeMs, ResourceProperties aProperties, boolean isVerbose, boolean isDebug) throws IOException, LifecycleException {
        String theFirstPassword = aAlphabetCounterComposite.toString();
        long thePasswordCount = aProperties.getLongOr(PASSWORDCOUNT_PROPERTY, (Long)0L);
        long eTimeElapsedSecs = aProperties.getLongOr(TIMEELAPSED_PROPERTY, (Long)0L);
        long startTime = eTimeElapsedSecs == 0L ? System.currentTimeMillis() : System.currentTimeMillis() - eTimeElapsedSecs * 1000L;
        Thread.currentThread().setPriority(aPriority);
        CrackZip theCrackZip = new CrackZip(aInFile, aOutputDir, aAlphabetCounterComposite, aYesPattern, aNoPattern, aThreads, aPriority, isNoCache);
        Signal.handle(new Signal("INT"), signal -> {
            try {
                theCrackZip.stopUnchecked();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        long ePasswordCount = 0L;
        if (isVerbose) {
            LOGGER.printSeparator();
        }
        String eLastProcessed = theFirstPassword;
        while (!theCrackZip.isStopped()) {
            long ePasswordsPerSecond;
            aProperties.putArray(RESUMEFROM_PROPERTY, aAlphabetCounterComposite.toAlphabetExpressions());
            eTimeElapsedSecs = (System.currentTimeMillis() - startTime) / 1000L;
            ePasswordCount = thePasswordCount + theCrackZip.getProbedPasswordsCount();
            long l = ePasswordsPerSecond = eTimeElapsedSecs != 0L ? ePasswordCount / eTimeElapsedSecs : -1L;
            if (isVerbose) {
                LOGGER.trace("Current probed password (of a total of <" + ePasswordCount + ">) is \"" + eLastProcessed + "\" (<" + String.valueOf(ePasswordsPerSecond != -1L ? Long.valueOf(ePasswordsPerSecond) : "?") + "> passwords/sec)...");
            }
            CrackZip crackZip = theCrackZip;
            synchronized (crackZip) {
                try {
                    theCrackZip.wait(aUpdateResumeLoopTimeMs);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            eLastProcessed = theCrackZip.lastProcessed();
            aProperties.flush();
        }
        ePasswordCount = thePasswordCount + theCrackZip.getProbedPasswordsCount();
        if (isVerbose) {
            long theThroughput = eTimeElapsedSecs != 0L ? ePasswordCount / eTimeElapsedSecs : -1L;
            LOGGER.printSeparator();
            LOGGER.info("Total time elapsed = <" + String.valueOf(eTimeElapsedSecs != -1L ? Long.valueOf(eTimeElapsedSecs) : "?") + "> seconds");
            LOGGER.info("Total number of passwords probed = <" + ePasswordCount + ">");
            LOGGER.info("Throughput = <" + theThroughput + "> passwords/sec");
            LOGGER.printSeparator();
            if (theCrackZip.getException() != null) {
                if (isDebug) {
                    LOGGER.warn(Trap.asMessage(theCrackZip.getException()), theCrackZip.getException());
                } else {
                    LOGGER.warn(Trap.asMessage(theCrackZip.getException()));
                }
            }
        }
        String theResumeVerbose = aAlphabetCounterComposite.toString();
        aProperties.putLong(TIMEELAPSED_PROPERTY, (Long)eTimeElapsedSecs);
        aProperties.putLong(PASSWORDCOUNT_PROPERTY, (Long)ePasswordCount);
        if (theCrackZip.getPassword() != null) {
            aProperties.putArray(RESUMEFROM_PROPERTY, aAlphabetCounterComposite.toAlphabetExpressions());
            aProperties.put(PASSWORD_PROPERTY, theCrackZip.getPassword());
            aProperties.flush();
            if (isVerbose) {
                LOGGER.printSeparator();
                LOGGER.info("Congratulations! Found your password in <" + (System.currentTimeMillis() - startTime) / 1000L + "> seconds!");
                LOGGER.info("Your password might be \"" + ESC_ATTENTION + theCrackZip.getPassword() + ESC_RESET + "\" (excluding the surrounding quotes)!");
                if (aOutputDir != null) {
                    LOGGER.info("ZIP (*.zip) content written to: <" + aOutputDir.getAbsolutePath() + ">");
                }
                LOGGER.printSeparator();
                LOGGER.info("If this is not the case, recovery will resume at password \"" + ESC_BOLD + theResumeVerbose + ESC_RESET + "\"...");
                LOGGER.printSeparator();
                LOGGER.info("Don't forget to mail me a success story to <steiner@refcodes.org>! :-)");
            } else {
                System.out.println("Your password might be \"" + ESC_ATTENTION + theCrackZip.getPassword() + ESC_RESET + "\" (excluding the surrounding quotes), found in <" + (System.currentTimeMillis() - startTime) / 1000L + "> seconds!");
                if (aOutputDir != null) {
                    System.out.println("ZIP (*.zip) content written to: <" + aOutputDir.getAbsolutePath() + ">");
                }
                System.out.println("If this is not the case, recovery will resume at password \"" + ESC_BOLD + theResumeVerbose + ESC_RESET + "\"...");
                System.out.println("Don't forget to mail me a success story to <steiner@refcodes.org>! :-)");
            }
        } else if (aAlphabetCounterComposite.hasNext()) {
            aProperties.putArray(RESUMEFROM_PROPERTY, aAlphabetCounterComposite.toAlphabetExpressions());
            aProperties.flush();
            if (isVerbose) {
                LOGGER.printSeparator();
                LOGGER.info("No success yet, last probed password number <" + ePasswordCount + "> is \"" + ESC_BOLD + theResumeVerbose + ESC_RESET + "\" (excluding the surrounding quotes)...");
                LOGGER.printSeparator();
                LOGGER.info("Recovery will resume at password \"" + theResumeVerbose + "\"...");
            } else {
                System.out.println("No success yet, last probed password number <" + ePasswordCount + "> is \"" + ESC_BOLD + theResumeVerbose + ESC_RESET + "\" (excluding the surrounding quotes)...");
                System.out.println("Recovery will resume at password \"" + theResumeVerbose + "\"...");
            }
        } else {
            aProperties.putArray(RESUMEFROM_PROPERTY, aAlphabetCounterComposite.toAlphabetExpressions());
            aProperties.flush();
            if (isVerbose) {
                LOGGER.printSeparator();
                LOGGER.info("No success after probing all passwords, last probed password number <" + ePasswordCount + "> was \"" + ESC_BOLD + theResumeVerbose + ESC_RESET + "\" (excluding the surrounding quotes)...");
            } else {
                System.out.println("No success after probing all passwords, last probed password number <" + ePasswordCount + "> was \"" + ESC_BOLD + theResumeVerbose + ESC_RESET + "\" (excluding the surrounding quotes)...");
            }
        }
    }

    private static AlphabetCounterMetrics toAlphabetCounterMetrics(String aStartValue, int aMinLength, int aMaxLength, String aAlphabet, CharSet theCharSet) {
        if (aAlphabet == null && theCharSet == null) {
            theCharSet = DEFAULT_CHARSET;
        }
        ArrayList<Character> theChars = new ArrayList<Character>();
        if (aAlphabet != null && aAlphabet.length() != 0) {
            for (int i = 0; i < aAlphabet.length(); ++i) {
                if (theChars.contains(Character.valueOf(aAlphabet.charAt(i)))) continue;
                theChars.add(Character.valueOf(aAlphabet.charAt(i)));
            }
        }
        if (theCharSet != null) {
            for (char eChar : theCharSet.getCharSet()) {
                if (theChars.contains(Character.valueOf(eChar))) continue;
                theChars.add(Character.valueOf(eChar));
            }
        }
        if (theChars.isEmpty()) {
            throw new IllegalStateException("Either the <alphabet> or the <charSet> arguments (properties) must be set!");
        }
        Collections.sort(theChars);
        char[] theAlphabet = new char[theChars.size()];
        for (int i = 0; i < theAlphabet.length; ++i) {
            theAlphabet[i] = ((Character)theChars.get(i)).charValue();
        }
        return new AlphabetCounterMetrics(aStartValue, aMinLength, aMaxLength, theAlphabet);
    }

    private static File toProjectFile(String aProjectFilePath, boolean isVerbose) {
        File theProjectFile = new File(aProjectFilePath);
        if (isVerbose) {
            LOGGER.info("Project file = \"" + theProjectFile.getAbsolutePath() + "\"");
        }
        return theProjectFile;
    }

    private static File toZipFile(String aInFilePath, boolean isVerbose) throws FileNotFoundException {
        File theZipFile = new File(aInFilePath);
        if (isVerbose) {
            LOGGER.info("ZIP file = \"" + theZipFile.getAbsolutePath() + "\"");
        }
        if (!theZipFile.exists() || !theZipFile.isFile()) {
            throw new FileNotFoundException("No input file \"" + aInFilePath + "\" (<" + theZipFile.getAbsolutePath() + ">) found!");
        }
        return theZipFile;
    }

    private static void init(String aProjectFilePath, boolean isVerbose) {
        File theProjectFile = Main.toProjectFile(aProjectFilePath, false);
        if (theProjectFile.isFile() && theProjectFile.delete()) {
            if (isVerbose) {
                LOGGER.info("Deleted project file \"" + aProjectFilePath + "\" (<" + theProjectFile.getAbsolutePath() + ">).");
            }
        } else {
            if (isVerbose) {
                LOGGER.warn("No such project file \"" + aProjectFilePath + "\" (<" + theProjectFile.getAbsolutePath() + ">), aborting!");
            } else {
                System.err.println("No such project file \"" + aProjectFilePath + "\" (<" + theProjectFile.getAbsolutePath() + ">), aborting!");
            }
            System.exit(ExitCode.NOT_FOUND.getStatusCode());
        }
    }

    private static void info(String aZipFilePath, boolean isVerbose) throws IOException {
        try (ZipFile theZipFile = new ZipFile(Main.toZipFile(aZipFilePath, isVerbose));){
            boolean isValidZip = theZipFile.isValidZipFile();
            boolean isEncrypted = theZipFile.isEncrypted();
            boolean isSplitArchive = theZipFile.isSplitArchive();
            String theComment = theZipFile.getComment();
            if (isVerbose) {
                LOGGER.printSeparator();
                LOGGER.info("Is valid ZIP (*.zip) file = " + isValidZip);
                LOGGER.info("Is encrypted = " + isEncrypted);
                LOGGER.info("Is split archive = " + isSplitArchive);
                LOGGER.info("ZIP (*.zip) file comment = \"" + theComment + "\"");
            } else {
                System.out.println("Is valid ZIP (*.zip) file = " + isValidZip);
                System.out.println("Is encrypted = " + isEncrypted);
                System.out.println("Is split archive = " + isSplitArchive);
                System.out.println("ZIP (*.zip) file comment = \"" + theComment + "\"");
            }
            List<FileHeader> theHeaders = theZipFile.getFileHeaders();
            if (isVerbose) {
                LOGGER.printSeparator();
            }
            for (FileHeader eHeader : theHeaders) {
                if (isVerbose) {
                    LOGGER.info(eHeader.getFileName() + " (" + eHeader.getUncompressedSize() + " bytes)");
                    continue;
                }
                System.out.println(eHeader.getFileName() + " (" + eHeader.getUncompressedSize() + " bytes)");
            }
            if (isVerbose) {
                LOGGER.printSeparator();
                LOGGER.info("ZIP (*.zip) file contains a total of <" + theHeaders.size() + "> files.");
            } else {
                System.out.println("ZIP (*.zip) file contains a total of <" + theHeaders.size() + "> files.");
            }
            if (isVerbose) {
                LOGGER.printSeparator();
                LOGGER.info("Available hardware threads = " + Runtime.getRuntime().availableProcessors());
            } else {
                System.out.println("Available hardware threads = " + Runtime.getRuntime().availableProcessors());
            }
        }
    }
}

