/*
 * Decompiled with CFR 0.152.
 */
package club.funcodes.crackzip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import java.util.zip.DataFormatException;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.inputstream.ZipInputStream;
import net.lingala.zip4j.model.LocalFileHeader;
import org.refcodes.component.StopException;
import org.refcodes.component.Stoppable;
import org.refcodes.controlflow.ControlFlowUtility;
import org.refcodes.exception.ExceptionAccessor;
import org.refcodes.generator.BufferedGenerator;
import org.refcodes.generator.IdCounter;
import org.refcodes.generator.ThreadLocalBufferedGeneratorDecorator;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;

public class CrackZip
implements Stoppable.StopAutomaton,
ExceptionAccessor<Exception> {
    private static final RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private static final long GC_INTERVALL_MS = 3600000L;
    private final int _priority;
    private final Thread[] _threads;
    private final CrackZipFile[] _runnables;
    private final BufferedGenerator<String> _passwordCounter;
    private final AtomicLong _counter = new AtomicLong(0L);
    private final Pattern _yesRegex;
    private final Pattern _noRegex;
    private Exception _exception = null;
    private String _password = null;
    private String _lastProcessed = null;
    private boolean _isRunning = false;
    private static long _lastGarbageCollectionTime = System.currentTimeMillis();

    public CrackZip(File aZipFile, File aOutputDir, IdCounter aAlphabetCounter, Pattern aYesPattern, Pattern aNoPattern, int aThreads, int aPriority, boolean isNoCache) throws IOException {
        this._threads = new Thread[aThreads];
        this._runnables = new CrackZipFile[aThreads];
        this._priority = aPriority;
        this._yesRegex = aYesPattern;
        this._noRegex = aNoPattern;
        try (ZipFile theZipFile = new ZipFile(aZipFile);){
            if (!theZipFile.isEncrypted()) {
                throw new IllegalArgumentException("Noting to do as the provided file <" + aZipFile.getAbsolutePath() + "> is not encrypted!");
            }
        }
        this._passwordCounter = new ThreadLocalBufferedGeneratorDecorator<String>(aAlphabetCounter);
        ByteArrayOutputStream theZipBufferStream = null;
        if (!isNoCache) {
            theZipBufferStream = new ByteArrayOutputStream((int)aZipFile.length());
            try (FileInputStream theInStream = new FileInputStream(aZipFile);){
                ((InputStream)theInStream).transferTo(theZipBufferStream);
            }
        }
        this._isRunning = true;
        for (int i = 0; i < this._threads.length; ++i) {
            this._runnables[i] = new CrackZipFile(aZipFile, theZipBufferStream != null ? new ByteArrayInputStream(theZipBufferStream.toByteArray()) : null, aOutputDir);
            this._threads[i] = new Thread(this._runnables[i]);
            this._threads[i].setDaemon(false);
            this._threads[i].setPriority(this._priority);
            this._threads[i].start();
        }
    }

    public long getProbedPasswordsCount() {
        return this._counter.get();
    }

    @Override
    public Exception getException() {
        return this._exception;
    }

    @Override
    public synchronized void stop() throws StopException {
        if (!this._isRunning) {
            throw new StopException("This instance has not being started prior to stopping it!");
        }
        this._isRunning = false;
        this._passwordCounter.suspend();
        ControlFlowUtility.joinThreads(this._threads);
    }

    public String getPassword() {
        return this._password;
    }

    public String lastProcessed() {
        return this._lastProcessed;
    }

    @Override
    public boolean isStoppable() {
        return this._isRunning;
    }

    @Override
    public boolean isStopped() {
        for (CrackZipFile _runnable : this._runnables) {
            if (!_runnable.isRunning()) continue;
            return false;
        }
        return true;
    }

    private static LocalFileHeader toFileHeader(ZipInputStream eZipInStream) throws IOException {
        LocalFileHeader eNextEntry = eZipInStream.getNextEntry();
        while (eNextEntry != null && (eNextEntry.isDirectory() || eNextEntry.getUncompressedSize() == 0L)) {
            eNextEntry = eZipInStream.getNextEntry();
        }
        return eNextEntry;
    }

    class CrackZipFile
    implements Runnable {
        private final File _zipFile;
        private final InputStream _zipInStream;
        private final File _outputDir;
        private boolean _isRunning = false;

        CrackZipFile(File aZipFile, InputStream aZipInStream, File aOutputDir) {
            this._zipFile = aZipFile;
            this._zipInStream = aZipInStream;
            this._outputDir = aOutputDir;
            if (this._zipInStream != null) {
                this._zipInStream.mark((int)aZipFile.length());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            this._isRunning = true;
            InputStream eInStream = this._zipInStream;
            try {
                while (CrackZip.this._passwordCounter.hasNext()) {
                    block30: {
                        String eNext = (String)CrackZip.this._passwordCounter.next();
                        CrackZip.this._counter.incrementAndGet();
                        CrackZip.this._lastProcessed = eNext;
                        if (CrackZip.this._yesRegex != null && !CrackZip.this._yesRegex.matcher(eNext).matches() || CrackZip.this._noRegex != null && CrackZip.this._noRegex.matcher(eNext).matches()) continue;
                        if (this._zipInStream != null) {
                            this._zipInStream.reset();
                        } else {
                            eInStream = new FileInputStream(this._zipFile);
                        }
                        try (ZipInputStream eZipInStream2 = new ZipInputStream(eInStream);){
                            eZipInStream2.setPassword(eNext.toCharArray());
                            LocalFileHeader eNextEntry = CrackZip.toFileHeader(eZipInStream2);
                            if (eNextEntry == null) break block30;
                            int i = 0;
                            while ((long)i < eNextEntry.getUncompressedSize()) {
                                while (eZipInStream2.read() != -1) {
                                }
                                ++i;
                            }
                            CrackZip.this._password = eNext;
                            CrackZip.this._isRunning = false;
                            CrackZip.this._passwordCounter.suspend();
                            if (this._outputDir != null) {
                                try (ZipFile theZipFile = new ZipFile(this._zipFile);){
                                    theZipFile.setPassword(eNext.toCharArray());
                                    theZipFile.extractAll(this._outputDir.getAbsolutePath());
                                }
                            }
                            CrackZip crackZip = CrackZip.this;
                            // MONITORENTER : crackZip
                            CrackZip.this.notifyAll();
                            // MONITOREXIT : crackZip
                        }
                        catch (ZipException eZipInStream2) {
                        }
                        catch (IOException e) {
                            if (e.getCause() == null) throw e;
                            if (e.getCause() instanceof DataFormatException) break block30;
                            throw e;
                        }
                    }
                    if (_lastGarbageCollectionTime + 3600000L >= System.currentTimeMillis()) continue;
                    Class<CrackZipFile> e = CrackZipFile.class;
                    // MONITORENTER : club.funcodes.crackzip.CrackZip$CrackZipFile.class
                    if (_lastGarbageCollectionTime + 3600000L < System.currentTimeMillis()) {
                        if (LOGGER.isLogInfo()) {
                            LOGGER.printSeparator();
                            LOGGER.info("Executing garbage collection (GC)...");
                            LOGGER.printSeparator();
                        }
                        System.gc();
                        _lastGarbageCollectionTime = System.currentTimeMillis();
                    }
                    // MONITOREXIT : e
                }
                return;
            }
            catch (IOException e) {
                CrackZip.this._exception = e;
                CrackZip.this._isRunning = false;
                CrackZip.this._passwordCounter.suspend();
                return;
            }
            finally {
                this._isRunning = false;
            }
        }

        public boolean isRunning() {
            return this._isRunning;
        }
    }
}

