/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.time;

import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.refcodes.time.DateFormat;
import org.refcodes.time.DateUtility;

public enum DateFormats {
    DEFAULT_DATE_FORMATS(new DateTimeFormatter[]{DateFormat.NORM_DATE_FORMAT.getFormatter(), DateFormat.MIN_DATE_FORMAT.getFormatter(), DateFormat.ALTERNATE_DATE_FORMAT.getFormatter(), DateFormat.DE_DATE_FORMAT.getFormatter(), DateFormat.NETSCAPE_COOKIE_DATE_FORMAT.getFormatter()}),
    DEFAULT_DATE_FORMATS_SHORT(new DateTimeFormatter[]{DateFormat.MIN_DATE_FORMAT.getFormatter(), DateFormat.NORM_DATE_FORMAT.getFormatter(), DateFormat.ALTERNATE_DATE_FORMAT.getFormatter(), DateFormat.DE_DATE_FORMAT.getFormatter()}),
    COOKIE_DATE_FORMATS(new DateTimeFormatter[]{DateFormat.RFC_1123_DATE_TIME_ALIKE.getFormatter(), DateTimeFormatter.RFC_1123_DATE_TIME, DateFormat.NETSCAPE_COOKIE_DATE_FORMAT.getFormatter(), DateFormat.ALTERNATE_COOKIE_DATE_FORMAT.getFormatter()}),
    INTERNET_DATE_FORMATS(new DateTimeFormatter[]{DateFormat.ISO_ZONED_DATE_TIME.getFormatter(), DateFormat.ISO_OFFSET_DATE_TIME.getFormatter(), DateFormat.RFC_1123_DATE_TIME_ALIKE.getFormatter(), DateTimeFormatter.RFC_1123_DATE_TIME, DateFormat.NETSCAPE_COOKIE_DATE_FORMAT.getFormatter(), DateFormat.ALTERNATE_COOKIE_DATE_FORMAT.getFormatter()}),
    ISO_DATE_FORMATS(new DateTimeFormatter[]{DateFormat.ISO_8601_ZULU_TIME.getFormatter(), DateFormat.ISO_LOCAL_DATE.getFormatter(), DateFormat.ISO_LOCAL_DATE_TIME.getFormatter(), DateFormat.ISO_OFFSET_DATE_TIME.getFormatter(), DateFormat.ISO_ZONED_DATE_TIME.getFormatter()});

    private DateTimeFormatter[] _dateFormats;

    private DateFormats(DateTimeFormatter[] aDateFormats) {
        this._dateFormats = aDateFormats;
    }

    public DateTimeFormatter[] getDateFormats() {
        return this._dateFormats;
    }

    public Date toDate(String aDateString) {
        return DateUtility.toDate(aDateString, this.getDateFormats());
    }

    public LocalDate toLocalDate(String aDateString) {
        return DateUtility.toLocalDate(aDateString, this.getDateFormats());
    }

    public LocalDateTime toLocalDateTime(String aDateString) {
        return DateUtility.toLocalDateTime(aDateString, this.getDateFormats());
    }

    public static Date asDate(String aDateString) {
        DateTimeException theFirstException = null;
        for (DateFormats eDateFormats : DateFormats.values()) {
            try {
                return eDateFormats.toDate(aDateString);
            }
            catch (DateTimeException e) {
                if (theFirstException == null) continue;
                theFirstException = e;
            }
        }
        if (theFirstException != null) {
            throw theFirstException;
        }
        throw new DateTimeException("Unable to parse date for date string <" + aDateString + ">.");
    }

    public static LocalDate asLocalDate(String aDateString) {
        DateTimeException theFirstException = null;
        for (DateFormats eDateFormats : DateFormats.values()) {
            try {
                return eDateFormats.toLocalDate(aDateString);
            }
            catch (DateTimeException e) {
                if (theFirstException == null) continue;
                theFirstException = e;
            }
        }
        if (theFirstException != null) {
            throw theFirstException;
        }
        throw new DateTimeException("Unable to parse date for date string <" + aDateString + ">.");
    }

    public static LocalDateTime asLocalDateTime(String aDateString) {
        DateTimeException theFirstException = null;
        for (DateFormats eDateFormats : DateFormats.values()) {
            try {
                return eDateFormats.toLocalDateTime(aDateString);
            }
            catch (DateTimeException e) {
                if (theFirstException == null) continue;
                theFirstException = e;
            }
        }
        if (theFirstException != null) {
            throw theFirstException;
        }
        throw new DateTimeException("Unable to parse date for date string <" + aDateString + ">.");
    }
}

