/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.tabular;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.refcodes.tabular.Header;
import org.refcodes.tabular.Row;
import org.refcodes.tabular.Rows;
import org.refcodes.textual.CsvBuilder;
import org.refcodes.textual.CsvEscapeMode;

public class RowsImpl<T>
implements Rows<T>,
Cloneable {
    private final Header<T> _header;
    private final Iterator<Row<T>> _rows;

    @SafeVarargs
    public RowsImpl(Header<T> aHeader, Row<T> ... aRows) {
        ArrayList<Row<T>> theRows = new ArrayList<Row<T>>();
        for (Row<T> eRow : aRows) {
            if (!aHeader.isEqualWith(eRow)) {
                throw new IllegalArgumentException("Row <" + new CsvBuilder().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{eRow}).toRecord() + "> mismatch with header <" + new CsvBuilder().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{aHeader}).toRecord() + ">.");
            }
            theRows.add(eRow);
        }
        this._header = aHeader;
        this._rows = theRows.iterator();
    }

    public RowsImpl(Header<T> aHeader, Collection<Row<T>> aRows) {
        for (Row<T> eRow : aRows) {
            if (aHeader.isEqualWith(eRow)) continue;
            throw new IllegalArgumentException("Row <" + new CsvBuilder().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{eRow}).toRecord() + "> mismatch with header <" + new CsvBuilder().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{aHeader}).toRecord() + ">.");
        }
        this._header = aHeader;
        this._rows = aRows.iterator();
    }

    @Override
    public Header<T> getHeader() {
        return this._header;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public boolean hasNext() {
        return this._rows.hasNext();
    }

    @Override
    public Row<T> next() {
        return this._rows.next();
    }

    @Override
    public void remove() {
        this._rows.remove();
    }
}

