/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.tabular;

import java.lang.reflect.Array;
import org.refcodes.tabular.Column;
import org.refcodes.tabular.ColumnMismatchException;
import org.refcodes.tabular.HeaderMismatchException;
import org.refcodes.tabular.HeaderRow;
import org.refcodes.tabular.Record;
import org.refcodes.tabular.RecordImpl;
import org.refcodes.tabular.Row;

public interface Header<T>
extends HeaderRow<T, Column<? extends T>> {
    default public T get(Row<T> aRow, String aKey) throws HeaderMismatchException, ColumnMismatchException {
        return aRow.get(this, aKey);
    }

    default public String[] toKeys() {
        return this.keySet().toArray(new String[this.size()]);
    }

    default public T[] toValues(Record<T> aRecord) {
        Object[] theValues = null;
        Class<T> theType = this.toType();
        if (theType != null) {
            theValues = (Object[])Array.newInstance(theType, this.size());
            for (int i = 0; i < this.size(); ++i) {
                String eKey = (String)((Column)this.get(i)).getKey();
                theValues[i] = aRecord.get(eKey);
            }
        }
        return theValues;
    }

    default public Class<T> toType() {
        Class theType = null;
        for (Column eColumn : this) {
            Class eType = eColumn.getType();
            if (theType != null && !eType.isAssignableFrom(theType)) continue;
            theType = eType;
        }
        return theType;
    }

    default public boolean isSubsetOf(Record<?> aRecord) {
        if (this.size() < aRecord.size()) {
            return false;
        }
        Column eColumn = null;
        Object eValue = null;
        for (String eKey : aRecord.keySet()) {
            if (!this.containsKey(eKey)) {
                return false;
            }
            eColumn = (Column)this.get(eKey);
            eValue = aRecord.get(eKey);
            if (eColumn.getType().isAssignableFrom(eValue.getClass())) continue;
            return false;
        }
        return true;
    }

    default public boolean isEqualWith(Record<?> aRecord) {
        if (this.size() != aRecord.size()) {
            return false;
        }
        Column eColumn = null;
        Object eValue = null;
        for (String eKey : aRecord.keySet()) {
            if (!this.containsKey(eKey)) {
                return false;
            }
            eColumn = (Column)this.get(eKey);
            eValue = aRecord.get(eKey);
            if (eColumn.getType().isAssignableFrom(eValue.getClass())) continue;
            return false;
        }
        return true;
    }

    default public boolean isSupersetOf(Record<?> aRecord) {
        if (this.size() > aRecord.size()) {
            return false;
        }
        Object eValue = null;
        Column eColumn = null;
        for (String eKey : this.keySet()) {
            if (!aRecord.containsKey(eKey)) {
                return false;
            }
            eColumn = (Column)this.get(eKey);
            eValue = aRecord.get(eKey);
            if (eColumn.getType().isAssignableFrom(eValue.getClass())) continue;
            return false;
        }
        return true;
    }

    default public boolean isSubsetOf(Row<?> aRow) {
        if (this.size() < aRow.size()) {
            return false;
        }
        int theIndex = 0;
        Column eColumn = null;
        for (Object eValue : aRow) {
            eColumn = (Column)this.get(theIndex);
            if (!eColumn.getType().isAssignableFrom(eValue.getClass())) {
                return false;
            }
            ++theIndex;
        }
        return true;
    }

    default public boolean isEqualWith(Row<?> aRow) {
        if (this.size() != aRow.size()) {
            return false;
        }
        int theIndex = 0;
        for (Object eValue : aRow) {
            Column eColumn = (Column)this.get(theIndex);
            if (!eColumn.getType().isAssignableFrom(eValue.getClass())) {
                return false;
            }
            ++theIndex;
        }
        return true;
    }

    default public boolean isSupersetOf(Row<?> aRow) {
        if (this.size() > aRow.size()) {
            return false;
        }
        int theIndex = 0;
        Object eValue = null;
        for (Column eColumn : this) {
            eValue = aRow.get(theIndex);
            if (!eColumn.getType().isAssignableFrom(eValue.getClass())) {
                return false;
            }
            ++theIndex;
        }
        return true;
    }

    default public <REC> Record<REC> toIntersection(Record<REC> aRecord) throws ColumnMismatchException {
        RecordImpl theRecord = new RecordImpl();
        for (Column eColumn : this) {
            if (!eColumn.contains(aRecord)) continue;
            Object eValue = eColumn.get(aRecord);
            theRecord.put((String)eColumn.getKey(), eValue);
        }
        return theRecord;
    }

    default public <REC> Record<REC> toSubset(Record<REC> aRecord) throws ColumnMismatchException {
        RecordImpl theRecord = new RecordImpl();
        for (Column eColumn : this) {
            Object eValue = null;
            if (eColumn.contains(aRecord)) {
                eValue = eColumn.get(aRecord);
            }
            theRecord.put((String)eColumn.getKey(), eValue);
        }
        return theRecord;
    }
}

