/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.struct.ext.factory;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import org.refcodes.exception.MarshalException;
import org.refcodes.exception.UnmarshalException;
import org.refcodes.struct.CanonicalTable;
import org.refcodes.struct.ImmutableCanonicalTable;
import org.refcodes.struct.ImmutablePathTable;
import org.refcodes.struct.MapCanonicalTable;
import org.refcodes.struct.ext.factory.AbstractCanonicalTableFactory;
import org.refcodes.struct.ext.factory.DocumentOptions;

public class YamlCanonicalTableFactory
extends AbstractCanonicalTableFactory {
    public static final char COMMENT = '#';

    @Override
    public CanonicalTable fromMarshaled(InputStream aMarshaled, DocumentOptions aOptions) throws UnmarshalException {
        char theDelimiter = aOptions != null ? aOptions.getDelimiterOr(ImmutablePathTable.DELIMITER) : ImmutablePathTable.DELIMITER;
        ObjectMapper theMapper = new ObjectMapper(new YAMLFactory());
        theMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            Map<Object, Object> theProperties = theMapper.readValue(aMarshaled, new TypeReference<Map<Object, Object>>(this){});
            MapCanonicalTable theResult = new MapCanonicalTable(theProperties, theDelimiter);
            this.postProcess(theResult);
            return theResult;
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new UnmarshalException("Unable to unmarshal the external representation from stream <" + String.valueOf(aMarshaled) + "> at column <" + e.getLocation().getColumnNr() + ">!", e);
        }
        catch (Exception e) {
            throw new UnmarshalException("Unable to unmarshal the external representation from stream <" + String.valueOf(aMarshaled) + ">!", e);
        }
    }

    @Override
    public String toMarshaled(ImmutableCanonicalTable aUnmarshaled, DocumentOptions aOptions) throws MarshalException {
        ObjectMapper theMapper = new ObjectMapper(new YAMLFactory());
        theMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Object theDataStructure = aUnmarshaled.toDataStructure();
        try {
            String theYaml = theMapper.writerWithDefaultPrettyPrinter().writeValueAsString(theDataStructure);
            Object theHead = "";
            String theComment = aOptions.getComment();
            if (theComment != null && theComment.length() > 0) {
                String[] theLines;
                for (String eLine : theLines = theComment.split("\\r?\\n")) {
                    theHead = (String)theHead + "# " + eLine + System.lineSeparator();
                }
            }
            return (String)theHead + theYaml;
        }
        catch (JsonProcessingException e) {
            throw new MarshalException("A problem occurred marshaling an object of type <" + ImmutableCanonicalTable.class.getName() + ">.", e);
        }
    }

    @Override
    public InputStream fromUnmarshaled(ImmutableCanonicalTable aUnmarshaled, DocumentOptions aOptions) throws MarshalException {
        String theMarshaled = this.toMarshaled(aUnmarshaled, aOptions);
        ByteArrayInputStream theMarshalledStream = new ByteArrayInputStream(theMarshaled.getBytes());
        return theMarshalledStream;
    }
}

