/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.struct.ext.factory;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.Map;
import org.refcodes.exception.MarshalException;
import org.refcodes.exception.UnmarshalException;
import org.refcodes.struct.CanonicalTable;
import org.refcodes.struct.ImmutableCanonicalTable;
import org.refcodes.struct.ImmutablePathTable;
import org.refcodes.struct.MapCanonicalTable;
import org.refcodes.struct.ext.factory.AbstractCanonicalTableFactory;
import org.refcodes.struct.ext.factory.DocumentOptions;

public class JsonCanonicalTableFactory
extends AbstractCanonicalTableFactory {
    private static final String JSON_TEXT_VALUE = "#text";

    @Override
    public CanonicalTable fromMarshaled(InputStream aMarshaled, DocumentOptions aOptions) throws UnmarshalException {
        char theDelimiter = aOptions != null ? aOptions.getDelimiterOr(ImmutablePathTable.DELIMITER) : ImmutablePathTable.DELIMITER;
        ObjectMapper theMapper = new ObjectMapper();
        theMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            Map<Object, Object> theProperties = theMapper.readValue(aMarshaled, new TypeReference<Map<Object, Object>>(this){});
            MapCanonicalTable theResult = new MapCanonicalTable(theProperties, theDelimiter);
            this.postProcess(theResult);
            return theResult;
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new UnmarshalException("Unable to unmarshal the external representation from stream <" + String.valueOf(aMarshaled) + "> at column <" + e.getLocation().getColumnNr() + ">!", e);
        }
        catch (Exception e) {
            throw new UnmarshalException("Unable to unmarshal the external representation from stream <" + String.valueOf(aMarshaled) + ">!", e);
        }
    }

    @Override
    public String toMarshaled(ImmutableCanonicalTable aUnmarshaled, DocumentOptions aOptions) throws MarshalException {
        ObjectMapper theMapper = new ObjectMapper();
        theMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Object theDataStructure = aUnmarshaled.toDataStructure();
        try {
            String theJson = theMapper.writerWithDefaultPrettyPrinter().writeValueAsString(theDataStructure);
            return theJson + System.lineSeparator();
        }
        catch (IOException e) {
            throw new MarshalException("A problem occurred marshaling an object of type <" + ImmutableCanonicalTable.class.getName() + ">.", e);
        }
    }

    @Override
    public InputStream fromUnmarshaled(ImmutableCanonicalTable aUnmarshaled, DocumentOptions aOptions) throws MarshalException {
        ObjectMapper theMapper = new ObjectMapper();
        theMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Object theDataStructure = aUnmarshaled.toDataStructure();
        try {
            PipedOutputStream theOut = new PipedOutputStream();
            PipedInputStream theIn = new PipedInputStream(theOut);
            theMapper.writerWithDefaultPrettyPrinter().writeValue(theOut, theDataStructure);
            return theIn;
        }
        catch (Exception e) {
            throw new MarshalException("A problem occurred marshaling an object of type <" + ImmutableCanonicalTable.class.getName() + ">.", e);
        }
    }

    @Override
    protected void postProcess(CanonicalTable aProperties) {
        String theSuffix = aProperties.getDelimiter() + JSON_TEXT_VALUE;
        for (String eKey : new ArrayList(aProperties.keySet())) {
            String eValue;
            String eToPath;
            if (!eKey.endsWith(theSuffix) || aProperties.isLeaf(eToPath = eKey.substring(0, eKey.length() - theSuffix.length())) || (eValue = (String)aProperties.remove((Object)eKey)) == null) continue;
            aProperties.put(eToPath, eValue);
        }
        super.postProcess(aProperties);
    }
}

