/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.struct.ext.factory;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Set;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.ParseSettings;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;
import org.refcodes.data.Encoding;
import org.refcodes.exception.MarshalException;
import org.refcodes.exception.UnmarshalException;
import org.refcodes.struct.CanonicalTable;
import org.refcodes.struct.ImmutableCanonicalTable;
import org.refcodes.struct.ImmutablePathTable;
import org.refcodes.struct.MapCanonicalTable;
import org.refcodes.struct.ext.factory.AbstractCanonicalTableFactory;
import org.refcodes.struct.ext.factory.DocumentOptions;
import org.refcodes.struct.ext.factory.XmlCanonicalTableFactory;

public class HtmlCanonicalTableFactory
extends AbstractCanonicalTableFactory {
    public static final String BODY = "body";
    public static final String HEAD = "head";
    public static final String HTML = "html";
    public static final String[] ROOT_SELECTOR = new String[]{"html", "body"};
    public static final String COMMENT_OPEN = "<!--";
    public static final String COMMENT_CLOSE = "-->";

    @Override
    public CanonicalTable fromMarshaled(InputStream aMarshaled, DocumentOptions aOptions) throws UnmarshalException {
        try {
            char theDelimiter = aOptions != null ? aOptions.getDelimiterOr(ImmutablePathTable.DELIMITER) : ImmutablePathTable.DELIMITER;
            String theEncoding = aOptions != null ? aOptions.getEncodingOr(Encoding.UTF_8.getCode()) : Encoding.UTF_8.getCode();
            String theBaseUri = aOptions != null ? aOptions.getBaseUrlOr("") : "";
            MapCanonicalTable theCanonicalMap = new MapCanonicalTable(theDelimiter);
            Parser theParser = Parser.htmlParser();
            theParser.settings(new ParseSettings(true, true));
            Document theDocument = Jsoup.parse(aMarshaled, theEncoding, theBaseUri, theParser);
            Elements theElements = theDocument.children();
            this.visitElements(theCanonicalMap, theElements, theCanonicalMap.getRootPath(), theDelimiter);
            this.postProcess(theCanonicalMap);
            return theCanonicalMap;
        }
        catch (Exception e) {
            throw new UnmarshalException("Unable to unmarshal the external representation from input stream <" + String.valueOf(aMarshaled) + ">!", e);
        }
    }

    @Override
    public CanonicalTable toUnmarshaled(String aMarshaled, DocumentOptions aOptions) throws UnmarshalException {
        try {
            char theDelimiter = aOptions != null ? aOptions.getDelimiterOr(ImmutablePathTable.DELIMITER) : ImmutablePathTable.DELIMITER;
            String theBaseUri = aOptions != null ? aOptions.getBaseUrlOr("") : "";
            MapCanonicalTable theCanonicalMap = new MapCanonicalTable(theDelimiter);
            Parser theParser = Parser.htmlParser();
            theParser.settings(new ParseSettings(true, true));
            Document doc = Jsoup.parse(aMarshaled, theBaseUri, theParser);
            Elements theElements = doc.children();
            this.visitElements(theCanonicalMap, theElements, theCanonicalMap.getRootPath(), theDelimiter);
            this.postProcess(theCanonicalMap);
            return theCanonicalMap;
        }
        catch (Exception e) {
            throw new UnmarshalException("Unable to unmarshal the external representation \"" + aMarshaled + "\"!", e);
        }
    }

    @Override
    public String toMarshaled(ImmutableCanonicalTable aUnmarshaled, DocumentOptions aOptions) throws MarshalException {
        String theComment;
        boolean isWellFormedHtml;
        block5: {
            String theRoot;
            isWellFormedHtml = false;
            Set<String> eDirs = aUnmarshaled.dirs();
            Set<String> eLeaves = aUnmarshaled.leaves();
            if (eDirs.size() == 1 && eLeaves.size() == 0 && HTML.equalsIgnoreCase(theRoot = eDirs.iterator().next()) && (eDirs = aUnmarshaled.children(theRoot)).size() >= 1 && eDirs.size() <= 2) {
                for (String eDir : eDirs) {
                    if (HEAD.equalsIgnoreCase(eDir) || BODY.equalsIgnoreCase(eDir)) continue;
                    break block5;
                }
                isWellFormedHtml = true;
            }
        }
        if (!isWellFormedHtml) {
            aUnmarshaled = aUnmarshaled.retrieveTo(ROOT_SELECTOR);
        }
        boolean hasArrayIndex = aOptions != null ? aOptions.hasArrayIndexOr(false) : false;
        String theXml = XmlCanonicalTableFactory.toXml(aUnmarshaled, hasArrayIndex);
        Object theHead = "";
        String string = theComment = aOptions != null ? aOptions.getComment() : null;
        if (theComment != null && theComment.length() > 0) {
            String[] theLines;
            for (String eLine : theLines = theComment.split("\\r?\\n")) {
                theHead = (String)theHead + "<!-- " + eLine + " -->" + System.lineSeparator();
            }
        }
        return (String)theHead + theXml;
    }

    @Override
    public InputStream fromUnmarshaled(ImmutableCanonicalTable aUnmarshaled, DocumentOptions aOptions) throws MarshalException {
        String theMarshaled = this.toMarshaled(aUnmarshaled, aOptions);
        ByteArrayInputStream theMarshalledStream = new ByteArrayInputStream(theMarshaled.getBytes());
        return theMarshalledStream;
    }

    private void visitElements(CanonicalTable aCanonicalTable, Elements elements, String aPath, char aDelimiter) {
        for (Element eElement : elements) {
            String ePath = aCanonicalTable.toPath(aPath, eElement.nodeName());
            int next = this.toAttributeIndex(eElement.attributes());
            String eValue = null;
            if (eElement.hasText()) {
                eValue = eElement.ownText();
            }
            if ((eValue == null || eValue.isEmpty()) && eElement.val() != null && eElement.val().length() != 0) {
                eValue = eElement.val();
            }
            if ((eValue == null || eValue.isEmpty()) && eElement.data() != null && eElement.data().length() != 0) {
                eValue = eElement.data();
            }
            if (eValue != null && eValue.trim().isEmpty()) {
                eValue = null;
            }
            if (eValue != null) {
                if (next != -1) {
                    aCanonicalTable.putValueAt(ePath, next, eValue);
                } else if (aCanonicalTable.isArray(ePath)) {
                    next = aCanonicalTable.nextArrayIndex(ePath);
                    aCanonicalTable.putValueAt(ePath, next, eValue);
                } else if (aCanonicalTable.containsKey((Object)ePath)) {
                    aCanonicalTable.putValueAt(ePath, 1, eValue);
                    eValue = (String)aCanonicalTable.remove((Object)ePath);
                    aCanonicalTable.putValueAt(ePath, 0, eValue);
                } else {
                    aCanonicalTable.put(ePath, eValue);
                }
            }
            if (next != -1) {
                ePath = aCanonicalTable.toPath(ePath, next);
            }
            this.visitAttributes(aCanonicalTable, eElement.attributes(), ePath);
            this.visitElements(aCanonicalTable, eElement.children(), ePath, aDelimiter);
        }
    }

    private int toAttributeIndex(Attributes aAttribs) {
        int index = -1;
        if (aAttribs != null) {
            try {
                for (Attribute eAttrib : aAttribs) {
                    if (!"index".equals(eAttrib.getKey())) continue;
                    return Integer.parseInt(eAttrib.getValue());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    private void visitAttributes(CanonicalTable aCanonicalTable, Attributes aAttribs, String aPath) {
        for (Attribute eAttrib : aAttribs) {
            if ("index".equals(eAttrib.getKey())) continue;
            aCanonicalTable.put(new String[]{aPath, ImmutablePathTable.ANNOTATOR + eAttrib.getKey()}, eAttrib.getValue());
        }
    }
}

