/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.struct;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.refcodes.data.Wildcard;
import org.refcodes.struct.ClassStructTable;
import org.refcodes.struct.ImmutablePathTable;
import org.refcodes.struct.MapClassStructTable;
import org.refcodes.struct.Property;
import org.refcodes.struct.Relation;
import org.refcodes.struct.SimpleType;
import org.refcodes.struct.TypeModeAccessor;

public interface ImmutableClassStructTable
extends ImmutablePathTable<Class<?>>,
TypeModeAccessor {
    public static final String ARRAY_SELECTOR = Wildcard.FILE.getValue();

    @Override
    default public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    default public ClassStructTable getDirAt(int aIndex) {
        return this.getDirAt(this.getRootPath(), aIndex);
    }

    default public ClassStructTable getDirAt(Collection<?> aPathElements, int aIndex) {
        return this.getDirAt(this.toPath(aPathElements), aIndex);
    }

    default public ClassStructTable getDirAt(Object aPath, int aIndex) {
        return this.getDirAt(this.toPath(aPath), aIndex);
    }

    default public ClassStructTable getDirAt(Object[] aPathElements, int aIndex) {
        return this.getDirAt(this.toPath(aPathElements), aIndex);
    }

    default public ClassStructTable getDirAt(String[] aPathElements, int aIndex) {
        return this.getDirAt(this.toPath(aPathElements), aIndex);
    }

    default public ClassStructTable getDirAt(String aPath, int aIndex) {
        return this.retrieveFrom(this.toPath(aPath, Integer.toString(aIndex)));
    }

    default public ClassStructTable query(Collection<?> aQueryElements) {
        return this.query(this.toPath(aQueryElements));
    }

    default public ClassStructTable query(Object ... aQueryElements) {
        return this.query(this.toPath(aQueryElements));
    }

    default public ClassStructTable query(Pattern aRegExp) {
        return new MapClassStructTable(ImmutablePathTable.super.query(aRegExp));
    }

    default public ClassStructTable query(String aPathQuery) {
        return new MapClassStructTable(ImmutablePathTable.super.query(aPathQuery));
    }

    default public ClassStructTable query(String ... aQueryElements) {
        return this.query(this.toPath(aQueryElements));
    }

    default public ClassStructTable queryBetween(Collection<?> aFromPath, Collection<?> aPathQuery, Collection<?> aToPath) {
        return this.queryBetween(this.toPath(aFromPath), this.toPath(aPathQuery), this.toPath(aToPath));
    }

    default public ClassStructTable queryBetween(Object aFromPath, Object aPathQuery, Object aToPath) {
        return this.queryBetween(this.toPath(aFromPath), this.toPath(aPathQuery), this.toPath(aToPath));
    }

    default public ClassStructTable queryBetween(Object[] aFromPath, Object[] aPathQuery, Object[] aToPath) {
        return this.queryBetween(this.toPath(aFromPath), this.toPath(aPathQuery), this.toPath(aToPath));
    }

    default public ClassStructTable queryBetween(String aFromPath, Pattern aRegExp, String aToPath) {
        return new MapClassStructTable(ImmutablePathTable.super.queryBetween(aFromPath, aRegExp, aToPath));
    }

    default public ClassStructTable queryBetween(String aFromPath, String aPathQuery, String aToPath) {
        return new MapClassStructTable(ImmutablePathTable.super.queryBetween(aFromPath, aPathQuery, aToPath));
    }

    default public ClassStructTable queryBetween(String[] aFromPath, String[] aPathQuery, String[] aToPath) {
        return this.queryBetween(this.toPath(aFromPath), this.toPath(aPathQuery), this.toPath(aToPath));
    }

    default public ClassStructTable queryFrom(Collection<?> aPathQuery, Collection<?> aFromPath) {
        return this.queryFrom(this.toPath(aPathQuery), this.toPath(aFromPath));
    }

    default public ClassStructTable queryFrom(Object aPathQuery, Object aFromPath) {
        return this.queryFrom(this.toPath(aPathQuery), this.toPath(aFromPath));
    }

    default public ClassStructTable queryFrom(Object[] aPathQuery, Object[] aFromPath) {
        return this.queryFrom(this.toPath(aPathQuery), this.toPath(aFromPath));
    }

    default public ClassStructTable queryFrom(Pattern aRegExp, String aFromPath) {
        return new MapClassStructTable(ImmutablePathTable.super.queryFrom(aRegExp, aFromPath));
    }

    default public ClassStructTable queryFrom(String aPathQuery, String aFromPath) {
        return new MapClassStructTable(ImmutablePathTable.super.queryFrom(aPathQuery, aFromPath));
    }

    default public ClassStructTable queryFrom(String[] aPathQuery, String[] aFromPath) {
        return this.queryFrom(this.toPath(aPathQuery), this.toPath(aFromPath));
    }

    default public ClassStructTable queryTo(Collection<?> aPathQuery, String aToPath) {
        return this.queryTo(this.toPath(aPathQuery), this.toPath((Object)aToPath));
    }

    default public ClassStructTable queryTo(Object aPathQuery, String aToPath) {
        return this.queryTo(this.toPath(aPathQuery), this.toPath((Object)aToPath));
    }

    default public ClassStructTable queryTo(Object[] aPathQuery, String aToPath) {
        return this.queryTo(this.toPath(aPathQuery), this.toPath((Object)aToPath));
    }

    default public ClassStructTable queryTo(Pattern aRegExp, String aToPath) {
        return new MapClassStructTable(ImmutablePathTable.super.queryTo(aRegExp, aToPath));
    }

    default public ClassStructTable queryTo(String aPathQuery, String aToPath) {
        return new MapClassStructTable(ImmutablePathTable.super.queryTo(aPathQuery, aToPath));
    }

    default public ClassStructTable queryTo(String[] aPathQuery, String aToPath) {
        return this.queryTo(this.toPath(aPathQuery), this.toPath((Object)aToPath));
    }

    default public ClassStructTable retrieveBetween(Collection<?> aFromPath, Collection<?> aToPath) {
        return this.retrieveBetween(this.toPath(aFromPath), this.toPath(aToPath));
    }

    default public ClassStructTable retrieveBetween(Object aFromPath, Object aToPath) {
        return this.retrieveBetween(this.toPath(aFromPath), this.toPath(aToPath));
    }

    default public ClassStructTable retrieveBetween(Object[] aFromPath, Object[] aToPath) {
        return this.retrieveBetween(this.toPath(aFromPath), this.toPath(aToPath));
    }

    default public ClassStructTable retrieveBetween(String aFromPath, String aToPath) {
        ClassStructTable thePathMap = this.retrieveFrom(aFromPath);
        return thePathMap.retrieveTo(aToPath);
    }

    default public ClassStructTable retrieveBetween(String[] aFromPath, String[] aToPath) {
        return this.retrieveBetween(this.toPath(aFromPath), this.toPath(aToPath));
    }

    default public ClassStructTable retrieveFrom(Collection<?> aPathElements) {
        return this.retrieveFrom(this.toPath(aPathElements));
    }

    default public ClassStructTable retrieveFrom(Object aParentPath) {
        return this.retrieveFrom(this.toPath(aParentPath));
    }

    default public ClassStructTable retrieveFrom(Object ... aPathElements) {
        return this.retrieveFrom(this.toPath(aPathElements));
    }

    public ClassStructTable retrieveFrom(String var1);

    default public ClassStructTable retrieveFrom(String ... aPathElements) {
        return this.retrieveFrom(this.toPath(aPathElements));
    }

    default public ClassStructTable getDir(Collection<?> aPathElements) {
        return this.getDir(this.toPath(aPathElements));
    }

    default public ClassStructTable getDir(Object aPath) {
        return this.getDir(this.toPath(aPath));
    }

    default public ClassStructTable getDir(Object ... aPathElements) {
        return this.getDir(this.toPath(aPathElements));
    }

    default public ClassStructTable getDir(String aPath) {
        return this.retrieveFrom(aPath);
    }

    default public ClassStructTable getDir(String ... aPathElements) {
        return this.getDir(this.toPath(aPathElements));
    }

    default public ClassStructTable[] getDirs(Collection<?> aPathElements) {
        return this.getDirs(this.toPath(aPathElements));
    }

    default public ClassStructTable[] getDirs(Object aPath) {
        return this.getDirs(this.toPath(aPath));
    }

    default public ClassStructTable[] getDirs(Object ... aPathElements) {
        return this.getDirs(this.toPath(aPathElements));
    }

    default public ClassStructTable[] getDirs(String aPath) {
        ClassStructTable[] theDirs;
        if (this.isIndexDir(aPath)) {
            int[] theIndexes = this.getDirIndexes(aPath);
            theDirs = new ClassStructTable[theIndexes[theIndexes.length - 1] + 1];
            for (int i : theIndexes) {
                theDirs[theIndexes[i]] = this.getDirAt(aPath, theIndexes[i]);
            }
        } else {
            theDirs = new ClassStructTable[]{this.getDir(aPath)};
        }
        return theDirs;
    }

    default public ClassStructTable[] getDirs(String ... aPathElements) {
        return this.getDirs(this.toPath(aPathElements));
    }

    default public ClassStructTable retrieveTo(Collection<?> aToPathElements) {
        return this.retrieveTo(this.toPath(aToPathElements));
    }

    default public ClassStructTable retrieveTo(Object aToPath) {
        return this.retrieveTo(this.toPath(aToPath));
    }

    default public ClassStructTable retrieveTo(Object ... aToPathElements) {
        return this.retrieveTo(this.toPath(aToPathElements));
    }

    public ClassStructTable retrieveTo(String var1);

    default public ClassStructTable retrieveTo(String ... aToPathElements) {
        return this.retrieveTo(this.toPath(aToPathElements));
    }

    @Override
    default public Map<String, Class<?>> toMap() {
        HashMap theProperties = new HashMap();
        for (String eKey : this.keySet()) {
            theProperties.put(eKey, (Class)this.get((Object)eKey));
        }
        return theProperties;
    }

    default public Properties toProperties() {
        Properties theProperties = new Properties();
        for (String eKey : this.keySet()) {
            theProperties.put(this.toPropertyPath(eKey), this.get((Object)eKey));
        }
        return theProperties;
    }

    default public String getArraySelector() {
        return ARRAY_SELECTOR;
    }

    default public boolean isArrayType() {
        return this.isArrayType(this.getRootPath());
    }

    default public boolean isArrayType(String ... aPathElements) {
        return this.isArrayType(this.toPath(aPathElements));
    }

    default public boolean isArrayType(Collection<?> aPathElements) {
        return this.isArrayType(this.toPath(aPathElements));
    }

    default public boolean isArrayType(Object aPath) {
        return this.isArrayType(this.toPath(aPath));
    }

    default public boolean isArrayType(Object ... aPathElements) {
        return this.isArrayType(this.toPath(aPathElements));
    }

    default public boolean isArrayType(String aPath) {
        return this.isSimpleArrayType(aPath) || this.isCompositeArrayDir(aPath);
    }

    default public boolean isSimpleArrayType() {
        return this.isSimpleArrayType(this.getRootPath());
    }

    default public boolean isSimpleArrayType(Object aPath) {
        return this.isSimpleArrayType(this.toPath(aPath));
    }

    default public boolean isSimpleArrayType(Object ... aPathElements) {
        return this.isSimpleArrayType(this.toPath(aPathElements));
    }

    default public boolean isSimpleArrayType(String ... aPathElements) {
        return this.isSimpleArrayType(this.toPath(aPathElements));
    }

    default public boolean isSimpleArrayType(Collection<?> aPathElements) {
        return this.isSimpleArrayType(this.toPath(aPathElements));
    }

    default public boolean isSimpleArrayType(String aPath) {
        Class theClass = (Class)this.get((Object)(aPath = this.toNormalizedPath(aPath)));
        if (theClass != null && theClass.isArray() && SimpleType.isSimpleArrayType(theClass = theClass.getComponentType())) {
            return true;
        }
        theClass = (Class)this.get((Object)(aPath.endsWith(this.getDelimiter() + this.getArraySelector()) ? aPath : this.toPath(aPath, this.getArraySelector())));
        return theClass != null && SimpleType.isSimpleType(theClass);
    }

    default public Class<?> getSimpleArrayType() {
        return this.getSimpleArrayType(this.getRootPath());
    }

    default public Class<?> getSimpleArrayType(Object aPath) {
        return this.getSimpleArrayType(this.toPath(aPath));
    }

    default public Class<?> getSimpleArrayType(Object ... aPathElements) {
        return this.getSimpleArrayType(this.toPath(aPathElements));
    }

    default public Class<?> getSimpleArrayType(String ... aPathElements) {
        return this.getSimpleArrayType(this.toPath(aPathElements));
    }

    default public Class<?> getSimpleArrayType(Collection<?> aPathElements) {
        return this.getSimpleArrayType(this.toPath(aPathElements));
    }

    default public Class<?> getSimpleArrayType(String aPath) {
        Class theClass = (Class)this.get((Object)(aPath = this.toNormalizedPath(aPath)));
        if (theClass != null && theClass.isArray() && SimpleType.isSimpleArrayType(theClass = theClass.getComponentType())) {
            return theClass;
        }
        theClass = (Class)this.get((Object)(aPath.endsWith(this.getDelimiter() + this.getArraySelector()) ? aPath : this.toPath(aPath, this.getArraySelector())));
        if (theClass != null && SimpleType.isSimpleType(theClass)) {
            return theClass;
        }
        throw new IllegalArgumentException("The provided path <" + aPath + "> does not direct to a simple array type!");
    }

    default public boolean isSimpleType() {
        return this.isSimpleType(this.getRootPath());
    }

    default public boolean isSimpleType(Object aPath) {
        return this.isSimpleType(this.toPath(aPath));
    }

    default public boolean isSimpleType(Object ... aPathElements) {
        return this.isSimpleType(this.toPath(aPathElements));
    }

    default public boolean isSimpleType(String ... aPathElements) {
        return this.isSimpleType(this.toPath(aPathElements));
    }

    default public boolean isSimpleType(Collection<?> aPathElements) {
        return this.isSimpleType(this.toPath(aPathElements));
    }

    default public boolean isSimpleType(String aPath) {
        Class theClass;
        if (!this.isSimpleArrayType() && (theClass = (Class)this.get((Object)(aPath = this.toNormalizedPath(aPath)))) != null) {
            return SimpleType.isSimpleType(theClass);
        }
        return false;
    }

    default public Class<?> getSimpleType() {
        return this.getSimpleArrayType(this.getRootPath());
    }

    default public Class<?> getSimpleType(Object aPath) {
        return this.getSimpleArrayType(this.toPath(aPath));
    }

    default public Class<?> getSimpleType(Object ... aPathElements) {
        return this.getSimpleArrayType(this.toPath(aPathElements));
    }

    default public Class<?> getSimpleType(String ... aPathElements) {
        return this.getSimpleArrayType(this.toPath(aPathElements));
    }

    default public Class<?> getSimpleType(Collection<?> aPathElements) {
        return this.getSimpleArrayType(this.toPath(aPathElements));
    }

    default public Class<?> getSimpleType(String aPath) {
        Class theClass = (Class)this.get((Object)(aPath = this.toNormalizedPath(aPath)));
        return SimpleType.isSimpleType(theClass) ? theClass : null;
    }

    default public boolean isPrimitiveArrayType() {
        return this.isPrimitiveArrayType(this.getRootPath());
    }

    default public boolean isPrimitiveArrayType(Object aPath) {
        return this.isPrimitiveArrayType(this.toPath(aPath));
    }

    default public boolean isPrimitiveArrayType(Object ... aPathElements) {
        return this.isPrimitiveArrayType(this.toPath(aPathElements));
    }

    default public boolean isPrimitiveArrayType(String ... aPathElements) {
        return this.isPrimitiveArrayType(this.toPath(aPathElements));
    }

    default public boolean isPrimitiveArrayType(Collection<?> aPathElements) {
        return this.isPrimitiveArrayType(this.toPath(aPathElements));
    }

    default public boolean isPrimitiveArrayType(String aPath) {
        Class theClass = (Class)this.get((Object)(aPath = this.toNormalizedPath(aPath)));
        if (theClass != null && theClass.isArray() && SimpleType.isPrimitiveArrayType(theClass = theClass.getComponentType())) {
            return true;
        }
        theClass = (Class)this.get((Object)(aPath.endsWith(this.getDelimiter() + this.getArraySelector()) ? aPath : this.toPath(aPath, this.getArraySelector())));
        return theClass != null && SimpleType.isPrimitiveType(theClass);
    }

    default public Class<?> getPrimitiveArrayType() {
        return this.getPrimitiveArrayType(this.getRootPath());
    }

    default public Class<?> getPrimitiveArrayType(Object aPath) {
        return this.getPrimitiveArrayType(this.toPath(aPath));
    }

    default public Class<?> getPrimitiveArrayType(Object ... aPathElements) {
        return this.getPrimitiveArrayType(this.toPath(aPathElements));
    }

    default public Class<?> getPrimitiveArrayType(String ... aPathElements) {
        return this.getPrimitiveArrayType(this.toPath(aPathElements));
    }

    default public Class<?> getPrimitiveArrayType(Collection<?> aPathElements) {
        return this.getPrimitiveArrayType(this.toPath(aPathElements));
    }

    default public Class<?> getPrimitiveArrayType(String aPath) {
        Class theClass = (Class)this.get((Object)(aPath = this.toNormalizedPath(aPath)));
        if (theClass != null && theClass.isArray() && SimpleType.isPrimitiveArrayType(theClass = theClass.getComponentType())) {
            return theClass;
        }
        theClass = (Class)this.get((Object)(aPath.endsWith(this.getDelimiter() + this.getArraySelector()) ? aPath : this.toPath(aPath, this.getArraySelector())));
        if (theClass != null && SimpleType.isPrimitiveType(theClass)) {
            return theClass;
        }
        throw new IllegalArgumentException("The provided path <" + aPath + "> does not direct to a primitive array type!");
    }

    default public boolean isPrimitiveType() {
        return this.isPrimitiveType(this.getRootPath());
    }

    default public boolean isPrimitiveType(Object aPath) {
        return this.isPrimitiveType(this.toPath(aPath));
    }

    default public boolean isPrimitiveType(Object ... aPathElements) {
        return this.isPrimitiveType(this.toPath(aPathElements));
    }

    default public boolean isPrimitiveType(String ... aPathElements) {
        return this.isPrimitiveType(this.toPath(aPathElements));
    }

    default public boolean isPrimitiveType(Collection<?> aPathElements) {
        return this.isPrimitiveType(this.toPath(aPathElements));
    }

    default public boolean isPrimitiveType(String aPath) {
        Class theClass;
        if (!this.isPrimitiveArrayType() && (theClass = (Class)this.get((Object)(aPath = this.toNormalizedPath(aPath)))) != null) {
            return SimpleType.isPrimitiveType(theClass);
        }
        return false;
    }

    default public Class<?> getPrimitiveType() {
        return this.getPrimitiveArrayType(this.getRootPath());
    }

    default public Class<?> getPrimitiveType(Object aPath) {
        return this.getPrimitiveArrayType(this.toPath(aPath));
    }

    default public Class<?> getPrimitiveType(Object ... aPathElements) {
        return this.getPrimitiveArrayType(this.toPath(aPathElements));
    }

    default public Class<?> getPrimitiveType(String ... aPathElements) {
        return this.getPrimitiveArrayType(this.toPath(aPathElements));
    }

    default public Class<?> getPrimitiveType(Collection<?> aPathElements) {
        return this.getPrimitiveArrayType(this.toPath(aPathElements));
    }

    default public Class<?> getPrimitiveType(String aPath) {
        Class theClass = (Class)this.get((Object)(aPath = this.toNormalizedPath(aPath)));
        return SimpleType.isPrimitiveType(theClass) ? theClass : null;
    }

    default public boolean isWrapperArrayType() {
        return this.isWrapperArrayType(this.getRootPath());
    }

    default public boolean isWrapperArrayType(Object aPath) {
        return this.isWrapperArrayType(this.toPath(aPath));
    }

    default public boolean isWrapperArrayType(Object ... aPathElements) {
        return this.isWrapperArrayType(this.toPath(aPathElements));
    }

    default public boolean isWrapperArrayType(String ... aPathElements) {
        return this.isWrapperArrayType(this.toPath(aPathElements));
    }

    default public boolean isWrapperArrayType(Collection<?> aPathElements) {
        return this.isWrapperArrayType(this.toPath(aPathElements));
    }

    default public boolean isWrapperArrayType(String aPath) {
        Class theClass = (Class)this.get((Object)(aPath = this.toNormalizedPath(aPath)));
        if (theClass != null && theClass.isArray() && SimpleType.isWrapperArrayType(theClass = theClass.getComponentType())) {
            return true;
        }
        theClass = (Class)this.get((Object)(aPath.endsWith(this.getDelimiter() + this.getArraySelector()) ? aPath : this.toPath(aPath, this.getArraySelector())));
        return theClass != null && SimpleType.isWrapperType(theClass);
    }

    default public Class<?> getWrapperArrayType() {
        return this.getWrapperArrayType(this.getRootPath());
    }

    default public Class<?> getWrapperArrayType(Object aPath) {
        return this.getWrapperArrayType(this.toPath(aPath));
    }

    default public Class<?> getWrapperArrayType(Object ... aPathElements) {
        return this.getWrapperArrayType(this.toPath(aPathElements));
    }

    default public Class<?> getWrapperArrayType(String ... aPathElements) {
        return this.getWrapperArrayType(this.toPath(aPathElements));
    }

    default public Class<?> getWrapperArrayType(Collection<?> aPathElements) {
        return this.getWrapperArrayType(this.toPath(aPathElements));
    }

    default public Class<?> getWrapperArrayType(String aPath) {
        Class theClass = (Class)this.get((Object)(aPath = this.toNormalizedPath(aPath)));
        if (theClass != null && theClass.isArray() && SimpleType.isWrapperArrayType(theClass = theClass.getComponentType())) {
            return theClass;
        }
        theClass = (Class)this.get((Object)(aPath.endsWith(this.getDelimiter() + this.getArraySelector()) ? aPath : this.toPath(aPath, this.getArraySelector())));
        if (theClass != null && SimpleType.isWrapperType(theClass)) {
            return theClass;
        }
        throw new IllegalArgumentException("The provided path <" + aPath + "> does not direct to a wrapper array type!");
    }

    default public boolean isWrapperType() {
        return this.isWrapperType(this.getRootPath());
    }

    default public boolean isWrapperType(Object aPath) {
        return this.isWrapperType(this.toPath(aPath));
    }

    default public boolean isWrapperType(Object ... aPathElements) {
        return this.isWrapperType(this.toPath(aPathElements));
    }

    default public boolean isWrapperType(String ... aPathElements) {
        return this.isWrapperType(this.toPath(aPathElements));
    }

    default public boolean isWrapperType(Collection<?> aPathElements) {
        return this.isWrapperType(this.toPath(aPathElements));
    }

    default public boolean isWrapperType(String aPath) {
        Class theClass;
        if (!this.isWrapperArrayType() && (theClass = (Class)this.get((Object)(aPath = this.toNormalizedPath(aPath)))) != null) {
            return SimpleType.isWrapperType(theClass);
        }
        return false;
    }

    default public Class<?> getWrapperType() {
        return this.getWrapperArrayType(this.getRootPath());
    }

    default public Class<?> getWrapperType(Object aPath) {
        return this.getWrapperArrayType(this.toPath(aPath));
    }

    default public Class<?> getWrapperType(Object ... aPathElements) {
        return this.getWrapperArrayType(this.toPath(aPathElements));
    }

    default public Class<?> getWrapperType(String ... aPathElements) {
        return this.getWrapperArrayType(this.toPath(aPathElements));
    }

    default public Class<?> getWrapperType(Collection<?> aPathElements) {
        return this.getWrapperArrayType(this.toPath(aPathElements));
    }

    default public Class<?> getWrapperType(String aPath) {
        Class theClass = (Class)this.get((Object)(aPath = this.toNormalizedPath(aPath)));
        return SimpleType.isWrapperType(theClass) ? theClass : null;
    }

    default public boolean isCompositeArrayDir() {
        return this.isCompositeArrayDir(this.getRootPath());
    }

    default public boolean isCompositeArrayDir(Object aPath) {
        return this.isCompositeArrayDir(this.toPath(aPath));
    }

    default public boolean isCompositeArrayDir(Object ... aPathElements) {
        return this.isCompositeArrayDir(this.toPath(aPathElements));
    }

    default public boolean isCompositeArrayDir(String ... aPathElements) {
        return this.isCompositeArrayDir(this.toPath(aPathElements));
    }

    default public boolean isCompositeArrayDir(Collection<?> aPathElements) {
        return this.isCompositeArrayDir(this.toPath(aPathElements));
    }

    default public boolean isCompositeArrayDir(String aPath) {
        return this.isDir((aPath = this.toNormalizedPath(aPath)).endsWith(this.getDelimiter() + this.getArraySelector()) ? aPath : this.toPath(aPath, this.getArraySelector()));
    }

    default public ClassStructTable getCompositeArrayDir() {
        return this.getCompositeArrayDir(this.getRootPath());
    }

    default public ClassStructTable getCompositeArrayDir(Object aPath) {
        return this.getCompositeArrayDir(this.toPath(aPath));
    }

    default public ClassStructTable getCompositeArrayDir(Object ... aPathElements) {
        return this.getCompositeArrayDir(this.toPath(aPathElements));
    }

    default public ClassStructTable getCompositeArrayDir(String ... aPathElements) {
        return this.getCompositeArrayDir(this.toPath(aPathElements));
    }

    default public ClassStructTable getCompositeArrayDir(Collection<?> aPathElements) {
        return this.getCompositeArrayDir(this.toPath(aPathElements));
    }

    default public ClassStructTable getCompositeArrayDir(String aPath) {
        if (this.isCompositeArrayDir(aPath = this.toNormalizedPath(aPath))) {
            return this.retrieveFrom(aPath.endsWith(this.getDelimiter() + this.getArraySelector()) ? aPath : this.toPath(aPath, this.getArraySelector()));
        }
        return null;
    }

    default public boolean isCompositeDir() {
        return this.isCompositeDir(this.getRootPath());
    }

    default public boolean isCompositeDir(Object aPath) {
        return this.isCompositeDir(this.toPath(aPath));
    }

    default public boolean isCompositeDir(Object ... aPathElements) {
        return this.isCompositeDir(this.toPath(aPathElements));
    }

    default public boolean isCompositeDir(String ... aPathElements) {
        return this.isCompositeDir(this.toPath(aPathElements));
    }

    default public boolean isCompositeDir(Collection<?> aPathElements) {
        return this.isCompositeDir(this.toPath(aPathElements));
    }

    default public boolean isCompositeDir(String aPath) {
        return this.isDir(aPath = this.toNormalizedPath(aPath)) && !this.isCompositeArrayDir() && !this.isSimpleType(aPath);
    }

    default public ClassStructTable getCompositeDir() {
        return this.getCompositeDir(this.getRootPath());
    }

    default public ClassStructTable getCompositeDir(Object aPath) {
        return this.getCompositeDir(this.toPath(aPath));
    }

    default public ClassStructTable getCompositeDir(Object ... aPathElements) {
        return this.getCompositeDir(this.toPath(aPathElements));
    }

    default public ClassStructTable getCompositeDir(String ... aPathElements) {
        return this.getCompositeDir(this.toPath(aPathElements));
    }

    default public ClassStructTable getCompositeDir(Collection<?> aPathElements) {
        return this.getCompositeDir(this.toPath(aPathElements));
    }

    default public ClassStructTable getCompositeDir(String aPath) {
        return this.isCompositeDir(aPath = this.toNormalizedPath(aPath)) ? this.retrieveFrom(aPath) : null;
    }

    public static interface MutableClassStructTable
    extends ImmutableClassStructTable,
    ImmutablePathTable.MutablePathTable<Class<?>>,
    Map<String, Class<?>> {
        @Override
        default public boolean containsValue(Object value) {
            return this.values().contains(value);
        }

        default public void insert(ImmutableClassStructTable aFrom) {
            this.insert((Object)aFrom);
        }

        default public void insertBetween(String aToPath, ImmutableClassStructTable aFrom, String aFromPath) {
            this.insertBetween(aToPath, (Object)aFrom, aFromPath);
        }

        default public void insertFrom(ImmutableClassStructTable aFrom, String aFromPath) {
            this.insertFrom((Object)aFrom, aFromPath);
        }

        default public void insertTo(String aToPath, ImmutableClassStructTable aFrom) {
            this.insertTo(aToPath, (Object)aFrom);
        }

        @Override
        default public String put(Object aKey, String aValue) {
            return this.put(aKey instanceof String ? (String)aKey : (aKey != null ? aKey.toString() : (String)null), aValue);
        }

        @Override
        default public Class<?> put(Object[] aPathElements, Class<?> aValue) {
            return this.put(this.toPath(aPathElements), aValue);
        }

        default public String put(Property aProperty) {
            return this.put(aProperty.getKey(), (String)aProperty.getValue());
        }

        @Override
        default public Class<?> put(Relation<String, Class<?>> aRelation) {
            return this.put((String)aRelation.getKey(), (Class)aRelation.getValue());
        }

        @Override
        default public Class<?> put(String[] aPathElements, Class<?> aValue) {
            return this.put(this.toPath(aPathElements), aValue);
        }

        default public void putAll(ImmutableClassStructTable aProperties) {
            for (Object eKey : aProperties.keySet()) {
                this.put((String)eKey, (Class)this.get((Object)((String)eKey)));
            }
        }

        default public void putAll(Properties aProperties) {
            for (Object eKey : aProperties.keySet()) {
                this.put((String)eKey, (Class)this.get((Object)((String)eKey)));
            }
        }

        @Override
        default public void putAll(Map<? extends String, ? extends Class<?>> aProperties) {
            for (String string : aProperties.keySet()) {
                this.put(string, (Class)this.get((Object)string));
            }
        }

        default public ClassStructTable putDirAt(Collection<?> aPathElements, int aIndex, Object aDir) {
            return this.putDirAt(this.toPath(aPathElements), aIndex, aDir);
        }

        default public ClassStructTable putDirAt(Collection<?> aPathElements, int aIndex, ImmutablePathTable<Class<?>> aDir) {
            return this.putDirAt(this.toPath(aPathElements), aIndex, (ImmutablePathTable)aDir);
        }

        default public ClassStructTable putDirAt(int aIndex, Object aDir) {
            return this.putDirAt(this.getRootPath(), aIndex, aDir);
        }

        default public ClassStructTable putDirAt(int aIndex, ImmutablePathTable<Class<?>> aDir) {
            return this.putDirAt(this.getRootPath(), aIndex, (ImmutablePathTable)aDir);
        }

        default public ClassStructTable putDirAt(Object aPath, int aIndex, Object aDir) {
            return this.putDirAt(this.toPath(aPath), aIndex, aDir);
        }

        default public ClassStructTable putDirAt(Object aPath, int aIndex, ImmutablePathTable<Class<?>> aDir) {
            return this.putDirAt(this.toPath(aPath), aIndex, (ImmutablePathTable)aDir);
        }

        default public ClassStructTable putDirAt(Object[] aPathElements, int aIndex, Object aDir) {
            return this.putDirAt(this.toPath(aPathElements), aIndex, aDir);
        }

        default public ClassStructTable putDirAt(Object[] aPathElements, int aIndex, ImmutablePathTable<Class<?>> aDir) {
            return this.putDirAt(this.toPath(aPathElements), aIndex, (ImmutablePathTable)aDir);
        }

        default public ClassStructTable putDirAt(String aPath, int aIndex, Object aDir) {
            ClassStructTable theReplaced = this.removeDirAt(aPath, aIndex);
            this.insertTo(this.toPath(aPath, aIndex), aDir);
            return theReplaced;
        }

        default public ClassStructTable putDirAt(String aPath, int aIndex, ImmutablePathTable<Class<?>> aDir) {
            ClassStructTable theReplaced = this.removeDirAt(aPath, aIndex);
            this.insertTo(this.toPath(aPath, aIndex), aDir);
            return theReplaced;
        }

        default public ClassStructTable putDirAt(String[] aPathElements, int aIndex, Object aDir) {
            return this.putDirAt(this.toPath(aPathElements), aIndex, aDir);
        }

        default public ClassStructTable putDirAt(String[] aPathElements, int aIndex, ImmutablePathTable<Class<?>> aDir) {
            return this.putDirAt(this.toPath(aPathElements), aIndex, (ImmutablePathTable)aDir);
        }

        default public ClassStructTable removeAll(Collection<?> aPathQueryElements) {
            return new MapClassStructTable(ImmutablePathTable.MutablePathTable.super.removeAll(aPathQueryElements));
        }

        default public ClassStructTable removeAll(Object ... aPathQueryElements) {
            return new MapClassStructTable(ImmutablePathTable.MutablePathTable.super.removeAll(aPathQueryElements));
        }

        default public ClassStructTable removeAll(Object aPathQuery) {
            return new MapClassStructTable(ImmutablePathTable.MutablePathTable.super.removeAll(aPathQuery));
        }

        default public ClassStructTable removeAll(Pattern aRegExp) {
            return new MapClassStructTable(ImmutablePathTable.MutablePathTable.super.removeAll(aRegExp));
        }

        default public ClassStructTable removeAll(String ... aPathQueryElements) {
            return new MapClassStructTable(ImmutablePathTable.MutablePathTable.super.removeAll(aPathQueryElements));
        }

        default public ClassStructTable removeAll(String aPathQuery) {
            return new MapClassStructTable(ImmutablePathTable.MutablePathTable.super.removeAll(aPathQuery));
        }

        default public ClassStructTable removeDirAt(int aIndex) {
            return new MapClassStructTable(ImmutablePathTable.MutablePathTable.super.removeDirAt(aIndex));
        }

        default public ClassStructTable removeDirAt(Object aPath, int aIndex) {
            return new MapClassStructTable(ImmutablePathTable.MutablePathTable.super.removeDirAt(aPath, aIndex));
        }

        default public ClassStructTable removeDirAt(Object[] aPathElements, int aIndex) {
            return new MapClassStructTable(ImmutablePathTable.MutablePathTable.super.removeDirAt(aPathElements, aIndex));
        }

        default public ClassStructTable removeDirAt(String aPath, int aIndex) {
            return new MapClassStructTable(ImmutablePathTable.MutablePathTable.super.removeDirAt(aPath, aIndex));
        }

        default public ClassStructTable removeDirAt(String[] aPathElements, int aIndex) {
            return new MapClassStructTable(ImmutablePathTable.MutablePathTable.super.removeDirAt(aPathElements, aIndex));
        }

        default public ClassStructTable removeFrom(Collection<?> aPathElements) {
            return new MapClassStructTable(ImmutablePathTable.MutablePathTable.super.removeFrom(aPathElements));
        }

        default public ClassStructTable removeFrom(Object ... aPathElements) {
            return new MapClassStructTable(ImmutablePathTable.MutablePathTable.super.removeFrom(aPathElements));
        }

        default public ClassStructTable removeFrom(Object aPath) {
            return new MapClassStructTable(ImmutablePathTable.MutablePathTable.super.removeFrom(aPath));
        }

        default public ClassStructTable removeFrom(String aPath) {
            return new MapClassStructTable(ImmutablePathTable.MutablePathTable.super.removeFrom(aPath));
        }

        default public ClassStructTable removeFrom(String ... aPathElements) {
            return new MapClassStructTable(ImmutablePathTable.MutablePathTable.super.removeFrom(aPathElements));
        }

        default public ClassStructTable removePaths(Collection<?> aPaths) {
            return new MapClassStructTable(ImmutablePathTable.MutablePathTable.super.removePaths(aPaths));
        }

        default public ClassStructTable removePaths(String ... aPaths) {
            return new MapClassStructTable(ImmutablePathTable.MutablePathTable.super.removePaths(aPaths));
        }
    }
}

