/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.security.alt.chaos;

import java.io.UnsupportedEncodingException;
import org.refcodes.codec.BaseBuilder;
import org.refcodes.codec.BaseMetricsConfig;
import org.refcodes.data.Encoding;
import org.refcodes.security.DecryptEncodingException;
import org.refcodes.security.Decrypter;
import org.refcodes.security.DecryptionException;
import org.refcodes.security.alt.chaos.ChaosDecrypter;
import org.refcodes.security.alt.chaos.ChaosKey;

public class ChaosTextDecrypter
implements Decrypter<String, String, DecryptionException> {
    private ChaosDecrypter _chaosDecrypter;
    private final BaseBuilder _baseCodec = new BaseBuilder().withBaseMetrics(BaseMetricsConfig.BASE64);

    public ChaosTextDecrypter(ChaosKey aKey) {
        this._chaosDecrypter = new ChaosDecrypter(aKey);
    }

    @Override
    public String toDecrypted(String aEncrypted) throws DecryptionException {
        byte[] theInput = this._baseCodec.toDecodedData(aEncrypted);
        byte[] theOutput = new byte[theInput.length];
        this.toDecrypted(theInput, 0, theInput.length, theOutput, 0);
        try {
            return new String(theOutput, Encoding.UTF_8.getCode());
        }
        catch (UnsupportedEncodingException e) {
            throw new DecryptEncodingException("The required encoding <{0}> is not supported!", Encoding.UTF_8.getCode(), e);
        }
    }

    @Override
    public int toDecrypted(byte[] aInput, int aInputOffset, int aInputLength, byte[] aOutput, int aOutputOffset) throws DecryptionException {
        return this._chaosDecrypter.toDecrypted(aInput, aInputOffset, aInputLength, aOutput, aOutputOffset);
    }

    @Override
    public void dispose() {
        ChaosDecrypter theChaosDecrypter = this._chaosDecrypter;
        if (theChaosDecrypter != null) {
            try {
                theChaosDecrypter.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._chaosDecrypter = null;
        }
    }
}

