/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.security.alt.chaos;

import org.refcodes.numerical.NumericalUtility;
import org.refcodes.security.alt.chaos.ChaosOptions;

public class ChaosOptionsImpl
implements ChaosOptions {
    private boolean _isXorNext;
    private boolean _isMutateS;
    private boolean _isSalted;
    private short _rndPrefixSize;

    public ChaosOptionsImpl(byte[] aEncoded) {
        if (!NumericalUtility.isBitSetAt(aEncoded[0], 3) && Byte.toUnsignedInt(aEncoded[1]) != 0) {
            throw new IllegalArgumentException("The PREFIX option has been set to false though the prefix size is set to <" + Byte.toUnsignedInt(aEncoded[1]) + "> which is ambigous!");
        }
        this._isMutateS = NumericalUtility.isBitSetAt(aEncoded[0], 0);
        this._isXorNext = NumericalUtility.isBitSetAt(aEncoded[0], 1);
        this._isSalted = NumericalUtility.isBitSetAt(aEncoded[0], 2);
        this._rndPrefixSize = NumericalUtility.isBitSetAt(aEncoded[0], 3) ? (short)(Byte.toUnsignedInt(aEncoded[1]) + 1) : (short)0;
    }

    public ChaosOptionsImpl(boolean isMutateS, boolean isXorNext, boolean isSalted) {
        this._isMutateS = isMutateS;
        this._isXorNext = isXorNext;
        this._isSalted = isSalted;
        this._rndPrefixSize = 0;
    }

    public ChaosOptionsImpl(boolean isMutateS, boolean isXorNext, boolean isSalted, short aRndPrefixSize) {
        this._isMutateS = isMutateS;
        this._isXorNext = isXorNext;
        this._isSalted = isSalted;
        this._rndPrefixSize = aRndPrefixSize;
    }

    private ChaosOptionsImpl(Builder builder) {
        this._isMutateS = builder.isMutateS;
        this._isXorNext = builder.isXorNext;
        this._isSalted = builder.isSalted;
        this._rndPrefixSize = builder.rndPrefixSize;
    }

    @Override
    public boolean isXorNext() {
        return this._isXorNext;
    }

    @Override
    public boolean isMutateS() {
        return this._isMutateS;
    }

    @Override
    public boolean isSalted() {
        return this._isSalted;
    }

    @Override
    public short getRndPrefixSize() {
        return this._rndPrefixSize;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [isMutateS=" + this._isMutateS + ", isXorNext=" + this._isXorNext + ", ( isSalted=" + this._isSalted + " | hasRndPrefix=" + this.hasRndPrefix() + " [rndPrefixSize=" + this._rndPrefixSize + "]) := isFixedLength=" + this.isFixedLength() + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._isMutateS ? 1231 : 1237);
        result = 31 * result + (this._isSalted ? 1231 : 1237);
        result = 31 * result + (this._isXorNext ? 1231 : 1237);
        result = 31 * result + this._rndPrefixSize;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChaosOptions)) {
            return false;
        }
        ChaosOptions other = (ChaosOptions)obj;
        if (this._isMutateS != other.isMutateS()) {
            return false;
        }
        if (this._isSalted != other.isSalted()) {
            return false;
        }
        if (this._isXorNext != other.isXorNext()) {
            return false;
        }
        return this._rndPrefixSize == other.getRndPrefixSize();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private boolean isXorNext;
        private boolean isMutateS;
        private boolean isSalted;
        public short rndPrefixSize;

        private Builder() {
        }

        public Builder withXorNext(boolean isXorNext) {
            this.isXorNext = isXorNext;
            return this;
        }

        public Builder withMutateS(boolean isMutateS) {
            this.isMutateS = isMutateS;
            return this;
        }

        public Builder withSalted(boolean isSalted) {
            this.isSalted = isSalted;
            return this;
        }

        public Builder withRndPrefixSize(short aRndPrefixSize) {
            if (aRndPrefixSize < 1 || aRndPrefixSize > 256) {
                throw new IllegalArgumentException("The RND prefix size <" + aRndPrefixSize + "> is out of range, valid values range from {1..256} representable by one byte as of {0x00..0xFF}.");
            }
            this.rndPrefixSize = aRndPrefixSize;
            return this;
        }

        public ChaosOptionsImpl build() {
            return new ChaosOptionsImpl(this);
        }
    }
}

