/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.security.alt.chaos;

import org.refcodes.mixin.EncodedAccessor;
import org.refcodes.numerical.NumericalUtility;

public interface ChaosOptions
extends EncodedAccessor {
    public static final int OPTIONS_BIT_MUTATE_S = 0;
    public static final int OPTIONS_BIT_XOR_NEXT = 1;
    public static final int OPTIONS_BIT_SALTED = 2;
    public static final int OPTIONS_BIT_RND_PREFIX = 3;
    public static final int OPTIONS_BYTES = 1;
    public static final int PREFIX_SIZE_BYZES = 1;
    public static final int ENCODED_LENGTH = 2;

    public boolean isXorNext();

    public boolean isMutateS();

    public boolean isSalted();

    default public boolean hasRndPrefix() {
        return this.getRndPrefixSize() != 0;
    }

    public short getRndPrefixSize();

    default public boolean isFixedLength() {
        return !this.isSalted() & !this.hasRndPrefix();
    }

    @Override
    default public byte[] getEncoded() {
        byte[] theBytes = new byte[]{0, 0};
        theBytes[0] = NumericalUtility.setBitAt(theBytes[0], 0, this.isMutateS());
        theBytes[0] = NumericalUtility.setBitAt(theBytes[0], 1, this.isXorNext());
        theBytes[0] = NumericalUtility.setBitAt(theBytes[0], 2, this.isSalted());
        theBytes[0] = NumericalUtility.setBitAt(theBytes[0], 3, this.hasRndPrefix());
        theBytes[1] = this.hasRndPrefix() ? (byte)(this.getRndPrefixSize() - 1) : (byte)0;
        return theBytes;
    }

    public static int getEncodedLength() {
        return 2;
    }

    public boolean equals(Object var1);
}

