/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.refcodes.data.Delimiter;
import org.refcodes.data.Scheme;
import org.refcodes.exception.MarshalException;
import org.refcodes.exception.Trap;
import org.refcodes.exception.UnmarshalException;
import org.refcodes.properties.DocumentMetrics;
import org.refcodes.properties.DocumentNotation;
import org.refcodes.properties.ImmutableProperties;
import org.refcodes.properties.MapProperties;
import org.refcodes.properties.Properties;
import org.refcodes.properties.ReloadMode;
import org.refcodes.properties.ResourceProperties;
import org.refcodes.runtime.ConfigLocator;
import org.refcodes.runtime.Execution;
import org.refcodes.struct.CanonicalTable;
import org.refcodes.struct.ImmutablePathTable;
import org.refcodes.struct.Property;
import org.refcodes.struct.Relation;
import org.refcodes.struct.ext.factory.CanonicalTableFactory;
import org.refcodes.struct.ext.factory.DocumentOptions;

public abstract class AbstractResourceProperties
extends MapProperties
implements ResourceProperties {
    private static final long serialVersionUID = 1L;
    protected final DocumentMetrics _documentMetrics;
    protected File _propertiesFile;
    private CanonicalTableFactory _factory = null;

    protected AbstractResourceProperties() {
        this._documentMetrics = DocumentNotation.DEFAULT;
    }

    public AbstractResourceProperties(ImmutableProperties aProperties) {
        super(aProperties);
        this._documentMetrics = DocumentNotation.DEFAULT;
    }

    public AbstractResourceProperties(Map<?, ?> aProperties) {
        super(aProperties);
        this._documentMetrics = DocumentNotation.DEFAULT;
    }

    public AbstractResourceProperties(Map<?, ?> aProperties, DocumentMetrics aDocumentMetrics) {
        super(aProperties);
        this._documentMetrics = aDocumentMetrics;
    }

    public AbstractResourceProperties(Object aObj) {
        super(aObj);
        this._documentMetrics = DocumentNotation.DEFAULT;
    }

    public AbstractResourceProperties(Object aObj, DocumentMetrics aDocumentMetrics) {
        super(aObj);
        this._documentMetrics = aDocumentMetrics;
    }

    protected AbstractResourceProperties(DocumentMetrics aDocumentMetrics) {
        this._documentMetrics = aDocumentMetrics;
    }

    protected AbstractResourceProperties(Class<?> aResourceClass, String aFilePath) throws IOException, ParseException {
        this._documentMetrics = DocumentNotation.DEFAULT;
        this.loadFrom(aResourceClass, aFilePath);
    }

    protected AbstractResourceProperties(Class<?> aResourceClass, String aFilePath, DocumentMetrics aDocumentMetrics) throws IOException, ParseException {
        this._documentMetrics = aDocumentMetrics;
        this.loadFrom(aResourceClass, aFilePath);
    }

    protected AbstractResourceProperties(Class<?> aResourceClass, String aFilePath, ConfigLocator aConfigLocator) throws IOException, ParseException {
        this._documentMetrics = DocumentNotation.DEFAULT;
        this.seekFrom(aResourceClass, aFilePath, aConfigLocator);
    }

    protected AbstractResourceProperties(Class<?> aResourceClass, String aFilePath, ConfigLocator aConfigLocator, DocumentMetrics aDocumentMetrics) throws IOException, ParseException {
        this._documentMetrics = aDocumentMetrics;
        this.seekFrom(aResourceClass, aFilePath, aConfigLocator);
    }

    protected AbstractResourceProperties(File aFile) throws IOException, ParseException {
        this._documentMetrics = DocumentNotation.DEFAULT;
        this.loadFrom(aFile);
    }

    protected AbstractResourceProperties(File aFile, DocumentMetrics aDocumentMetrics) throws IOException, ParseException {
        this._documentMetrics = aDocumentMetrics;
        this.loadFrom(aFile);
    }

    protected AbstractResourceProperties(File aFile, ConfigLocator aConfigLocator) throws IOException, ParseException {
        this._documentMetrics = DocumentNotation.DEFAULT;
        this.seekFrom(aFile, aConfigLocator);
    }

    protected AbstractResourceProperties(File aFile, ConfigLocator aConfigLocator, DocumentMetrics aDocumentMetrics) throws IOException, ParseException {
        this._documentMetrics = aDocumentMetrics;
        this.seekFrom(aFile, aConfigLocator);
    }

    protected AbstractResourceProperties(InputStream aInputStream) throws IOException, ParseException {
        this._documentMetrics = DocumentNotation.DEFAULT;
        this.loadFrom(aInputStream);
    }

    protected AbstractResourceProperties(InputStream aInputStream, DocumentMetrics aDocumentMetrics) throws IOException, ParseException {
        this._documentMetrics = aDocumentMetrics;
        this.loadFrom(aInputStream);
    }

    protected AbstractResourceProperties(ImmutableProperties aProperties, DocumentMetrics aDocumentMetrics) {
        super(aProperties);
        this._documentMetrics = aDocumentMetrics;
    }

    protected AbstractResourceProperties(Properties aProperties, DocumentMetrics aDocumentMetrics) {
        super(aProperties);
        this._documentMetrics = aDocumentMetrics;
    }

    protected AbstractResourceProperties(String aFilePath, DocumentMetrics aDocumentMetrics) throws IOException, ParseException {
        this._documentMetrics = aDocumentMetrics;
        this.loadFrom(aFilePath);
    }

    protected AbstractResourceProperties(String aFilePath, ConfigLocator aConfigLocator) throws IOException, ParseException {
        this._documentMetrics = DocumentNotation.DEFAULT;
        this.seekFrom(aFilePath, aConfigLocator);
    }

    protected AbstractResourceProperties(String aFilePath, ConfigLocator aConfigLocator, DocumentMetrics aDocumentMetrics) throws IOException, ParseException {
        this._documentMetrics = aDocumentMetrics;
        this.seekFrom(aFilePath, aConfigLocator);
    }

    protected AbstractResourceProperties(URL aUrl, DocumentMetrics aDocumentMetrics) throws IOException, ParseException {
        this._documentMetrics = aDocumentMetrics;
        this.loadFrom(aUrl);
    }

    @Override
    public void flush() throws IOException {
        try {
            this.saveTo(this._propertiesFile);
        }
        catch (IOException e) {
            throw new IOException("Cannot flush properties to file <" + this._propertiesFile.getAbsolutePath() + "!", e);
        }
    }

    @Override
    public boolean isFlushable() {
        return this._propertiesFile != null && this._propertiesFile.canWrite();
    }

    @Override
    public Properties loadFrom(File aFile) throws IOException, ParseException {
        try (FileInputStream theInputStream = new FileInputStream(aFile);){
            Properties theResult = this.loadFrom(theInputStream);
            this._propertiesFile = aFile;
            Properties properties = theResult;
            return properties;
        }
    }

    @Override
    public Properties loadFrom(InputStream aInputStream) throws IOException, ParseException {
        CanonicalTable theCanonicalMap;
        BufferedInputStream theInputStream = new BufferedInputStream(aInputStream);
        DocumentOptions theOptions = this._documentMetrics.toProperties(this.getDelimiter());
        try {
            theCanonicalMap = (CanonicalTable)this.getCanonicalMapFactory().fromMarshaled(theInputStream, theOptions);
        }
        catch (UnmarshalException e) {
            throw new ParseException("Error parsing properties at offset <" + e.getOffset() + ">:" + Trap.asMessage(e), e.getOffset());
        }
        MapProperties theResult = new MapProperties((Map<?, ?>)theCanonicalMap);
        this.insert(theResult);
        return theResult;
    }

    @Override
    public Properties reload() throws IOException, ParseException {
        return this.reload(ReloadMode.KEEP_ORPHANS);
    }

    @Override
    public Properties reload(ReloadMode aReloadMode) throws IOException, ParseException {
        if (this._propertiesFile == null) {
            throw new IllegalStateException("There is no resource (supporting reloading, such as an input stream) attached to these properties.");
        }
        Properties theResult = this.loadFrom(this._propertiesFile);
        if (aReloadMode == ReloadMode.ORPHAN_REMOVAL) {
            HashSet<String> theKeys = new HashSet<String>(this.keySet());
            for (String eKey : theKeys) {
                if (theResult.containsKey((Object)eKey)) continue;
                this.remove((Object)eKey);
            }
        }
        return theResult;
    }

    @Override
    public File saveTo(File aFile, String aComment, char aDelimiter) throws IOException {
        try (BufferedOutputStream theOutputStream = new BufferedOutputStream(new FileOutputStream(aFile));){
            this.saveTo(theOutputStream, aComment, aDelimiter);
        }
        this._propertiesFile = aFile;
        return aFile;
    }

    @Override
    public void saveTo(OutputStream aOutputStream, String aComment, char aDelimiter) throws IOException {
        DocumentOptions theProperties = this._documentMetrics.toProperties(aComment, aDelimiter);
        try {
            String theMarshaled = this.getCanonicalMapFactory().toMarshaled(this, theProperties);
            OutputStreamWriter theWriter = new OutputStreamWriter(aOutputStream);
            theWriter.write(theMarshaled);
            theWriter.flush();
        }
        catch (MarshalException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Properties seekFrom(Class<?> aResourceClass, String aFilePath, ConfigLocator aConfigLocator) throws IOException, ParseException {
        ArrayList<Object> theProbedFiles = new ArrayList<Object>();
        IOException aCause = null;
        File eFile = new File(aFilePath);
        if (aConfigLocator != null && aConfigLocator == ConfigLocator.ABSOLUTE) {
            if (eFile.isAbsolute()) {
                theProbedFiles.add(eFile.getAbsolutePath());
                if (aResourceClass != null) {
                    try {
                        return this.loadFrom(aResourceClass, aFilePath);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return this.loadFrom(aFilePath);
            }
        } else {
            File[] theFolders;
            Properties theResult = null;
            theProbedFiles.add(eFile.getAbsolutePath());
            if (eFile.isAbsolute() && eFile.exists() && eFile.isFile() && eFile.canRead()) {
                theResult = this.loadFrom(eFile);
                return theResult;
            }
            if (aConfigLocator == null) {
                aConfigLocator = ConfigLocator.ALL;
            }
            if ((eFile = aConfigLocator.toFile(aFilePath)) != null) {
                theResult = this.loadFrom(eFile);
                return theResult;
            }
            for (File eFolder : theFolders = aConfigLocator.getFolders()) {
                theProbedFiles.add(eFolder.getAbsolutePath());
            }
            try {
                if (aResourceClass == null) {
                    aResourceClass = Execution.getMainClass();
                }
                URL theResource = aResourceClass.getResource(aFilePath);
                InputStream theInputStream = aResourceClass.getResourceAsStream(aFilePath);
                if (theInputStream == null && !aFilePath.startsWith("" + Delimiter.PATH.getChar())) {
                    theInputStream = aResourceClass.getResourceAsStream(Delimiter.PATH.getChar() + aFilePath);
                }
                if (theInputStream != null) {
                    theResult = this.loadFrom(theInputStream);
                    if (theResource != null) {
                        try {
                            this._propertiesFile = new File(theResource.toURI());
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            // empty catch block
                        }
                    }
                    return theResult;
                }
                theProbedFiles.add(theResource != null ? theResource.toExternalForm() : Scheme.JAR.getMarker() + aFilePath + "@" + aResourceClass.getName());
            }
            catch (IOException e) {
                aCause = e;
            }
        }
        StringBuilder theProbedLocations = new StringBuilder();
        Iterator e = theProbedFiles.iterator();
        while (e.hasNext()) {
            theProbedLocations.append((String)e.next());
            if (!e.hasNext()) continue;
            theProbedLocations.append(", ");
        }
        throw new IOException("Cannot find a properties file <" + aFilePath + "> (or <" + aFilePath + ".*>, depending on the implementation) at any of the supported locations: " + theProbedLocations.toString(), aCause);
    }

    @Override
    public ResourceProperties withInsert(Object aObj) {
        this.insert(aObj);
        return this;
    }

    @Override
    public ResourceProperties withInsert(ImmutablePathTable<String> aFrom) {
        this.insert(aFrom);
        return this;
    }

    @Override
    public ResourceProperties withInsertBetween(Collection<?> aToPathElements, Object aFrom, Collection<?> aFromPathElements) {
        this.insertBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties withInsertBetween(Collection<?> aToPathElements, ImmutablePathTable<String> aFrom, Collection<?> aFromPathElements) {
        this.insertBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties withInsertBetween(Object aToPath, Object aFrom, Object aFromPath) {
        this.insertBetween(aToPath, aFrom, aFromPath);
        return this;
    }

    @Override
    public ResourceProperties withInsertBetween(Object aToPath, ImmutablePathTable<String> aFrom, Object aFromPath) {
        this.insertBetween(aToPath, aFrom, aFromPath);
        return this;
    }

    @Override
    public ResourceProperties withInsertBetween(Object[] aToPathElements, Object aFrom, Object[] aFromPathElements) {
        this.insertBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties withInsertBetween(Object[] aToPathElements, ImmutablePathTable<String> aFrom, Object[] aFromPathElements) {
        this.insertBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties withInsertBetween(String aToPath, Object aFrom, String aFromPath) {
        this.insertBetween(aToPath, aFrom, aFromPath);
        return this;
    }

    @Override
    public ResourceProperties withInsertBetween(String aToPath, ImmutablePathTable<String> aFrom, String aFromPath) {
        this.insertBetween(aToPath, aFrom, aFromPath);
        return this;
    }

    @Override
    public ResourceProperties withInsertBetween(String[] aToPathElements, Object aFrom, String[] aFromPathElements) {
        this.insertBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties withInsertBetween(String[] aToPathElements, ImmutablePathTable<String> aFrom, String[] aFromPathElements) {
        this.insertBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties withInsertFrom(Object aFrom, Collection<?> aFromPathElements) {
        this.insertFrom(aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties withInsertFrom(Object aFrom, Object aFromPath) {
        this.insertFrom(aFrom, aFromPath);
        return this;
    }

    @Override
    public ResourceProperties withInsertFrom(Object aFrom, Object ... aFromPathElements) {
        this.withInsertFrom(aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties withInsertFrom(Object aFrom, String aFromPath) {
        this.insertFrom(aFrom, aFromPath);
        return this;
    }

    @Override
    public ResourceProperties withInsertFrom(Object aFrom, String ... aFromPathElements) {
        this.insertFrom(aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties withInsertFrom(ImmutablePathTable<String> aFrom, Collection<?> aFromPathElements) {
        this.insertFrom(aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties withInsertFrom(ImmutablePathTable<String> aFrom, Object aFromPath) {
        this.insertFrom((Object)aFrom, aFromPath);
        return this;
    }

    @Override
    public ResourceProperties withInsertFrom(ImmutablePathTable<String> aFrom, Object ... aFromPathElements) {
        this.withInsertFrom((ImmutablePathTable)aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties withInsertFrom(ImmutablePathTable<String> aFrom, String aFromPath) {
        this.insertFrom((Object)aFrom, aFromPath);
        return this;
    }

    @Override
    public ResourceProperties withInsertFrom(ImmutablePathTable<String> aFrom, String ... aFromPathElements) {
        this.insertFrom((Object)aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties withInsertTo(Collection<?> aToPathElements, Object aFrom) {
        this.insertTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public ResourceProperties withInsertTo(Collection<?> aToPathElements, ImmutablePathTable<String> aFrom) {
        this.insertTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public ResourceProperties withInsertTo(Object aToPath, Object aFrom) {
        this.insertTo(aToPath, aFrom);
        return this;
    }

    @Override
    public ResourceProperties withInsertTo(Object aToPath, ImmutablePathTable<String> aFrom) {
        this.insertTo(aToPath, aFrom);
        return this;
    }

    @Override
    public ResourceProperties withInsertTo(Object[] aToPathElements, Object aFrom) {
        this.insertTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public ResourceProperties withInsertTo(Object[] aToPathElements, ImmutablePathTable<String> aFrom) {
        this.insertTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public ResourceProperties withInsertTo(String aToPath, Object aFrom) {
        this.insertTo(aToPath, aFrom);
        return this;
    }

    @Override
    public ResourceProperties withInsertTo(String aToPath, ImmutablePathTable<String> aFrom) {
        this.insertTo(aToPath, aFrom);
        return this;
    }

    @Override
    public ResourceProperties withInsertTo(String[] aToPathElements, Object aFrom) {
        this.insertTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public ResourceProperties withInsertTo(String[] aToPathElements, ImmutablePathTable<String> aFrom) {
        this.insertTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public ResourceProperties withMerge(Object aObj) {
        this.merge(aObj);
        return this;
    }

    @Override
    public ResourceProperties withMerge(ImmutablePathTable<String> aFrom) {
        this.merge(aFrom);
        return this;
    }

    @Override
    public ResourceProperties withMergeBetween(Collection<?> aToPathElements, Object aFrom, Collection<?> aFromPathElements) {
        this.mergeBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties withMergeBetween(Collection<?> aToPathElements, ImmutablePathTable<String> aFrom, Collection<?> aFromPathElements) {
        this.mergeBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties withMergeBetween(Object aToPath, Object aFrom, Object aFromPath) {
        this.mergeBetween(aToPath, aFrom, aFromPath);
        return this;
    }

    @Override
    public ResourceProperties withMergeBetween(Object aToPath, ImmutablePathTable<String> aFrom, Object aFromPath) {
        this.mergeBetween(aToPath, aFrom, aFromPath);
        return this;
    }

    @Override
    public ResourceProperties withMergeBetween(Object[] aToPathElements, Object aFrom, Object[] aFromPathElements) {
        this.mergeBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties withMergeBetween(Object[] aToPathElements, ImmutablePathTable<String> aFrom, Object[] aFromPathElements) {
        this.mergeBetween(aToPathElements, (Object)aFromPathElements, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties withMergeBetween(String aToPath, Object aFrom, String aFromPath) {
        this.mergeBetween(aToPath, aFrom, aFromPath);
        return this;
    }

    @Override
    public ResourceProperties withMergeBetween(String aToPath, ImmutablePathTable<String> aFrom, String aFromPath) {
        this.mergeBetween(aToPath, aFrom, aFromPath);
        return this;
    }

    @Override
    public ResourceProperties withMergeBetween(String[] aToPathElements, Object aFrom, String[] aFromPathElements) {
        this.mergeBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties withMergeBetween(String[] aToPathElements, ImmutablePathTable<String> aFrom, String[] aFromPathElements) {
        this.mergeBetween(aToPathElements, aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties withMergeFrom(Object aFrom, Collection<?> aFromPathElements) {
        this.mergeFrom(aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties withMergeFrom(Object aFrom, Object aFromPath) {
        this.mergeFrom(aFrom, aFromPath);
        return this;
    }

    @Override
    public ResourceProperties withMergeFrom(Object aFrom, Object ... aFromPathElements) {
        this.mergeFrom(aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties withMergeFrom(Object aFrom, String aFromPath) {
        this.mergeFrom(aFrom, aFromPath);
        return this;
    }

    @Override
    public ResourceProperties withMergeFrom(Object aFrom, String ... aFromPathElements) {
        this.mergeFrom(aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties withMergeFrom(ImmutablePathTable<String> aFrom, Collection<?> aFromPathElements) {
        this.mergeFrom(aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties withMergeFrom(ImmutablePathTable<String> aFrom, Object aFromPath) {
        this.mergeFrom((Object)aFrom, aFromPath);
        return this;
    }

    @Override
    public ResourceProperties withMergeFrom(ImmutablePathTable<String> aFrom, Object ... aFromPathElements) {
        this.mergeFrom((Object)aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties withMergeFrom(ImmutablePathTable<String> aFrom, String aFromPath) {
        this.mergeFrom((Object)aFrom, aFromPath);
        return this;
    }

    @Override
    public ResourceProperties withMergeFrom(ImmutablePathTable<String> aFrom, String ... aFromPathElements) {
        this.mergeFrom((Object)aFrom, aFromPathElements);
        return this;
    }

    @Override
    public ResourceProperties withMergeTo(Collection<?> aToPathElements, Object aFrom) {
        this.mergeTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public ResourceProperties withMergeTo(Collection<?> aToPathElements, ImmutablePathTable<String> aFrom) {
        this.mergeTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public ResourceProperties withMergeTo(Object aToPath, Object aFrom) {
        this.mergeTo(aToPath, aFrom);
        return this;
    }

    @Override
    public ResourceProperties withMergeTo(Object aToPath, ImmutablePathTable<String> aFrom) {
        this.mergeTo(aToPath, aFrom);
        return this;
    }

    @Override
    public ResourceProperties withMergeTo(Object[] aToPathElements, Object aFrom) {
        this.mergeTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public ResourceProperties withMergeTo(Object[] aToPathElements, ImmutablePathTable<String> aFrom) {
        this.mergeTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public ResourceProperties withMergeTo(String aToPath, Object aFrom) {
        this.mergeTo(aToPath, aFrom);
        return this;
    }

    @Override
    public ResourceProperties withMergeTo(String aToPath, ImmutablePathTable<String> aFrom) {
        this.mergeTo(aToPath, aFrom);
        return this;
    }

    @Override
    public ResourceProperties withMergeTo(String[] aToPathElements, Object aFrom) {
        this.mergeTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public ResourceProperties withMergeTo(String[] aToPathElements, ImmutablePathTable<String> aFrom) {
        this.mergeTo(aToPathElements, aFrom);
        return this;
    }

    @Override
    public ResourceProperties withPut(Collection<?> aPathElements, String aValue) {
        this.put(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPut(Object[] aPathElements, String aValue) {
        this.put(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPut(Property aProperty) {
        this.put(aProperty);
        return this;
    }

    @Override
    public ResourceProperties withPut(Relation<String, String> aProperty) {
        this.put(aProperty);
        return this;
    }

    @Override
    public ResourceProperties withPut(String aKey, String aValue) {
        this.put(aKey, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPut(String[] aKey, String aValue) {
        this.put(aKey, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPutBoolean(Collection<?> aPathElements, Boolean aValue) {
        this.putBoolean(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPutBoolean(Object aKey, Boolean aValue) {
        this.putBoolean(aKey, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPutBoolean(Object[] aPathElements, Boolean aValue) {
        this.putBoolean(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPutBoolean(String aKey, Boolean aValue) {
        this.putBoolean(aKey, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPutBoolean(String[] aPathElements, Boolean aValue) {
        this.putBoolean(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPutByte(Collection<?> aPathElements, Byte aValue) {
        this.putByte(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPutByte(Object aKey, Byte aValue) {
        this.putByte(aKey, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPutByte(Object[] aPathElements, Byte aValue) {
        this.putByte(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPutByte(String aKey, Byte aValue) {
        this.putByte(aKey, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPutByte(String[] aPathElements, Byte aValue) {
        this.putByte(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPutChar(Collection<?> aPathElements, Character aValue) {
        this.putChar(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPutChar(Object aKey, Character aValue) {
        this.putChar(aKey, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPutChar(Object[] aPathElements, Character aValue) {
        this.putChar(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPutChar(String aKey, Character aValue) {
        this.putChar(aKey, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPutChar(String[] aPathElements, Character aValue) {
        this.putChar(aPathElements, aValue);
        return this;
    }

    @Override
    public <C> ResourceProperties withPutClass(Collection<?> aPathElements, Class<C> aValue) {
        this.putClass(aPathElements, aValue);
        return this;
    }

    @Override
    public <C> ResourceProperties withPutClass(Object aKey, Class<C> aValue) {
        this.putClass(aKey, aValue);
        return this;
    }

    @Override
    public <C> ResourceProperties withPutClass(Object[] aPathElements, Class<C> aValue) {
        this.putClass(aPathElements, aValue);
        return this;
    }

    @Override
    public <C> ResourceProperties withPutClass(String aKey, Class<C> aValue) {
        this.putClass(aKey, aValue);
        return this;
    }

    @Override
    public <C> ResourceProperties withPutClass(String[] aPathElements, Class<C> aValue) {
        this.putClass(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPutDirAt(Collection<?> aPathElements, int aIndex, Object aDir) {
        this.putDirAt((Collection)aPathElements, aIndex, aDir);
        return this;
    }

    @Override
    public ResourceProperties withPutDirAt(Collection<?> aPathElements, int aIndex, ImmutablePathTable<String> aDir) {
        this.putDirAt((Collection)aPathElements, aIndex, (ImmutablePathTable)aDir);
        return this;
    }

    @Override
    public ResourceProperties withPutDirAt(int aIndex, Object aDir) {
        this.putDirAt(aIndex, aDir);
        return this;
    }

    @Override
    public ResourceProperties withPutDirAt(int aIndex, ImmutablePathTable<String> aDir) {
        this.putDirAt(aIndex, (ImmutablePathTable)aDir);
        return this;
    }

    @Override
    public ResourceProperties withPutDirAt(Object aPath, int aIndex, Object aDir) {
        this.putDirAt(aPath, aIndex, aDir);
        return this;
    }

    @Override
    public ResourceProperties withPutDirAt(Object aPath, int aIndex, ImmutablePathTable<String> aDir) {
        this.putDirAt(aPath, aIndex, (ImmutablePathTable)aDir);
        return this;
    }

    @Override
    public ResourceProperties withPutDirAt(Object[] aPathElements, int aIndex, Object aDir) {
        this.putDirAt(aPathElements, aIndex, aDir);
        return this;
    }

    @Override
    public ResourceProperties withPutDirAt(Object[] aPathElements, int aIndex, ImmutablePathTable<String> aDir) {
        this.putDirAt(aPathElements, aIndex, (ImmutablePathTable)aDir);
        return this;
    }

    @Override
    public ResourceProperties withPutDirAt(String aPath, int aIndex, Object aDir) {
        this.putDirAt(aPath, aIndex, aDir);
        return this;
    }

    @Override
    public ResourceProperties withPutDirAt(String aPath, int aIndex, ImmutablePathTable<String> aDir) {
        this.putDirAt(aPath, aIndex, (ImmutablePathTable)aDir);
        return this;
    }

    @Override
    public ResourceProperties withPutDirAt(String[] aPathElements, int aIndex, Object aDir) {
        this.putDirAt(aPathElements, aIndex, aDir);
        return this;
    }

    @Override
    public ResourceProperties withPutDirAt(String[] aPathElements, int aIndex, ImmutablePathTable<String> aDir) {
        this.putDirAt(aPathElements, aIndex, (ImmutablePathTable)aDir);
        return this;
    }

    @Override
    public ResourceProperties withPutDouble(Collection<?> aPathElements, Double aValue) {
        this.putDouble(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPutDouble(Object aKey, Double aValue) {
        this.putDouble(aKey, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPutDouble(Object[] aPathElements, Double aValue) {
        this.putDouble(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPutDouble(String aKey, Double aValue) {
        this.putDouble(aKey, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPutDouble(String[] aPathElements, Double aValue) {
        this.putDouble(aPathElements, aValue);
        return this;
    }

    @Override
    public <E extends Enum<E>> ResourceProperties withPutEnum(Collection<?> aPathElements, E aValue) {
        this.putEnum(aPathElements, aValue);
        return this;
    }

    @Override
    public <E extends Enum<E>> ResourceProperties withPutEnum(Object aKey, E aValue) {
        this.putEnum(aKey, aValue);
        return this;
    }

    @Override
    public <E extends Enum<E>> ResourceProperties withPutEnum(Object[] aPathElements, E aValue) {
        this.putEnum(aPathElements, aValue);
        return this;
    }

    @Override
    public <E extends Enum<E>> ResourceProperties withPutEnum(String aKey, E aValue) {
        this.putEnum(aKey, aValue);
        return this;
    }

    @Override
    public <E extends Enum<E>> ResourceProperties withPutEnum(String[] aPathElements, E aValue) {
        this.putEnum(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPutFloat(Collection<?> aPathElements, Float aValue) {
        this.putFloat(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPutFloat(Object aKey, Float aValue) {
        this.putFloat(aKey, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPutFloat(Object[] aPathElements, Float aValue) {
        this.putFloat(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPutFloat(String aKey, Float aValue) {
        this.putFloat(aKey, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPutFloat(String[] aPathElements, Float aValue) {
        this.putFloat(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPutInt(Collection<?> aPathElements, Integer aValue) {
        this.putInt(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPutInt(Object aKey, Integer aValue) {
        this.putInt(aKey, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPutInt(Object[] aPathElements, Integer aValue) {
        this.putInt(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPutInt(String aKey, Integer aValue) {
        this.putInt(aKey, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPutInt(String[] aPathElements, Integer aValue) {
        this.putInt(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPutLong(Collection<?> aPathElements, Long aValue) {
        this.putLong(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPutLong(Object aKey, Long aValue) {
        this.putLong(aKey, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPutLong(Object[] aPathElements, Long aValue) {
        this.putLong(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPutLong(String aKey, Long aValue) {
        this.putLong(aKey, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPutLong(String[] aPathElements, Long aValue) {
        this.putLong(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPutShort(Collection<?> aPathElements, Short aValue) {
        this.putShort(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPutShort(Object aKey, Short aValue) {
        this.putShort(aKey, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPutShort(Object[] aPathElements, Short aValue) {
        this.putShort(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPutShort(String aKey, Short aValue) {
        this.putShort(aKey, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPutShort(String[] aPathElements, Short aValue) {
        this.putShort(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPutString(Collection<?> aPathElements, String aValue) {
        this.putString(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPutString(Object aKey, String aValue) {
        this.putString(aKey, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPutString(Object[] aPathElements, String aValue) {
        this.putString(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPutString(String aKey, String aValue) {
        this.putString(aKey, aValue);
        return this;
    }

    @Override
    public ResourceProperties withPutString(String[] aPathElements, String aValue) {
        this.putString(aPathElements, aValue);
        return this;
    }

    @Override
    public ResourceProperties withRemoveFrom(Collection<?> aPathElements) {
        this.removeFrom((Collection)aPathElements);
        return this;
    }

    @Override
    public ResourceProperties withRemoveFrom(Object aPath) {
        this.removeFrom(aPath);
        return this;
    }

    @Override
    public ResourceProperties withRemoveFrom(Object ... aPathElements) {
        this.removeFrom(aPathElements);
        return this;
    }

    @Override
    public ResourceProperties withRemoveFrom(String aPath) {
        this.removeFrom(aPath);
        return this;
    }

    @Override
    public ResourceProperties withRemoveFrom(String ... aPathElements) {
        this.removeFrom(aPathElements);
        return this;
    }

    @Override
    public ResourceProperties withRemovePaths(String ... aPathElements) {
        this.removeFrom(aPathElements);
        return this;
    }

    protected abstract CanonicalTableFactory createCanonicalMapFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CanonicalTableFactory getCanonicalMapFactory() {
        if (this._factory == null) {
            AbstractResourceProperties abstractResourceProperties = this;
            synchronized (abstractResourceProperties) {
                if (this._factory == null) {
                    this._factory = this.createCanonicalMapFactory();
                }
            }
        }
        return this._factory;
    }
}

