/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.logger.alt.console;

import java.io.PrintStream;
import org.refcodes.data.ConsoleDimension;
import org.refcodes.data.Field;
import org.refcodes.logger.ColumnLayout;
import org.refcodes.logger.ColumnLayoutAccessor;
import org.refcodes.logger.IllegalRecordRuntimeException;
import org.refcodes.logger.LogPriority;
import org.refcodes.logger.LoggerField;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;
import org.refcodes.logger.alt.console.AbstractConsoleLogger;
import org.refcodes.logger.alt.console.ConsoleLoggerHeader;
import org.refcodes.runtime.EnvironmentVariable;
import org.refcodes.runtime.SystemProperty;
import org.refcodes.runtime.Terminal;
import org.refcodes.tabular.ColumnMismatchException;
import org.refcodes.tabular.FormattedColumn;
import org.refcodes.tabular.FormattedHeader;
import org.refcodes.tabular.Record;
import org.refcodes.textual.MoreTextMode;
import org.refcodes.textual.TableBuilder;
import org.refcodes.textual.TableStyle;

public class ConsoleLogger
extends AbstractConsoleLogger<Object>
implements ColumnLayoutAccessor.ColumnLayoutProperty,
ColumnLayoutAccessor.ColumnLayoutBuilder<ConsoleLogger> {
    private static final boolean IS_STACKTRACE_INSIDE_TABLE = true;
    private LogPriority _lastPriority;
    private String _lastFqcn;
    private int _exceptionIndex;
    private FormattedColumn<Throwable> _errorColumn;
    protected TableBuilder _errorBuilder;
    protected TableBuilder _standardBuilder;
    protected FormattedHeader<Object> _standardHeader;
    private TableLayout _lastLayout = TableLayout.NONE;
    private ColumnLayout _columnLayout = ColumnLayout.NONE;

    public ConsoleLogger() {
        this(ConsoleLogger.toLoggerLayout(null));
    }

    public ConsoleLogger(ColumnLayout aLoggerLayout) {
        super(new ConsoleLoggerHeader(ConsoleLogger.toLoggerLayout(aLoggerLayout)));
        this.init(ConsoleLogger.toLoggerLayout(aLoggerLayout));
    }

    @Override
    public ColumnLayout getColumnLayout() {
        return this._columnLayout;
    }

    @Override
    public void setColumnLayout(ColumnLayout aColumnLayout) {
        ColumnLayout theColumnLayout;
        if (ConsoleLogger.toLoggerLayout() == null && (theColumnLayout = ConsoleLogger.toLoggerLayout(aColumnLayout)) != this._columnLayout) {
            this._columnLayout = theColumnLayout;
            this._errorColumn = null;
            this._header = new ConsoleLoggerHeader(this._columnLayout);
            this.init();
        }
    }

    @Override
    public synchronized void log(Record<? extends Object> aRecord) {
        try {
            LogPriority thePriority = (LogPriority)((Object)LoggerField.LOG_PRIORITY.getColumn().get(aRecord));
            String theFqcn = (String)LoggerField.LOG_FULLY_QUALIFIED_CLASS_NAME.getColumn().get(aRecord);
            Throwable theException = null;
            if (aRecord.size() > this._exceptionIndex) {
                theException = (Throwable)aRecord.get(Field.LOG_EXCEPTION.getName());
            }
            if (thePriority == null || thePriority.getPriority() > LogPriority.DISCARD.getPriority()) {
                if (theFqcn != null && !theFqcn.equals(this._lastFqcn) || this._lastPriority != thePriority || this._columnLayout == ColumnLayout.ANALYST || thePriority.getPriority() >= LogPriority.WARN.getPriority() || this._isPrintSeparator) {
                    this._isPrintSeparator = false;
                    if (this._lastLayout == TableLayout.EXCEPTION) {
                        if (theException != null) {
                            this._standardBuilder.printRowEnd(this._errorBuilder);
                        } else if (thePriority.getPriority() >= LogPriority.WARN.getPriority()) {
                            this._standardBuilder.printRowEnd(this._errorBuilder);
                        } else {
                            this._tableBuilder.printRowEnd(this._errorBuilder);
                        }
                    } else if (this._lastLayout != TableLayout.NONE) {
                        this._tableBuilder.printRowBegin();
                    }
                }
                if (thePriority.getPriority() >= LogPriority.WARN.getPriority()) {
                    if (this._lastLayout == TableLayout.NONE && this._hasLogLines) {
                        this._standardBuilder.printRowBegin();
                    }
                    this.log(aRecord, this._standardHeader, this._standardBuilder);
                } else {
                    super.log(aRecord);
                }
                if (theException != null) {
                    this.printException(theException);
                    this._lastLayout = TableLayout.EXCEPTION;
                } else {
                    this._lastLayout = TableLayout.MESSAGE;
                }
            } else if (theException != null) {
                System.err.println(theException.getMessage());
                theException.printStackTrace();
            }
            this._lastPriority = thePriority;
            this._lastFqcn = theFqcn;
        }
        catch (ClassCastException | ColumnMismatchException e) {
            throw new IllegalRecordRuntimeException(aRecord, (Throwable)e);
        }
    }

    @Override
    public void printTail() {
        if (this._hasLogLines) {
            if (this._lastLayout == TableLayout.EXCEPTION) {
                this._errorBuilder.printTail();
                this._errStream.flush();
            } else {
                super.printTail();
            }
            this._lastLayout = TableLayout.NONE;
            this._hasLogLines = false;
            this._isPrintHead = true;
        }
    }

    @Override
    public ConsoleLogger withColumnLayout(ColumnLayout aColumnLayout) {
        this.setColumnLayout(aColumnLayout);
        return this;
    }

    @Override
    public ConsoleLogger withTableStyle(TableStyle aTableStyle) {
        this.setTableStyle(aTableStyle);
        return this;
    }

    @Override
    public ConsoleLogger withRowWidth(int aRowWidth) {
        this.setRowWidth(aRowWidth);
        return this;
    }

    public ConsoleLogger withEscapeCodes(boolean isEscCodesEnabled) {
        this.setEscapeCodes(isEscCodesEnabled);
        return this;
    }

    public ConsoleLogger withLeftBorder(boolean hasLeftBorder) {
        this.setLeftBorder(hasLeftBorder);
        return this;
    }

    public ConsoleLogger withRightBorder(boolean hasRightBorder) {
        this.setRightBorder(hasRightBorder);
        return this;
    }

    @Override
    public ConsoleLogger withErrorPrintStream(PrintStream aErrorPrintStream) {
        this.setErrorPrintStream(aErrorPrintStream);
        return this;
    }

    @Override
    public ConsoleLogger withStandardPrintStream(PrintStream aStandardPrintStream) {
        this.setStandardPrintStream(aStandardPrintStream);
        return this;
    }

    public void setLoggerLayout(String aLoggerLayout) {
        this.setColumnLayout(ColumnLayout.toColumnLayout(aLoggerLayout));
    }

    public void setLayout(String aLoggerLayout) {
        this.setLoggerLayout(aLoggerLayout);
    }

    protected static ColumnLayout toLoggerLayout(ColumnLayout aLoggerLayout) {
        if (aLoggerLayout != null && (aLoggerLayout != ColumnLayout.SUPERUSER || Terminal.toHeuristicWidth() >= ConsoleDimension.NORM_WIDTH.getValue())) {
            return aLoggerLayout;
        }
        ColumnLayout theLoggerLayout = ConsoleLogger.toLoggerLayout();
        if (theLoggerLayout == null) {
            theLoggerLayout = ColumnLayout.SUPERUSER;
        }
        if (theLoggerLayout == ColumnLayout.SUPERUSER && Terminal.toHeuristicWidth() < ConsoleDimension.NORM_WIDTH.getValue()) {
            return ColumnLayout.BASIC;
        }
        return theLoggerLayout;
    }

    protected static ColumnLayout toLoggerLayout() {
        ColumnLayout theLoggerLayout = null;
        String theResult = SystemProperty.toPropertyValue(SystemProperty.LOGGER_LAYOUT, EnvironmentVariable.LOGGER_LAYOUT);
        if (theResult != null) {
            try {
                theLoggerLayout = ColumnLayout.toColumnLayout(theResult);
                if (theLoggerLayout == null) {
                    theLoggerLayout = ColumnLayout.SUPERUSER;
                }
            }
            catch (IllegalArgumentException | NullPointerException runtimeException) {
                // empty catch block
            }
        }
        return theLoggerLayout;
    }

    protected static TableStyle toShortcutLoggerStyle() {
        String theResult = SystemProperty.toPropertyValue(SystemProperty.LOGGER_STYLE, EnvironmentVariable.LOGGER_STYLE);
        if (theResult != null) {
            try {
                TableStyle theTableStyle = TableStyle.toTableStyle(theResult);
                return theTableStyle;
            }
            catch (IllegalArgumentException | NullPointerException runtimeException) {
                // empty catch block
            }
        }
        return null;
    }

    protected synchronized void printException(Throwable theException) {
        String theText = this._errorColumn.toPrintable(theException);
        theText = theText.replaceAll("\t", "--> ");
        this._errorBuilder.printRowEnd(this._standardBuilder);
        this._errorBuilder.printRowContinue(theText);
        this._errorBuilder.withPrintStream(this._errStream);
    }

    @Override
    protected void init() {
        TableStyle theTableStyle = ConsoleLogger.toShortcutLoggerStyle();
        if (theTableStyle != null) {
            this._tableStyle = theTableStyle;
        }
        if (this._errorColumn == null) {
            this._exceptionIndex = this._header.indexOf(Field.LOG_EXCEPTION.getName());
            this._errorColumn = (FormattedColumn)this._header.delete(Field.LOG_EXCEPTION.getName());
        }
        this._errorBuilder = new TableBuilder(this._rowWidth).addColumn().withColumnFormatMetrics(this._errorColumn).withPrintStream(this._errStream).withTableStyle(this._tableStyle).withLeftBorder(this._hasLeftBorder).withRightBorder(this._hasRightBorder);
        this._errorBuilder.withBorderEscapeCode(this.DEFAULT_ANSI_BOX_GRID_COLOR);
        this._errorBuilder.withLineBreak(Terminal.toLineBreak(this._rowWidth));
        if (this._columnLayout != null) {
            this.init(this._columnLayout);
        }
        super.init();
    }

    private void init(ColumnLayout aColumnLayout) {
        this._columnLayout = aColumnLayout;
        this._standardHeader = this.toVerboseHeader();
        this._standardBuilder = this.toPreConfiguredTableBuilder(this._standardHeader, AbstractConsoleLogger.OutputPrintStream.ERROR);
    }

    private FormattedHeader<Object> toVerboseHeader() {
        ConsoleLoggerHeader theVerboseHeader = new ConsoleLoggerHeader(this._columnLayout);
        FormattedColumn theMessageColumn = (FormattedColumn)this._header.get(Field.LOG_MESSAGE.getName());
        theMessageColumn.setHeaderMoreTextMode(MoreTextMode.NONE);
        theVerboseHeader.delete(Field.LOG_EXCEPTION.getName());
        return theVerboseHeader;
    }

    static {
        RuntimeLoggerFactorySingleton.bindJavaUtilLogging();
    }

    private static enum TableLayout {
        NONE,
        MESSAGE,
        EXCEPTION;

    }
}

