/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.logger.alt.console;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.refcodes.component.Destroyable;
import org.refcodes.data.AnsiEscapeCode;
import org.refcodes.data.Text;
import org.refcodes.logger.IllegalRecordRuntimeException;
import org.refcodes.logger.Logger;
import org.refcodes.mixin.ErrorPrintStreamAccessor;
import org.refcodes.mixin.RowWidthAccessor;
import org.refcodes.mixin.StandardPrintStreamAccessor;
import org.refcodes.runtime.Execution;
import org.refcodes.runtime.Terminal;
import org.refcodes.tabular.ColumnMismatchException;
import org.refcodes.tabular.FormattedColumn;
import org.refcodes.tabular.FormattedHeader;
import org.refcodes.tabular.HeaderMismatchException;
import org.refcodes.tabular.Record;
import org.refcodes.tabular.Row;
import org.refcodes.textual.ColumnSetupMetrics;
import org.refcodes.textual.TableBuilder;
import org.refcodes.textual.TableStatus;
import org.refcodes.textual.TableStyle;
import org.refcodes.textual.TableStyleAccessor;

public abstract class AbstractConsoleLogger<T>
implements Destroyable,
Logger<T>,
RowWidthAccessor.RowWidthProperty,
RowWidthAccessor.RowWidthBuilder<AbstractConsoleLogger<?>>,
TableStyleAccessor.TableStyleProperty,
TableStyleAccessor.TableStyleBuilder<AbstractConsoleLogger<?>>,
StandardPrintStreamAccessor.StandardPrintStreamProperty,
StandardPrintStreamAccessor.StandardPrintStreamBuilder<AbstractConsoleLogger<T>>,
ErrorPrintStreamAccessor.ErrorPrintStreamProperty,
ErrorPrintStreamAccessor.ErrorPrintStreamBuilder<AbstractConsoleLogger<T>> {
    protected String DEFAULT_ANSI_BOX_GRID_COLOR = AnsiEscapeCode.FG_DEFAULT.toEscapeSequence();
    protected boolean _isPrintHead = true;
    protected boolean _isPrintSeparator = false;
    protected boolean _hasLogLines = false;
    protected FormattedHeader<T> _header;
    protected TableBuilder _tableBuilder;
    protected PrintStream _stdStream = Execution.toSystemOut();
    protected PrintStream _errStream = Execution.toSystemErr();
    protected int _rowWidth = Terminal.toHeuristicWidth();
    protected TableStyle _tableStyle;
    protected boolean _hasLeftBorder = true;
    protected boolean _hasRightBorder = true;
    private List<String> _columnNames;
    private boolean _isEscCodesEnabled = Terminal.isAnsiTerminalEnabled();

    public AbstractConsoleLogger(FormattedHeader<T> aHeader) {
        this._header = aHeader;
        this._tableStyle = TableStyle.toExecutionTableStyle();
        this.init();
    }

    @Override
    public synchronized void log(Record<? extends T> aRecord) {
        this.log(aRecord, this._header, this._tableBuilder);
    }

    @Override
    public PrintStream getStandardPrintStream() {
        return this._stdStream;
    }

    @Override
    public void setStandardPrintStream(PrintStream aOutStream) {
        this._stdStream = aOutStream;
    }

    @Override
    public PrintStream getErrorPrintStream() {
        return this._errStream;
    }

    @Override
    public void setErrorPrintStream(PrintStream aErrStream) {
        this._errStream = aErrStream;
    }

    public void setStyle(String aTableStyle) {
        this.setLoggerStyle(aTableStyle);
    }

    @Override
    public TableStyle getTableStyle() {
        return this._tableStyle;
    }

    @Override
    public void setTableStyle(TableStyle aTableStyle) {
        this._tableStyle = aTableStyle;
        this.init();
    }

    public void setLoggerStyle(String aTableStyleName) {
        this.setTableStyle(TableStyle.valueOf(aTableStyleName));
    }

    public void setEscapeCodes(boolean isEscCodesEnabled) {
        this._isEscCodesEnabled = isEscCodesEnabled;
        TableBuilder theTableBuilder = this._tableBuilder;
        if (theTableBuilder != null) {
            theTableBuilder.withEscapeCodesEnabled(isEscCodesEnabled);
        }
    }

    public boolean hasLeftBorder() {
        return this._hasLeftBorder;
    }

    public void setLeftBorder(boolean hasLeftBorder) {
        this._hasLeftBorder = hasLeftBorder;
        this.init();
    }

    public AbstractConsoleLogger<T> withLeftBorder(boolean hasLeftBorder) {
        this.setLeftBorder(hasLeftBorder);
        return this;
    }

    public boolean hasRightBorder() {
        return this._hasRightBorder;
    }

    public void setRightBorder(boolean hasRightBorder) {
        this._hasRightBorder = hasRightBorder;
        this.init();
    }

    public AbstractConsoleLogger<T> withRightBorder(boolean hasRightBorder) {
        this.setRightBorder(hasRightBorder);
        return this;
    }

    @Override
    public AbstractConsoleLogger<T> withErrorPrintStream(PrintStream aErrorPrintStream) {
        this.setErrorPrintStream(aErrorPrintStream);
        return this;
    }

    @Override
    public AbstractConsoleLogger<T> withStandardPrintStream(PrintStream aStandardPrintStream) {
        this.setStandardPrintStream(aStandardPrintStream);
        return this;
    }

    @Override
    public AbstractConsoleLogger<?> withTableStyle(TableStyle aTableStyle) {
        this.setTableStyle(aTableStyle);
        return this;
    }

    @Override
    public AbstractConsoleLogger<?> withRowWidth(int aRowWidth) {
        this.setRowWidth(aRowWidth);
        return this;
    }

    @Override
    public int getRowWidth() {
        return this._rowWidth;
    }

    @Override
    public void setRowWidth(int aRowWidth) {
        this._rowWidth = aRowWidth;
        this.init();
    }

    public boolean hasEscapeCodes() {
        return this._isEscCodesEnabled;
    }

    public AbstractConsoleLogger<T> withEscapeCodes(boolean isEscCodesEnabled) {
        this.setEscapeCodes(isEscCodesEnabled);
        return this;
    }

    @Override
    public void destroy() {
        this.printTail();
    }

    protected void init() {
        TableBuilder theTableBuilder;
        block2: {
            theTableBuilder = this.toPreConfiguredTableBuilder(this._header, OutputPrintStream.STANDARD);
            this._columnNames = new ArrayList<String>();
            for (ColumnSetupMetrics columnSetupMetrics : this._header) {
                if (!columnSetupMetrics.isVisible()) continue;
                this._columnNames.add(columnSetupMetrics.getName());
            }
            for (String string : this._columnNames) {
                if (string == null || string.length() == 0) continue;
                break block2;
            }
            this._columnNames.clear();
            this._columnNames = null;
        }
        this._tableBuilder = theTableBuilder;
    }

    @Override
    public void printSeparator() {
        this._isPrintSeparator = true;
    }

    @Override
    public void printTail() {
        if (this._hasLogLines) {
            this._tableBuilder.printTail();
            this._stdStream.flush();
            this._hasLogLines = false;
        }
    }

    @Override
    public void printHead() {
        this._isPrintHead = true;
    }

    protected TableBuilder toPreConfiguredTableBuilder(FormattedHeader<?> aHeader, OutputPrintStream aOutputPrintStream) {
        TableBuilder theTableBuilder = new TableBuilder(this._rowWidth).withTableStyle(this._tableStyle).withPrintStream(aOutputPrintStream == OutputPrintStream.STANDARD ? this._stdStream : this._errStream).withResetEscapeCode(this._header.getResetEscapeCode()).withLeftBorder(this._hasLeftBorder).withRightBorder(this._hasRightBorder).withEscapeCodesEnabled(this._isEscCodesEnabled).withLineBreak(Terminal.toLineBreak(this._rowWidth));
        theTableBuilder.withBorderEscapeCode(this.DEFAULT_ANSI_BOX_GRID_COLOR);
        for (ColumnSetupMetrics columnSetupMetrics : aHeader) {
            if (!columnSetupMetrics.isVisible()) continue;
            theTableBuilder.addColumn().withColumnFormatMetrics(columnSetupMetrics);
        }
        return theTableBuilder;
    }

    protected synchronized void log(Record<? extends T> aRecord, FormattedHeader<T> aHeader, TableBuilder aTableBuilder) {
        if (this._isPrintHead) {
            if (this._columnNames != null) {
                this._tableBuilder.setTableStatus(TableStatus.NONE);
                this._tableBuilder.printHeaderBegin();
                this._tableBuilder.printHeaderContinue(this._columnNames);
                this._tableBuilder.printHeaderComplete();
            }
            this._isPrintHead = false;
        }
        if (this._isPrintSeparator) {
            this._isPrintSeparator = false;
        }
        try {
            int i;
            Row<String> theRow = aHeader.toPrintableRow(aRecord);
            for (i = aHeader.size() - 1; i >= 0; --i) {
                if (((FormattedColumn)aHeader.get(i)).isVisible() || theRow.size() <= i) continue;
                theRow.remove(i);
            }
            for (i = 0; i < theRow.size(); ++i) {
                if (theRow.get(i) != null) continue;
                theRow.remove(i);
                theRow.add(i, Text.NULL_VALUE.getText());
            }
            aTableBuilder.printRowContinue(theRow);
        }
        catch (ClassCastException | ColumnMismatchException | HeaderMismatchException e) {
            throw new IllegalRecordRuntimeException(aRecord, (Throwable)e);
        }
        this._hasLogLines = true;
    }

    public static enum OutputPrintStream {
        STANDARD,
        ERROR;

    }
}

