/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.logger.alt.async;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.refcodes.component.Destroyable;
import org.refcodes.controlflow.ControlFlowUtility;
import org.refcodes.controlflow.RetryCounter;
import org.refcodes.data.IoRetryCount;
import org.refcodes.data.RetryCount;
import org.refcodes.data.SleepLoopTime;
import org.refcodes.exception.Trap;
import org.refcodes.logger.IllegalRecordRuntimeException;
import org.refcodes.logger.Logger;
import org.refcodes.logger.LoggerAccessor;
import org.refcodes.logger.UnexpectedLogRuntimeException;
import org.refcodes.tabular.Record;
import org.refcodes.tabular.RecordImpl;

public class AsyncLogger<T>
implements Logger<T>,
Destroyable,
LoggerAccessor.LoggerMutator<Logger<T>> {
    private static final java.util.logging.Logger LOGGER = java.util.logging.Logger.getLogger(AsyncLogger.class.getName());
    private static final int LOGGERS_MULTIPLIER = 1000;
    private LinkedBlockingQueue<Record<? extends T>> _logLineQueue;
    private boolean _isDestroyed = false;
    private boolean _isInitialized = false;
    private final SeparatorRecord<T> _separator = new SeparatorRecord();

    public AsyncLogger() {
    }

    public AsyncLogger(Logger<T> aLogger) {
        this.init(ControlFlowUtility.createCachedExecutorService(true), aLogger);
    }

    public AsyncLogger(ExecutorService aExecutorService, Logger<T> aLogger) {
        this.init(aExecutorService, aLogger);
    }

    @Override
    public void log(Record<? extends T> aRecord) {
        RetryCounter theRetryCounter = new RetryCounter(IoRetryCount.MAX.getValue());
        try {
            while (!this._logLineQueue.offer(aRecord, SleepLoopTime.MAX.getTimeMillis(), TimeUnit.MILLISECONDS) && theRetryCounter.nextRetry()) {
                LOGGER.log(Level.WARNING, "Trying to offer (add) a log line to the log line queue, though the queue is full, this is retry # <" + theRetryCounter.getRetryCount() + ">, aborting after <" + theRetryCounter.getRetryNumber() + "> retries. Retrying now after a delay of <" + SleepLoopTime.MAX.getTimeMillis() / 1000 + "> seconds...");
                if (theRetryCounter.hasNextRetry()) continue;
                throw new UnexpectedLogRuntimeException("Unable to process the log line after <" + theRetryCounter.getRetryNumber() + "> retries, aborting retries, dismissing log line \"" + aRecord.toString() + "\"!", aRecord);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void printSeparator() {
        this.log(this._separator);
    }

    @Override
    public void destroy() {
        this._isDestroyed = true;
        RetryCounter theRetryCounter = new RetryCounter(RetryCount.MAX.getValue(), (long)SleepLoopTime.NORM.getTimeMillis());
        while (theRetryCounter.hasNextRetry() && !this._logLineQueue.isEmpty()) {
            LOGGER.log(Level.WARNING, "The logline queue is not empty, waiting <" + theRetryCounter.getNextRetryDelayMillis() + "> ms for next retry number <" + theRetryCounter.getRetryCount() + "> (of <" + theRetryCounter.getRetryNumber() + "> altogether).");
            theRetryCounter.nextRetry();
        }
        int theLogLineQueueSize = this._logLineQueue.size();
        if (theLogLineQueueSize != 0) {
            LOGGER.log(Level.WARNING, "The logline queue was not empty (with size <" + theLogLineQueueSize + ">) upon destroying this component.");
        }
    }

    private void init(ExecutorService aExecutorService, Logger<T> aLogger) {
        if (this._isInitialized) {
            throw new IllegalStateException("Unable re-initialize the asynchronous logger after it already has been initialized with a eunning logger!");
        }
        if (aLogger == null) {
            throw new IllegalArgumentException("Unable to construct the asynchronous logger as there must at least one logger instance provided!");
        }
        this._logLineQueue = new LinkedBlockingQueue(1000);
        LogDaemon theDaemon = new LogDaemon(aLogger);
        aExecutorService.execute(theDaemon);
        this._isInitialized = true;
    }

    @Override
    public void setLogger(Logger<T> aLogger) {
        this.init(ControlFlowUtility.createCachedExecutorService(true), aLogger);
    }

    private static class SeparatorRecord<T>
    extends RecordImpl<T> {
        private SeparatorRecord() {
        }
    }

    private class LogDaemon
    extends Thread {
        private final Logger<T> _logger;

        public LogDaemon(Logger<T> aLogger) {
            this._logger = aLogger;
            this.setDaemon(true);
            this.setPriority(5);
        }

        @Override
        public void run() {
            Record eRecord = null;
            while (!AsyncLogger.this._logLineQueue.isEmpty() || !AsyncLogger.this._isDestroyed) {
                try {
                    eRecord = AsyncLogger.this._logLineQueue.take();
                    if (eRecord == AsyncLogger.this._separator) {
                        this._logger.printSeparator();
                        continue;
                    }
                    this._logger.log(eRecord);
                }
                catch (InterruptedException e) {
                    break;
                }
                catch (IllegalRecordRuntimeException e) {
                    LOGGER.log(Level.WARNING, "As of an illegal record, the daemon is unable to log the log line \"" + String.valueOf(eRecord) + "\" as of: " + Trap.asMessage(e), e);
                }
                catch (UnexpectedLogRuntimeException e) {
                    LOGGER.log(Level.WARNING, "As of an unexpected log exception, the daemon is unable to log the log line \"" + String.valueOf(eRecord) + "\" as of: " + Trap.asMessage(e), e);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "As of an unrecognized exception, the daemon is unable to log the log line \"" + String.valueOf(eRecord) + "\" as of: " + Trap.asMessage(e), e);
                }
            }
        }
    }
}

