/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.IOException;
import java.io.Serializable;
import org.refcodes.component.Closable;
import org.refcodes.component.Flushable;
import org.refcodes.io.AbstractDatagramsTransmitter;
import org.refcodes.io.DatagramsSource;

public class TransmitterDecorator<DATA extends Serializable>
extends AbstractDatagramsTransmitter<DATA> {
    private final DatagramsSource<DATA> _consumer;

    public TransmitterDecorator(DatagramsSource<DATA> aConsumer) {
        this._consumer = aConsumer;
        try {
            this.open();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void transmit(DATA aDatagram) throws IOException {
        this._consumer.transmit(aDatagram);
    }

    @Override
    public void transmit(DATA[] aDatagrams) throws IOException {
        this._consumer.transmit(aDatagrams);
    }

    @Override
    public void transmit(DATA[] aDatagrams, int aOffset, int aLength) throws IOException {
        this._consumer.transmit((Serializable[])aDatagrams, aOffset, aLength);
    }

    @Override
    public void flush() throws IOException {
        if (this._consumer instanceof Flushable) {
            ((Flushable)((Object)this._consumer)).flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this._consumer instanceof Closable) {
            ((Closable)((Object)this._consumer)).close();
        }
        super.close();
    }
}

