/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.EOFException;
import java.io.IOException;
import org.refcodes.component.AbstractConnectableAutomaton;
import org.refcodes.component.ConnectionStatus;
import org.refcodes.io.AbstractShortsDestination;
import org.refcodes.io.ShortsReceiver;

public abstract class AbstractShortsReceiver
extends AbstractShortsDestination
implements ShortsReceiver {
    protected ConnectableAutomaton _automaton = new ConnectableAutomaton();

    public AbstractShortsReceiver() {
    }

    public AbstractShortsReceiver(int aCapacity) {
        super(aCapacity);
    }

    @Override
    public short receiveShort() throws IOException {
        if (this._datagramQueue.isEmpty() && this.isClosed()) {
            throw new EOFException("Connection is closed and no (more) data is available (connection status is <" + String.valueOf((Object)this.getConnectionStatus()) + ">).");
        }
        if (this._datagramQueue.isEmpty() && !this.isOpened()) {
            throw new IOException("Unable to read datagram  as the connection is NOT OPEN (connection status is " + String.valueOf((Object)this.getConnectionStatus()) + ").");
        }
        return super.receiveShort();
    }

    @Override
    public short[] receiveAllShorts() throws IOException {
        if (this._datagramQueue.isEmpty() && this.isClosed()) {
            throw new EOFException("Connection is closed and no (more) data is available (connection status is <" + String.valueOf((Object)this.getConnectionStatus()) + ">).");
        }
        if (this._datagramQueue.isEmpty() && !this.isOpened()) {
            throw new IOException("Unable to read datagram  as the connection is NOT OPEN (connection status is " + String.valueOf((Object)this.getConnectionStatus()) + ").");
        }
        return super.receiveAllShorts();
    }

    @Override
    public short[] receiveShorts(int aLength) throws IOException {
        if (this._datagramQueue.isEmpty() && this.isClosed()) {
            throw new EOFException("Connection is closed and no (more) data is available (connection status is <" + String.valueOf((Object)this.getConnectionStatus()) + ">).");
        }
        if (this._datagramQueue.isEmpty() && !this.isOpened()) {
            throw new IOException("Unable to read datagram  as the connection is NOT OPEN (connection status is " + String.valueOf((Object)this.getConnectionStatus()) + ").");
        }
        return super.receiveShorts(aLength);
    }

    @Override
    public int available() throws IOException {
        return this._datagramQueue.size();
    }

    @Override
    public void close() throws IOException {
        if (this.isOpened()) {
            this._automaton.close();
        }
    }

    @Override
    public boolean isOpened() {
        return this._automaton.isOpened();
    }

    @Override
    public boolean isClosable() {
        return this._automaton.isClosable();
    }

    @Override
    public boolean isClosed() {
        return this._automaton.isClosed();
    }

    @Override
    public ConnectionStatus getConnectionStatus() {
        return this._automaton.getConnectionStatus();
    }

    protected void open() throws IOException {
        this._automaton.open();
    }

    protected void setConnectionStatus(ConnectionStatus aConnectionStatus) {
        this._automaton.setConnectionStatus(aConnectionStatus);
    }

    protected boolean isOpenable() {
        return this._automaton.isOpenable();
    }

    protected static class ConnectableAutomaton
    extends AbstractConnectableAutomaton {
        protected ConnectableAutomaton() {
        }

        @Override
        public boolean isOpenable() {
            return super.isOpenable();
        }

        @Override
        public void open() throws IOException {
            super.open();
        }

        @Override
        public void setConnectionStatus(ConnectionStatus aConnectionStatus) {
            super.setConnectionStatus(aConnectionStatus);
        }
    }
}

