/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.graphical;

public enum ColorDepth {
    MONOCHROME_1_BIT(1, 1, 1, 1, 1, 0, true),
    GRAYSCALE_8_BIT(8, 1, 8, 8, 8, 0, true),
    MSX_8_BIT(8, 1, 3, 3, 2, 0, false),
    HIGH_COLOR_16_BIT(16, 2, 5, 6, 5, 0, false),
    TRUE_COLOR_24_BIT(24, 3, 8, 8, 8, 0, false),
    AWT_COLOR_24_BIT(24, 3, 8, 8, 8, 0, false),
    TRUE_COLOR_32_BIT(32, 4, 8, 8, 8, 8, false);

    private int _bits;
    private int _bytes;
    private int _redBits;
    private int _greenBits;
    private int _blueBits;
    private int _alphaBits;
    private int _maxValue;
    private int _maxRedValue;
    private int _maxGreenValue;
    private int _maxBlueValue;
    private int _maxAlphaValue;
    private boolean _isMonochrome;

    private ColorDepth(int aBits, int aBytes, int aRedBits, int aGreenBits, int aBlueBits, int aAlphaBits, boolean isMonochrome) {
        this._bits = aBits;
        this._bytes = aBytes;
        this._redBits = aRedBits;
        this._greenBits = aGreenBits;
        this._blueBits = aBlueBits;
        this._alphaBits = aAlphaBits;
        this._maxValue = (int)(Math.pow(2.0, aBits) - 1.0);
        this._maxRedValue = (int)(Math.pow(2.0, aRedBits) - 1.0);
        this._maxGreenValue = (int)(Math.pow(2.0, aGreenBits) - 1.0);
        this._maxBlueValue = (int)(Math.pow(2.0, aBlueBits) - 1.0);
        this._maxAlphaValue = (int)(Math.pow(2.0, aAlphaBits) - 1.0);
        this._isMonochrome = isMonochrome;
    }

    public int getBits() {
        return this._bits;
    }

    public int getBytes() {
        return this._bytes;
    }

    public int getRedBits() {
        return this._redBits;
    }

    public int getGreenBits() {
        return this._greenBits;
    }

    public int getBlueBits() {
        return this._blueBits;
    }

    public int getAlphaBits() {
        return this._alphaBits;
    }

    public int getMaxValue() {
        return this._maxValue;
    }

    public int getMaxRedValue() {
        return this._maxRedValue;
    }

    public int getMaxGreenValue() {
        return this._maxGreenValue;
    }

    public int getMaxBlueValue() {
        return this._maxBlueValue;
    }

    public int getMaxAlphaValue() {
        return this._maxAlphaValue;
    }

    public boolean isMonochrome() {
        return this._isMonochrome;
    }

    public int toAlphaValue(int aColorValue) {
        if (this.isMonochrome()) {
            return this.getMaxAlphaValue();
        }
        int shiftRight = this.getGreenBits() + this.getGreenBits() + this.getBlueBits();
        return aColorValue >> shiftRight & this.getMaxAlphaValue();
    }

    public int toRedValue(int aColorValue) {
        if (this.isMonochrome()) {
            return aColorValue;
        }
        int shiftRight = this.getGreenBits() + this.getBlueBits();
        int shifted = aColorValue >> shiftRight;
        return shifted & this.getMaxRedValue();
    }

    public int toGreenValue(int aColorValue) {
        if (this.isMonochrome()) {
            return aColorValue;
        }
        int shiftRight = this.getBlueBits();
        return aColorValue >> shiftRight & this.getMaxGreenValue();
    }

    public int toBlueValue(int aColorValue) {
        if (this.isMonochrome()) {
            return aColorValue;
        }
        return aColorValue & this.getMaxBlueValue();
    }

    public int toColor(int aColor, ColorDepth aColorDepth) {
        if (aColorDepth == this) {
            return aColor;
        }
        float theAlphaValue = aColorDepth.getMaxAlphaValue() != 0 ? (float)aColorDepth.toAlphaValue(aColor) / (float)aColorDepth.getMaxAlphaValue() * (float)this.getMaxAlphaValue() : 0.0f;
        float theRedValue = aColorDepth.getMaxRedValue() != 0 ? (float)aColorDepth.toRedValue(aColor) / (float)aColorDepth.getMaxRedValue() * (float)this.getMaxRedValue() : 0.0f;
        float theGreenValue = aColorDepth.getMaxGreenValue() != 0 ? (float)aColorDepth.toGreenValue(aColor) / (float)aColorDepth.getMaxGreenValue() * (float)this.getMaxGreenValue() : 0.0f;
        float theBlueValue = aColorDepth.getMaxBlueValue() != 0 ? (float)aColorDepth.toBlueValue(aColor) / (float)aColorDepth.getMaxBlueValue() * (float)this.getMaxBlueValue() : 0.0f;
        int theColor = (int)theAlphaValue;
        theColor = theColor << this.getRedBits() | (int)theRedValue;
        theColor = theColor << this.getGreenBits() | (int)theGreenValue;
        theColor = theColor << this.getBlueBits() | (int)theBlueValue;
        return theColor;
    }
}

