/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.generator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.refcodes.generator.BufferedGenerator;
import org.refcodes.mixin.DecorateeAccessor;
import org.refcodes.mixin.Disposable;

public class ThreadLocalBufferedGeneratorDecorator<T>
implements BufferedGenerator<T>,
DecorateeAccessor<Iterator<T>>,
Disposable {
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    private final ThreadLocal<List<T>> _threadBuffer = new ThreadLocal();
    private Iterator<T> _decoratee;
    private int _bufferSize;
    private boolean _isSuspended = false;
    private boolean _isDisposed = false;

    public ThreadLocalBufferedGeneratorDecorator(Iterator<T> aDecoratee) {
        this(aDecoratee, 1024);
    }

    public ThreadLocalBufferedGeneratorDecorator(Iterator<T> aDecoratee, int aBufferSize) {
        this._decoratee = aDecoratee;
        this._bufferSize = aBufferSize;
    }

    @Override
    public boolean hasNext() {
        List<T> theLocalBuffer = this.getLocalBuffer();
        if (this._isDisposed) {
            theLocalBuffer.clear();
        }
        return !theLocalBuffer.isEmpty();
    }

    @Override
    public T next() {
        List<T> theLocalBuffer = this.getLocalBuffer();
        if (!theLocalBuffer.isEmpty() && !this._isDisposed) {
            return theLocalBuffer.remove(0);
        }
        if (this._isDisposed) {
            theLocalBuffer.clear();
        }
        throw new NoSuchElementException("No more elements left in the underlying generator <" + String.valueOf(this._decoratee) + ">!");
    }

    @Override
    public void remove() {
        List<T> theLocalBuffer = this.getLocalBuffer();
        if (!theLocalBuffer.isEmpty()) {
            theLocalBuffer.remove(0);
        } else {
            this._decoratee.remove();
        }
    }

    @Override
    public void suspend() {
        this._isSuspended = true;
    }

    @Override
    public Iterator<T> getDecoratee() {
        return this._decoratee;
    }

    @Override
    public void dispose() {
        this._isDisposed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<T> getLocalBuffer() {
        List<T> theLocalBuffer = this._threadBuffer.get();
        if (theLocalBuffer == null || theLocalBuffer.isEmpty()) {
            if (theLocalBuffer == null) {
                theLocalBuffer = new ArrayList<T>();
                this._threadBuffer.set(theLocalBuffer);
            }
            if (!this._isSuspended) {
                ThreadLocalBufferedGeneratorDecorator threadLocalBufferedGeneratorDecorator = this;
                synchronized (threadLocalBufferedGeneratorDecorator) {
                    for (int i = 0; i < this._bufferSize && this._decoratee.hasNext(); ++i) {
                        theLocalBuffer.add(this._decoratee.next());
                    }
                }
            }
        }
        return theLocalBuffer;
    }
}

