/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.generator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.refcodes.generator.Generator;
import org.refcodes.generator.SeriesMonitor;

public class SeriesMonitorDecorator<T>
implements SeriesMonitor<T> {
    private final Generator<T> _decoratee;
    private final List<T> _generated = new ArrayList<T>();
    private final List<Boolean> _processed = new ArrayList<Boolean>();
    private T _lastProcessed = null;

    public SeriesMonitorDecorator(Generator<T> aDecoratee) {
        this._decoratee = aDecoratee;
    }

    @Override
    public void remove() {
        this._decoratee.remove();
    }

    @Override
    public boolean hasNext() {
        return this._decoratee.hasNext();
    }

    @Override
    public T next() {
        T e = this._decoratee.next();
        this._generated.add(e);
        this._processed.add(false);
        return e;
    }

    @Override
    public void forEachRemaining(Consumer<? super T> aAction) {
        this._decoratee.forEachRemaining(aAction);
    }

    @Override
    public boolean markAsProcessed(T aId) {
        int index = this._generated.indexOf(aId);
        if (index != -1) {
            this._processed.set(index, true);
        }
        Iterator<Boolean> e = this._processed.iterator();
        while (e.hasNext() && e.next().booleanValue()) {
            this._lastProcessed = this._generated.remove(0);
            e.remove();
        }
        return index != -1;
    }

    @Override
    public T lastProcessed() {
        return this._lastProcessed;
    }

    @Override
    public void clear() {
        this._generated.clear();
        this._processed.clear();
    }

    boolean isEmpty() {
        return this._generated.isEmpty() & this._processed.isEmpty();
    }
}

