/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.generator;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.refcodes.data.CharSet;
import org.refcodes.data.EscapeCode;

public class AlphabetCounterMetrics {
    private static final char LENGTH_SEPARATOR = '-';
    private static final char EXPRESSION_SEPARATOR = ',';
    private static final String SECTION_SEPARATOR = ":";
    private static final String LENGTH_BEGIN = "[";
    private static final String LENGTH_END = "]";
    private static final String ALPHABET_BEGIN = "{";
    private static final String ALPHABET_END = "}";
    private static final String WORD_BEGIN = "\"";
    private static final String WORD_END = "\"";
    private static final String ALT_WORD_BEGIN = "'";
    private static final String ALT_WORD_END = "'";
    private static final String WORDS_BEGIN = "(";
    private static final String WORDS_END = ")";
    private static final String WORDS_FILES_BEGIN = "<";
    private static final String WORDS_FILES_END = ">";
    private static final String UTF_CODEPOINT_PREFIX = "U+";
    protected String _startValue = null;
    protected String[] _words = null;
    protected char[] _alphabet = null;
    protected File[] _wordsFiles = null;
    protected InputStream[] _wordsStreams = null;
    protected int _minLength = 0;
    protected int _maxLength = -1;
    protected String _alphabetExpression;

    protected AlphabetCounterMetrics() {
    }

    public AlphabetCounterMetrics(String ... aWords) {
        this((String)null, aWords);
    }

    public AlphabetCounterMetrics(String aStartValue, String[] aWords) {
        if (aWords == null | aWords.length == 0) {
            throw new IllegalArgumentException("You must provide an array of words instead of " + (aWords == null ? "<null>" : "an empty <{}> array!"));
        }
        AlphabetCounterMetrics.validateStartValue(aStartValue, aWords);
        this._startValue = aStartValue;
        this._alphabetExpression = AlphabetCounterMetrics.toAlphabetExpression(aStartValue, aWords);
        this._words = aWords;
        this.initWords();
    }

    public AlphabetCounterMetrics(File ... aWordsFiles) throws FileNotFoundException {
        this((String)null, aWordsFiles);
    }

    public AlphabetCounterMetrics(String aStartValue, File ... aWordsFiles) throws FileNotFoundException {
        if (aWordsFiles == null | aWordsFiles.length == 0) {
            throw new IllegalArgumentException("You must provide an array of words files instead of " + (aWordsFiles == null ? "<null>" : "an empty <{}> array!"));
        }
        this._startValue = aStartValue;
        this._alphabetExpression = AlphabetCounterMetrics.toAlphabetExpression(aStartValue, aWordsFiles);
        this._wordsFiles = aWordsFiles;
        if (this._wordsFiles != null && this._wordsFiles.length != 0) {
            this._wordsStreams = new FileInputStream[this._wordsFiles.length];
            for (int i = 0; i < this._wordsFiles.length; ++i) {
                this._wordsStreams[i] = new FileInputStream(this._wordsFiles[i]);
            }
        }
    }

    public AlphabetCounterMetrics(String aAlphabetExpression) throws ParseException {
        this.parseAlphabetExpression(aAlphabetExpression);
    }

    public AlphabetCounterMetrics(int aMinLength, int aMaxLength, char ... aAlphabet) {
        this(null, aMinLength, aMaxLength, aAlphabet);
    }

    public AlphabetCounterMetrics(String aStartValue, int aMinLength, int aMaxLength, char ... aAlphabet) {
        if (aStartValue != null) {
            AlphabetCounterMetrics.validateStartValue(aStartValue, aMinLength, aMaxLength, aAlphabet);
        }
        this._alphabet = aAlphabet;
        this._minLength = aMinLength;
        this._maxLength = aMaxLength;
        this._startValue = aStartValue;
        this._alphabetExpression = AlphabetCounterMetrics.toAlphabetExpression(aStartValue, aMinLength, aMaxLength, aAlphabet);
    }

    public String[] getWords() {
        return this._words;
    }

    public File[] getWordsFiles() {
        return this._wordsFiles;
    }

    public InputStream[] getWordsStreams() {
        return this._wordsStreams;
    }

    public char[] getAlphabet() {
        return this._alphabet;
    }

    public String getStartValue() {
        return this._startValue;
    }

    public int getMinLength() {
        return this._minLength;
    }

    public int getMaxLength() {
        return this._maxLength;
    }

    public String toAlphabetExpression() {
        return this._alphabetExpression;
    }

    public static String toAlphabetExpression(String aStartValue, String[] aWords) {
        Object theAlphabetExpression = WORDS_BEGIN;
        if (aWords != null && aWords.length != 0) {
            for (int i = 0; i < aWords.length; ++i) {
                String eWordEnd;
                String eWordBegin;
                if (aWords[i].contains("\"")) {
                    eWordBegin = "'";
                    eWordEnd = "'";
                } else {
                    eWordBegin = "\"";
                    eWordEnd = "\"";
                }
                theAlphabetExpression = (String)theAlphabetExpression + eWordBegin + aWords[i] + eWordEnd + String.valueOf(i < aWords.length - 1 ? Character.valueOf(',') : "");
            }
        }
        theAlphabetExpression = (String)theAlphabetExpression + WORDS_END;
        if (aStartValue != null) {
            theAlphabetExpression = (String)theAlphabetExpression + (((String)theAlphabetExpression).isEmpty() ? "\"" : ":\"");
            theAlphabetExpression = (String)theAlphabetExpression + aStartValue + "\"";
        }
        return theAlphabetExpression;
    }

    public static String toAlphabetExpression(String aStartValue, InputStream[] aWordsStreams) throws IOException {
        FileInputStream theFileInput;
        InputStream inputStream;
        Object theAlphabetExpression = WORDS_FILES_BEGIN;
        if (aWordsStreams == null || aWordsStreams.length != 1 || !((inputStream = aWordsStreams[0]) instanceof FileInputStream) || FileDescriptor.in.equals((theFileInput = (FileInputStream)inputStream).getFD())) {
            // empty if block
        }
        theAlphabetExpression = (String)theAlphabetExpression + WORDS_FILES_END;
        if (aStartValue != null) {
            theAlphabetExpression = (String)theAlphabetExpression + (((String)theAlphabetExpression).isEmpty() ? "\"" : ":\"");
            theAlphabetExpression = (String)theAlphabetExpression + aStartValue + "\"";
        }
        return theAlphabetExpression;
    }

    public static String toAlphabetExpression(String aStartValue, File[] aWordsFiles) {
        Object theAlphabetExpression = WORDS_FILES_BEGIN;
        if (aWordsFiles != null && aWordsFiles.length != 0) {
            for (int i = 0; i < aWordsFiles.length; ++i) {
                String eWordEnd;
                String eWordBegin;
                if (aWordsFiles[i].getAbsolutePath().contains("\"")) {
                    eWordBegin = "'";
                    eWordEnd = "'";
                } else {
                    eWordBegin = "\"";
                    eWordEnd = "\"";
                }
                theAlphabetExpression = (String)theAlphabetExpression + eWordBegin + aWordsFiles[i].getAbsolutePath() + eWordEnd + String.valueOf(i < aWordsFiles.length - 1 ? Character.valueOf(',') : "");
            }
        }
        theAlphabetExpression = (String)theAlphabetExpression + WORDS_FILES_END;
        if (aStartValue != null) {
            theAlphabetExpression = (String)theAlphabetExpression + (((String)theAlphabetExpression).isEmpty() ? "\"" : ":\"");
            theAlphabetExpression = (String)theAlphabetExpression + aStartValue + "\"";
        }
        return theAlphabetExpression;
    }

    public static String toAlphabetExpression(String aStartValue, int aMinLength, int aMaxLength, char ... aAlphabet) {
        Object theAlphabetExpression = "";
        if (aAlphabet != null && aAlphabet.length != 0) {
            theAlphabetExpression = aMinLength != -1 ? LENGTH_BEGIN + aMinLength + "-" + aMaxLength + LENGTH_END : "";
            theAlphabetExpression = (String)theAlphabetExpression + (((String)theAlphabetExpression).isEmpty() ? ALPHABET_BEGIN : ":{");
            for (int i = 0; i < aAlphabet.length; ++i) {
                char eChar = aAlphabet[i];
                if (eChar < ' ' || eChar == '\u007f') {
                    Object eHex = Integer.toHexString(eChar);
                    while (((String)eHex).length() < 4) {
                        eHex = "0" + (String)eHex;
                    }
                    theAlphabetExpression = (String)theAlphabetExpression + UTF_CODEPOINT_PREFIX + (String)eHex;
                } else {
                    theAlphabetExpression = (String)theAlphabetExpression + eChar;
                }
                if (i >= aAlphabet.length - 1) continue;
                theAlphabetExpression = (String)theAlphabetExpression + ",";
            }
            theAlphabetExpression = (String)theAlphabetExpression + ALPHABET_END;
        }
        if (aStartValue != null && aStartValue.length() != 0) {
            theAlphabetExpression = (String)theAlphabetExpression + (((String)theAlphabetExpression).isEmpty() ? "\"" : ":\"");
            theAlphabetExpression = (String)theAlphabetExpression + aStartValue + "\"";
        }
        return theAlphabetExpression;
    }

    public String toString() {
        return AlphabetCounterMetrics.toAlphabetExpression(this._startValue, this._minLength, this._maxLength, this._alphabet);
    }

    static void validateStartValue(String aStartValue, int aMinLength, int aMaxLength, char ... aAlphabet) {
        if (aStartValue.length() < aMinLength || aMaxLength != -1 && aStartValue.length() > aMaxLength) {
            throw new IllegalArgumentException("The length <" + aStartValue.length() + "> of the start value must be between <" + aMinLength + "> and <" + String.valueOf(aMaxLength != -1 ? Integer.valueOf(aMaxLength) : "\u221e") + ">!");
        }
        block0: for (int i = 0; i < aStartValue.length(); ++i) {
            for (char anAAlphabet : aAlphabet) {
                if (aStartValue.charAt(i) == anAAlphabet) continue block0;
            }
            throw new IllegalArgumentException("The provided start value \"" + aStartValue + "\" must only contain values found in the alphabet <" + Arrays.toString(aAlphabet) + "> !");
        }
    }

    static void validateStartValue(String aStartValue, String[] aWords) {
        block3: {
            if (aStartValue != null) {
                for (String eWord : aWords) {
                    if (!eWord.equals(aStartValue)) {
                        continue;
                    }
                    break block3;
                }
                throw new IllegalArgumentException("The start value \"" + aStartValue + "\" is not contained in the words list " + Arrays.toString(aWords) + "!");
            }
        }
    }

    protected void parseAlphabetExpression(String aAlphabetExpression) throws ParseException {
        block11: {
            String theExpectedExpression;
            if (aAlphabetExpression == null || aAlphabetExpression.isEmpty()) {
                throw new IllegalArgumentException("The alphabet expression must not be " + (aAlphabetExpression == null ? "<null>" : "an empty string") + "!");
            }
            String theWordsSection = AlphabetCounterMetrics.toSection(aAlphabetExpression, WORDS_BEGIN, WORDS_END, SECTION_SEPARATOR);
            String theWordsFilesSection = AlphabetCounterMetrics.toSection(aAlphabetExpression, WORDS_FILES_BEGIN, WORDS_FILES_END, SECTION_SEPARATOR);
            String theLengthSection = AlphabetCounterMetrics.toSection(aAlphabetExpression, LENGTH_BEGIN, LENGTH_END, SECTION_SEPARATOR);
            String theAlphabetSection = AlphabetCounterMetrics.toSection(aAlphabetExpression, ALPHABET_BEGIN, ALPHABET_END, SECTION_SEPARATOR);
            String theStartValueSection = AlphabetCounterMetrics.toSection(aAlphabetExpression, "\"", "\"", SECTION_SEPARATOR);
            if (theStartValueSection == null || theStartValueSection.isEmpty()) {
                theStartValueSection = AlphabetCounterMetrics.toSection(aAlphabetExpression, "'", "'", SECTION_SEPARATOR);
            }
            if (!(theExpectedExpression = AlphabetCounterMetrics.toAltAlphabetExpression(theLengthSection, theAlphabetSection, theStartValueSection, theWordsSection, theWordsFilesSection)).equals(aAlphabetExpression) && !(theExpectedExpression = AlphabetCounterMetrics.toAlphabetExpression(theLengthSection, theAlphabetSection, theStartValueSection, theWordsSection, theWordsFilesSection)).equals(aAlphabetExpression)) {
                for (int i = 0; i < theExpectedExpression.length() && i < aAlphabetExpression.length(); ++i) {
                    if (theExpectedExpression.charAt(i) == aAlphabetExpression.charAt(i)) continue;
                    throw new ParseException("Unexpected character '" + aAlphabetExpression.charAt(i) + "' at position <" + i + "> of the alphabet \"" + aAlphabetExpression + "\" (expected a '" + theExpectedExpression.charAt(i) + "' character)!", i);
                }
                if (aAlphabetExpression.length() > theExpectedExpression.length()) {
                    throw new ParseException("Unexpected '" + aAlphabetExpression.substring(theExpectedExpression.length()) + "' beginning at position <" + theExpectedExpression.length() + "> of the alphabet \"" + aAlphabetExpression + "\"!", theExpectedExpression.length());
                }
                throw new ParseException("Expected '" + theExpectedExpression.substring(aAlphabetExpression.length()) + "' at position <" + aAlphabetExpression.length() + "> of the alphabet \"" + aAlphabetExpression + "\"!", aAlphabetExpression.length());
            }
            if (theLengthSection == null && theAlphabetSection == null && theStartValueSection == null && theWordsSection == null && theWordsFilesSection == null) {
                throw new ParseException("Encountered an invalid alphabet expression \"" + aAlphabetExpression + "\"!", 0);
            }
            if (theLengthSection == null && theAlphabetSection == null && theStartValueSection != null) {
                this._maxLength = theStartValueSection.length();
                this._minLength = theStartValueSection.length();
            }
            if (theLengthSection != null && theAlphabetSection == null) {
                throw new ParseException("No alphabet declared in alphabet expression \"" + aAlphabetExpression + "\"!", aAlphabetExpression.length());
            }
            this.parseLength(theLengthSection, aAlphabetExpression);
            this.parseAlphabet(theAlphabetSection, aAlphabetExpression);
            this.parseStartValue(theStartValueSection);
            this.parseWords(theWordsSection, aAlphabetExpression);
            this.parseWordsFiles(theWordsFilesSection, aAlphabetExpression);
            if (this._startValue != null && this._words != null) {
                for (String eWord : this._words) {
                    if (!eWord.equals(this._startValue)) {
                        continue;
                    }
                    break block11;
                }
                int index = aAlphabetExpression.indexOf(theStartValueSection);
                throw new ParseException("The start value \"" + this._startValue + "\" is not contained in the words list " + Arrays.toString(this._words) + " at position <" + index + "> of the alphabet \"" + aAlphabetExpression + "\"!", index);
            }
        }
        this._alphabetExpression = this._wordsFiles != null && this._wordsFiles.length != 0 ? AlphabetCounterMetrics.toAlphabetExpression(this._startValue, this._wordsFiles) : aAlphabetExpression;
    }

    private void parseWordsFiles(String aWordsFilesDeclaration, String aAlphabetExpression) throws ParseException {
        if (aWordsFilesDeclaration != null) {
            int eEndIndex;
            int theOffset = aAlphabetExpression.indexOf(aWordsFilesDeclaration);
            ArrayList<String> theWordsFiles = new ArrayList<String>();
            int eDelimiterIndex = -1;
            do {
                String eWordEnd = "\"";
                int eStartIndex = aWordsFilesDeclaration.indexOf("\"", eDelimiterIndex + 1);
                if (eStartIndex != eDelimiterIndex + 1) {
                    eWordEnd = "'";
                    eStartIndex = aWordsFilesDeclaration.indexOf("'", eDelimiterIndex + 1);
                    if (eStartIndex != eDelimiterIndex + 1) {
                        throw new ParseException("Expecting a '\"' or a  a ''' symbol at position <" + (theOffset + eDelimiterIndex + 1) + ">  for the words declaration \"" + aWordsFilesDeclaration + "\" of the alphabet \"" + aAlphabetExpression + "\"!", theOffset + eDelimiterIndex + 1);
                    }
                }
                if ((eEndIndex = aWordsFilesDeclaration.indexOf(eWordEnd, ++eStartIndex)) == -1 && (eEndIndex = aWordsFilesDeclaration.indexOf(eWordEnd, eStartIndex)) == -1) {
                    throw new ParseException("Expecting a '" + eWordEnd + "' symbol after  position <" + (theOffset + eStartIndex) + ">  for the words files declaration \"" + aWordsFilesDeclaration + "\" of the alphabet \"" + aAlphabetExpression + "\"!", theOffset + eStartIndex);
                }
                theWordsFiles.add(aWordsFilesDeclaration.substring(eStartIndex, eEndIndex));
            } while ((eDelimiterIndex = aWordsFilesDeclaration.indexOf(44, eEndIndex)) != -1);
            String[] theWordsFilePaths = theWordsFiles.toArray(new String[theWordsFiles.size()]);
            if (theWordsFilePaths != null && theWordsFilePaths.length != 0) {
                this._wordsFiles = new File[theWordsFilePaths.length];
                this._wordsStreams = new InputStream[theWordsFilePaths.length];
                for (int i = 0; i < theWordsFilePaths.length; ++i) {
                    this._wordsFiles[i] = new File(theWordsFilePaths[i]);
                    try {
                        this._wordsStreams[i] = new FileInputStream(this._wordsFiles[i]);
                        continue;
                    }
                    catch (FileNotFoundException e) {
                        throw new ParseException("File <" + theWordsFilePaths[i] + "> from the words files declaration \"" + aWordsFilesDeclaration + "\" of the alphabet \"" + aAlphabetExpression + "\" not found!", aAlphabetExpression.indexOf(theWordsFilePaths[i]));
                    }
                }
            }
        }
    }

    private void parseWords(String aWordsDeclaration, String aAlphabetExpression) throws ParseException {
        if (aWordsDeclaration != null) {
            int eEndIndex;
            int theOffset = aAlphabetExpression.indexOf(aWordsDeclaration);
            ArrayList<String> theWords = new ArrayList<String>();
            int eDelimiterIndex = -1;
            do {
                String eWordEnd = "\"";
                int eStartIndex = aWordsDeclaration.indexOf("\"", eDelimiterIndex + 1);
                if (eStartIndex != eDelimiterIndex + 1) {
                    eWordEnd = "'";
                    eStartIndex = aWordsDeclaration.indexOf("'", eDelimiterIndex + 1);
                    if (eStartIndex != eDelimiterIndex + 1) {
                        throw new ParseException("Expecting a '\"' or a  a ''' symbol at position <" + (theOffset + eDelimiterIndex + 1) + ">  for the words declaration \"" + aWordsDeclaration + "\" of the alphabet \"" + aAlphabetExpression + "\"!", theOffset + eDelimiterIndex + 1);
                    }
                }
                if ((eEndIndex = aWordsDeclaration.indexOf(eWordEnd, ++eStartIndex)) == -1 && (eEndIndex = aWordsDeclaration.indexOf(eWordEnd, eStartIndex)) == -1) {
                    throw new ParseException("Expecting a '" + eWordEnd + "' symbol after  position <" + (theOffset + eStartIndex) + ">  for the words declaration \"" + aWordsDeclaration + "\" of the alphabet \"" + aAlphabetExpression + "\"!", theOffset + eStartIndex);
                }
                theWords.add(aWordsDeclaration.substring(eStartIndex, eEndIndex));
            } while ((eDelimiterIndex = aWordsDeclaration.indexOf(44, eEndIndex)) != -1);
            this._words = theWords.toArray(new String[theWords.size()]);
            this.initWords();
        }
    }

    private void initWords() {
        if (this._words != null) {
            for (String eWord : this._words) {
                if (this._minLength == 0 || this._minLength > eWord.length()) {
                    this._minLength = eWord.length();
                }
                if (this._maxLength >= eWord.length()) continue;
                this._maxLength = eWord.length();
            }
        }
    }

    private void parseLength(String aLengthDeclaration, String aAlphabetExpression) throws ParseException {
        if (aLengthDeclaration != null) {
            int theOffset = aAlphabetExpression.indexOf(aLengthDeclaration);
            int theEndIndex = aLengthDeclaration.indexOf(45);
            if (theEndIndex == -1) {
                throw new ParseException("Expecting a '-' symbol after position <" + theOffset + "> for the lengths declaration \"" + aLengthDeclaration + "\" of the alphabet \"" + aAlphabetExpression + "\"!", theOffset);
            }
            String eSubstring = aLengthDeclaration.substring(0, theEndIndex);
            try {
                this._minLength = Integer.parseInt(eSubstring);
            }
            catch (NumberFormatException e) {
                throw new ParseException("Cannot parse min length from \"" + eSubstring + "\" at position <" + theOffset + "> for the lengths declaration \"" + aLengthDeclaration + "\" of the alphabet \"" + aAlphabetExpression + "\"!", theOffset);
            }
            int theStartIndex = theEndIndex + 1;
            eSubstring = aLengthDeclaration.substring(theStartIndex);
            try {
                this._maxLength = Integer.parseInt(eSubstring);
            }
            catch (NumberFormatException e) {
                throw new ParseException("Cannot parse max length from \"" + eSubstring + "\" at position <" + (theOffset + theStartIndex) + "> for the lengths declaration \"" + aLengthDeclaration + "\" of the alphabet \"" + aAlphabetExpression + "\"!", theOffset + theStartIndex);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseAlphabet(String aAlphabetDeclaration, String aAlphabetExpression) throws ParseException {
        int eEndIndex;
        if (aAlphabetDeclaration == null) return;
        int theOffset = aAlphabetExpression.indexOf(aAlphabetDeclaration);
        ArrayList<Character> theAlphabet = new ArrayList<Character>();
        int eBeginIndex = 0;
        do {
            if ((eEndIndex = aAlphabetDeclaration.indexOf(44, eBeginIndex)) == -1) {
                eEndIndex = aAlphabetDeclaration.length();
            }
            if (eBeginIndex == eEndIndex && eEndIndex < aAlphabetDeclaration.length() && aAlphabetDeclaration.charAt(eEndIndex) == ',') {
                if (eEndIndex != aAlphabetDeclaration.length() - 1 && (eEndIndex >= aAlphabetDeclaration.length() - 1 || aAlphabetDeclaration.charAt(eEndIndex + 1) != ',')) throw new ParseException("Expecting a value at position <" + (eEndIndex != -1 ? theOffset + eEndIndex : aAlphabetExpression.length()) + "> of declaration \"" + aAlphabetDeclaration + "\" in expression \"" + aAlphabetExpression + "\"!", theOffset + eBeginIndex);
                AlphabetCounterMetrics.addToAlphabet(theAlphabet, ',');
                ++eEndIndex;
            } else {
                String eSubstring = aAlphabetDeclaration.substring(eBeginIndex, eEndIndex);
                if (eSubstring.length() == 1) {
                    AlphabetCounterMetrics.addToAlphabet(theAlphabet, eSubstring.charAt(0));
                } else if (eSubstring.length() == 6 && eSubstring.startsWith(UTF_CODEPOINT_PREFIX)) {
                    try {
                        char[] eUtfChars;
                        int eCodepoint = Integer.parseInt(eSubstring.substring(2), 16);
                        for (char eUtfChar : eUtfChars = Character.toChars(eCodepoint)) {
                            AlphabetCounterMetrics.addToAlphabet(theAlphabet, eUtfChar);
                        }
                    }
                    catch (Exception e) {
                        throw new ParseException("Unable to parse UTF codepoint from \"" + eSubstring + "\" of expression \"" + aAlphabetDeclaration + "\" at position <" + theOffset + eBeginIndex + ">!", theOffset + eBeginIndex);
                    }
                } else if (eSubstring.length() == 3 && eSubstring.charAt(1) == '-') {
                    eRangeStart = eSubstring.charAt(0);
                    if (eRangeStart <= (eRangeEnd = eSubstring.charAt(2))) {
                        for (int i = eRangeStart; i <= eRangeEnd; ++i) {
                            AlphabetCounterMetrics.addToAlphabet(theAlphabet, (char)i);
                        }
                    } else {
                        for (int i = eRangeStart; i >= eRangeEnd; --i) {
                            AlphabetCounterMetrics.addToAlphabet(theAlphabet, (char)i);
                        }
                    }
                } else if (eSubstring.startsWith(UTF_CODEPOINT_PREFIX) && eSubstring.length() == 13 && eSubstring.charAt(6) == '-' && eSubstring.indexOf(UTF_CODEPOINT_PREFIX, 7) == 7) {
                    eRangeStart = Integer.parseInt(eSubstring.substring(2, 6), 16);
                    if (eRangeStart <= (eRangeEnd = Integer.parseInt(eSubstring.substring(9), 16))) {
                        for (int i = eRangeStart; i <= eRangeEnd; ++i) {
                            AlphabetCounterMetrics.addToAlphabet(theAlphabet, (char)i);
                        }
                    } else {
                        for (int i = eRangeStart; i >= eRangeEnd; --i) {
                            AlphabetCounterMetrics.addToAlphabet(theAlphabet, (char)i);
                        }
                    }
                } else {
                    CharSet theCharset = CharSet.toCharset(eSubstring);
                    if (theCharset != null) {
                        AlphabetCounterMetrics.addToAlphabet(theAlphabet, theCharset.getCharSet());
                    } else {
                        EscapeCode theEscape = EscapeCode.toEscapeCode(eSubstring);
                        if (theEscape == null) throw new ParseException("Expecting a value at position <" + (eEndIndex != -1 ? theOffset + eEndIndex : aAlphabetExpression.length()) + "> of declaration \"" + aAlphabetDeclaration + "\" in expression \"" + aAlphabetExpression + "\"!", theOffset + eBeginIndex);
                        AlphabetCounterMetrics.addToAlphabet(theAlphabet, theEscape.getEscapeCode());
                    }
                }
            }
            eBeginIndex = eEndIndex + 1;
        } while (eEndIndex != -1 && eEndIndex <= aAlphabetDeclaration.length() - 1);
        this._alphabet = new char[theAlphabet.size()];
        for (int i = 0; i < this._alphabet.length; ++i) {
            this._alphabet[i] = ((Character)theAlphabet.get(i)).charValue();
        }
    }

    private void parseStartValue(String aStartValueDeclaration) {
        if (aStartValueDeclaration != null && this._alphabet != null) {
            AlphabetCounterMetrics.validateStartValue(aStartValueDeclaration, this._minLength, this._maxLength, this._alphabet);
        }
        this._startValue = aStartValueDeclaration;
    }

    private static void addToAlphabet(List<Character> aAlphabet, char ... aChars) {
        for (char aChar : aChars) {
            if (aAlphabet.contains(Character.valueOf(aChar))) continue;
            aAlphabet.add(Character.valueOf(aChar));
        }
    }

    private static String toAlphabetExpression(String aLengthSection, String aAlphabetSection, String aStartValueSection, String aWordsSection, String aWordsFilesSection) {
        Object theExpextedExpression = "";
        if (aWordsSection != null) {
            theExpextedExpression = (String)theExpextedExpression + WORDS_BEGIN + aWordsSection + WORDS_END;
        }
        if (aWordsFilesSection != null) {
            theExpextedExpression = (String)theExpextedExpression + WORDS_FILES_BEGIN + aWordsFilesSection + WORDS_FILES_END;
        }
        if (aLengthSection != null) {
            theExpextedExpression = (String)theExpextedExpression + LENGTH_BEGIN + aLengthSection + LENGTH_END;
        }
        if (aAlphabetSection != null) {
            theExpextedExpression = (String)theExpextedExpression + (((String)theExpextedExpression).length() != 0 ? SECTION_SEPARATOR : "") + ALPHABET_BEGIN + aAlphabetSection + ALPHABET_END;
        }
        if (aStartValueSection != null) {
            theExpextedExpression = (String)theExpextedExpression + (((String)theExpextedExpression).length() != 0 ? SECTION_SEPARATOR : "") + "\"" + aStartValueSection + "\"";
        }
        return theExpextedExpression;
    }

    private static String toAltAlphabetExpression(String aLengthSection, String aAlphabetSection, String aStartValueSection, String aWordsSection, String aWordsFilesSection) {
        Object theExpextedExpression = "";
        if (aWordsSection != null) {
            theExpextedExpression = (String)theExpextedExpression + WORDS_BEGIN + aWordsSection + WORDS_END;
        }
        if (aWordsFilesSection != null) {
            theExpextedExpression = (String)theExpextedExpression + WORDS_FILES_BEGIN + aWordsFilesSection + WORDS_FILES_END;
        }
        if (aLengthSection != null) {
            theExpextedExpression = (String)theExpextedExpression + LENGTH_BEGIN + aLengthSection + LENGTH_END;
        }
        if (aAlphabetSection != null) {
            theExpextedExpression = (String)theExpextedExpression + (((String)theExpextedExpression).length() != 0 ? SECTION_SEPARATOR : "") + ALPHABET_BEGIN + aAlphabetSection + ALPHABET_END;
        }
        if (aStartValueSection != null) {
            theExpextedExpression = (String)theExpextedExpression + (((String)theExpextedExpression).length() != 0 ? SECTION_SEPARATOR : "") + "'" + aStartValueSection + "'";
        }
        return theExpextedExpression;
    }

    private static String toSection(String aAlphabetExpression, String aOpenSymbol, String aCloseSymbol, String aSectionSeparator) throws ParseException {
        String theOpenSection = aSectionSeparator + aOpenSymbol;
        int theStartIndex = aAlphabetExpression.indexOf(theOpenSection);
        if (theStartIndex != -1) {
            theStartIndex += theOpenSection.length();
        } else {
            theStartIndex = aAlphabetExpression.indexOf(aOpenSymbol);
            if (theStartIndex == 0) {
                theStartIndex += aOpenSymbol.length();
            } else {
                return null;
            }
        }
        String theCloseSection = aCloseSymbol + aSectionSeparator;
        int theEndIndex = aAlphabetExpression.indexOf(theCloseSection, theStartIndex);
        if (theEndIndex == -1 && ((theEndIndex = aAlphabetExpression.lastIndexOf(aCloseSymbol)) == -1 || theEndIndex != aAlphabetExpression.length() - 1)) {
            throw new ParseException("Expecting a closing symbol \"" + aCloseSymbol + "\" at position <" + theStartIndex + "> or beyond (or a missing section separator \"" + aSectionSeparator + "\") for expression \"" + aAlphabetExpression + "\"!", theStartIndex);
        }
        return aAlphabetExpression.substring(theStartIndex, theEndIndex);
    }
}

