/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.data;

import java.nio.file.Path;
import java.util.Objects;
import org.refcodes.data.Delimiter;
import org.refcodes.mixin.FilenameExtensionAccessor;
import org.refcodes.mixin.FilenameSuffixAccessor;

public enum FilenameExtension implements FilenameExtensionAccessor,
FilenameSuffixAccessor
{
    TEMP("tmp"),
    BACKUP("bak"),
    TAR("tar"),
    GZIP("gz"),
    TAR_GZIP("tgz"),
    CSV("csv"),
    TXT("txt"),
    JAR("jar"),
    ZIP("zip"),
    SH("sh"),
    CIPHER_VERSION("cv"),
    PROPERTIES("properties"),
    JSON("json"),
    TOML("toml"),
    YAML("yaml"),
    XML("xml"),
    INI("ini"),
    BASE64("base64"),
    CHAOS64("chaos64"),
    CHAOS("chaos"),
    TIFF("tiff"),
    GIF("tiff"),
    PNG("png"),
    BMP("bmp"),
    JPG("bmp"),
    DATA("dat");

    private String _extension;
    private String _suffix;

    private FilenameExtension(String aExtension) {
        this._extension = aExtension;
        this._suffix = Delimiter.FILENAME_EXTENSION.getChar() + aExtension;
    }

    @Override
    public String getFilenameSuffix() {
        return this._suffix;
    }

    @Override
    public String getFilenameExtension() {
        return this._extension;
    }

    public boolean hasFilenameExtension(Path aPath) {
        return Objects.requireNonNull(aPath, "aPath").toString().toLowerCase().endsWith(this.getFilenameSuffix());
    }

    public boolean hasFilenameExtension(String aFileName) {
        return Objects.requireNonNull(aFileName, "aPath").toLowerCase().endsWith(this.getFilenameSuffix());
    }

    public static String toRawFileNameExtension(String aFilename) {
        if (aFilename != null && aFilename.length() != 0) {
            int index = aFilename.indexOf(Delimiter.FILENAME_EXTENSION.getChar());
            if (index == 0) {
                aFilename = aFilename.substring(1);
            }
            if ((index = aFilename.indexOf(Delimiter.FILENAME_EXTENSION.getChar())) != -1) {
                aFilename = aFilename.substring(index + 1);
                while ((index = aFilename.indexOf(Delimiter.FILENAME_EXTENSION.getChar())) != -1) {
                    aFilename = aFilename.substring(index + 1);
                }
                if (aFilename.length() != 0) {
                    return aFilename;
                }
            }
        }
        return null;
    }

    public static FilenameExtension toFileNameExtension(String aFilename) {
        for (FilenameExtension eExtension : FilenameExtension.values()) {
            if (!eExtension.hasFilenameExtension(aFilename)) continue;
            return eExtension;
        }
        return null;
    }

    public static FilenameExtension toFileNameExtension(Path aPath) {
        for (FilenameExtension eExtension : FilenameExtension.values()) {
            if (!eExtension.hasFilenameExtension(aPath)) continue;
            return eExtension;
        }
        return null;
    }
}

