/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.criteria;

import java.util.Iterator;
import org.refcodes.criteria.AndCriteria;
import org.refcodes.criteria.Criteria;
import org.refcodes.criteria.CriteriaLeaf;
import org.refcodes.criteria.EqualWithCriteria;
import org.refcodes.criteria.GreaterOrEqualThanCriteria;
import org.refcodes.criteria.GreaterThanCriteria;
import org.refcodes.criteria.IntersectWithCriteria;
import org.refcodes.criteria.LessOrEqualThanCriteria;
import org.refcodes.criteria.LessThanCriteria;
import org.refcodes.criteria.NotCriteria;
import org.refcodes.criteria.NotEqualWithCriteria;
import org.refcodes.criteria.OrCriteria;
import org.refcodes.criteria.QueryFactory;
import org.refcodes.criteria.UnknownCriteriaRuntimeException;
import org.refcodes.data.Literal;
import org.refcodes.data.QuotationMark;

public class ExpressionQueryFactory
implements QueryFactory<String> {
    private static final String IS = " IS ";
    private static final String EQUAL_WITH = " = ";
    private static final String IS_NOT = " IS NOT ";
    private static final String NOT_EQUAL_WITH = " != ";
    private static final String GREATER_THAN = " > ";
    private static final String GREATER_OR_EQUAL_THAN = " >= ";
    private static final String LESS_THAN = " < ";
    private static final String LESS_OR_EQUAL_THAN = " <= ";
    private static final String AND = " AND ";
    private static final String OR = " OR ";
    private static final String NOT = "NOT ";
    private static final String INTERSECTION = " INTERSECTION ";
    private static final String SINGLE_QUOTE = "" + QuotationMark.SINGLE_QUOTE.getChar();
    private static final String DELIMITER = ", ";
    private static final String BRACE_OPEN = "( ";
    private static final String BRACE_CLOSE = " )";

    @Override
    public String fromCriteria(Criteria aCriteria) {
        return this.toQuery(aCriteria, true);
    }

    private String toQuery(NotCriteria aCriteriaNode, boolean isCriteriaTreeRoot) {
        StringBuilder theQueryBuffer = new StringBuilder();
        theQueryBuffer.append(NOT);
        Iterator<Criteria> e = aCriteriaNode.getChildren().iterator();
        while (e.hasNext()) {
            theQueryBuffer.append(this.toQuery(e.next(), false));
            if (!e.hasNext()) continue;
            theQueryBuffer.append(DELIMITER);
        }
        return theQueryBuffer.toString();
    }

    private String toQuery(AndCriteria aCriteriaNode, boolean isCriteriaTreeRoot) {
        StringBuilder theQueryBuffer = new StringBuilder();
        if (!isCriteriaTreeRoot) {
            theQueryBuffer.append(BRACE_OPEN);
        }
        Iterator<Criteria> e = aCriteriaNode.getChildren().iterator();
        while (e.hasNext()) {
            theQueryBuffer.append(this.toQuery(e.next(), false));
            if (!e.hasNext()) continue;
            theQueryBuffer.append(AND);
        }
        if (!isCriteriaTreeRoot) {
            theQueryBuffer.append(BRACE_CLOSE);
        }
        return theQueryBuffer.toString();
    }

    private String toQuery(OrCriteria aCriteriaNode, boolean isCriteriaTreeRoot) {
        StringBuilder theQueryBuffer = new StringBuilder();
        if (!isCriteriaTreeRoot) {
            theQueryBuffer.append(BRACE_OPEN);
        }
        Iterator<Criteria> e = aCriteriaNode.getChildren().iterator();
        while (e.hasNext()) {
            theQueryBuffer.append(this.toQuery(e.next(), false));
            if (!e.hasNext()) continue;
            theQueryBuffer.append(OR);
        }
        if (!isCriteriaTreeRoot) {
            theQueryBuffer.append(BRACE_CLOSE);
        }
        return theQueryBuffer.toString();
    }

    public String toQuery(IntersectWithCriteria aCriteriaNode, boolean isCriteriaTreeRoot) {
        StringBuilder theQueryBuffer = new StringBuilder();
        Iterator<Criteria> e = aCriteriaNode.getChildren().iterator();
        while (e.hasNext()) {
            theQueryBuffer.append(this.toQuery(e.next(), false));
            if (!e.hasNext()) continue;
            theQueryBuffer.append(INTERSECTION);
        }
        return theQueryBuffer.toString();
    }

    private String toQuery(EqualWithCriteria<?> aCriteriaLeaf, boolean isCriteriaTreeRoot) {
        StringBuilder theQueryBuffer = new StringBuilder();
        if (!isCriteriaTreeRoot) {
            theQueryBuffer.append(BRACE_OPEN);
        }
        theQueryBuffer.append(aCriteriaLeaf.getKey());
        if (Literal.NULL.getValue().equalsIgnoreCase(aCriteriaLeaf.getValue().toString())) {
            theQueryBuffer.append(IS);
        } else {
            theQueryBuffer.append(EQUAL_WITH);
        }
        ExpressionQueryFactory.appendCriteriaLeaf(aCriteriaLeaf, theQueryBuffer);
        if (!isCriteriaTreeRoot) {
            theQueryBuffer.append(BRACE_CLOSE);
        }
        return theQueryBuffer.toString();
    }

    private String toQuery(NotEqualWithCriteria<?> aCriteriaLeaf, boolean isCriteriaTreeRoot) {
        StringBuilder theQueryBuffer = new StringBuilder();
        if (!isCriteriaTreeRoot) {
            theQueryBuffer.append(BRACE_OPEN);
        }
        theQueryBuffer.append(aCriteriaLeaf.getKey());
        if (ExpressionQueryFactory.isNullCriteriaLeaf(aCriteriaLeaf)) {
            theQueryBuffer.append(IS_NOT);
        } else {
            theQueryBuffer.append(NOT_EQUAL_WITH);
        }
        ExpressionQueryFactory.appendCriteriaLeaf(aCriteriaLeaf, theQueryBuffer);
        if (!isCriteriaTreeRoot) {
            theQueryBuffer.append(BRACE_CLOSE);
        }
        return theQueryBuffer.toString();
    }

    private String toQuery(GreaterThanCriteria<?> aCriteriaLeaf, boolean isCriteriaTreeRoot) {
        StringBuilder theQueryBuffer = new StringBuilder();
        if (!isCriteriaTreeRoot) {
            theQueryBuffer.append(BRACE_OPEN);
        }
        theQueryBuffer.append(aCriteriaLeaf.getKey());
        theQueryBuffer.append(GREATER_THAN);
        ExpressionQueryFactory.appendCriteriaLeaf(aCriteriaLeaf, theQueryBuffer);
        if (!isCriteriaTreeRoot) {
            theQueryBuffer.append(BRACE_CLOSE);
        }
        return theQueryBuffer.toString();
    }

    private String toQuery(GreaterOrEqualThanCriteria<?> aCriteriaLeaf, boolean isCriteriaTreeRoot) {
        StringBuilder theQueryBuffer = new StringBuilder();
        if (!isCriteriaTreeRoot) {
            theQueryBuffer.append(BRACE_OPEN);
        }
        theQueryBuffer.append(aCriteriaLeaf.getKey());
        theQueryBuffer.append(GREATER_OR_EQUAL_THAN);
        ExpressionQueryFactory.appendCriteriaLeaf(aCriteriaLeaf, theQueryBuffer);
        if (!isCriteriaTreeRoot) {
            theQueryBuffer.append(BRACE_CLOSE);
        }
        return theQueryBuffer.toString();
    }

    public String toQuery(LessThanCriteria<?> aCriteriaLeaf, boolean isCriteriaTreeRoot) {
        StringBuilder theQueryBuffer = new StringBuilder();
        if (!isCriteriaTreeRoot) {
            theQueryBuffer.append(BRACE_OPEN);
        }
        theQueryBuffer.append(aCriteriaLeaf.getKey());
        theQueryBuffer.append(LESS_THAN);
        ExpressionQueryFactory.appendCriteriaLeaf(aCriteriaLeaf, theQueryBuffer);
        if (!isCriteriaTreeRoot) {
            theQueryBuffer.append(BRACE_CLOSE);
        }
        return theQueryBuffer.toString();
    }

    private String toQuery(LessOrEqualThanCriteria<?> aCriteriaLeaf, boolean isCriteriaTreeRoot) {
        StringBuilder theQueryBuffer = new StringBuilder();
        if (!isCriteriaTreeRoot) {
            theQueryBuffer.append(BRACE_OPEN);
        }
        theQueryBuffer.append(aCriteriaLeaf.getKey());
        theQueryBuffer.append(LESS_OR_EQUAL_THAN);
        ExpressionQueryFactory.appendCriteriaLeaf(aCriteriaLeaf, theQueryBuffer);
        if (!isCriteriaTreeRoot) {
            theQueryBuffer.append(BRACE_CLOSE);
        }
        return theQueryBuffer.toString();
    }

    private String toQuery(Criteria aCriteria, boolean isCriteriaTreeRoot) {
        if (aCriteria instanceof AndCriteria) {
            return this.toQuery((AndCriteria)aCriteria, isCriteriaTreeRoot);
        }
        if (aCriteria instanceof OrCriteria) {
            return this.toQuery((OrCriteria)aCriteria, isCriteriaTreeRoot);
        }
        if (aCriteria instanceof NotCriteria) {
            return this.toQuery((NotCriteria)aCriteria, isCriteriaTreeRoot);
        }
        if (aCriteria instanceof IntersectWithCriteria) {
            return this.toQuery((IntersectWithCriteria)aCriteria, isCriteriaTreeRoot);
        }
        if (aCriteria instanceof EqualWithCriteria) {
            return this.toQuery((EqualWithCriteria)aCriteria, isCriteriaTreeRoot);
        }
        if (aCriteria instanceof NotEqualWithCriteria) {
            return this.toQuery((NotEqualWithCriteria)aCriteria, isCriteriaTreeRoot);
        }
        if (aCriteria instanceof GreaterThanCriteria) {
            return this.toQuery((GreaterThanCriteria)aCriteria, isCriteriaTreeRoot);
        }
        if (aCriteria instanceof GreaterOrEqualThanCriteria) {
            return this.toQuery((GreaterOrEqualThanCriteria)aCriteria, isCriteriaTreeRoot);
        }
        if (aCriteria instanceof LessThanCriteria) {
            return this.toQuery((LessThanCriteria)aCriteria, isCriteriaTreeRoot);
        }
        if (aCriteria instanceof LessOrEqualThanCriteria) {
            return this.toQuery((LessOrEqualThanCriteria)aCriteria, isCriteriaTreeRoot);
        }
        throw new UnknownCriteriaRuntimeException("The criteria with alias \"" + aCriteria.getAlias() + "\" is unknown by this query factory.", aCriteria);
    }

    private static void appendCriteriaLeaf(CriteriaLeaf<?> aCriteriaLeaf, StringBuilder aQueryBuffer) {
        boolean isQuote;
        boolean bl = isQuote = !(aCriteriaLeaf.getValue() instanceof Number) && !ExpressionQueryFactory.isNullCriteriaLeaf(aCriteriaLeaf);
        if (isQuote) {
            aQueryBuffer.append(SINGLE_QUOTE);
        }
        if (ExpressionQueryFactory.isNullCriteriaLeaf(aCriteriaLeaf)) {
            aQueryBuffer.append(Literal.NULL.getValue().toUpperCase());
        } else {
            aQueryBuffer.append(aCriteriaLeaf.getValue());
        }
        if (isQuote) {
            aQueryBuffer.append(SINGLE_QUOTE);
        }
    }

    private static boolean isNullCriteriaLeaf(CriteriaLeaf<?> aCriteriaLeaf) {
        return aCriteriaLeaf.getValue() instanceof String && ((String)aCriteriaLeaf.getValue()).equalsIgnoreCase(Literal.NULL.getValue());
    }
}

