/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.component;

import org.refcodes.component.ResumeException;
import org.refcodes.component.RunningAccessor;

public interface Resumable {
    public void resume() throws ResumeException;

    default public void resumeUnchecked() {
        try {
            this.resume();
        }
        catch (ResumeException e) {
            throw new ResumeException.ResumeRuntimeException(e);
        }
    }

    public static interface UncheckedResumable
    extends Resumable {
        @Override
        public void resume();
    }

    public static interface ResumeBuilder<B extends ResumeBuilder<B>> {
        public B withResume() throws ResumeException;

        default public B withResumeUnchecked() {
            try {
                return this.withResume();
            }
            catch (ResumeException e) {
                throw new ResumeException.ResumeRuntimeException(e);
            }
        }
    }

    public static interface ResumeAutomaton
    extends Resumable,
    RunningAccessor {
        public boolean isResumable();
    }
}

