/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.component;

import org.refcodes.component.InitializeException;
import org.refcodes.component.InitializedAccessor;

public interface Initializable {
    public void initialize() throws InitializeException;

    default public void initializeUnchecked() {
        try {
            this.initialize();
        }
        catch (InitializeException e) {
            throw new InitializeException.InitializeRuntimeException(e);
        }
    }

    public static interface UncheckedInitializable
    extends Initializable {
        @Override
        public void initialize();
    }

    public static interface InitializeBuilder<B extends InitializeBuilder<B>> {
        public B withInitialize() throws InitializeException;

        default public B withInitializeUnchecked() {
            try {
                return this.withInitialize();
            }
            catch (InitializeException e) {
                throw new InitializeException.InitializeRuntimeException(e);
            }
        }
    }

    public static interface InitializeAutomaton
    extends Initializable,
    InitializedAccessor {
        public boolean isInitalizable();
    }
}

