/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.codec;

import org.refcodes.codec.ChannelSelector;
import org.refcodes.codec.FrequencyThreshold;
import org.refcodes.codec.ModemMetrics;
import org.refcodes.codec.ModemMode;
import org.refcodes.codec.ModulationFormat;
import org.refcodes.codec.SampleRate;

public class ModemMetricsImpl
implements ModemMetrics {
    private final SampleRate _sampleRate;
    private final ModulationFormat _modulationFormat;
    private final ChannelSelector _channelSelector;
    private final ModemMode _softModem;
    private FrequencyThreshold _frequencyThreshold;
    private final int _higherFrequencyUpperThreshold;
    private final int _lowerFrequencyUpperThreshold;
    private final int _samplesPerBit;

    public ModemMetricsImpl(SampleRate aSampleRate, ModulationFormat aModulationFormat, ChannelSelector aChannelSelector, ModemMode aModemModem, FrequencyThreshold aFrequencyThreshold) {
        if (aSampleRate.getValue() % aModemModem.getBaudRate() > 0) {
            throw new IllegalArgumentException("The provided soft modem's <" + String.valueOf(aModemModem) + "> baud rate <" + aModemModem.getBaudRate() + "> does not match with the sample rate <" + String.valueOf(aSampleRate) + "> with value <" + aSampleRate.getValue() + ">.");
        }
        this._sampleRate = aSampleRate;
        this._modulationFormat = aModulationFormat;
        this._channelSelector = aChannelSelector;
        this._softModem = aModemModem;
        this._higherFrequencyUpperThreshold = aModemModem.getHigherFrequency() + Math.round((float)(aModemModem.getHigherFrequency() * aFrequencyThreshold.getPercent()) / 100.0f);
        this._lowerFrequencyUpperThreshold = aModemModem.getLowerFrequency() + Math.round((float)(aModemModem.getLowerFrequency() * aFrequencyThreshold.getPercent()) / 100.0f);
        this._samplesPerBit = ModemMetrics.super.toSamplesPerBit();
    }

    @Override
    public SampleRate getSampleRate() {
        return this._sampleRate;
    }

    @Override
    public ModulationFormat getModulationFormat() {
        return this._modulationFormat;
    }

    @Override
    public ChannelSelector getChannelSelector() {
        return this._channelSelector;
    }

    @Override
    public ModemMode getModemMode() {
        return this._softModem;
    }

    @Override
    public FrequencyThreshold getFrequencyThreshold() {
        return this._frequencyThreshold;
    }

    @Override
    public int toHigherFrequencyUpperThreshold() {
        return this._higherFrequencyUpperThreshold;
    }

    @Override
    public int toLowerFrequencyUpperThreshold() {
        return this._lowerFrequencyUpperThreshold;
    }

    @Override
    public int toSamplesPerBit() {
        return this._samplesPerBit;
    }
}

