/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.cli;

import java.util.function.Consumer;
import org.refcodes.cli.AbstractOption;
import org.refcodes.cli.ArgsSyntaxException;
import org.refcodes.cli.CliContext;
import org.refcodes.cli.Operand;
import org.refcodes.cli.ParseArgsException;
import org.refcodes.cli.Property;
import org.refcodes.struct.Relation;
import org.refcodes.struct.RelationImpl;

public abstract class AbstractProperty<T>
extends AbstractOption<T>
implements Property<T> {
    public AbstractProperty(Character aShortProperty, String aLongProperty, Class<T> aType, String aAlias, String aDescription) {
        super(aShortProperty, aLongProperty, aType, aAlias, aDescription);
        if (aShortProperty == null && (aLongProperty == null || aLongProperty.isEmpty())) {
            throw new IllegalArgumentException("At least the short option <" + String.valueOf(aShortProperty != null ? "'" + aShortProperty + "'" : aShortProperty) + "> must not be null or the long option <" + (String)(aLongProperty != null ? "\"" + aLongProperty + "\"" : aLongProperty) + "> must not be empty!");
        }
    }

    public AbstractProperty(Character aShortProperty, String aLongProperty, Class<T> aType, String aAlias, String aDescription, Consumer<? extends Operand<T>> aConsumer) {
        super(aShortProperty, aLongProperty, aType, aAlias, aDescription, aConsumer);
        if (aShortProperty == null && (aLongProperty == null || aLongProperty.isEmpty())) {
            throw new IllegalArgumentException("At least the short option <" + String.valueOf(aShortProperty != null ? "'" + aShortProperty + "'" : aShortProperty) + "> must not be null or the long option <" + (String)(aLongProperty != null ? "\"" + aLongProperty + "\"" : aLongProperty) + "> must not be empty!");
        }
    }

    public AbstractProperty(Relation<String, T> aProperty, Class<T> aType) {
        super(aProperty, aType);
    }

    public AbstractProperty(Relation<String, T> aProperty, Class<T> aType, Consumer<? extends Operand<T>> aConsumer) {
        super(aProperty, aType, aConsumer);
    }

    public AbstractProperty(String aLongProperty, Class<T> aType, String aDescription) {
        super(aLongProperty, aType, aDescription);
    }

    public AbstractProperty(String aLongProperty, Class<T> aType, String aDescription, Consumer<? extends Operand<T>> aConsumer) {
        super(aLongProperty, aType, aDescription, aConsumer);
    }

    public AbstractProperty(String aLongProperty, Class<T> aType, String aAlias, String aDescription) {
        super(aLongProperty, aType, aAlias, aDescription);
    }

    public AbstractProperty(String aLongProperty, Class<T> aType, String aAlias, String aDescription, Consumer<? extends Operand<T>> aConsumer) {
        super(aLongProperty, aType, aAlias, aDescription, aConsumer);
    }

    protected AbstractProperty(Character aShortProperty, String aLongProperty, Class<T> aType, String aDescription) {
        super(aShortProperty, aLongProperty, aType, aDescription);
    }

    protected AbstractProperty(Character aShortProperty, String aLongProperty, Class<T> aType, String aDescription, Consumer<? extends Operand<T>> aConsumer) {
        super(aShortProperty, aLongProperty, aType, aDescription, aConsumer);
    }

    @Override
    public Operand<?>[] parseArgs(String[] aArgs, String[] aKeywords, CliContext aCliCtx) throws ArgsSyntaxException {
        Relation<String, String> thePropertyArgument = this.toPropertyArgument(aArgs, aCliCtx);
        if (thePropertyArgument != null) {
            this.setParsedArgs(new String[]{(String)thePropertyArgument.getKey() + aCliCtx.getSyntaxMetrics().getAssignmentOperator() + (String)thePropertyArgument.getValue()});
            this.setValue(this.toType((String)thePropertyArgument.getValue()));
            this._matchCount = 1;
            return new Operand[]{this};
        }
        String theShortOption = this.toShortOption(aCliCtx);
        if (AbstractProperty.contains(aArgs, theShortOption)) {
            this._exception = new ParseArgsException("Missing value for option \"" + theShortOption + "\" requiring a value.", aArgs, this);
            throw this._exception;
        }
        String theLongOption = this.toLongOption(aCliCtx);
        if (AbstractProperty.contains(aArgs, theLongOption)) {
            this._exception = new ParseArgsException("Missing value for option \"" + theLongOption + "\" requiring a value.", aArgs, this);
            throw this._exception;
        }
        this._exception = this.toException(aArgs, aCliCtx);
        throw this._exception;
    }

    protected Relation<String, String> toPropertyArgument(String[] aArgs, CliContext aCliCtx) {
        if (aArgs.length > 0) {
            String theShortOption = this.toShortOption(aCliCtx);
            Relation<String, String> theAttribute = AbstractProperty.toPropertyArgument(aArgs, theShortOption, aCliCtx);
            if (theAttribute != null) {
                return theAttribute;
            }
            theAttribute = AbstractProperty.toPropertyArgument(aArgs, this.toLongOption(aCliCtx), aCliCtx);
            if (theAttribute != null) {
                return theAttribute;
            }
        }
        return null;
    }

    protected static Relation<String, String> toPropertyArgument(String[] aArgs, String aOption, CliContext aCliCtx) {
        if (aOption != null) {
            String theAssignmentOperator = aCliCtx.getSyntaxMetrics().getAssignmentOperator();
            for (String eArg : aArgs) {
                int eIndex = eArg.indexOf(theAssignmentOperator);
                if (eIndex == -1) continue;
                String eKey = eArg.substring(0, eIndex);
                String eValue = eArg.substring(eIndex + 1);
                if (!aOption.equals(eKey)) continue;
                return new RelationImpl<String, String>(eKey, eValue);
            }
        }
        return null;
    }
}

