/*
 * Decompiled with CFR 0.152.
 */
package club.funcodes.chaos;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.refcodes.archetype.CliHelper;
import org.refcodes.cli.CasesCondition;
import org.refcodes.cli.CliSugar;
import org.refcodes.cli.DebugFlag;
import org.refcodes.cli.DoubleOption;
import org.refcodes.cli.EnumOption;
import org.refcodes.cli.Example;
import org.refcodes.cli.Flag;
import org.refcodes.cli.HelpFlag;
import org.refcodes.cli.IntOption;
import org.refcodes.cli.LongOption;
import org.refcodes.cli.StringOption;
import org.refcodes.cli.SysInfoFlag;
import org.refcodes.cli.VerboseFlag;
import org.refcodes.codec.BaseBuilder;
import org.refcodes.codec.BaseDecoderInputStream;
import org.refcodes.codec.BaseEncoderOutputStream;
import org.refcodes.codec.BaseMetrics;
import org.refcodes.codec.BaseMetricsConfig;
import org.refcodes.data.AsciiColorPalette;
import org.refcodes.data.Delimiter;
import org.refcodes.data.ExitCode;
import org.refcodes.exception.BugException;
import org.refcodes.io.ClipboardOutputStream;
import org.refcodes.io.LineBreakOutputStream;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;
import org.refcodes.numerical.NumericalUtility;
import org.refcodes.properties.ext.application.ApplicationProperties;
import org.refcodes.runtime.Execution;
import org.refcodes.runtime.SystemContext;
import org.refcodes.security.DecryptionException;
import org.refcodes.security.EncryptionException;
import org.refcodes.security.alt.chaos.ChaosDecryptionInputStream;
import org.refcodes.security.alt.chaos.ChaosEncryptionOutputStream;
import org.refcodes.security.alt.chaos.ChaosKey;
import org.refcodes.security.alt.chaos.ChaosMode;
import org.refcodes.security.alt.chaos.ChaosOptions;
import org.refcodes.security.alt.chaos.ChaosOptionsImpl;
import org.refcodes.tabular.CsvRecordReader;
import org.refcodes.tabular.Header;
import org.refcodes.tabular.TabularSugar;
import org.refcodes.textual.CaseStyle;
import org.refcodes.textual.Font;
import org.refcodes.textual.FontFamily;
import org.refcodes.textual.FontStyle;
import org.refcodes.textual.HorizAlignTextBuilder;
import org.refcodes.textual.HorizAlignTextMode;
import org.refcodes.textual.SecretHintBuilder;
import org.refcodes.textual.VerboseTextBuilder;

public class Main {
    private static final int MIN_LINE_WIDTH = 65;
    private static final RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private static final String NAME = "chaos";
    private static final String TITLE = ">?" + "chaos".toUpperCase() + "!>";
    private static final String DEFAULT_CONFIG = "chaos.ini";
    private static final String LICENSE_NOTE = "You may choose between the LGPL v3.0 or later and the Apache License v2.0 when using this software";
    private static final String COPYRIGHT = "Credits [C] S\u00f6nke Rehder | Copyright (c) by FUNCODES.CLUB | See [https://www.metacodes.pro/manpages/chaos_manpage]";
    private static final char[] BANNER_PALETTE = AsciiColorPalette.MAX_LEVEL_GRAY.getPalette();
    private static final Font BANNER_FONT = new Font(FontFamily.DIALOG, FontStyle.BOLD);
    private static final String DESCRIPTION = "Encryption and decryption tool of file or stream data using Chaos-based encryption (see [https://www.metacodes.pro/manpages/chaos_manpage]).";
    private static final String BASE64_PROPERTY = "base64";
    private static final String BYTES_PROPERTY = "bytes";
    private static final String COPY_TO_PROPERTY = "copyTo";
    private static final String PASTE_FROM_PROPERTY = "pasteFrom";
    private static final String CERT_FILE_PROPERTY = "certFile";
    private static final String CERT_INFO_PROPERTY = "certInfo";
    private static final String CERT_MODE_PROPERTY = "certMode";
    private static final String CHAIN_LENGTH_PROPERTY = "chainLength";
    private static final String CHAOS_MODE_PROPERTY = "chaosMode";
    private static final String CONTEXT_PROPERTY = "context";
    private static final String CREATE_CERT_PROPERTY = "createCert";
    private static final String CREATE_SPEC_PROPERTY = "createSpec";
    private static final String DECRYPT_PROPERTY = "decrypt";
    private static final String ENCODED_LENGTH_PROPERTY = "encodedLength";
    private static final String ENCODING_PROPERTY = "encoding";
    private static final String ENCRYPT_PROPERTY = "encrypt";
    private static final String HEX_PROPERTY = "hex";
    private static final String INPUT_FILE_PROPERTY = "inputFile";
    private static final String LINE_WIDTH_PROPERTY = "lineWidth";
    private static final String OUTPUT_FILE_PROPERTY = "outputFile";
    private static final String PASSWORD_PROPERTY = "password";
    private static final String PROMPT_PASSWORD_PROPERTY = "promptPassword";
    private static final String SPEC_FILE_PROPERTY = "specFile";
    private static final String TEXT_PROPERTY = "text";
    private static final String VERIFY_PROPERTY = "verify";
    private static final String X0_PROPERTY = "x0";
    private static final String A_PROPERTY = "a";
    private static final String S_PROPERTY = "s";
    private static final ChaosMode DEFAULT_CHAOS_MODE = ChaosMode.SALTED_MUTATE;
    private static final ChaosMode DEFAULT_PLAIN_MODE = ChaosMode.NONE;
    private static final String DEFAULT_SPECFILE_NAME = "sample-chaos.spec";
    private static final SystemContext DEFAULT_CONTEXT = SystemContext.HOST_USER;
    private static final int DEFAULT_CERT_LINE_WIDTH = 65;
    private static final int DEFAULT_CHAIN_LENGTH = 16;

    public static void main(String[] args) {
        block51: {
            EnumOption<BaseMetricsConfig> theEncodingArg = CliSugar.enumOption(ENCODING_PROPERTY, BaseMetricsConfig.class, ENCODING_PROPERTY, "The BASE (e.g. BASE64) encoding/decoding to be applied for handling encrypted data: " + VerboseTextBuilder.asString(BaseMetricsConfig.values()));
            EnumOption<ChaosMode> theCertModeArg = CliSugar.enumOption("cert-mode", ChaosMode.class, CERT_MODE_PROPERTY, "The chaos options (mode) to be used for the cert itself: " + VerboseTextBuilder.asString(ChaosMode.values()));
            EnumOption<ChaosMode> theChaosModeArg = CliSugar.enumOption("chaos-mode", ChaosMode.class, CHAOS_MODE_PROPERTY, "The mode to be used when encrypting/decrypting: " + VerboseTextBuilder.asString(ChaosMode.values()));
            EnumOption<SystemContext> theContextArg = CliSugar.enumOption(CONTEXT_PROPERTY, SystemContext.class, CONTEXT_PROPERTY, "The system context providing the password: " + VerboseTextBuilder.asString((Object[])SystemContext.values()));
            Flag theBase64Flag = CliSugar.flag(BASE64_PROPERTY, BASE64_PROPERTY, "Use BASE64 encoding/decoding to be applied for handling encrypted data.");
            Flag theCertInfoFlag = CliSugar.flag("cert-info", CERT_INFO_PROPERTY, "Prints out information of a given cert.");
            Flag theCreateCertFlag = CliSugar.flag("create-cert", CREATE_CERT_PROPERTY, "Create an according cert record (file).");
            Flag theCreateSpecFlag = CliSugar.flag("create-spec", CREATE_SPEC_PROPERTY, "Create an according spec record (file).");
            DebugFlag theDebugFlag = CliSugar.debugFlag(false);
            Flag theDecryptFlag = CliSugar.flag(Character.valueOf('d'), DECRYPT_PROPERTY, DECRYPT_PROPERTY, "Decrypts the message (stream, file, text or bytes).");
            Flag theEncodedFlag = CliSugar.flag("encoded-length", ENCODED_LENGTH_PROPERTY, "Prints length in bytes of a single chaos key encoding (being the additional length of a salted encryption).");
            Flag theEncryptFlag = CliSugar.flag(Character.valueOf('e'), ENCRYPT_PROPERTY, ENCRYPT_PROPERTY, "Encrypts the message (stream, file, text or bytes).");
            HelpFlag theHelpFlag = CliSugar.helpFlag();
            Flag theHexFlag = CliSugar.flag(HEX_PROPERTY, HEX_PROPERTY, "Use a hexadecimal representation of (binary) output.");
            Flag thePromptPasswordFlag = CliSugar.flag("prompt", PROMPT_PASSWORD_PROPERTY, "Prompt for the password to use for encryption or decryption.");
            SysInfoFlag theSysInfoFlag = CliSugar.sysInfoFlag(false);
            VerboseFlag theVerboseFlag = CliSugar.verboseFlag();
            Flag theVerifyFlag = CliSugar.flag(VERIFY_PROPERTY, VERIFY_PROPERTY, "Verify the encryption process to make sure encryption decrypts flawlessly.");
            Flag theCopyToFlag = CliSugar.flag("copy-to", COPY_TO_PROPERTY, "Copy the processed output data to the clipboard" + (Execution.isNativeImage() ? " (without warranty)" : "") + ".");
            Flag thePasteFromFlag = CliSugar.flag("paste-from", PASTE_FROM_PROPERTY, "Paste the input data to be processed from the clipboard" + (Execution.isNativeImage() ? " (without warranty)" : "") + ".");
            IntOption theChainLengthArg = CliSugar.intOption("chain-length", CHAIN_LENGTH_PROPERTY, "The length of the chaos key chain (e.g. number of nested chaos keys, defaults to <16>)");
            IntOption theLineWidthArg = CliSugar.intOption("line-width", LINE_WIDTH_PROPERTY, "The line width for base64 encoded ASCII output.");
            DoubleOption theX0Arg = CliSugar.doubleOption(Character.valueOf('x'), "start-value", X0_PROPERTY, "The chaos key's <x0> start value to use: 0.0 < x0 \u2264 1.0");
            DoubleOption theAArg = CliSugar.doubleOption(Character.valueOf('a'), "parable-coefficient", A_PROPERTY, "The chaos key's parable coefficient <a> to use: 3.57 \u2264 a \u2264 4.0");
            LongOption theSArg = CliSugar.longOption(Character.valueOf('s'), "expansion-factor", S_PROPERTY, "The chaos key's expansion factor <s> to use: " + ChaosKey.S_MIN + " \u2264 s \u2264 -16 or 16 \u2264 s \u2264 " + ChaosKey.S_MAX);
            StringOption theBytesArg = CliSugar.stringOption(Character.valueOf('b'), BYTES_PROPERTY, BYTES_PROPERTY, "The message in bytes (e.g. \"127, 128, 0x10, 0xFF\") which to process.");
            StringOption theCertFileArg = CliSugar.stringOption(Character.valueOf('c'), "cert-file", CERT_FILE_PROPERTY, "The cert file file which to use.");
            StringOption theInputFileArg = CliSugar.stringOption(Character.valueOf('i'), "input-file", INPUT_FILE_PROPERTY, "The input file which to process from.");
            StringOption theOutputFileArg = CliSugar.stringOption(Character.valueOf('o'), "output-file", OUTPUT_FILE_PROPERTY, "The output file which to process to.");
            StringOption thePasswordArg = CliSugar.stringOption(Character.valueOf('p'), PASSWORD_PROPERTY, PASSWORD_PROPERTY, "The password to use for encryption or decryption.");
            StringOption theSpecFileArg = CliSugar.stringOption("spec-file", SPEC_FILE_PROPERTY, "The spec file file which to use.");
            StringOption theTextArg = CliSugar.stringOption(Character.valueOf('t'), TEXT_PROPERTY, TEXT_PROPERTY, "The text message which to process.");
            CasesCondition theArgsSyntax = CliSugar.cases(CliSugar.and(theEncryptFlag, CliSugar.xor(theTextArg, theBytesArg), CliSugar.any(CliSugar.xor(theHexFlag, theBase64Flag, theEncodingArg), CliSugar.xor(CliSugar.any(CliSugar.xor(thePromptPasswordFlag, thePasswordArg, theContextArg, CliSugar.and(theX0Arg, theAArg, theSArg)), theChaosModeArg), CliSugar.and(theCertFileArg, CliSugar.any(CliSugar.xor(thePromptPasswordFlag, thePasswordArg, theContextArg)))), theCopyToFlag, theVerifyFlag, theVerboseFlag, theDebugFlag)), CliSugar.and(theDecryptFlag, CliSugar.xor(theTextArg, theBytesArg), CliSugar.any(CliSugar.xor(theBase64Flag, theEncodingArg), theHexFlag, CliSugar.xor(CliSugar.any(CliSugar.xor(thePromptPasswordFlag, thePasswordArg, theContextArg, CliSugar.and(theX0Arg, theAArg, theSArg)), theChaosModeArg), CliSugar.and(theCertFileArg, CliSugar.any(CliSugar.xor(thePromptPasswordFlag, thePasswordArg, theContextArg)))), theCopyToFlag, theVerboseFlag, theDebugFlag)), CliSugar.and(theEncryptFlag, CliSugar.any(CliSugar.xor(theInputFileArg, thePasteFromFlag), CliSugar.xor(theOutputFileArg, theCopyToFlag), CliSugar.and(CliSugar.xor(theBase64Flag, theEncodingArg), CliSugar.any(theLineWidthArg)), CliSugar.xor(CliSugar.any(CliSugar.xor(thePromptPasswordFlag, thePasswordArg, theContextArg, CliSugar.and(theX0Arg, theAArg, theSArg)), theChaosModeArg), CliSugar.and(theCertFileArg, CliSugar.any(CliSugar.xor(thePromptPasswordFlag, thePasswordArg, theContextArg)))), theVerifyFlag, theVerboseFlag, theDebugFlag)), CliSugar.and(theDecryptFlag, CliSugar.any(CliSugar.xor(theInputFileArg, thePasteFromFlag), CliSugar.xor(theOutputFileArg, theCopyToFlag), CliSugar.xor(theBase64Flag, theEncodingArg), CliSugar.xor(CliSugar.any(CliSugar.xor(thePromptPasswordFlag, thePasswordArg, theContextArg, CliSugar.and(theX0Arg, theAArg, theSArg)), theChaosModeArg), CliSugar.and(theCertFileArg, CliSugar.any(CliSugar.xor(thePromptPasswordFlag, thePasswordArg, theContextArg)))), theVerboseFlag, theDebugFlag)), CliSugar.and(theCreateCertFlag, CliSugar.any(theLineWidthArg, theCertFileArg, CliSugar.and(CliSugar.xor(thePromptPasswordFlag, thePasswordArg, theContextArg), CliSugar.any(theCertModeArg)), CliSugar.xor(CliSugar.or(theChainLengthArg, theChaosModeArg), theSpecFileArg), theVerboseFlag, theDebugFlag)), CliSugar.and(theCertInfoFlag, theCertFileArg, CliSugar.any(CliSugar.xor(thePromptPasswordFlag, thePasswordArg, theContextArg), theVerboseFlag, theDebugFlag)), CliSugar.and(theCreateSpecFlag, CliSugar.any(theSpecFileArg, theVerboseFlag, theDebugFlag)), CliSugar.xor(theHelpFlag, CliSugar.and(CliSugar.xor(theEncodedFlag, theSysInfoFlag), CliSugar.any(theVerboseFlag, theDebugFlag))));
            Example[] theExamples = CliSugar.examples(CliSugar.example("Encrypt (BASE64 encoded) a text message", theEncryptFlag, theTextArg, theBase64Flag, thePromptPasswordFlag), CliSugar.example("Decrypt a text message (BASE64 encoded)", theDecryptFlag, theTextArg, theBase64Flag, thePromptPasswordFlag), CliSugar.example("Encrypt (BASE64 encoded) a text message and copy to clipboard", theEncryptFlag, theTextArg, theBase64Flag, thePromptPasswordFlag, theCopyToFlag), CliSugar.example("Decrypt a text message (BASE64 encoded) and copy to clipboard", theDecryptFlag, theTextArg, theBase64Flag, thePromptPasswordFlag, theCopyToFlag), CliSugar.example("Encrypt (BASE64 encoded) a text message using (x0, a, s)", theEncryptFlag, theTextArg, theBase64Flag, theX0Arg, theAArg, theSArg), CliSugar.example("Decrypt a text message (BASE64 encoded) using (x0, a, s)", theDecryptFlag, theTextArg, theBase64Flag, theX0Arg, theAArg, theSArg), CliSugar.example("Encrypt a text message with mode", theEncryptFlag, theTextArg, theVerboseFlag, theChaosModeArg), CliSugar.example("Decrypt a text message with mode", theDecryptFlag, theTextArg, theVerboseFlag, theChaosModeArg), CliSugar.example("Encrypt a message in bytes", theEncryptFlag, theBytesArg, theHexFlag, thePromptPasswordFlag), CliSugar.example("Decrypt a message in bytes", theDecryptFlag, theBytesArg, theHexFlag, thePromptPasswordFlag), CliSugar.example("Encrypt input file to output file (bound to context)", theEncryptFlag, theInputFileArg, theOutputFileArg, theContextArg, theVerboseFlag), CliSugar.example("Decrypt input file to output file (bound to context)", theDecryptFlag, theInputFileArg, theOutputFileArg, theContextArg, theVerboseFlag), CliSugar.example("Use password to encrypt input file to output file", theEncryptFlag, theInputFileArg, theOutputFileArg, thePasswordArg, theVerboseFlag), CliSugar.example("Use password to decrypt input file to output file", theDecryptFlag, theInputFileArg, theOutputFileArg, thePasswordArg, theVerboseFlag), CliSugar.example("Encrypt input file to output file, prompt for password", theEncryptFlag, theInputFileArg, theOutputFileArg, thePromptPasswordFlag, theVerboseFlag), CliSugar.example("Decrypt input file to output file, prompt for password", theDecryptFlag, theInputFileArg, theOutputFileArg, thePromptPasswordFlag, theVerboseFlag), CliSugar.example("Encrypt clipboard to output file, prompt for password", theEncryptFlag, thePasteFromFlag, theOutputFileArg, thePromptPasswordFlag, theVerboseFlag), CliSugar.example("Decrypt input file to clipboard, prompt for password", theDecryptFlag, theInputFileArg, theCopyToFlag, thePromptPasswordFlag, theVerboseFlag), CliSugar.example("Encrypt input file to output file with mode and password", theEncryptFlag, theInputFileArg, theOutputFileArg, theChaosModeArg, thePasswordArg, theVerboseFlag), CliSugar.example("Decrypt input file to output file with mode and password", theDecryptFlag, theInputFileArg, theOutputFileArg, theChaosModeArg, thePasswordArg, theVerboseFlag), CliSugar.example("Encrypt STDIN to output file with password", theEncryptFlag, theInputFileArg, thePasswordArg), CliSugar.example("Decrypt input file to STDOUT with password", theDecryptFlag, theOutputFileArg, thePasswordArg), CliSugar.example("Encrypt STDIN to output file with mode for " + String.valueOf((Object)DEFAULT_CONTEXT), theEncryptFlag, theInputFileArg, theChaosModeArg), CliSugar.example("Decrypt input file to STDOUT with mode for " + String.valueOf((Object)DEFAULT_CONTEXT), theDecryptFlag, theOutputFileArg, theChaosModeArg), CliSugar.example("Encrypt STDIN to STDOUT/BASE64 encoded for " + String.valueOf((Object)DEFAULT_CONTEXT), theEncryptFlag, theBase64Flag), CliSugar.example("Decrypt STDIN/BASE64 encoded to STDOUT for " + String.valueOf((Object)DEFAULT_CONTEXT), theDecryptFlag, theBase64Flag), CliSugar.example("Create and print cert with key chain length", theCreateCertFlag, theChainLengthArg, theVerboseFlag), CliSugar.example("Create cert file with key chain length", theCreateCertFlag, theCertFileArg, theChainLengthArg, theVerboseFlag), CliSugar.example("Create secured cert file with key chain length and mode", theCreateCertFlag, theCertFileArg, theChainLengthArg, theChaosModeArg, thePromptPasswordFlag, theVerboseFlag), CliSugar.example("Create sample cert spec file (for you to edit)", theCreateSpecFlag, theSpecFileArg, theVerboseFlag), CliSugar.example("Create secured cert file from (edited) cert spec file", theCreateCertFlag, theCertFileArg, theSpecFileArg, thePromptPasswordFlag, theVerboseFlag), CliSugar.example("Encrypt input file to output file, use secured cert", theEncryptFlag, theInputFileArg, theOutputFileArg, theCertFileArg, thePromptPasswordFlag, theVerboseFlag), CliSugar.example("Decrypt input file to output file, use secured cert", theDecryptFlag, theInputFileArg, theOutputFileArg, theCertFileArg, thePromptPasswordFlag, theVerboseFlag), CliSugar.example("Print cert file info", theCertInfoFlag, theCertFileArg, theVerboseFlag), CliSugar.example("Print secured cert file info", theCertInfoFlag, theCertFileArg, thePromptPasswordFlag, theVerboseFlag), CliSugar.example("Print length of single chaos key (bytes)", theEncodedFlag, theVerboseFlag), CliSugar.example("To show the help text", theHelpFlag), CliSugar.example("To print the system info", theSysInfoFlag));
            CliHelper theCliHelper = ((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)CliHelper.builder().withArgs(args)).withArgsSyntax(theArgsSyntax)).withExamples(theExamples)).withFilePath(DEFAULT_CONFIG)).withResourceClass((Class)Main.class)).withName(NAME)).withTitle(TITLE)).withDescription(DESCRIPTION)).withLicense(LICENSE_NOTE)).withCopyright(COPYRIGHT)).withBannerFont(BANNER_FONT)).withBannerFontPalette(BANNER_PALETTE)).withLogger(LOGGER)).build();
            ApplicationProperties theArgsProperties = theCliHelper.getApplicationProperties();
            boolean isVerbose = theCliHelper.isVerbose();
            if (theArgsProperties.getBoolean((Object)theEncodedFlag).booleanValue()) {
                Main.printEncodedLength(isVerbose);
            } else {
                try {
                    byte[] theBytes = theArgsProperties.get((Object)theBytesArg) != null ? NumericalUtility.toBytes((String)theArgsProperties.get((Object)theBytesArg)) : null;
                    String theText = (String)theArgsProperties.get((Object)theTextArg);
                    String theInputFilePath = (String)theArgsProperties.get((Object)theInputFileArg);
                    String theOutputFilePath = (String)theArgsProperties.get((Object)theOutputFileArg);
                    String theCertFileName = (String)theArgsProperties.get((Object)theCertFileArg);
                    String theSpecFileName = (String)theArgsProperties.get((Object)theSpecFileArg);
                    Boolean isPasteFrom = theArgsProperties.getBoolean((Object)thePasteFromFlag);
                    Boolean isCopyTo = theArgsProperties.getBoolean((Object)theCopyToFlag);
                    Boolean isBase64 = theArgsProperties.getBoolean((Object)theBase64Flag);
                    Boolean isHex = theArgsProperties.getBoolean((Object)theHexFlag);
                    Boolean isEncrypt = theArgsProperties.getBoolean((Object)theEncryptFlag);
                    Boolean isDecrypt = theArgsProperties.getBoolean((Object)theDecryptFlag);
                    Boolean isVerify = theArgsProperties.getBoolean((Object)theVerifyFlag);
                    Boolean isCreateCert = theArgsProperties.getBoolean((Object)theCreateCertFlag);
                    Boolean isCertInfo = theArgsProperties.getBoolean((Object)theCertInfoFlag);
                    Boolean isCreateSpec = theArgsProperties.getBoolean((Object)theCreateSpecFlag);
                    Boolean isPromptPassword = theArgsProperties.getBoolean((Object)thePromptPasswordFlag);
                    String thePassword = (String)theArgsProperties.get((Object)thePasswordArg);
                    SystemContext theContext = theArgsProperties.getEnum(SystemContext.class, (Object)theContextArg);
                    BaseMetricsConfig theBaseMetrics = isBase64 != false ? BaseMetricsConfig.BASE64 : theArgsProperties.getEnum(BaseMetricsConfig.class, (Object)theEncodingArg);
                    Double x0 = theArgsProperties.getDouble((Object)theX0Arg);
                    Double a = theArgsProperties.getDouble((Object)theAArg);
                    Long s = theArgsProperties.getLong((Object)theSArg);
                    Integer theLineWidth = theArgsProperties.getInt((Object)theLineWidthArg);
                    Integer theChainLength = theArgsProperties.getInt((Object)theChainLengthArg);
                    ChaosOptions theChaosMode = theArgsProperties.getEnum(ChaosMode.class, (Object)theChaosModeArg);
                    ChaosOptions theCertMode = theArgsProperties.getEnum(ChaosMode.class, (Object)theCertModeArg);
                    if (isVerbose) {
                        if (isCreateCert != null && isCreateCert.booleanValue()) {
                            LOGGER.info("Operation = " + CaseStyle.KEBAB_UPPER_CASE.toCaseStyle(CREATE_CERT_PROPERTY));
                        }
                        if (isCertInfo != null && isCertInfo.booleanValue()) {
                            LOGGER.info("Operation = " + CaseStyle.KEBAB_UPPER_CASE.toCaseStyle(CERT_INFO_PROPERTY));
                        }
                        if (isDecrypt != null && isDecrypt.booleanValue()) {
                            LOGGER.info("Operation = " + CaseStyle.KEBAB_UPPER_CASE.toCaseStyle(DECRYPT_PROPERTY));
                        }
                        if (isEncrypt != null && isEncrypt.booleanValue()) {
                            LOGGER.info("Operation = " + CaseStyle.KEBAB_UPPER_CASE.toCaseStyle(ENCRYPT_PROPERTY));
                        }
                        if (x0 != null) {
                            LOGGER.info("x0 = " + x0);
                        }
                        if (a != null) {
                            LOGGER.info("a = " + a);
                        }
                        if (s != null) {
                            LOGGER.info("s = " + s);
                        }
                        if (thePassword != null) {
                            LOGGER.info("Password (hint) = " + SecretHintBuilder.asString(thePassword));
                        }
                        if (isPromptPassword != null && isPromptPassword.booleanValue()) {
                            LOGGER.info("Prompt password = " + Main.toBooleanText(isPromptPassword));
                        }
                        if (theContext != null) {
                            LOGGER.info("Context = " + theContext.name());
                        }
                        if (theText != null && theText.length() != 0) {
                            LOGGER.info("Text = " + theText);
                        }
                        if (theBytes != null && theBytes.length != 0) {
                            LOGGER.info("Bytes = { " + NumericalUtility.toHexString(", ", theBytes) + " }");
                        }
                        if (theBaseMetrics != null) {
                            LOGGER.info("Encoding = " + String.valueOf(theBaseMetrics));
                        }
                        if (isHex != null && isHex.booleanValue()) {
                            LOGGER.info("Hexadecimal = " + Main.toBooleanText(isHex));
                        }
                        if (isVerify != null && isVerify.booleanValue()) {
                            LOGGER.info("Verify = " + Main.toBooleanText(isVerify));
                        }
                        if (isCopyTo != null && isCopyTo.booleanValue()) {
                            LOGGER.info("Copy to clipboard = " + Main.toBooleanText(isCopyTo));
                        }
                        if (isPasteFrom != null && isPasteFrom.booleanValue()) {
                            LOGGER.info("Past from clipboard = " + Main.toBooleanText(isPasteFrom));
                        }
                    }
                    if (isCreateCert.booleanValue()) {
                        File theSpecFile = Main.toSpecFile(theSpecFileName, isVerbose);
                        File theCertFile = Main.toCertFile(theCertFileName, isVerbose);
                        String theCertPassword = Main.toCertPassword(isPromptPassword, thePassword, theContext, isVerbose);
                        theLineWidth = Main.toLineWidth(theLineWidth, 65, isVerbose);
                        theChaosMode = Main.toChaosMode(theChaosMode, isVerbose);
                        theChainLength = Main.toChainLength(theChainLength, theSpecFile, isVerbose);
                        theCertMode = Main.toCertMode(isPromptPassword, thePassword, theContext, theCertMode, isVerbose);
                        Main.createCert(theCertFile, theSpecFile, theChaosMode, theChainLength, theCertMode, theCertPassword, theLineWidth, isVerbose);
                        break block51;
                    }
                    if (isCertInfo.booleanValue()) {
                        Main.printCertInfo(theCertFileName, isPromptPassword, thePassword, theContext, isVerbose);
                        break block51;
                    }
                    if (isCreateSpec.booleanValue()) {
                        File theSpecFile = Main.toSpecFile(Main.toSpecFileName(theSpecFileName), isVerbose);
                        Main.createSpecFile(theSpecFile, isVerbose);
                        break block51;
                    }
                    if (isEncrypt.booleanValue()) {
                        File theCertFile = Main.toCertFile(theCertFileName, isVerbose);
                        try (InputStream theInputStream = Main.toInputStream(isPasteFrom, theInputFilePath, isVerbose);
                             OutputStream theOutputStream = Main.toOutputStream(isCopyTo, theOutputFilePath, isVerbose);){
                            theChaosMode = Main.toChaosMode(theChaosMode, theText, theBytes, isPasteFrom, theCertFile, isVerbose);
                            ChaosKey theChaosKey = Main.toChaosKey(isPromptPassword, thePassword, theContext, theCertFile, x0, a, s, theChaosMode, isVerbose);
                            theLineWidth = Main.toLineWidth(theLineWidth, -1, isVerbose);
                            Main.encrypt(theText, theBytes, theInputStream, theOutputStream, theChaosKey, isVerify, isHex, theBaseMetrics, theLineWidth, isVerbose);
                            break block51;
                        }
                    }
                    if (isDecrypt.booleanValue()) {
                        File theCertFile = Main.toCertFile(theCertFileName, isVerbose);
                        try (InputStream theInputStream = Main.toInputStream(isPasteFrom, theInputFilePath, isVerbose);
                             OutputStream theOutputStream = Main.toOutputStream(isCopyTo, theOutputFilePath, isVerbose);){
                            theChaosMode = Main.toChaosMode(theChaosMode, theText, theBytes, isPasteFrom, theCertFile, isVerbose);
                            ChaosKey theChaosKey = Main.toChaosKey(isPromptPassword, thePassword, theContext, theCertFile, x0, a, s, theChaosMode, isVerbose);
                            Main.decrypt(theText, theBytes, theInputStream, theOutputStream, theChaosKey, isHex, theBaseMetrics, isVerbose);
                            break block51;
                        }
                    }
                    throw new BugException("We encountered a bug, none argument was processed!");
                }
                catch (Throwable e) {
                    theCliHelper.exitOnException(e);
                }
            }
        }
    }

    private static void printCertInfo(String aCertFileName, boolean isPromptPassword, String aPassword, SystemContext aContext, boolean isVerbose) throws IOException {
        File theCertFile = Main.toCertFile(aCertFileName, isVerbose);
        String theFileSize = "Cert file size  = " + theCertFile.length();
        ChaosOptions theChaosOptions = ChaosKey.asCertificateOptions(theCertFile);
        String theCertOptions = "Cert file options = " + (String)(theChaosOptions != null ? "Encrypted: " + theChaosOptions.toString() : "None");
        ChaosKey theChaosKey = Main.toChaosKey(isPromptPassword, aPassword, aContext, theCertFile, null, null, null, null, isVerbose);
        if (isVerbose) {
            LOGGER.info(theFileSize);
            LOGGER.info(theCertOptions);
            LOGGER.printSeparator();
            int length = Main.printChaosKey(theChaosKey, LOGGER::info, true);
            LOGGER.printSeparator();
            LOGGER.info("Chain length = " + length);
        } else {
            System.out.println(theFileSize);
            System.out.println(theCertOptions);
            int length = Main.printChaosKey(theChaosKey, System.out::println, false);
            System.out.println("Chain length = " + length);
        }
    }

    private static void printEncodedLength(boolean isVerbose) {
        if (isVerbose) {
            LOGGER.info("Encoded chaos key length (bytes) = " + ChaosKey.getEncodedLength());
        } else {
            System.out.println(ChaosKey.getEncodedLength());
        }
    }

    private static void createCert(File aCertFile, File aSpecFile, ChaosOptions aChaosMode, Integer aChainLength, ChaosOptions aCertMode, String aPassword, int aLineWidth, boolean isVerbose) throws IOException {
        ChaosKey theCertKey;
        Header<?> theHeader = TabularSugar.headerOf(TabularSugar.stringColumn(X0_PROPERTY), TabularSugar.stringColumn(A_PROPERTY), TabularSugar.stringColumn(S_PROPERTY), TabularSugar.booleanColumn("salted"), TabularSugar.booleanColumn("mutate"), TabularSugar.booleanColumn("xor"), TabularSugar.intColumn("prefix"));
        if (aSpecFile != null) {
            try (CsvRecordReader theCsvReader = new CsvRecordReader(theHeader, aSpecFile, Delimiter.CSV.getChar());){
                theCsvReader.readHeader();
                theCertKey = theCsvReader.nextType(ChaosKeyLine.class).toChaosKey(theCsvReader);
            }
        } else {
            theCertKey = ChaosKey.createRndKeyChain(aChainLength, aChaosMode, ChaosMode.NONE);
        }
        String theKeyCert = aPassword != null && aPassword.length() != 0 ? theCertKey.toCertificate(aPassword, aCertMode, aLineWidth) : theCertKey.toCertificate(aLineWidth);
        if (aCertFile == null) {
            if (isVerbose) {
                LOGGER.printTail();
            }
            System.out.println();
            System.out.println(theKeyCert);
        } else {
            try (BufferedOutputStream theOutStream = new BufferedOutputStream(new FileOutputStream(aCertFile));){
                theOutStream.write(theKeyCert.getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    private static void createSpecFile(File aSpecFile, boolean isVerbose) throws IOException {
        if (isVerbose) {
            LOGGER.info("Creating sample spec file <" + aSpecFile.getAbsolutePath() + "> ...");
        }
        try (FileOutputStream theOutputStream = new FileOutputStream(aSpecFile);
             InputStream theInputStream = CliHelper.class.getResourceAsStream("/sample-chaos.spec");){
            theInputStream.transferTo(theOutputStream);
            theOutputStream.flush();
        }
    }

    private static void decrypt(String aText, byte[] aBytes, InputStream aInputStream, OutputStream aOutputStream, ChaosKey aChaosKey, boolean isHex, BaseMetricsConfig aBaseMetrics, boolean isVerbose) throws DecryptionException, IOException {
        if (aText != null && aText.length() != 0 || aBytes != null && aBytes.length != 0) {
            Main.decrypt(aText, aBytes, aOutputStream, aChaosKey, aBaseMetrics, isHex, isVerbose);
        } else {
            if (aBaseMetrics != null) {
                aInputStream = new BaseDecoderInputStream(aInputStream, (BaseMetrics)aBaseMetrics);
            }
            Main.decryptStream(aInputStream, aOutputStream, aChaosKey, isVerbose);
        }
    }

    private static void decrypt(String aText, byte[] aBytes, OutputStream aOutputStream, ChaosKey aChaosKey, BaseMetrics aBaseMetrics, boolean isHex, boolean isVerbose) throws DecryptionException, IOException {
        if (aChaosKey.getOptions().isSalted() && isVerbose) {
            LOGGER.warn("A mode <" + aChaosKey.getOptions().toString() + "> with salting was provided, though currently salting a text or bytes argument is not supported (please use the file or stream based operations), continuing without salting!");
        }
        byte[] theMessage = aBytes;
        theMessage = aBaseMetrics != null ? new BaseBuilder().withBaseMetrics(aBaseMetrics).toDecodedData(aText) : aText.getBytes();
        ByteArrayInputStream theInputStream = new ByteArrayInputStream(theMessage);
        ByteArrayOutputStream theOutputStream = new ByteArrayOutputStream();
        Main.decryptStream(theInputStream, theOutputStream, aChaosKey, isVerbose);
        byte[] theDecrypted = theOutputStream.toByteArray();
        Object theResult = null;
        theResult = isHex ? "{ " + NumericalUtility.toHexString(", ", theDecrypted) + " }" : new String(theDecrypted);
        LOGGER.printTail();
        PrintWriter theWriter = new PrintWriter(aOutputStream);
        theWriter.println((String)(theResult != null ? theResult : new String(theDecrypted)));
        theWriter.flush();
    }

    private static void decryptStream(InputStream aInputStream, OutputStream aOutputStream, ChaosKey aChaosKey, boolean isVerbose) throws IOException {
        LOGGER.printTail();
        try (ChaosDecryptionInputStream theChaosInputStream = new ChaosDecryptionInputStream((InputStream)new BufferedInputStream(aInputStream), aChaosKey);
             ChaosDecryptionInputStream theInputStream = theChaosInputStream;
             BufferedOutputStream theOutputStream = new BufferedOutputStream(aOutputStream);){
            theInputStream.transferTo(theOutputStream);
        }
    }

    private static void encrypt(String aText, byte[] aBytes, InputStream aInputStream, OutputStream aOutputStream, ChaosKey aChaosKey, boolean isVerify, boolean isHex, BaseMetricsConfig aBaseMetrics, int aLineWidth, boolean isVerbose) throws EncryptionException, IOException {
        if (aText != null && aText.length() != 0 || aBytes != null && aBytes.length != 0) {
            Main.encrypt(aText, aBytes, aOutputStream, aChaosKey, aBaseMetrics, isHex, isVerify, isVerbose);
        } else {
            if (aBaseMetrics != null) {
                if (aLineWidth != -1) {
                    aOutputStream = new LineBreakOutputStream(aOutputStream, aLineWidth);
                }
                aOutputStream = new BaseEncoderOutputStream(aOutputStream, (BaseMetrics)aBaseMetrics);
            }
            Main.encryptStream(aInputStream, aOutputStream, aChaosKey, isVerify, isVerbose);
        }
    }

    private static void encrypt(String aText, byte[] aBytes, OutputStream aOutputStream, ChaosKey aChaosKey, BaseMetrics aBaseMetrics, boolean isHex, boolean isVerify, boolean isVerbose) throws EncryptionException, IOException {
        if (aChaosKey.getOptions().isSalted() && isVerbose) {
            LOGGER.warn("A mode <" + aChaosKey.getOptions().toString() + "> with salting was provided, though currently salting a text or bytes argument is not supported (please use the file or stream based operations), continuing without salting!");
        }
        byte[] theMessage = aBytes != null ? aBytes : aText.getBytes();
        ByteArrayInputStream theInputStream = new ByteArrayInputStream(theMessage);
        ByteArrayOutputStream theOutputStream = new ByteArrayOutputStream();
        Main.encryptStream(theInputStream, theOutputStream, aChaosKey, isVerify, isVerbose);
        byte[] theEncrypted = theOutputStream.toByteArray();
        Object theResult = null;
        theResult = aBaseMetrics != null ? new BaseBuilder().withBaseMetrics(aBaseMetrics).toEncodedText(theEncrypted) : (isHex ? "{ " + NumericalUtility.toHexString(", ", theEncrypted) + " }" : new String(theEncrypted));
        LOGGER.printTail();
        PrintWriter theWriter = new PrintWriter(aOutputStream);
        if (theResult != null) {
            theWriter.println((String)theResult);
        } else {
            theWriter.println(theEncrypted);
        }
        theWriter.flush();
    }

    private static void encryptStream(InputStream aInputStream, OutputStream aOutputStream, ChaosKey aChaosKey, boolean isVerify, boolean isVerbose) throws IOException {
        try (BufferedInputStream theInputStream = new BufferedInputStream(aInputStream);
             ChaosEncryptionOutputStream theChaosOutputStream = new ChaosEncryptionOutputStream(new BufferedOutputStream(aOutputStream), aChaosKey, isVerify);
             ChaosEncryptionOutputStream theOutputStream = theChaosOutputStream;){
            ((InputStream)theInputStream).transferTo(theOutputStream);
        }
    }

    private static InputStream toInputStream(Boolean isPasteFrom, String aInputFileName, boolean isVerbose) throws UnsupportedFlavorException, IOException {
        InputStream theInputStream;
        if (isPasteFrom.booleanValue()) {
            Clipboard theClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            theInputStream = new ByteArrayInputStream(((String)theClipboard.getData(DataFlavor.stringFlavor)).getBytes());
        } else {
            theInputStream = Execution.toBootstrapStandardIn();
            if (aInputFileName != null && aInputFileName.length() != 0) {
                File theInputFile = new File(aInputFileName);
                if (isVerbose) {
                    LOGGER.info("Input file = " + theInputFile.getAbsolutePath());
                }
                if (!theInputFile.exists() || !theInputFile.isFile()) {
                    throw new FileNotFoundException("No such file \"" + aInputFileName + "\" (<" + theInputFile.getAbsolutePath() + ">) found!");
                }
                theInputStream = new FileInputStream(theInputFile);
            }
        }
        return theInputStream;
    }

    private static OutputStream toOutputStream(Boolean isCopyTo, String aOutputFileName, boolean isVerbose) throws FileNotFoundException {
        OutputStream theOutputStream;
        if (isCopyTo.booleanValue()) {
            theOutputStream = new ClipboardOutputStream();
        } else {
            theOutputStream = Execution.toBootstrapStandardOut();
            if (aOutputFileName != null && aOutputFileName.length() != 0) {
                File theOutputFile = new File(aOutputFileName);
                if (isVerbose) {
                    LOGGER.info("Output file = " + theOutputFile.getAbsolutePath());
                }
                theOutputStream = new FileOutputStream(theOutputFile);
            }
        }
        return theOutputStream;
    }

    private static File toCertFile(String aCertFileName, boolean isVerbose) {
        File theCertFile;
        File file = theCertFile = aCertFileName != null && aCertFileName.length() != 0 ? new File(aCertFileName) : null;
        if (isVerbose && theCertFile != null) {
            LOGGER.info("Cert file = \"" + aCertFileName + "\" (<" + theCertFile.getAbsolutePath() + ">)");
        }
        return theCertFile;
    }

    private static String toSpecFileName(String aSpecFileName) {
        return aSpecFileName != null ? aSpecFileName : DEFAULT_SPECFILE_NAME;
    }

    private static File toSpecFile(String aSpecFileName, boolean isVerbose) {
        File theSpecFile;
        File file = theSpecFile = aSpecFileName != null && aSpecFileName.length() != 0 ? new File(aSpecFileName) : null;
        if (isVerbose && theSpecFile != null) {
            LOGGER.info("Specification file = \"" + aSpecFileName + "\" (<" + theSpecFile.getAbsolutePath() + ">)");
        }
        return theSpecFile;
    }

    private static ChaosOptions toCertMode(Boolean isPromptPassword, String aPassword, SystemContext aContext, ChaosOptions aCertMode, boolean isVerbose) {
        ChaosOptions theCertMode;
        ChaosOptions chaosOptions = theCertMode = aCertMode == null && (isPromptPassword != false || aPassword != null && aPassword.length() != 0 || aContext != null) ? DEFAULT_CHAOS_MODE : aCertMode;
        if (isVerbose && theCertMode != null) {
            LOGGER.info("Certificate mode = " + theCertMode.toString());
        }
        return theCertMode;
    }

    private static ChaosOptions toChaosMode(ChaosOptions aChaosMode, boolean isVerbose) {
        ChaosOptions chaosOptions = aChaosMode = aChaosMode == null ? DEFAULT_CHAOS_MODE : aChaosMode;
        if (isVerbose && aChaosMode != null) {
            LOGGER.info("Chaos mode = " + (aChaosMode instanceof ChaosMode ? ((ChaosMode)aChaosMode).name() : aChaosMode.toString()));
        }
        return aChaosMode;
    }

    private static ChaosOptions toChaosMode(ChaosOptions aChaosMode, String aText, byte[] aBytes, boolean isPasteFrom, File aCertFile, boolean isVerbose) {
        if (aChaosMode == null && aCertFile == null) {
            ChaosOptions chaosOptions = aChaosMode = isPasteFrom || aText != null || aBytes != null ? DEFAULT_PLAIN_MODE : DEFAULT_CHAOS_MODE;
        }
        if (isVerbose && aChaosMode != null) {
            LOGGER.info("Chaos mode = " + (aChaosMode instanceof ChaosMode ? ((ChaosMode)aChaosMode).name() : aChaosMode.toString()));
        }
        return aChaosMode;
    }

    private static Integer toChainLength(Integer aChainLength, File aSpecFile, boolean isVerbose) {
        if (aChainLength != null && aChainLength < 1) {
            throw new IllegalArgumentException("The chain length <" + aChainLength + "> of argument <chainLength> must be at least <1> !");
        }
        Integer n = aChainLength = aChainLength == null && aSpecFile == null ? Integer.valueOf(16) : aChainLength;
        if (isVerbose && aChainLength != null) {
            LOGGER.info("Chain length = " + aChainLength);
        }
        return aChainLength;
    }

    private static int toLineWidth(Integer aLineWidth, int aDefaultLineWidth, boolean isVerbose) {
        if (aLineWidth != null && aLineWidth < 65) {
            throw new IllegalArgumentException("The line width <" + aLineWidth + "> of argument <lineWidth> must be at least <65> !");
        }
        if (aLineWidth == null) {
            aLineWidth = aDefaultLineWidth;
        }
        if (isVerbose && aLineWidth != null && aLineWidth != -1) {
            LOGGER.info("Line width = " + aLineWidth);
        }
        return aLineWidth;
    }

    private static ChaosKey toChaosKey(Boolean isPromptPassword, String aPassword, SystemContext aContext, File aCertFile, Double x0, Double a, Long s, ChaosOptions aChaosOptions, boolean isVerbose) throws IOException {
        ChaosKey theChaosKey;
        String thePassword;
        if (aCertFile == null && x0 == null && a == null && s == null && aContext == null) {
            aContext = DEFAULT_CONTEXT;
        }
        String string = isPromptPassword.booleanValue() ? (aCertFile != null ? Main.readCertPassword(isVerbose) : Main.readKeyPassword(isVerbose)) : (aPassword != null ? aPassword : (thePassword = aContext != null ? aContext.toContextString() : null));
        if (aCertFile != null) {
            try {
                theChaosKey = thePassword != null && thePassword.length() != 0 ? ChaosKey.createFromCertificate(aCertFile, thePassword) : ChaosKey.createFromCertificate(aCertFile);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Cannot instantiate chaos key, maybe you provided a bad password or a bad cert file!", e);
            }
        } else {
            theChaosKey = thePassword != null ? new ChaosKey(thePassword, aChaosOptions) : new ChaosKey((double)x0, (double)a, (long)s, aChaosOptions);
        }
        return theChaosKey;
    }

    private static String toCertPassword(Boolean isPromptPassword, String aPassword, SystemContext aContext, boolean isVerbose) {
        return isPromptPassword != false ? Main.readCertPassword(isVerbose) : (aPassword != null ? aPassword : (aContext != null ? aContext.toContextString() : null));
    }

    private static String readKeyPassword(boolean isVerbose) {
        return Main.readPassword("Please enter password and hit [ENTER] > ", isVerbose);
    }

    private static String readCertPassword(boolean isVerbose) {
        String thePasswd = Main.readPassword("Please enter certifcate password and hit [ENTER] > ", isVerbose);
        return thePasswd;
    }

    private static String readPassword(String aPrompt, boolean isVerbose) {
        if (isVerbose) {
            LOGGER.printTail();
        }
        System.console().printf(aPrompt, new Object[0]);
        char[] theReadPassword = System.console().readPassword();
        if (theReadPassword == null || theReadPassword.length == 0) {
            System.exit(ExitCode.CONTROL_C.getStatusCode());
        }
        return new String(theReadPassword);
    }

    private static int printChaosKey(ChaosKey aChaosKey, Consumer<String> aPrinter, boolean isAlign) {
        int length = 0;
        ChaosKey eChaosKey = aChaosKey;
        while (eChaosKey != null) {
            String eIndex = isAlign ? HorizAlignTextBuilder.asAligned("" + length, 4, '0', HorizAlignTextMode.RIGHT) : "" + length;
            String eX0 = isAlign ? HorizAlignTextBuilder.asAligned("" + eChaosKey.getX0(), 20, ' ', HorizAlignTextMode.RIGHT) : "" + eChaosKey.getX0();
            String eA = isAlign ? HorizAlignTextBuilder.asAligned("" + eChaosKey.getA(), 20, ' ', HorizAlignTextMode.RIGHT) : "" + eChaosKey.getA();
            String eS = isAlign ? HorizAlignTextBuilder.asAligned("" + eChaosKey.getS(), 18, ' ', HorizAlignTextMode.RIGHT) : "" + eChaosKey.getS();
            String ePrefix = isAlign ? HorizAlignTextBuilder.asAligned("" + eChaosKey.getOptions().getRndPrefixSize(), 3, ' ', HorizAlignTextMode.RIGHT) : "" + eChaosKey.getOptions().getRndPrefixSize();
            aPrinter.accept("Key [" + eIndex + "] = ( x0 = " + eX0 + ", a = " + eA + ", s = " + eS + ", salted = " + Main.toBooleanValue(eChaosKey.getOptions().isSalted()) + ", mutate = " + Main.toBooleanValue(eChaosKey.getOptions().isMutateS()) + ", xor = " + Main.toBooleanValue(eChaosKey.getOptions().isXorNext()) + ", prefix = " + ePrefix + " )");
            eChaosKey = eChaosKey.getChild();
            ++length;
        }
        return length;
    }

    private static String toBooleanText(Boolean isTrue) {
        return isTrue != false ? "YES" : "NO";
    }

    private static String toBooleanValue(Boolean isTrue) {
        return isTrue != false ? "1" : "0";
    }

    public static class ChaosKeyLine {
        private static final String RND_LITERAL = "rnd";
        public String x0;
        public String a;
        public String s;
        boolean isSalted;
        boolean isMutate;
        boolean isXor;
        short prefix;

        public String getX0() {
            return this.x0;
        }

        public void setX0(String aX0) {
            this.x0 = aX0;
        }

        public String getA() {
            return this.a;
        }

        public void setA(String aA) {
            this.a = aA;
        }

        public String getS() {
            return this.s;
        }

        public void setS(String aS) {
            this.s = aS;
        }

        public boolean isSalted() {
            return this.isSalted;
        }

        public void setSalted(boolean aIsSalted) {
            this.isSalted = aIsSalted;
        }

        public boolean isMutate() {
            return this.isMutate;
        }

        public void setMutate(boolean aIsMmutate) {
            this.isMutate = aIsMmutate;
        }

        public boolean isXor() {
            return this.isXor;
        }

        public void setXor(boolean aIsXor) {
            this.isXor = aIsXor;
        }

        public int getPrefix() {
            return this.prefix;
        }

        public void setPrefix(short aPrefix) {
            this.prefix = aPrefix;
        }

        public ChaosKey toChaosKey(CsvRecordReader<?> aCsvReader) {
            ChaosKey theRndKey = ChaosKey.createRndKey();
            double x0 = RND_LITERAL.equalsIgnoreCase(this.x0) ? theRndKey.getX0() : Double.valueOf(this.x0).doubleValue();
            double a = RND_LITERAL.equalsIgnoreCase(this.a) ? theRndKey.getA() : Double.valueOf(this.a).doubleValue();
            long s = RND_LITERAL.equalsIgnoreCase(this.s) ? theRndKey.getS() : Long.valueOf(this.s).longValue();
            return new ChaosKey(x0, a, s, (ChaosOptions)new ChaosOptionsImpl(this.isMutate, this.isXor, this.isSalted, this.prefix), aCsvReader.hasNext() ? aCsvReader.nextType(ChaosKeyLine.class).toChaosKey(aCsvReader) : null);
        }

        public String toString() {
            return this.getClass().getSimpleName() + " [x0=" + this.x0 + ", a=" + this.a + ", s=" + this.s + ", isSalted=" + this.isSalted + ", isMutate=" + this.isMutate + ", isXor=" + this.isXor + ", prefix=" + this.prefix + "]";
        }
    }
}

