/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.struct;

import java.util.Collection;
import org.refcodes.data.BooleanLiterals;
import org.refcodes.data.Literal;
import org.refcodes.mixin.AliasAccessor;
import org.refcodes.struct.ImmutablePathTable;
import org.refcodes.struct.InterOperableTable;

public interface ImmutableInterOperableTable<T>
extends ImmutablePathTable<T> {
    default public Boolean getBoolean(Object ... aPathElements) {
        return this.getBoolean(this.toPath(aPathElements));
    }

    default public Boolean getBoolean(Collection<?> aPathElements) {
        return this.getBoolean(this.toPath(aPathElements));
    }

    default public Boolean getBoolean(Object aKey) {
        return this.getBoolean(ImmutableInterOperableTable.asKey(aKey));
    }

    default public Boolean getBoolean(String ... aPathElements) {
        return this.getBoolean(this.toPath(aPathElements));
    }

    default public Boolean getBoolean(String aKey) {
        Object theValue = this.get((Object)aKey);
        if (theValue == null) {
            return false;
        }
        if (theValue instanceof Boolean) {
            return (Boolean)theValue;
        }
        if (theValue instanceof String) {
            for (String eTrue : BooleanLiterals.TRUE.getNames()) {
                if (!eTrue.equalsIgnoreCase((String)theValue)) continue;
                return true;
            }
            for (String eFalse : BooleanLiterals.FALSE.getNames()) {
                if (!eFalse.equalsIgnoreCase((String)theValue)) continue;
                return false;
            }
        }
        throw new NumberFormatException("Unable to parse a boolean from the value <" + String.valueOf(theValue) + "> of type <" + theValue.getClass().getName() + ">!");
    }

    default public Boolean getBooleanOr(Object aKey, Boolean aDefaultValue) {
        Boolean theValue = this.getBoolean(aKey);
        return theValue == null ? aDefaultValue : theValue;
    }

    default public Boolean getBooleanOr(Object[] aPathElements, Boolean aDefaultValue) {
        return this.getBooleanOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public Boolean getBooleanOr(Collection<?> aPathElements, Boolean aDefaultValue) {
        return this.getBooleanOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public Boolean getBooleanOr(String aKey, Boolean aDefaultValue) {
        Boolean theValue = this.getBoolean(aKey);
        return theValue == null ? aDefaultValue : theValue;
    }

    default public Boolean getBooleanOr(String[] aPathElements, Boolean aDefaultValue) {
        return this.getBooleanOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public Byte getByte(Object ... aPathElements) {
        return this.getByte(this.toPath(aPathElements));
    }

    default public Byte getByte(Collection<?> aPathElements) {
        return this.getByte(this.toPath(aPathElements));
    }

    default public Byte getByte(Object aKey) {
        return this.getByte(ImmutableInterOperableTable.asKey(aKey));
    }

    default public Byte getByte(String ... aPathElements) {
        return this.getByte(this.toPath(aPathElements));
    }

    default public Byte getByte(String aKey) {
        Object theValue = this.get((Object)aKey);
        if (theValue == null) {
            return null;
        }
        if (theValue instanceof Byte) {
            return (Byte)theValue;
        }
        if (theValue instanceof String) {
            String theString = (String)theValue;
            if (theString.endsWith(".0")) {
                theString = theString.substring(0, theString.length() - 2);
            }
            return Byte.valueOf(theString);
        }
        throw new NumberFormatException("Unable to parse a byte from the value <" + String.valueOf(theValue) + "> of type <" + theValue.getClass().getName() + ">!");
    }

    default public Byte getByteOr(Object aKey, Byte aDefaultValue) {
        Byte theValue = this.getByte(aKey);
        return theValue == null ? aDefaultValue : theValue;
    }

    default public Byte getByteOr(Object[] aPathElements, Byte aDefaultValue) {
        return this.getByteOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public Byte getByteOr(Collection<?> aPathElements, Byte aDefaultValue) {
        return this.getByteOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public Byte getByteOr(String aKey, Byte aDefaultValue) {
        Byte theValue = this.getByte(aKey);
        return theValue == null ? aDefaultValue : theValue;
    }

    default public Byte getByteOr(String[] aPathElements, Byte aDefaultValue) {
        return this.getByteOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public Character getChar(Object aKey) {
        return this.getChar(ImmutableInterOperableTable.asKey(aKey));
    }

    default public Character getChar(String aKey) {
        String theString;
        Object theValue = this.get((Object)aKey);
        if (theValue == null) {
            return null;
        }
        if (theValue instanceof Character) {
            return (Character)theValue;
        }
        if (theValue instanceof String && (theString = (String)theValue).length() == 1) {
            return Character.valueOf(theString.charAt(0));
        }
        throw new NumberFormatException("Unable to convert a character from the value <" + String.valueOf(theValue) + "> of type <" + theValue.getClass().getName() + ">!");
    }

    default public Character getChar(String ... aPathElements) {
        return this.getChar(this.toPath(aPathElements));
    }

    default public Character getChar(Object ... aPathElements) {
        return this.getChar(this.toPath(aPathElements));
    }

    default public Character getChar(Collection<?> aPathElements) {
        return this.getChar(this.toPath(aPathElements));
    }

    default public Character getCharOr(Object aKey, Character aDefaultValue) {
        Character theValue = this.getChar(aKey);
        return theValue == null ? aDefaultValue : theValue;
    }

    default public Character getCharOr(Object[] aPathElements, Character aDefaultValue) {
        return this.getCharOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public Character getCharOr(Collection<?> aPathElements, Character aDefaultValue) {
        return this.getCharOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public Character getCharOr(String aKey, Character aDefaultValue) {
        Character theValue = this.getChar(aKey);
        return theValue == null ? aDefaultValue : theValue;
    }

    default public Character getCharOr(String[] aPathElements, Character aDefaultValue) {
        return this.getCharOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public <C> Class<C> getClass(Object ... aPathElements) {
        return this.getClass(this.toPath(aPathElements));
    }

    default public <C> Class<C> getClass(Collection<?> aPathElements) {
        return this.getClass(this.toPath(aPathElements));
    }

    default public <C> Class<C> getClass(Object aKey) {
        return this.getClass(ImmutableInterOperableTable.asKey(aKey));
    }

    default public <C> Class<C> getClass(String ... aPathElements) {
        return this.getClass(this.toPath(aPathElements));
    }

    default public <C> Class<C> getClass(String aKey) {
        Object theValue = this.get((Object)aKey);
        if (theValue == null) {
            return null;
        }
        if (theValue instanceof Class) {
            try {
                return (Class)theValue;
            }
            catch (ClassCastException e) {
                throw new NumberFormatException("Unable to parse a class from the value <" + String.valueOf(theValue) + "> of type <" + theValue.getClass().getName() + ">: " + e.getMessage());
            }
        }
        if (theValue instanceof String) {
            String theString = (String)theValue;
            try {
                return Class.forName(theString);
            }
            catch (Exception e) {
                throw new NumberFormatException("Unable to parse a class from the value <" + String.valueOf(theValue) + "> of type <" + theValue.getClass().getName() + ">: " + e.getMessage());
            }
        }
        throw new NumberFormatException("Unable to parse a class from the value <" + String.valueOf(theValue) + "> of type <" + theValue.getClass().getName() + ">!");
    }

    default public <C> Class<C> getClassOr(Object aKey, Class<C> aDefaultValue) {
        Class<C> theValue = this.getClass(aKey);
        return theValue == null ? aDefaultValue : theValue;
    }

    default public <C> Class<C> getClassOr(Object[] aPathElements, Class<C> aDefaultValue) {
        return this.getClassOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public <C> Class<C> getClassOr(Collection<?> aPathElements, Class<C> aDefaultValue) {
        return this.getClassOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public <C> Class<C> getClassOr(String aKey, Class<C> aDefaultValue) {
        Class<C> theValue = this.getClass(aKey);
        return theValue == null ? aDefaultValue : theValue;
    }

    default public <C> Class<C> getClassOr(String[] aPathElements, Class<C> aDefaultValue) {
        return this.getClassOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public Double getDouble(Object ... aPathElements) {
        return this.getDouble(this.toPath(aPathElements));
    }

    default public Double getDouble(Collection<?> aPathElements) {
        return this.getDouble(this.toPath(aPathElements));
    }

    default public Double getDouble(Object aKey) {
        return this.getDouble(ImmutableInterOperableTable.asKey(aKey));
    }

    default public Double getDouble(String ... aPathElements) {
        return this.getDouble(this.toPath(aPathElements));
    }

    default public Double getDouble(String aKey) {
        Object theValue = this.get((Object)aKey);
        if (theValue == null) {
            return null;
        }
        if (theValue instanceof Double) {
            return (Double)theValue;
        }
        if (theValue instanceof String) {
            return Double.valueOf((String)theValue);
        }
        throw new NumberFormatException("Unable to convert a double from the value <" + String.valueOf(theValue) + "> of type <" + theValue.getClass().getName() + ">!");
    }

    default public Double getDoubleOr(Object aKey, Double aDefaultValue) {
        Double theValue = this.getDouble(aKey);
        return theValue == null ? aDefaultValue : theValue;
    }

    default public Double getDoubleOr(Object[] aPathElements, Double aDefaultValue) {
        return this.getDoubleOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public Double getDoubleOr(Collection<?> aPathElements, Double aDefaultValue) {
        return this.getDoubleOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public Double getDoubleOr(String aKey, Double aDefaultValue) {
        Double theValue = this.getDouble(aKey);
        return theValue == null ? aDefaultValue : theValue;
    }

    default public Double getDoubleOr(String[] aPathElements, Double aDefaultValue) {
        return this.getDoubleOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public <E extends Enum<E>> E getEnum(Class<E> aEnumType, Object aKey) {
        return this.getEnum(aEnumType, ImmutableInterOperableTable.asKey(aKey));
    }

    default public <E extends Enum<E>> E getEnum(Class<E> aEnumType, String aKey) {
        Object theValue = this.get((Object)aKey);
        if (theValue == null) {
            return null;
        }
        if (theValue instanceof String) {
            Enum[] theValues;
            for (Enum eValue : theValues = (Enum[])aEnumType.getEnumConstants()) {
                if (!eValue.name().equals(theValue)) continue;
                return (E)eValue;
            }
        }
        if (theValue instanceof Enum) {
            try {
                return (E)((Enum)theValue);
            }
            catch (Exception e) {
                throw new NumberFormatException("Unable to convert a enumeration from the value <" + String.valueOf(theValue) + "> of type <" + theValue.getClass().getName() + "> to enum type <\" + aEnumType.getName() + \">:" + e.getMessage());
            }
        }
        throw new NumberFormatException("Unable to convert a enumeration from the value <" + String.valueOf(theValue) + "> of type <" + theValue.getClass().getName() + "> to enum type <" + aEnumType.getName() + ">!");
    }

    default public <E extends Enum<E>> E getEnum(Class<E> aEnumType, String ... aPathElements) {
        return this.getEnum(aEnumType, this.toPath(aPathElements));
    }

    default public <E extends Enum<E>> E getEnum(Class<E> aEnumType, Object ... aPathElements) {
        return this.getEnum(aEnumType, this.toPath(aPathElements));
    }

    default public <E extends Enum<E>> E getEnum(Class<E> aEnumType, Collection<?> aPathElements) {
        return this.getEnum(aEnumType, this.toPath(aPathElements));
    }

    default public <E extends Enum<E>> E getEnumOr(Class<E> aEnumType, Object aKey, E aDefaultValue) {
        E theValue = this.getEnum(aEnumType, aKey);
        return theValue == null ? aDefaultValue : theValue;
    }

    default public <E extends Enum<E>> E getEnumOr(Class<E> aEnumType, Object[] aPathElements, E aDefaultValue) {
        return this.getEnumOr(aEnumType, this.toPath(aPathElements), aDefaultValue);
    }

    default public <E extends Enum<E>> E getEnumOr(Class<E> aEnumType, Collection<?> aPathElements, E aDefaultValue) {
        return this.getEnumOr(aEnumType, this.toPath(aPathElements), aDefaultValue);
    }

    default public <E extends Enum<E>> E getEnumOr(Class<E> aEnumType, String aKey, E aDefaultValue) {
        E theValue = this.getEnum(aEnumType, aKey);
        return theValue == null ? aDefaultValue : theValue;
    }

    default public <E extends Enum<E>> E getEnumOr(Class<E> aEnumType, String[] aPathElements, E aDefaultValue) {
        return this.getEnumOr(aEnumType, this.toPath(aPathElements), aDefaultValue);
    }

    default public <E extends Enum<E>> E getEnumOr(Object aKey, E aDefaultValue) {
        E theValue = this.getEnum(aDefaultValue.getDeclaringClass(), aKey);
        return theValue == null ? aDefaultValue : theValue;
    }

    default public <E extends Enum<E>> E getEnumOr(Object[] aPathElements, E aDefaultValue) {
        return this.getEnumOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public <E extends Enum<E>> E getEnumOr(Collection<?> aPathElements, E aDefaultValue) {
        return this.getEnumOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public <E extends Enum<E>> E getEnumOr(String aKey, E aDefaultValue) {
        E theValue = this.getEnum(aDefaultValue.getDeclaringClass(), aKey);
        return theValue == null ? aDefaultValue : theValue;
    }

    default public <E extends Enum<E>> E getEnumOr(String[] aPathElements, E aDefaultValue) {
        return this.getEnumOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public Float getFloat(Object ... aPathElements) {
        return this.getFloat(this.toPath(aPathElements));
    }

    default public Float getFloat(Collection<?> aPathElements) {
        return this.getFloat(this.toPath(aPathElements));
    }

    default public Float getFloat(Object aKey) {
        return this.getFloat(ImmutableInterOperableTable.asKey(aKey));
    }

    default public Float getFloat(String ... aPathElements) {
        return this.getFloat(this.toPath(aPathElements));
    }

    default public Float getFloat(String aKey) {
        Object theValue = this.get((Object)aKey);
        if (theValue == null) {
            return null;
        }
        if (theValue instanceof Float) {
            return (Float)theValue;
        }
        if (theValue instanceof String) {
            return Float.valueOf((String)theValue);
        }
        throw new NumberFormatException("Unable to convert a float from the value <" + String.valueOf(theValue) + "> of type <" + theValue.getClass().getName() + ">!");
    }

    default public Float getFloatOr(Object aKey, Float aDefaultValue) {
        Float theValue = this.getFloat(aKey);
        return theValue == null ? aDefaultValue : theValue;
    }

    default public Float getFloatOr(Object[] aPathElements, Float aDefaultValue) {
        return this.getFloatOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public Float getFloatOr(Collection<?> aPathElements, Float aDefaultValue) {
        return this.getFloatOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public Float getFloatOr(String aKey, Float aDefaultValue) {
        Float theValue = this.getFloat(aKey);
        return theValue == null ? aDefaultValue : theValue;
    }

    default public Float getFloatOr(String[] aPathElements, Float aDefaultValue) {
        return this.getFloatOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public Integer getInt(Object ... aPathElements) {
        return this.getInt(this.toPath(aPathElements));
    }

    default public Integer getInt(Collection<?> aPathElements) {
        return this.getInt(this.toPath(aPathElements));
    }

    default public Integer getInt(Object aKey) {
        return this.getInt(ImmutableInterOperableTable.asKey(aKey));
    }

    default public Integer getInt(String ... aPathElements) {
        return this.getInt(this.toPath(aPathElements));
    }

    default public Integer getInt(String aKey) {
        Object theValue = this.get((Object)aKey);
        if (theValue == null) {
            return null;
        }
        if (theValue instanceof Integer) {
            return (Integer)theValue;
        }
        if (theValue instanceof String) {
            String theString = (String)theValue;
            if (theString.endsWith(".0")) {
                theString = theString.substring(0, theString.length() - 2);
            }
            return Integer.valueOf(theString);
        }
        throw new NumberFormatException("Unable to convert an Integer from the value <" + String.valueOf(theValue) + "> of type <" + theValue.getClass().getName() + ">!");
    }

    default public Integer getIntOr(Object aKey, Integer aDefaultValue) {
        Integer theValue = this.getInt(aKey);
        return theValue == null ? aDefaultValue : theValue;
    }

    default public Integer getIntOr(Object[] aPathElements, Integer aDefaultValue) {
        return this.getIntOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public Integer getIntOr(Collection<?> aPathElements, Integer aDefaultValue) {
        return this.getIntOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public Integer getIntOr(String aKey, Integer aDefaultValue) {
        Integer theValue = this.getInt(aKey);
        return theValue == null ? aDefaultValue : theValue;
    }

    default public Integer getIntOr(String[] aPathElements, Integer aDefaultValue) {
        return this.getIntOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public Long getLong(Object ... aPathElements) {
        return this.getLong(this.toPath(aPathElements));
    }

    default public Long getLong(Collection<?> aPathElements) {
        return this.getLong(this.toPath(aPathElements));
    }

    default public Long getLong(Object aKey) {
        return this.getLong(ImmutableInterOperableTable.asKey(aKey));
    }

    default public Long getLong(String ... aPathElements) {
        return this.getLong(this.toPath(aPathElements));
    }

    default public Long getLong(String aKey) {
        Object theValue = this.get((Object)aKey);
        if (theValue == null) {
            return null;
        }
        if (theValue instanceof Long) {
            return (Long)theValue;
        }
        if (theValue instanceof String) {
            String theString = (String)theValue;
            if (theString.endsWith(".0")) {
                theString = theString.substring(0, theString.length() - 2);
            }
            return Long.valueOf(theString);
        }
        throw new NumberFormatException("Unable to convert an Long from the value <" + String.valueOf(theValue) + "> of type <" + theValue.getClass().getName() + ">!");
    }

    default public Long getLongOr(Object aKey, Long aDefaultValue) {
        Long theValue = this.getLong(aKey);
        return theValue == null ? aDefaultValue : theValue;
    }

    default public Long getLongOr(Object[] aPathElements, Long aDefaultValue) {
        return this.getLongOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public Long getLongOr(Collection<?> aPathElements, Long aDefaultValue) {
        return this.getLongOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public Long getLongOr(String aKey, Long aDefaultValue) {
        Long theValue = this.getLong(aKey);
        return theValue == null ? aDefaultValue : theValue;
    }

    default public Long getLongOr(String[] aPathElements, Long aDefaultValue) {
        return this.getLongOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public Short getShort(Object ... aPathElements) {
        return this.getShort(this.toPath(aPathElements));
    }

    default public Short getShort(Collection<?> aPathElements) {
        return this.getShort(this.toPath(aPathElements));
    }

    default public Short getShort(Object aKey) {
        return this.getShort(ImmutableInterOperableTable.asKey(aKey));
    }

    default public Short getShort(String ... aPathElements) {
        return this.getShort(this.toPath(aPathElements));
    }

    default public Short getShort(String aKey) {
        Object theValue = this.get((Object)aKey);
        if (theValue == null) {
            return null;
        }
        if (theValue instanceof Short) {
            return (Short)theValue;
        }
        if (theValue instanceof String) {
            String theString = (String)theValue;
            if (theString.endsWith(".0")) {
                theString = theString.substring(0, theString.length() - 2);
            }
            return Short.valueOf(theString);
        }
        throw new NumberFormatException("Unable to convert an Short from the value <" + String.valueOf(theValue) + "> of type <" + theValue.getClass().getName() + ">!");
    }

    default public Short getShortOr(Object aKey, Short aDefaultValue) {
        Short theValue = this.getShort(aKey);
        return theValue == null ? aDefaultValue : theValue;
    }

    default public Short getShortOr(Object[] aPathElements, Short aDefaultValue) {
        return this.getShortOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public Short getShortOr(Collection<?> aPathElements, Short aDefaultValue) {
        return this.getShortOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public Short getShortOr(String aKey, Short aDefaultValue) {
        Short theValue = this.getShort(aKey);
        return theValue == null ? aDefaultValue : theValue;
    }

    default public Short getShortOr(String[] aPathElements, Short aDefaultValue) {
        return this.getShortOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public String getString(Object ... aPathElements) {
        return this.getString(this.toPath(aPathElements));
    }

    default public String getString(Collection<?> aPathElements) {
        return this.getString(this.toPath(aPathElements));
    }

    default public String getString(Object aKey) {
        return this.getString(ImmutableInterOperableTable.asKey(aKey));
    }

    default public String getString(String ... aPathElements) {
        return this.getString(this.toPath(aPathElements));
    }

    default public String getString(String aKey) {
        Object theValue = this.get((Object)aKey);
        if (theValue == null) {
            return null;
        }
        if (theValue instanceof String) {
            return (String)theValue;
        }
        throw new NumberFormatException("Unable to convert an String from the value <" + String.valueOf(theValue) + "> of type <" + theValue.getClass().getName() + ">!");
    }

    default public String getStringOr(Object aKey, String aDefaultValue) {
        String theValue = this.getString(aKey);
        return theValue == null ? aDefaultValue : theValue;
    }

    default public String getStringOr(Object[] aPathElements, String aDefaultValue) {
        return this.getStringOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public String getStringOr(Collection<?> aPathElements, String aDefaultValue) {
        return this.getStringOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public String getStringOr(String aKey, String aDefaultValue) {
        String theValue = this.getString(aKey);
        return theValue == null ? aDefaultValue : theValue;
    }

    default public String getStringOr(String[] aPathElements, String aDefaultValue) {
        return this.getStringOr(this.toPath(aPathElements), aDefaultValue);
    }

    public static String asKey(Object aKey) {
        if (aKey instanceof String) {
            return (String)aKey;
        }
        if (aKey instanceof AliasAccessor && ((AliasAccessor)aKey).getAlias() != null) {
            return ((AliasAccessor)aKey).getAlias();
        }
        return aKey != null ? aKey.toString() : null;
    }

    public static interface MutableInterOperableTable<T>
    extends ImmutableInterOperableTable<T>,
    ImmutablePathTable.MutablePathTable<T> {
        @Override
        default public boolean containsValue(Object value) {
            return this.values().contains(value);
        }

        @Override
        default public void insert(InterOperableTable<T> aFrom) {
            this.insert((Object)aFrom);
        }

        @Override
        default public void insertBetween(String aToPath, InterOperableTable<T> aFrom, String aFromPath) {
            this.insertBetween(aToPath, (Object)aFrom, aFromPath);
        }

        @Override
        default public void insertFrom(InterOperableTable<T> aFrom, String aFromPath) {
            this.insertFrom((Object)aFrom, aFromPath);
        }

        @Override
        default public void insertTo(String aToPath, InterOperableTable<T> aFrom) {
            this.insertTo(aToPath, (Object)aFrom);
        }

        default public T putBoolean(Object aKey, Boolean aValue) {
            return this.putBoolean(ImmutableInterOperableTable.asKey(aKey), aValue);
        }

        default public T putBoolean(Object[] aPathElements, Boolean aValue) {
            return this.putBoolean(this.toPath(aPathElements), aValue);
        }

        default public T putBoolean(Collection<?> aPathElements, Boolean aValue) {
            return this.putBoolean(this.toPath(aPathElements), aValue);
        }

        default public T putBoolean(String aKey, Boolean aValue) {
            if (aValue == null) {
                return this.put(aKey, null);
            }
            if (this.getType().isAssignableFrom(Boolean.class)) {
                return (T)this.put(aKey, aValue);
            }
            if (this.getType().isAssignableFrom(String.class)) {
                return (T)this.put(aKey, Boolean.TRUE.equals(aValue) ? Literal.TRUE.getValue() : Literal.FALSE.getValue());
            }
            throw new NumberFormatException("Unable to convert a boolean from the value <" + aValue + "> of type <" + aValue.getClass().getName() + "> to type <" + this.getType().getName() + ">!");
        }

        default public T putBoolean(String[] aPathElements, Boolean aValue) {
            return this.putBoolean(this.toPath(aPathElements), aValue);
        }

        default public T putByte(Object aKey, Byte aValue) {
            return this.putByte(ImmutableInterOperableTable.asKey(aKey), aValue);
        }

        default public T putByte(Object[] aPathElements, Byte aValue) {
            return this.putByte(this.toPath(aPathElements), aValue);
        }

        default public T putByte(Collection<?> aPathElements, Byte aValue) {
            return this.putByte(this.toPath(aPathElements), aValue);
        }

        default public T putByte(String aKey, Byte aValue) {
            if (aValue == null) {
                return this.put(aKey, null);
            }
            if (this.getType().isAssignableFrom(Byte.class)) {
                return (T)this.put(aKey, aValue);
            }
            if (this.getType().isAssignableFrom(String.class)) {
                return (T)this.put(aKey, aValue.toString());
            }
            throw new NumberFormatException("Unable to convert a byte from the value <" + aValue + "> of type <" + aValue.getClass().getName() + "> to type <" + this.getType().getName() + ">!");
        }

        default public T putByte(String[] aPathElements, Byte aValue) {
            return this.putByte(this.toPath(aPathElements), aValue);
        }

        default public T putChar(Object aKey, Character aValue) {
            return this.putChar(ImmutableInterOperableTable.asKey(aKey), aValue);
        }

        default public T putChar(Object[] aPathElements, Character aValue) {
            return this.putChar(this.toPath(aPathElements), aValue);
        }

        default public T putChar(Collection<?> aPathElements, Character aValue) {
            return this.putChar(this.toPath(aPathElements), aValue);
        }

        default public T putChar(String aKey, Character aValue) {
            if (aValue == null) {
                return this.put(aKey, null);
            }
            if (this.getType().isAssignableFrom(Character.class)) {
                return (T)this.put(aKey, aValue);
            }
            if (this.getType().isAssignableFrom(String.class)) {
                return (T)this.put(aKey, aValue.toString());
            }
            throw new NumberFormatException("Unable to convert a character from the value <" + aValue + "> of type <" + aValue.getClass().getName() + "> to type <" + this.getType().getName() + ">!");
        }

        default public T putChar(String[] aPathElements, Character aValue) {
            return this.putChar(this.toPath(aPathElements), aValue);
        }

        default public <C> T putClass(Object aKey, Class<C> aValue) {
            return this.putClass(ImmutableInterOperableTable.asKey(aKey), aValue);
        }

        default public <C> T putClass(Object[] aPathElements, Class<C> aValue) {
            return this.putClass(this.toPath(aPathElements), aValue);
        }

        default public <C> T putClass(Collection<?> aPathElements, Class<C> aValue) {
            return this.putClass(this.toPath(aPathElements), aValue);
        }

        default public <C> T putClass(String aKey, Class<C> aValue) {
            if (aValue == null) {
                return this.put(aKey, null);
            }
            if (this.getType().isAssignableFrom(Class.class)) {
                try {
                    return (T)this.put(aKey, aValue);
                }
                catch (Exception e) {
                    throw new NumberFormatException("Unable to convert a class from the value <" + String.valueOf(aValue) + "> of type <" + aValue.getClass().getName() + "> to type <" + this.getType().getName() + ">: " + e.getMessage());
                }
            }
            if (this.getType().isAssignableFrom(String.class)) {
                return (T)this.put(aKey, aValue.getName());
            }
            throw new NumberFormatException("Unable to convert a class from the value <" + String.valueOf(aValue) + "> of type <" + aValue.getClass().getName() + "> to type <" + this.getType().getName() + ">!");
        }

        default public <C> T putClass(String[] aPathElements, Class<C> aValue) {
            return this.putClass(this.toPath(aPathElements), aValue);
        }

        default public T putDouble(Object aKey, Double aValue) {
            return this.putDouble(ImmutableInterOperableTable.asKey(aKey), aValue);
        }

        default public T putDouble(Object[] aPathElements, Double aValue) {
            return this.putDouble(this.toPath(aPathElements), aValue);
        }

        default public T putDouble(Collection<?> aPathElements, Double aValue) {
            return this.putDouble(this.toPath(aPathElements), aValue);
        }

        default public T putDouble(String aKey, Double aValue) {
            if (aValue == null) {
                return this.put(aKey, null);
            }
            if (this.getType().isAssignableFrom(Double.class)) {
                return (T)this.put(aKey, aValue);
            }
            if (this.getType().isAssignableFrom(String.class)) {
                return (T)this.put(aKey, aValue.toString());
            }
            throw new NumberFormatException("Unable to convert a double from the value <" + aValue + "> of type <" + aValue.getClass().getName() + "> to type <" + this.getType().getName() + ">!");
        }

        default public T putDouble(String[] aPathElements, Double aValue) {
            return this.putDouble(this.toPath(aPathElements), aValue);
        }

        default public <E extends Enum<E>> T putEnum(Object aKey, E aValue) {
            return this.putEnum(ImmutableInterOperableTable.asKey(aKey), aValue);
        }

        default public <E extends Enum<E>> T putEnum(Object[] aPathElements, E aValue) {
            return this.putEnum(this.toPath(aPathElements), aValue);
        }

        default public <E extends Enum<E>> T putEnum(Collection<?> aPathElements, E aValue) {
            return this.putEnum(this.toPath(aPathElements), aValue);
        }

        default public <E extends Enum<E>> T putEnum(String aKey, E aValue) {
            if (aValue == null) {
                return this.put(aKey, null);
            }
            if (this.getType().isAssignableFrom(Enum.class)) {
                try {
                    return (T)this.put(aKey, aValue);
                }
                catch (Exception e) {
                    throw new NumberFormatException("Unable to convert a enumeration from the value <" + String.valueOf(aValue) + "> of type <" + aValue.getClass().getName() + "> to type <" + this.getType().getName() + ">: " + e.getMessage());
                }
            }
            if (this.getType().isAssignableFrom(String.class)) {
                return (T)this.put(aKey, aValue.name());
            }
            throw new NumberFormatException("Unable to convert a enumeration from the value <" + String.valueOf(aValue) + "> of type <" + aValue.getClass().getName() + "> to type <" + this.getType().getName() + ">!");
        }

        default public <E extends Enum<E>> T putEnum(String[] aPathElements, E aValue) {
            return this.putEnum(this.toPath(aPathElements), aValue);
        }

        default public T putFloat(Object aKey, Float aValue) {
            return this.putFloat(ImmutableInterOperableTable.asKey(aKey), aValue);
        }

        default public T putFloat(Object[] aPathElements, Float aValue) {
            return this.putFloat(this.toPath(aPathElements), aValue);
        }

        default public T putFloat(Collection<?> aPathElements, Float aValue) {
            return this.putFloat(this.toPath(aPathElements), aValue);
        }

        default public T putFloat(String aKey, Float aValue) {
            if (aValue == null) {
                return this.put(aKey, null);
            }
            if (this.getType().isAssignableFrom(Float.class)) {
                return (T)this.put(aKey, aValue);
            }
            if (this.getType().isAssignableFrom(String.class)) {
                return (T)this.put(aKey, aValue.toString());
            }
            throw new NumberFormatException("Unable to convert a float from the value <" + aValue + "> of type <" + aValue.getClass().getName() + "> to type <" + this.getType().getName() + ">!");
        }

        default public T putFloat(String[] aPathElements, Float aValue) {
            return this.putFloat(this.toPath(aPathElements), aValue);
        }

        default public T putInt(Object aKey, Integer aValue) {
            return this.putInt(ImmutableInterOperableTable.asKey(aKey), aValue);
        }

        default public T putInt(Object[] aPathElements, Integer aValue) {
            return this.putInt(this.toPath(aPathElements), aValue);
        }

        default public T putInt(Collection<?> aPathElements, Integer aValue) {
            return this.putInt(this.toPath(aPathElements), aValue);
        }

        default public T putInt(String aKey, Integer aValue) {
            if (aValue == null) {
                return this.put(aKey, null);
            }
            if (this.getType().isAssignableFrom(Integer.class)) {
                return (T)this.put(aKey, aValue);
            }
            if (this.getType().isAssignableFrom(String.class)) {
                return (T)this.put(aKey, aValue.toString());
            }
            throw new NumberFormatException("Unable to convert a integer from the value <" + aValue + "> of type <" + aValue.getClass().getName() + "> to type <" + this.getType().getName() + ">!");
        }

        default public T putInt(String[] aPathElements, Integer aValue) {
            return this.putInt(this.toPath(aPathElements), aValue);
        }

        default public T putLong(Object aKey, Long aValue) {
            return this.putLong(ImmutableInterOperableTable.asKey(aKey), aValue);
        }

        default public T putLong(Object[] aPathElements, Long aValue) {
            return this.putLong(this.toPath(aPathElements), aValue);
        }

        default public T putLong(Collection<?> aPathElements, Long aValue) {
            return this.putLong(this.toPath(aPathElements), aValue);
        }

        default public T putLong(String aKey, Long aValue) {
            if (aValue == null) {
                return this.put(aKey, null);
            }
            if (this.getType().isAssignableFrom(Long.class)) {
                return (T)this.put(aKey, aValue);
            }
            if (this.getType().isAssignableFrom(String.class)) {
                return (T)this.put(aKey, aValue.toString());
            }
            throw new NumberFormatException("Unable to convert a long from the value <" + aValue + "> of type <" + aValue.getClass().getName() + "> to type <" + this.getType().getName() + ">!");
        }

        default public T putLong(String[] aPathElements, Long aValue) {
            return this.putLong(this.toPath(aPathElements), aValue);
        }

        default public T putShort(Object aKey, Short aValue) {
            return this.putShort(ImmutableInterOperableTable.asKey(aKey), aValue);
        }

        default public T putShort(Object[] aPathElements, Short aValue) {
            return this.putShort(this.toPath(aPathElements), aValue);
        }

        default public T putShort(Collection<?> aPathElements, Short aValue) {
            return this.putShort(this.toPath(aPathElements), aValue);
        }

        default public T putShort(String aKey, Short aValue) {
            if (aValue == null) {
                return this.put(aKey, null);
            }
            if (this.getType().isAssignableFrom(Short.class)) {
                return (T)this.put(aKey, aValue);
            }
            if (this.getType().isAssignableFrom(String.class)) {
                return (T)this.put(aKey, aValue.toString());
            }
            throw new NumberFormatException("Unable to convert a short from the value <" + aValue + "> of type <" + aValue.getClass().getName() + "> to type <" + this.getType().getName() + ">!");
        }

        default public T putShort(String[] aPathElements, Short aValue) {
            return this.putShort(this.toPath(aPathElements), aValue);
        }

        default public T putString(Object aKey, String aValue) {
            return this.putString(ImmutableInterOperableTable.asKey(aKey), aValue);
        }

        default public T putString(Object[] aPathElements, String aValue) {
            return this.putString(this.toPath(aPathElements), aValue);
        }

        default public T putString(Collection<?> aPathElements, String aValue) {
            return this.putString(this.toPath(aPathElements), aValue);
        }

        default public T putString(String aKey, String aValue) {
            if (aValue == null) {
                return this.put(aKey, null);
            }
            if (this.getType().isAssignableFrom(String.class)) {
                return (T)this.put(aKey, aValue);
            }
            throw new NumberFormatException("Unable to convert a string from the value <" + aValue + "> of type <" + aValue.getClass().getName() + "> to type <" + this.getType().getName() + ">!");
        }

        default public T putString(String[] aPathElements, String aValue) {
            return this.putString(this.toPath(aPathElements), aValue);
        }
    }
}

