/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.controlflow;

import java.util.Arrays;
import org.refcodes.controlflow.AbstractInterceptorComposite;
import org.refcodes.controlflow.DelegationInterceptor;

public class DelegationInterceptorComposite<WP>
extends AbstractInterceptorComposite<DelegationInterceptor<WP>>
implements DelegationInterceptor<WP> {
    private boolean _isContinueOnFinished;
    private boolean _isContinueOnError;

    public DelegationInterceptorComposite() {
        this(false, false, (DelegationInterceptor[])null);
    }

    public DelegationInterceptorComposite(boolean isContinueOnFinished, boolean isContinueOnError) {
        this(isContinueOnFinished, isContinueOnError, (DelegationInterceptor[])null);
    }

    @SafeVarargs
    public DelegationInterceptorComposite(DelegationInterceptor<WP> ... aInterceptors) {
        this(false, false, aInterceptors);
    }

    @SafeVarargs
    public DelegationInterceptorComposite(boolean isContinueOnFinished, boolean isContinueOnError, DelegationInterceptor<WP> ... aInterceptors) {
        this._isContinueOnFinished = isContinueOnFinished;
        this._isContinueOnError = isContinueOnError;
        this._interceptors = Arrays.asList(aInterceptors);
    }

    @Override
    public Boolean intercept(WP aWorkPiece) {
        boolean isFinished = false;
        for (DelegationInterceptor eInterceptor : this._interceptors) {
            try {
                if (((Boolean)eInterceptor.intercept((Object)aWorkPiece)).booleanValue()) {
                    isFinished = true;
                }
                if (this._isContinueOnFinished || !isFinished) continue;
                return true;
            }
            catch (Exception e) {
                if (this._isContinueOnError) continue;
                throw e;
            }
        }
        return isFinished;
    }
}

